/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.vrrp.dto;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.OswVrrpDeviceVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class OswVrrpDeviceConfigOpenApiVO {
    @NotNull(message="VRRP Device parameter [name] should not be null")
    @Schema(name="name", description="The name of the device")
    private @NotNull(message="VRRP Device parameter [name] should not be null") String name;
    @NotNull(message="VRRP Device parameter [mac] should not be null")
    @Schema(name="mac", description="Device Mac")
    @a
    private @NotNull(message="VRRP Device parameter [mac] should not be null") String mac;
    @NotNull(message="VRRP Device parameter [priority] should not be null")
    @Range(max=254L, min=1L, message="Value of priority is from 1 to 254.")
    @Schema(name="priority", description="The device priority should be within the range of 1-254.")
    private @NotNull(message="VRRP Device parameter [priority] should not be null") @Range(max=254L, min=1L, message="Value of priority is from 1 to 254.") Integer priority;
    @NotNull(message="VRRP Device parameter [vlanInterface] should not be null")
    @Range(max=4094L, min=1L, message="Value of vlanInterface is from 1 to 4094.")
    @Schema(name="vlanInterface", description="The Vlan Interface should be within the range of 1-4094.")
    private @NotNull(message="VRRP Device parameter [vlanInterface] should not be null") @Range(max=4094L, min=1L, message="Value of vlanInterface is from 1 to 4094.") Integer vlanInterface;
    @Range(max=4094L, min=1L, message="Value of trackedInterface is from 1 to 4094.")
    @Schema(name="trackedInterface", description="The TrackedInterface should be within the range of 1-4094.")
    private @Range(max=4094L, min=1L, message="Value of trackedInterface is from 1 to 4094.") Integer trackedInterface;
    @Range(max=254L, min=1L, message="Value of reducedPriority is from 1 to 254.")
    @Schema(name="reducedPriority", description="The ReducedPriority should be within the range of 1-254.")
    private @Range(max=254L, min=1L, message="Value of reducedPriority is from 1 to 254.") Integer reducedPriority;
    @NotEmpty(message="VRRP Device parameter [networks] should not be null")
    @Size(max=2, message="Size of networks should less than 2.")
    @Schema(name="networks", description="Store the IPv4 and IPv6 network segments corresponding to the VLAN interface, up to 2 entries are allowed for the networks.")
    private @NotEmpty(message="VRRP Device parameter [networks] should not be null") @Size(max=2, message="Size of networks should less than 2.") List<String> networks;
    @NotNull(message="VRRP Device parameter [type] should not be null")
    @Schema(name="type", description="Device Type")
    private @NotNull(message="VRRP Device parameter [type] should not be null") String type;
    @Schema(name="stackId", description="ID of stack group")
    private String stackId;

    public static OswVrrpDeviceConfigOpenApiVO buildByWebVO(OswVrrpDeviceVO webVO) {
        if (Objects.isNull(webVO)) {
            return null;
        }
        OswVrrpDeviceConfigOpenApiVO oswVrrpDeviceConfigOpenApiVO = new OswVrrpDeviceConfigOpenApiVO();
        oswVrrpDeviceConfigOpenApiVO.setName(webVO.getName()).setMac(webVO.getMac()).setPriority(webVO.getPriority()).setVlanInterface(webVO.getVlanInterface()).setTrackedInterface(webVO.getTrackedInterface()).setReducedPriority(webVO.getReducedPriority()).setNetworks(CollectionUtils.isEmpty((Collection)webVO.getNetworks()) ? List.of("IPv4 DHCP Mode") : webVO.getNetworks()).setType(webVO.getType()).setStackId(webVO.getStackId());
        return oswVrrpDeviceConfigOpenApiVO;
    }

    public static OswVrrpDeviceVO toWebVO(OswVrrpDeviceConfigOpenApiVO openApiVO) {
        if (Objects.isNull(openApiVO)) {
            return null;
        }
        OswVrrpDeviceVO webVO = new OswVrrpDeviceVO();
        webVO.setName(openApiVO.getName());
        webVO.setMac(openApiVO.getMac());
        webVO.setPriority(openApiVO.getPriority());
        webVO.setVlanInterface(openApiVO.getVlanInterface());
        webVO.setTrackedInterface(openApiVO.getTrackedInterface());
        webVO.setReducedPriority(openApiVO.getReducedPriority());
        webVO.setNetworks(CollectionUtils.isEmpty(openApiVO.getNetworks()) ? List.of("IPv4 DHCP Mode") : openApiVO.getNetworks());
        webVO.setType(openApiVO.getType());
        webVO.setStackId(openApiVO.getStackId());
        webVO.setModel(null);
        webVO.setModelVersion(null);
        webVO.setDeviceSeriesType(null);
        return webVO;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public Integer getPriority() {
        return this.priority;
    }

    @Generated
    public Integer getVlanInterface() {
        return this.vlanInterface;
    }

    @Generated
    public Integer getTrackedInterface() {
        return this.trackedInterface;
    }

    @Generated
    public Integer getReducedPriority() {
        return this.reducedPriority;
    }

    @Generated
    public List<String> getNetworks() {
        return this.networks;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getStackId() {
        return this.stackId;
    }

    @Generated
    public OswVrrpDeviceConfigOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public OswVrrpDeviceConfigOpenApiVO setMac(String mac) {
        this.mac = mac;
        return this;
    }

    @Generated
    public OswVrrpDeviceConfigOpenApiVO setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Generated
    public OswVrrpDeviceConfigOpenApiVO setVlanInterface(Integer vlanInterface) {
        this.vlanInterface = vlanInterface;
        return this;
    }

    @Generated
    public OswVrrpDeviceConfigOpenApiVO setTrackedInterface(Integer trackedInterface) {
        this.trackedInterface = trackedInterface;
        return this;
    }

    @Generated
    public OswVrrpDeviceConfigOpenApiVO setReducedPriority(Integer reducedPriority) {
        this.reducedPriority = reducedPriority;
        return this;
    }

    @Generated
    public OswVrrpDeviceConfigOpenApiVO setNetworks(List<String> networks) {
        this.networks = networks;
        return this;
    }

    @Generated
    public OswVrrpDeviceConfigOpenApiVO setType(String type) {
        this.type = type;
        return this;
    }

    @Generated
    public OswVrrpDeviceConfigOpenApiVO setStackId(String stackId) {
        this.stackId = stackId;
        return this;
    }
}

