/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.vrrp.dto;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.vrrp.dto.OswVrrpDeviceConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.OswVrrpDeviceVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.OswVrrpVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class OswVrrpConfigOpenApiVO {
    @NotNull(message="VRRP parameter [name] should not be null")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.")
    @Schema(name="name", description="VRRP name, it should be visible ASCII, and should contain 1 to 64 characters.")
    private @NotNull(message="VRRP parameter [name] should not be null") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.") String name;
    @NotNull(message="VRRP parameter [vrId] should not be null")
    @Range(max=255L, min=1L, message="Value of vrId is from 1 to 255.")
    @Schema(name="vrId", description="Virtual Router ID, its value should be within the range of 1-255.")
    private @NotNull(message="VRRP parameter [vrId] should not be null") @Range(max=255L, min=1L, message="Value of vrId is from 1 to 255.") Integer vrId;
    @Valid
    @Size(min=1, max=8, message="Size of deviceList should between 1 and 8.")
    @Schema(name="deviceList", description="Up to 8 entries are allowed for the deviceList, and it cannot be empty.")
    private @Valid @Size(min=1, max=8, message="Size of deviceList should between 1 and 8.") List<OswVrrpDeviceConfigOpenApiVO> deviceList;
    @Size(max=32, message="Size of virtualIpv4s should less than 32.")
    @Schema(name="virtualIpv4s", description="Up to 32 entries are allowed for the virtualIpv4s.")
    private @Size(max=32, message="Size of virtualIpv4s should less than 32.") List<String> virtualIpv4s;
    @Schema(name="ipV6LinkLocal", description="Virtual IpV6LinkLocal Address")
    private String ipV6LinkLocal;
    @Size(max=15, message="size of virtualIpV6Global should less than 15.")
    @Schema(name="ipV6Global", description="Up to 15 entries are allowed for the ipV6Global.")
    private @Size(max=15, message="size of virtualIpV6Global should less than 15.") List<String> ipV6Global;
    @NotNull(message="VRRP parameter [advertiseTimer] should not be null")
    @Range(max=255L, min=1L, message="Value of advertiseTimer is from 1 to 255.")
    @Schema(name="advertiseTimer", description="AdvertiseTimer should be within the range of 1-255, the default setting value is 100 and the unit is millimeter second.")
    private @NotNull(message="VRRP parameter [advertiseTimer] should not be null") @Range(max=255L, min=1L, message="Value of advertiseTimer is from 1 to 255.") Integer advertiseTimer;
    @NotNull(message="VRRP parameter [preemptMode] should not be null")
    @Schema(name="preemptMode", description="Whether the preemption mode is enabled or not, it defaults to enabled.")
    private @NotNull(message="VRRP parameter [preemptMode] should not be null") Boolean preemptMode;
    @NotNull(message="VRRP parameter [delayTime] should not be null")
    @Range(max=255L, min=0L, message="Value of delayTime is from 0 to 255.")
    @Schema(name="delayTime", description="DelayTime should be within the range of 0-255, default setting is 0 and the unit is second")
    private @NotNull(message="VRRP parameter [delayTime] should not be null") @Range(max=255L, min=0L, message="Value of delayTime is from 0 to 255.") Integer delayTime;
    @NotNull(message="VRRP parameter [authentication] should not be null")
    @Range(min=0L, max=2L, message="Value of authentication is from 0 to 2.")
    @Schema(name="authentication", description="Authentication type should be a value as follows: 0: NONE, 1: Simple, 2: MD5")
    private @NotNull(message="VRRP parameter [authentication] should not be null") @Range(min=0L, max=2L, message="Value of authentication is from 0 to 2.") Integer authentication;
    @Pattern(regexp="^(?:[A-Za-z0-9]|[-./:_@]){1,8}$", message="Parameter [key] should be visible ASCII, between 1 and 8 characters.")
    @Schema(name="key", description="Key of VRRP")
    private @Pattern(regexp="^(?:[A-Za-z0-9]|[-./:_@]){1,8}$", message="Parameter [key] should be visible ASCII, between 1 and 8 characters.") String key;

    public static OswVrrpConfigOpenApiVO buildByWebVO(OswVrrpVO webVO) {
        if (Objects.isNull(webVO)) {
            return null;
        }
        ArrayList<OswVrrpDeviceConfigOpenApiVO> deviceList = new ArrayList<OswVrrpDeviceConfigOpenApiVO>();
        if (!CollectionUtils.isEmpty((Collection)webVO.getDeviceList())) {
            for (OswVrrpDeviceVO vo : webVO.getDeviceList()) {
                deviceList.add(OswVrrpDeviceConfigOpenApiVO.buildByWebVO(vo));
            }
        }
        OswVrrpConfigOpenApiVO oswVrrpConfigOpenApiVO = new OswVrrpConfigOpenApiVO();
        oswVrrpConfigOpenApiVO.setName(webVO.getName()).setVrId(webVO.getVrId()).setDeviceList(deviceList).setVirtualIpv4s(CollectionUtils.isEmpty((Collection)webVO.getVirtualIpv4s()) ? new ArrayList() : webVO.getVirtualIpv4s()).setIpV6LinkLocal(webVO.getIpV6LinkLocal()).setIpV6Global(CollectionUtils.isEmpty((Collection)webVO.getIpV6Global()) ? new ArrayList() : webVO.getIpV6Global()).setAdvertiseTimer(webVO.getAdvertiseTimer()).setPreemptMode(webVO.getPreemptMode()).setDelayTime(webVO.getDelayTime()).setAuthentication(webVO.getAuthentication()).setKey(webVO.getKey());
        return oswVrrpConfigOpenApiVO;
    }

    public static OswVrrpVO toWebVO(OswVrrpConfigOpenApiVO oswVrrpConfigOpenApiVO) {
        if (Objects.isNull(oswVrrpConfigOpenApiVO)) {
            return null;
        }
        ArrayList<OswVrrpDeviceVO> deviceList = new ArrayList<OswVrrpDeviceVO>();
        if (!CollectionUtils.isEmpty(oswVrrpConfigOpenApiVO.getDeviceList())) {
            for (OswVrrpDeviceConfigOpenApiVO vo : oswVrrpConfigOpenApiVO.getDeviceList()) {
                deviceList.add(OswVrrpDeviceConfigOpenApiVO.toWebVO(vo));
            }
        }
        OswVrrpVO webVO = new OswVrrpVO();
        webVO.setId(null);
        webVO.setName(oswVrrpConfigOpenApiVO.getName());
        webVO.setVrId(oswVrrpConfigOpenApiVO.getVrId());
        webVO.setDeviceList(deviceList);
        webVO.setVirtualIpv4s(CollectionUtils.isEmpty(oswVrrpConfigOpenApiVO.getVirtualIpv4s()) ? new ArrayList() : oswVrrpConfigOpenApiVO.getVirtualIpv4s());
        webVO.setIpV6LinkLocal(oswVrrpConfigOpenApiVO.getIpV6LinkLocal());
        webVO.setIpV6Global(CollectionUtils.isEmpty(oswVrrpConfigOpenApiVO.getIpV6Global()) ? new ArrayList() : oswVrrpConfigOpenApiVO.getIpV6Global());
        webVO.setAdvertiseTimer(oswVrrpConfigOpenApiVO.getAdvertiseTimer());
        webVO.setPreemptMode(oswVrrpConfigOpenApiVO.getPreemptMode());
        webVO.setDelayTime(oswVrrpConfigOpenApiVO.getDelayTime());
        webVO.setAuthentication(oswVrrpConfigOpenApiVO.getAuthentication());
        webVO.setKey(oswVrrpConfigOpenApiVO.getKey());
        webVO.setStatus(null);
        webVO.setIpv4MasterDevice(null);
        webVO.setIpv6MasterDevice(null);
        return webVO;
    }

    public static String[] getSearchKeys() {
        return new String[]{"name"};
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getVrId() {
        return this.vrId;
    }

    @Generated
    public List<OswVrrpDeviceConfigOpenApiVO> getDeviceList() {
        return this.deviceList;
    }

    @Generated
    public List<String> getVirtualIpv4s() {
        return this.virtualIpv4s;
    }

    @Generated
    public String getIpV6LinkLocal() {
        return this.ipV6LinkLocal;
    }

    @Generated
    public List<String> getIpV6Global() {
        return this.ipV6Global;
    }

    @Generated
    public Integer getAdvertiseTimer() {
        return this.advertiseTimer;
    }

    @Generated
    public Boolean getPreemptMode() {
        return this.preemptMode;
    }

    @Generated
    public Integer getDelayTime() {
        return this.delayTime;
    }

    @Generated
    public Integer getAuthentication() {
        return this.authentication;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public OswVrrpConfigOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public OswVrrpConfigOpenApiVO setVrId(Integer vrId) {
        this.vrId = vrId;
        return this;
    }

    @Generated
    public OswVrrpConfigOpenApiVO setDeviceList(List<OswVrrpDeviceConfigOpenApiVO> deviceList) {
        this.deviceList = deviceList;
        return this;
    }

    @Generated
    public OswVrrpConfigOpenApiVO setVirtualIpv4s(List<String> virtualIpv4s) {
        this.virtualIpv4s = virtualIpv4s;
        return this;
    }

    @Generated
    public OswVrrpConfigOpenApiVO setIpV6LinkLocal(String ipV6LinkLocal) {
        this.ipV6LinkLocal = ipV6LinkLocal;
        return this;
    }

    @Generated
    public OswVrrpConfigOpenApiVO setIpV6Global(List<String> ipV6Global) {
        this.ipV6Global = ipV6Global;
        return this;
    }

    @Generated
    public OswVrrpConfigOpenApiVO setAdvertiseTimer(Integer advertiseTimer) {
        this.advertiseTimer = advertiseTimer;
        return this;
    }

    @Generated
    public OswVrrpConfigOpenApiVO setPreemptMode(Boolean preemptMode) {
        this.preemptMode = preemptMode;
        return this;
    }

    @Generated
    public OswVrrpConfigOpenApiVO setDelayTime(Integer delayTime) {
        this.delayTime = delayTime;
        return this;
    }

    @Generated
    public OswVrrpConfigOpenApiVO setAuthentication(Integer authentication) {
        this.authentication = authentication;
        return this;
    }

    @Generated
    public OswVrrpConfigOpenApiVO setKey(String key) {
        this.key = key;
        return this;
    }
}

