/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.routing.dto;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.StaticRoutingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="StaticRoutingConfigTemplate")
public class StaticRoutingTemplateOpenApiVO {
    @NotNull(message="StaticRouting parameter [name] should not be null")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.")
    @Schema(name="name", description="Name, name should contain 1 to 64 characters.")
    private @NotNull(message="StaticRouting parameter [name] should not be null") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.") String name;
    @NotNull(message="StaticRouting parameter [status] should not be null")
    @Schema(name="status", description="Status")
    private @NotNull(message="StaticRouting parameter [status] should not be null") Boolean status;
    @NotNull(message="StaticRouting parameter [destinations] should not be null")
    @Schema(name="destinations", description="IP address/SubNet")
    private @NotNull(message="StaticRouting parameter [destinations] should not be null") List<String> destinations;
    @NotNull(message="StaticRouting parameter [routeType] should not be null")
    @Schema(name="routeType", description="RouteType should be a value as follows: 0: NextHop; 1: Interface")
    @Range(min=0L, max=1L)
    private @NotNull(message="StaticRouting parameter [routeType] should not be null") @Range(min=0L, max=1L) Integer routeType;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [nextHopIp] Invalid.")
    @Schema(name="nextHopIp", description="Only for routeType:0 or routeType:1 and selected WAN is Static IP/Dynamic IP mode")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [nextHopIp] Invalid.") String nextHopIp;
    @NumberSet(value={0, 1, 2, 3, 5})
    @Schema(name="interfaceType", description="Only for routeType:1, interfaceType should be a value as follows: 0: Internet(WAN); 1: Network(LAN); 2: L2TP, 3: PPTP, 5: Virtual WAN.")
    private Integer interfaceType;
    @Schema(name="interfaceId", description="Interface ID, for example: if interfaceType is network, interfaceId should be LAN network ID. LAN Network can be created using 'Create LAN network template' interface, and LAN Network ID can be obtained from 'Get LAN network list template' interface.")
    private String interfaceId;
    @NotNull(message="StaticRouting parameter [metric] should not be null")
    @Range(min=0L, max=15L, message="Value of metric is from 0 to 15.")
    @Schema(name="metric", description="Metric should be within the range of 0\u201315.")
    private @NotNull(message="StaticRouting parameter [metric] should not be null") @Range(min=0L, max=15L, message="Value of metric is from 0 to 15.") Integer metric;

    public static StaticRoutingVO toWebVO(StaticRoutingTemplateOpenApiVO vo) {
        StaticRoutingVO staticRoutingVO = new StaticRoutingVO();
        staticRoutingVO.setName(vo.getName());
        staticRoutingVO.setDestinations(vo.getDestinations());
        staticRoutingVO.setInterfaceId(vo.getInterfaceId());
        staticRoutingVO.setInterfaceType(vo.getInterfaceType());
        staticRoutingVO.setNextHopIp(vo.getNextHopIp());
        staticRoutingVO.setRouteType(vo.getRouteType());
        staticRoutingVO.setMetric(vo.getMetric());
        staticRoutingVO.setStatus(vo.getStatus());
        return staticRoutingVO;
    }

    @Generated
    protected StaticRoutingTemplateOpenApiVO(StaticRoutingTemplateOpenApiVOBuilder<?, ?> b2) {
        this.name = b2.name;
        this.status = b2.status;
        this.destinations = b2.destinations;
        this.routeType = b2.routeType;
        this.nextHopIp = b2.nextHopIp;
        this.interfaceType = b2.interfaceType;
        this.interfaceId = b2.interfaceId;
        this.metric = b2.metric;
    }

    @Generated
    public static StaticRoutingTemplateOpenApiVOBuilder<?, ?> builder() {
        return new StaticRoutingTemplateOpenApiVOBuilderImpl();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public List<String> getDestinations() {
        return this.destinations;
    }

    @Generated
    public Integer getRouteType() {
        return this.routeType;
    }

    @Generated
    public String getNextHopIp() {
        return this.nextHopIp;
    }

    @Generated
    public Integer getInterfaceType() {
        return this.interfaceType;
    }

    @Generated
    public String getInterfaceId() {
        return this.interfaceId;
    }

    @Generated
    public Integer getMetric() {
        return this.metric;
    }

    @Generated
    public StaticRoutingTemplateOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public StaticRoutingTemplateOpenApiVO setStatus(Boolean status) {
        this.status = status;
        return this;
    }

    @Generated
    public StaticRoutingTemplateOpenApiVO setDestinations(List<String> destinations) {
        this.destinations = destinations;
        return this;
    }

    @Generated
    public StaticRoutingTemplateOpenApiVO setRouteType(Integer routeType) {
        this.routeType = routeType;
        return this;
    }

    @Generated
    public StaticRoutingTemplateOpenApiVO setNextHopIp(String nextHopIp) {
        this.nextHopIp = nextHopIp;
        return this;
    }

    @Generated
    public StaticRoutingTemplateOpenApiVO setInterfaceType(Integer interfaceType) {
        this.interfaceType = interfaceType;
        return this;
    }

    @Generated
    public StaticRoutingTemplateOpenApiVO setInterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
        return this;
    }

    @Generated
    public StaticRoutingTemplateOpenApiVO setMetric(Integer metric) {
        this.metric = metric;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StaticRoutingTemplateOpenApiVO)) {
            return false;
        }
        StaticRoutingTemplateOpenApiVO other = (StaticRoutingTemplateOpenApiVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$status = this.getStatus();
        Boolean other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$routeType = this.getRouteType();
        Integer other$routeType = other.getRouteType();
        if (this$routeType == null ? other$routeType != null : !((Object)this$routeType).equals(other$routeType)) {
            return false;
        }
        Integer this$interfaceType = this.getInterfaceType();
        Integer other$interfaceType = other.getInterfaceType();
        if (this$interfaceType == null ? other$interfaceType != null : !((Object)this$interfaceType).equals(other$interfaceType)) {
            return false;
        }
        Integer this$metric = this.getMetric();
        Integer other$metric = other.getMetric();
        if (this$metric == null ? other$metric != null : !((Object)this$metric).equals(other$metric)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$destinations = this.getDestinations();
        List<String> other$destinations = other.getDestinations();
        if (this$destinations == null ? other$destinations != null : !((Object)this$destinations).equals(other$destinations)) {
            return false;
        }
        String this$nextHopIp = this.getNextHopIp();
        String other$nextHopIp = other.getNextHopIp();
        if (this$nextHopIp == null ? other$nextHopIp != null : !this$nextHopIp.equals(other$nextHopIp)) {
            return false;
        }
        String this$interfaceId = this.getInterfaceId();
        String other$interfaceId = other.getInterfaceId();
        return !(this$interfaceId == null ? other$interfaceId != null : !this$interfaceId.equals(other$interfaceId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StaticRoutingTemplateOpenApiVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $routeType = this.getRouteType();
        result = result * 59 + ($routeType == null ? 43 : ((Object)$routeType).hashCode());
        Integer $interfaceType = this.getInterfaceType();
        result = result * 59 + ($interfaceType == null ? 43 : ((Object)$interfaceType).hashCode());
        Integer $metric = this.getMetric();
        result = result * 59 + ($metric == null ? 43 : ((Object)$metric).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $destinations = this.getDestinations();
        result = result * 59 + ($destinations == null ? 43 : ((Object)$destinations).hashCode());
        String $nextHopIp = this.getNextHopIp();
        result = result * 59 + ($nextHopIp == null ? 43 : $nextHopIp.hashCode());
        String $interfaceId = this.getInterfaceId();
        result = result * 59 + ($interfaceId == null ? 43 : $interfaceId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StaticRoutingTemplateOpenApiVO(name=" + this.getName() + ", status=" + this.getStatus() + ", destinations=" + this.getDestinations() + ", routeType=" + this.getRouteType() + ", nextHopIp=" + this.getNextHopIp() + ", interfaceType=" + this.getInterfaceType() + ", interfaceId=" + this.getInterfaceId() + ", metric=" + this.getMetric() + ")";
    }

    @Generated
    public StaticRoutingTemplateOpenApiVO(String name, Boolean status, List<String> destinations, Integer routeType, String nextHopIp, Integer interfaceType, String interfaceId, Integer metric) {
        this.name = name;
        this.status = status;
        this.destinations = destinations;
        this.routeType = routeType;
        this.nextHopIp = nextHopIp;
        this.interfaceType = interfaceType;
        this.interfaceId = interfaceId;
        this.metric = metric;
    }

    @Generated
    public StaticRoutingTemplateOpenApiVO() {
    }

    @Generated
    public static abstract class StaticRoutingTemplateOpenApiVOBuilder<C extends StaticRoutingTemplateOpenApiVO, B extends StaticRoutingTemplateOpenApiVOBuilder<C, B>> {
        @Generated
        private String name;
        @Generated
        private Boolean status;
        @Generated
        private List<String> destinations;
        @Generated
        private Integer routeType;
        @Generated
        private String nextHopIp;
        @Generated
        private Integer interfaceType;
        @Generated
        private String interfaceId;
        @Generated
        private Integer metric;

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B status(Boolean status) {
            this.status = status;
            return this.self();
        }

        @Generated
        public B destinations(List<String> destinations) {
            this.destinations = destinations;
            return this.self();
        }

        @Generated
        public B routeType(Integer routeType) {
            this.routeType = routeType;
            return this.self();
        }

        @Generated
        public B nextHopIp(String nextHopIp) {
            this.nextHopIp = nextHopIp;
            return this.self();
        }

        @Generated
        public B interfaceType(Integer interfaceType) {
            this.interfaceType = interfaceType;
            return this.self();
        }

        @Generated
        public B interfaceId(String interfaceId) {
            this.interfaceId = interfaceId;
            return this.self();
        }

        @Generated
        public B metric(Integer metric) {
            this.metric = metric;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "StaticRoutingTemplateOpenApiVO.StaticRoutingTemplateOpenApiVOBuilder(name=" + this.name + ", status=" + this.status + ", destinations=" + this.destinations + ", routeType=" + this.routeType + ", nextHopIp=" + this.nextHopIp + ", interfaceType=" + this.interfaceType + ", interfaceId=" + this.interfaceId + ", metric=" + this.metric + ")";
        }
    }

    @Generated
    private static final class StaticRoutingTemplateOpenApiVOBuilderImpl
    extends StaticRoutingTemplateOpenApiVOBuilder<StaticRoutingTemplateOpenApiVO, StaticRoutingTemplateOpenApiVOBuilderImpl> {
        @Generated
        private StaticRoutingTemplateOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected StaticRoutingTemplateOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public StaticRoutingTemplateOpenApiVO build() {
            return new StaticRoutingTemplateOpenApiVO(this);
        }
    }
}

