/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.routing.dto;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.StaticRoutingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="StaticRoutingConfig")
public class StaticRoutingOpenApiVO {
    @NotNull(message="StaticRouting parameter [name] should not be null")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.")
    @Schema(name="name", description="Name, name should contain 1 to 64 characters.")
    private @NotNull(message="StaticRouting parameter [name] should not be null") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.") String name;
    @NotNull(message="StaticRouting parameter [status] should not be null")
    @Schema(name="status", description="Status")
    private @NotNull(message="StaticRouting parameter [status] should not be null") Boolean status;
    @NotNull(message="StaticRouting parameter [destinations] should not be null")
    @Schema(name="destinations", description="IP address/SubNet")
    private @NotNull(message="StaticRouting parameter [destinations] should not be null") List<String> destinations;
    @NotNull(message="StaticRouting parameter [routeType] should not be null")
    @Schema(name="routeType", description="RouteType should be a value as follows: 0: NextHop; 1: Interface")
    @Range(min=0L, max=1L)
    private @NotNull(message="StaticRouting parameter [routeType] should not be null") @Range(min=0L, max=1L) Integer routeType;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [nextHopIp] Invalid.")
    @Schema(name="nextHopIp", description="Only for routeType:0 or routeType:1 and selected WAN is Static IP/Dynamic IP mode")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [nextHopIp] Invalid.") String nextHopIp;
    @NumberSet(value={0, 1, 2, 3, 5})
    @Schema(name="interfaceType", description="Only for routeType:1, interfaceType should be a value as follows: 0: Internet(WAN); 1: Network(LAN); 2: L2TP, 3: PPTP, 5: Virtual WAN.")
    private Integer interfaceType;
    @Schema(name="interfaceId", description="Interface ID, for example: if interfaceType is network, interfaceId should be LAN network ID. LAN Network can be created using 'Create LAN network' interface, and LAN Network ID can be obtained from 'Get LAN network list' interface.")
    private String interfaceId;
    @NotNull(message="StaticRouting parameter [metric] should not be null")
    @Range(min=0L, max=15L, message="Value of metric is from 0 to 15.")
    @Schema(name="metric", description="Metric should be within the range of 0\u201315.")
    private @NotNull(message="StaticRouting parameter [metric] should not be null") @Range(min=0L, max=15L, message="Value of metric is from 0 to 15.") Integer metric;

    public static StaticRoutingVO toWebVO(StaticRoutingOpenApiVO vo) {
        StaticRoutingVO staticRoutingVO = new StaticRoutingVO();
        staticRoutingVO.setName(vo.getName());
        staticRoutingVO.setDestinations(vo.getDestinations());
        staticRoutingVO.setInterfaceId(vo.getInterfaceId());
        staticRoutingVO.setInterfaceType(vo.getInterfaceType());
        staticRoutingVO.setNextHopIp(vo.getNextHopIp());
        staticRoutingVO.setRouteType(vo.getRouteType());
        staticRoutingVO.setMetric(vo.getMetric());
        staticRoutingVO.setStatus(vo.getStatus());
        return staticRoutingVO;
    }

    @Generated
    protected StaticRoutingOpenApiVO(StaticRoutingOpenApiVOBuilder<?, ?> b2) {
        this.name = b2.name;
        this.status = b2.status;
        this.destinations = b2.destinations;
        this.routeType = b2.routeType;
        this.nextHopIp = b2.nextHopIp;
        this.interfaceType = b2.interfaceType;
        this.interfaceId = b2.interfaceId;
        this.metric = b2.metric;
    }

    @Generated
    public static StaticRoutingOpenApiVOBuilder<?, ?> builder() {
        return new StaticRoutingOpenApiVOBuilderImpl();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public List<String> getDestinations() {
        return this.destinations;
    }

    @Generated
    public Integer getRouteType() {
        return this.routeType;
    }

    @Generated
    public String getNextHopIp() {
        return this.nextHopIp;
    }

    @Generated
    public Integer getInterfaceType() {
        return this.interfaceType;
    }

    @Generated
    public String getInterfaceId() {
        return this.interfaceId;
    }

    @Generated
    public Integer getMetric() {
        return this.metric;
    }

    @Generated
    public StaticRoutingOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public StaticRoutingOpenApiVO setStatus(Boolean status) {
        this.status = status;
        return this;
    }

    @Generated
    public StaticRoutingOpenApiVO setDestinations(List<String> destinations) {
        this.destinations = destinations;
        return this;
    }

    @Generated
    public StaticRoutingOpenApiVO setRouteType(Integer routeType) {
        this.routeType = routeType;
        return this;
    }

    @Generated
    public StaticRoutingOpenApiVO setNextHopIp(String nextHopIp) {
        this.nextHopIp = nextHopIp;
        return this;
    }

    @Generated
    public StaticRoutingOpenApiVO setInterfaceType(Integer interfaceType) {
        this.interfaceType = interfaceType;
        return this;
    }

    @Generated
    public StaticRoutingOpenApiVO setInterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
        return this;
    }

    @Generated
    public StaticRoutingOpenApiVO setMetric(Integer metric) {
        this.metric = metric;
        return this;
    }

    @Generated
    public String toString() {
        return "StaticRoutingOpenApiVO(name=" + this.getName() + ", status=" + this.getStatus() + ", destinations=" + this.getDestinations() + ", routeType=" + this.getRouteType() + ", nextHopIp=" + this.getNextHopIp() + ", interfaceType=" + this.getInterfaceType() + ", interfaceId=" + this.getInterfaceId() + ", metric=" + this.getMetric() + ")";
    }

    @Generated
    public StaticRoutingOpenApiVO(String name, Boolean status, List<String> destinations, Integer routeType, String nextHopIp, Integer interfaceType, String interfaceId, Integer metric) {
        this.name = name;
        this.status = status;
        this.destinations = destinations;
        this.routeType = routeType;
        this.nextHopIp = nextHopIp;
        this.interfaceType = interfaceType;
        this.interfaceId = interfaceId;
        this.metric = metric;
    }

    @Generated
    public StaticRoutingOpenApiVO() {
    }

    @Generated
    public static abstract class StaticRoutingOpenApiVOBuilder<C extends StaticRoutingOpenApiVO, B extends StaticRoutingOpenApiVOBuilder<C, B>> {
        @Generated
        private String name;
        @Generated
        private Boolean status;
        @Generated
        private List<String> destinations;
        @Generated
        private Integer routeType;
        @Generated
        private String nextHopIp;
        @Generated
        private Integer interfaceType;
        @Generated
        private String interfaceId;
        @Generated
        private Integer metric;

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B status(Boolean status) {
            this.status = status;
            return this.self();
        }

        @Generated
        public B destinations(List<String> destinations) {
            this.destinations = destinations;
            return this.self();
        }

        @Generated
        public B routeType(Integer routeType) {
            this.routeType = routeType;
            return this.self();
        }

        @Generated
        public B nextHopIp(String nextHopIp) {
            this.nextHopIp = nextHopIp;
            return this.self();
        }

        @Generated
        public B interfaceType(Integer interfaceType) {
            this.interfaceType = interfaceType;
            return this.self();
        }

        @Generated
        public B interfaceId(String interfaceId) {
            this.interfaceId = interfaceId;
            return this.self();
        }

        @Generated
        public B metric(Integer metric) {
            this.metric = metric;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "StaticRoutingOpenApiVO.StaticRoutingOpenApiVOBuilder(name=" + this.name + ", status=" + this.status + ", destinations=" + this.destinations + ", routeType=" + this.routeType + ", nextHopIp=" + this.nextHopIp + ", interfaceType=" + this.interfaceType + ", interfaceId=" + this.interfaceId + ", metric=" + this.metric + ")";
        }
    }

    @Generated
    private static final class StaticRoutingOpenApiVOBuilderImpl
    extends StaticRoutingOpenApiVOBuilder<StaticRoutingOpenApiVO, StaticRoutingOpenApiVOBuilderImpl> {
        @Generated
        private StaticRoutingOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected StaticRoutingOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public StaticRoutingOpenApiVO build() {
            return new StaticRoutingOpenApiVO(this);
        }
    }
}

