/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.routing.dto;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.StaticRoutingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="StaticRoutingInfo")
public class StaticRoutingInfoOpenApiVO {
    @Schema(name="id", description="ID")
    private String id;
    @NotNull(message="StaticRouting parameter [name] should not be null")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.")
    @Schema(name="name", description="Name, name should contain 1 to 64 characters.")
    private @NotNull(message="StaticRouting parameter [name] should not be null") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.") String name;
    @NotNull(message="StaticRouting parameter [status] should not be null")
    @Schema(name="status", description="Status")
    private @NotNull(message="StaticRouting parameter [status] should not be null") Boolean status;
    @NotNull(message="StaticRouting parameter [destinations] should not be null")
    @Schema(name="destinations", description="IP address/SubNet, up to 16 entries are allowed for the destinations list.")
    private @NotNull(message="StaticRouting parameter [destinations] should not be null") List<String> destinations;
    @NotNull(message="StaticRouting parameter [routeType] should not be null")
    @Schema(name="routeType", description="RouteType should be a value as follows: 0: NextHop; 1: Interface")
    @Range(min=0L, max=1L)
    private @NotNull(message="StaticRouting parameter [routeType] should not be null") @Range(min=0L, max=1L) Integer routeType;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [nextHopIp] Invalid.")
    @Schema(name="nextHopIp", description="Only for routeType:0 or routeType:1 and selected WAN is Static IP/Dynamic IP mode")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [nextHopIp] Invalid.") String nextHopIp;
    @NumberSet(value={0, 1, 2, 3, 5})
    @Schema(name="interfaceType", description="Only for routeType:1, interfaceType should be a value as follows: 0: Internet(WAN); 1: Network(LAN); 2: L2TP, 3: PPTP, 5: Virtual WAN.")
    private Integer interfaceType;
    @Schema(name="interfaceId", description="Interface ID, for example: if interfaceType is network, interfaceId should be LAN network ID. LAN Network can be created using 'Create LAN network' interface, and LAN Network ID can be obtained from 'Get LAN network list' interface.")
    private String interfaceId;
    @NotNull(message="StaticRouting parameter [metric] should not be null")
    @Range(min=0L, max=15L, message="Value of metric is from 0 to 15.")
    @Schema(name="metric", description="Metric should be within the range of 0\u201315.")
    private @NotNull(message="StaticRouting parameter [metric] should not be null") @Range(min=0L, max=15L, message="Value of metric is from 0 to 15.") Integer metric;
    @Schema(name="existVpnClient", description="Whether the interface option exists VPN client")
    private Boolean existVpnClient;
    @Schema(name="existVirtualWan", description="Whether the interface option exists virtual WAN")
    private Boolean existVirtualWan;

    public static StaticRoutingInfoOpenApiVO buildByWebVO(StaticRoutingVO vo) {
        return ((StaticRoutingInfoOpenApiVOBuilder)((StaticRoutingInfoOpenApiVOBuilder)((StaticRoutingInfoOpenApiVOBuilder)((StaticRoutingInfoOpenApiVOBuilder)((StaticRoutingInfoOpenApiVOBuilder)((StaticRoutingInfoOpenApiVOBuilder)((StaticRoutingInfoOpenApiVOBuilder)((StaticRoutingInfoOpenApiVOBuilder)((StaticRoutingInfoOpenApiVOBuilder)((StaticRoutingInfoOpenApiVOBuilder)((StaticRoutingInfoOpenApiVOBuilder)StaticRoutingInfoOpenApiVO.builder().id(vo.getId())).name(vo.getName())).status(vo.getStatus())).destinations(vo.getDestinations())).routeType(vo.getRouteType())).nextHopIp(vo.getNextHopIp())).interfaceType(vo.getInterfaceType())).interfaceId(vo.getInterfaceId())).metric(vo.getMetric())).existVpnClient(vo.getExistVpnClient())).existVirtualWan(vo.getExistVirtualWan())).build();
    }

    @Generated
    protected StaticRoutingInfoOpenApiVO(StaticRoutingInfoOpenApiVOBuilder<?, ?> b2) {
        this.id = b2.id;
        this.name = b2.name;
        this.status = b2.status;
        this.destinations = b2.destinations;
        this.routeType = b2.routeType;
        this.nextHopIp = b2.nextHopIp;
        this.interfaceType = b2.interfaceType;
        this.interfaceId = b2.interfaceId;
        this.metric = b2.metric;
        this.existVpnClient = b2.existVpnClient;
        this.existVirtualWan = b2.existVirtualWan;
    }

    @Generated
    public static StaticRoutingInfoOpenApiVOBuilder<?, ?> builder() {
        return new StaticRoutingInfoOpenApiVOBuilderImpl();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public List<String> getDestinations() {
        return this.destinations;
    }

    @Generated
    public Integer getRouteType() {
        return this.routeType;
    }

    @Generated
    public String getNextHopIp() {
        return this.nextHopIp;
    }

    @Generated
    public Integer getInterfaceType() {
        return this.interfaceType;
    }

    @Generated
    public String getInterfaceId() {
        return this.interfaceId;
    }

    @Generated
    public Integer getMetric() {
        return this.metric;
    }

    @Generated
    public Boolean getExistVpnClient() {
        return this.existVpnClient;
    }

    @Generated
    public Boolean getExistVirtualWan() {
        return this.existVirtualWan;
    }

    @Generated
    public StaticRoutingInfoOpenApiVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public StaticRoutingInfoOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public StaticRoutingInfoOpenApiVO setStatus(Boolean status) {
        this.status = status;
        return this;
    }

    @Generated
    public StaticRoutingInfoOpenApiVO setDestinations(List<String> destinations) {
        this.destinations = destinations;
        return this;
    }

    @Generated
    public StaticRoutingInfoOpenApiVO setRouteType(Integer routeType) {
        this.routeType = routeType;
        return this;
    }

    @Generated
    public StaticRoutingInfoOpenApiVO setNextHopIp(String nextHopIp) {
        this.nextHopIp = nextHopIp;
        return this;
    }

    @Generated
    public StaticRoutingInfoOpenApiVO setInterfaceType(Integer interfaceType) {
        this.interfaceType = interfaceType;
        return this;
    }

    @Generated
    public StaticRoutingInfoOpenApiVO setInterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
        return this;
    }

    @Generated
    public StaticRoutingInfoOpenApiVO setMetric(Integer metric) {
        this.metric = metric;
        return this;
    }

    @Generated
    public StaticRoutingInfoOpenApiVO setExistVpnClient(Boolean existVpnClient) {
        this.existVpnClient = existVpnClient;
        return this;
    }

    @Generated
    public StaticRoutingInfoOpenApiVO setExistVirtualWan(Boolean existVirtualWan) {
        this.existVirtualWan = existVirtualWan;
        return this;
    }

    @Generated
    public String toString() {
        return "StaticRoutingInfoOpenApiVO(id=" + this.getId() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", destinations=" + this.getDestinations() + ", routeType=" + this.getRouteType() + ", nextHopIp=" + this.getNextHopIp() + ", interfaceType=" + this.getInterfaceType() + ", interfaceId=" + this.getInterfaceId() + ", metric=" + this.getMetric() + ", existVpnClient=" + this.getExistVpnClient() + ", existVirtualWan=" + this.getExistVirtualWan() + ")";
    }

    @Generated
    public StaticRoutingInfoOpenApiVO(String id, String name, Boolean status, List<String> destinations, Integer routeType, String nextHopIp, Integer interfaceType, String interfaceId, Integer metric, Boolean existVpnClient, Boolean existVirtualWan) {
        this.id = id;
        this.name = name;
        this.status = status;
        this.destinations = destinations;
        this.routeType = routeType;
        this.nextHopIp = nextHopIp;
        this.interfaceType = interfaceType;
        this.interfaceId = interfaceId;
        this.metric = metric;
        this.existVpnClient = existVpnClient;
        this.existVirtualWan = existVirtualWan;
    }

    @Generated
    public StaticRoutingInfoOpenApiVO() {
    }

    @Generated
    public static abstract class StaticRoutingInfoOpenApiVOBuilder<C extends StaticRoutingInfoOpenApiVO, B extends StaticRoutingInfoOpenApiVOBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private Boolean status;
        @Generated
        private List<String> destinations;
        @Generated
        private Integer routeType;
        @Generated
        private String nextHopIp;
        @Generated
        private Integer interfaceType;
        @Generated
        private String interfaceId;
        @Generated
        private Integer metric;
        @Generated
        private Boolean existVpnClient;
        @Generated
        private Boolean existVirtualWan;

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B status(Boolean status) {
            this.status = status;
            return this.self();
        }

        @Generated
        public B destinations(List<String> destinations) {
            this.destinations = destinations;
            return this.self();
        }

        @Generated
        public B routeType(Integer routeType) {
            this.routeType = routeType;
            return this.self();
        }

        @Generated
        public B nextHopIp(String nextHopIp) {
            this.nextHopIp = nextHopIp;
            return this.self();
        }

        @Generated
        public B interfaceType(Integer interfaceType) {
            this.interfaceType = interfaceType;
            return this.self();
        }

        @Generated
        public B interfaceId(String interfaceId) {
            this.interfaceId = interfaceId;
            return this.self();
        }

        @Generated
        public B metric(Integer metric) {
            this.metric = metric;
            return this.self();
        }

        @Generated
        public B existVpnClient(Boolean existVpnClient) {
            this.existVpnClient = existVpnClient;
            return this.self();
        }

        @Generated
        public B existVirtualWan(Boolean existVirtualWan) {
            this.existVirtualWan = existVirtualWan;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "StaticRoutingInfoOpenApiVO.StaticRoutingInfoOpenApiVOBuilder(id=" + this.id + ", name=" + this.name + ", status=" + this.status + ", destinations=" + this.destinations + ", routeType=" + this.routeType + ", nextHopIp=" + this.nextHopIp + ", interfaceType=" + this.interfaceType + ", interfaceId=" + this.interfaceId + ", metric=" + this.metric + ", existVpnClient=" + this.existVpnClient + ", existVirtualWan=" + this.existVirtualWan + ")";
        }
    }

    @Generated
    private static final class StaticRoutingInfoOpenApiVOBuilderImpl
    extends StaticRoutingInfoOpenApiVOBuilder<StaticRoutingInfoOpenApiVO, StaticRoutingInfoOpenApiVOBuilderImpl> {
        @Generated
        private StaticRoutingInfoOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected StaticRoutingInfoOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public StaticRoutingInfoOpenApiVO build() {
            return new StaticRoutingInfoOpenApiVO(this);
        }
    }
}

