/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.routing.dto;

import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.PolicyRoutingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="PolicyRoutingConfig")
public class PolicyRoutingOpenApiVO {
    @NotNull(message="PolicyRouting parameter [name] should not be null")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.")
    @Schema(name="name", description="Name, name should contain 1 to 64 characters.")
    private @NotNull(message="PolicyRouting parameter [name] should not be null") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.") String name;
    @NotNull(message="PolicyRouting parameter [status] should not be null")
    @Schema(name="status", description="Status")
    private @NotNull(message="PolicyRouting parameter [status] should not be null") Boolean status;
    @NotNull(message="PolicyRouting parameter [protocols] should not be null")
    @Schema(name="protocols", description="For the values of protocols, refer to section 5.5.2 of the Open API Access Guide.")
    private @NotNull(message="PolicyRouting parameter [protocols] should not be null") List<Integer> protocols;
    @Range(min=0L, max=4L, message="Parameter [interfaceType] should range from 0 and 4")
    @Schema(name="interfaceType", description="InterfaceType should be a value as follows: 0: WAN; 2: L2TP; 3: PPTP; 4: multi-select WAN or VPN or virtual WAN.")
    private @Range(min=0L, max=4L, message="Parameter [interfaceType] should range from 0 and 4") Integer interfaceType;
    @Nullable
    @Schema(name="interfaceId", description="Interface ID")
    private String interfaceId;
    @Nullable
    @Schema(name="wanPortIds", description="WAN port list. When interfaceType is 4, at least one of the wanPortIds or vpnIds or virtualWanIds is not empty.")
    private List<String> wanPortIds;
    @Nullable
    @Schema(name="vpnIds", description="VPN list. When interfaceType is 4, at least one of the wanPortIds or vpnIds or virtualWanIds is not empty.")
    private List<String> vpnIds;
    @Schema(name="virtualWanIds", description="Virtual WAN list. When interfaceType is 4, at least one of the wanPortIds or vpnIds or virtualWanIds is not empty.")
    private List<String> virtualWanIds;
    @NotNull(message="PolicyRouting parameter [backupInterface] should not be null")
    @Schema(name="backupInterface", description="Use the other WAN port if the current one is down")
    private @NotNull(message="PolicyRouting parameter [backupInterface] should not be null") Boolean backupInterface;
    @NotNull(message="PolicyRouting parameter [sourceType] should not be null")
    @Schema(name="sourceType", description="SourceType should be a value as follows: 0: Network; 1: IP Group; 2: IP port Group")
    @Range(min=0L, max=2L)
    private @NotNull(message="PolicyRouting parameter [sourceType] should not be null") @Range(min=0L, max=2L) Integer sourceType;
    @NotNull(message="PolicyRouting parameter [sourceIds] should not be null")
    @Schema(name="sourceIds", description="Source IDs, which depends on sourceType, for example: if sourceType is network, sourceIds should be LAN network ID. LAN Network can be created using 'Create LAN network' interface, and LAN Network ID can be obtained from 'Get LAN network list' interface.")
    private @NotNull(message="PolicyRouting parameter [sourceIds] should not be null") List<String> sourceIds;
    @NotNull(message="PolicyRouting parameter [destinationType] should not be null")
    @Range(min=0L, max=2L)
    @Schema(name="destinationType", description="DestinationType should be a value as follows: 0: Network; 1: IP Group; 2: IP port Group")
    private @NotNull(message="PolicyRouting parameter [destinationType] should not be null") @Range(min=0L, max=2L) Integer destinationType;
    @NotNull(message="PolicyRouting parameter [destinationIds] should not be null")
    @Schema(name="destinationIds", description="Destination IDs, which depends on destinationType, for example: if destinationType is network, destinationIds should be LAN network ID. LAN Network can be created using 'Create LAN network' interface, and LAN Network ID can be obtained from 'Get LAN network list' interface.")
    private @NotNull(message="PolicyRouting parameter [destinationIds] should not be null") List<String> destinationIds;

    public static PolicyRoutingVO toWebVO(PolicyRoutingOpenApiVO policyRoutingOpenApiVO) {
        PolicyRoutingVO policyRoutingVO = new PolicyRoutingVO();
        policyRoutingVO.setName(policyRoutingOpenApiVO.getName());
        policyRoutingVO.setStatus(policyRoutingOpenApiVO.getStatus());
        policyRoutingVO.setBackupInterface(policyRoutingOpenApiVO.getBackupInterface());
        policyRoutingVO.setDestinationIds(policyRoutingOpenApiVO.getDestinationIds());
        policyRoutingVO.setDestinationType(policyRoutingOpenApiVO.getDestinationType());
        policyRoutingVO.setInterfaceId(policyRoutingOpenApiVO.getInterfaceId());
        policyRoutingVO.setInterfaceType(policyRoutingOpenApiVO.getInterfaceType());
        policyRoutingVO.setProtocols(policyRoutingOpenApiVO.getProtocols());
        policyRoutingVO.setSourceIds(policyRoutingOpenApiVO.getSourceIds());
        policyRoutingVO.setSourceType(policyRoutingOpenApiVO.getSourceType());
        policyRoutingVO.setVpnIds(policyRoutingOpenApiVO.getVpnIds());
        policyRoutingVO.setWanPortIds(policyRoutingOpenApiVO.getWanPortIds());
        policyRoutingVO.setVirtualWanIds(policyRoutingOpenApiVO.getVirtualWanIds());
        return policyRoutingVO;
    }

    @Generated
    protected PolicyRoutingOpenApiVO(PolicyRoutingOpenApiVOBuilder<?, ?> b2) {
        this.name = b2.name;
        this.status = b2.status;
        this.protocols = b2.protocols;
        this.interfaceType = b2.interfaceType;
        this.interfaceId = b2.interfaceId;
        this.wanPortIds = b2.wanPortIds;
        this.vpnIds = b2.vpnIds;
        this.virtualWanIds = b2.virtualWanIds;
        this.backupInterface = b2.backupInterface;
        this.sourceType = b2.sourceType;
        this.sourceIds = b2.sourceIds;
        this.destinationType = b2.destinationType;
        this.destinationIds = b2.destinationIds;
    }

    @Generated
    public static PolicyRoutingOpenApiVOBuilder<?, ?> builder() {
        return new PolicyRoutingOpenApiVOBuilderImpl();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public List<Integer> getProtocols() {
        return this.protocols;
    }

    @Generated
    public Integer getInterfaceType() {
        return this.interfaceType;
    }

    @Nullable
    @Generated
    public String getInterfaceId() {
        return this.interfaceId;
    }

    @Nullable
    @Generated
    public List<String> getWanPortIds() {
        return this.wanPortIds;
    }

    @Nullable
    @Generated
    public List<String> getVpnIds() {
        return this.vpnIds;
    }

    @Generated
    public List<String> getVirtualWanIds() {
        return this.virtualWanIds;
    }

    @Generated
    public Boolean getBackupInterface() {
        return this.backupInterface;
    }

    @Generated
    public Integer getSourceType() {
        return this.sourceType;
    }

    @Generated
    public List<String> getSourceIds() {
        return this.sourceIds;
    }

    @Generated
    public Integer getDestinationType() {
        return this.destinationType;
    }

    @Generated
    public List<String> getDestinationIds() {
        return this.destinationIds;
    }

    @Generated
    public PolicyRoutingOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public PolicyRoutingOpenApiVO setStatus(Boolean status) {
        this.status = status;
        return this;
    }

    @Generated
    public PolicyRoutingOpenApiVO setProtocols(List<Integer> protocols) {
        this.protocols = protocols;
        return this;
    }

    @Generated
    public PolicyRoutingOpenApiVO setInterfaceType(Integer interfaceType) {
        this.interfaceType = interfaceType;
        return this;
    }

    @Generated
    public PolicyRoutingOpenApiVO setInterfaceId(@Nullable String interfaceId) {
        this.interfaceId = interfaceId;
        return this;
    }

    @Generated
    public PolicyRoutingOpenApiVO setWanPortIds(@Nullable List<String> wanPortIds) {
        this.wanPortIds = wanPortIds;
        return this;
    }

    @Generated
    public PolicyRoutingOpenApiVO setVpnIds(@Nullable List<String> vpnIds) {
        this.vpnIds = vpnIds;
        return this;
    }

    @Generated
    public PolicyRoutingOpenApiVO setVirtualWanIds(List<String> virtualWanIds) {
        this.virtualWanIds = virtualWanIds;
        return this;
    }

    @Generated
    public PolicyRoutingOpenApiVO setBackupInterface(Boolean backupInterface) {
        this.backupInterface = backupInterface;
        return this;
    }

    @Generated
    public PolicyRoutingOpenApiVO setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    @Generated
    public PolicyRoutingOpenApiVO setSourceIds(List<String> sourceIds) {
        this.sourceIds = sourceIds;
        return this;
    }

    @Generated
    public PolicyRoutingOpenApiVO setDestinationType(Integer destinationType) {
        this.destinationType = destinationType;
        return this;
    }

    @Generated
    public PolicyRoutingOpenApiVO setDestinationIds(List<String> destinationIds) {
        this.destinationIds = destinationIds;
        return this;
    }

    @Generated
    public String toString() {
        return "PolicyRoutingOpenApiVO(name=" + this.getName() + ", status=" + this.getStatus() + ", protocols=" + this.getProtocols() + ", interfaceType=" + this.getInterfaceType() + ", interfaceId=" + this.getInterfaceId() + ", wanPortIds=" + this.getWanPortIds() + ", vpnIds=" + this.getVpnIds() + ", virtualWanIds=" + this.getVirtualWanIds() + ", backupInterface=" + this.getBackupInterface() + ", sourceType=" + this.getSourceType() + ", sourceIds=" + this.getSourceIds() + ", destinationType=" + this.getDestinationType() + ", destinationIds=" + this.getDestinationIds() + ")";
    }

    @Generated
    public PolicyRoutingOpenApiVO(String name, Boolean status, List<Integer> protocols, Integer interfaceType, @Nullable String interfaceId, @Nullable List<String> wanPortIds, @Nullable List<String> vpnIds, List<String> virtualWanIds, Boolean backupInterface, Integer sourceType, List<String> sourceIds, Integer destinationType, List<String> destinationIds) {
        this.name = name;
        this.status = status;
        this.protocols = protocols;
        this.interfaceType = interfaceType;
        this.interfaceId = interfaceId;
        this.wanPortIds = wanPortIds;
        this.vpnIds = vpnIds;
        this.virtualWanIds = virtualWanIds;
        this.backupInterface = backupInterface;
        this.sourceType = sourceType;
        this.sourceIds = sourceIds;
        this.destinationType = destinationType;
        this.destinationIds = destinationIds;
    }

    @Generated
    public PolicyRoutingOpenApiVO() {
    }

    @Generated
    public static abstract class PolicyRoutingOpenApiVOBuilder<C extends PolicyRoutingOpenApiVO, B extends PolicyRoutingOpenApiVOBuilder<C, B>> {
        @Generated
        private String name;
        @Generated
        private Boolean status;
        @Generated
        private List<Integer> protocols;
        @Generated
        private Integer interfaceType;
        @Generated
        private String interfaceId;
        @Generated
        private List<String> wanPortIds;
        @Generated
        private List<String> vpnIds;
        @Generated
        private List<String> virtualWanIds;
        @Generated
        private Boolean backupInterface;
        @Generated
        private Integer sourceType;
        @Generated
        private List<String> sourceIds;
        @Generated
        private Integer destinationType;
        @Generated
        private List<String> destinationIds;

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B status(Boolean status) {
            this.status = status;
            return this.self();
        }

        @Generated
        public B protocols(List<Integer> protocols) {
            this.protocols = protocols;
            return this.self();
        }

        @Generated
        public B interfaceType(Integer interfaceType) {
            this.interfaceType = interfaceType;
            return this.self();
        }

        @Generated
        public B interfaceId(@Nullable String interfaceId) {
            this.interfaceId = interfaceId;
            return this.self();
        }

        @Generated
        public B wanPortIds(@Nullable List<String> wanPortIds) {
            this.wanPortIds = wanPortIds;
            return this.self();
        }

        @Generated
        public B vpnIds(@Nullable List<String> vpnIds) {
            this.vpnIds = vpnIds;
            return this.self();
        }

        @Generated
        public B virtualWanIds(List<String> virtualWanIds) {
            this.virtualWanIds = virtualWanIds;
            return this.self();
        }

        @Generated
        public B backupInterface(Boolean backupInterface) {
            this.backupInterface = backupInterface;
            return this.self();
        }

        @Generated
        public B sourceType(Integer sourceType) {
            this.sourceType = sourceType;
            return this.self();
        }

        @Generated
        public B sourceIds(List<String> sourceIds) {
            this.sourceIds = sourceIds;
            return this.self();
        }

        @Generated
        public B destinationType(Integer destinationType) {
            this.destinationType = destinationType;
            return this.self();
        }

        @Generated
        public B destinationIds(List<String> destinationIds) {
            this.destinationIds = destinationIds;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "PolicyRoutingOpenApiVO.PolicyRoutingOpenApiVOBuilder(name=" + this.name + ", status=" + this.status + ", protocols=" + this.protocols + ", interfaceType=" + this.interfaceType + ", interfaceId=" + this.interfaceId + ", wanPortIds=" + this.wanPortIds + ", vpnIds=" + this.vpnIds + ", virtualWanIds=" + this.virtualWanIds + ", backupInterface=" + this.backupInterface + ", sourceType=" + this.sourceType + ", sourceIds=" + this.sourceIds + ", destinationType=" + this.destinationType + ", destinationIds=" + this.destinationIds + ")";
        }
    }

    @Generated
    private static final class PolicyRoutingOpenApiVOBuilderImpl
    extends PolicyRoutingOpenApiVOBuilder<PolicyRoutingOpenApiVO, PolicyRoutingOpenApiVOBuilderImpl> {
        @Generated
        private PolicyRoutingOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected PolicyRoutingOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PolicyRoutingOpenApiVO build() {
            return new PolicyRoutingOpenApiVO(this);
        }
    }
}

