/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.routing.dto;

import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.PolicyRoutingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="PolicyRoutingInfo")
public class PolicyRoutingInfoOpenApiVO {
    @Schema(name="id", description="ID")
    private String id;
    @Schema(name="index", description="Index")
    private Integer index;
    @NotNull(message="PolicyRouting parameter [name] should not be null")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.")
    @Schema(name="name", description="Name, name should contain 1 to 64 characters.")
    private @NotNull(message="PolicyRouting parameter [name] should not be null") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.") String name;
    @NotNull(message="PolicyRouting parameter [status] should not be null")
    @Schema(name="status", description="Status")
    private @NotNull(message="PolicyRouting parameter [status] should not be null") Boolean status;
    @NotNull(message="PolicyRouting parameter [protocols] should not be null")
    @Schema(name="protocols", description="For the values of protocols, refer to section 5.5.2 of the Open API Access Guide.")
    private @NotNull(message="PolicyRouting parameter [protocols] should not be null") List<Integer> protocols;
    @Range(min=0L, max=4L, message="Parameter [interfaceType] should range from 0 and 4")
    @Schema(name="interfaceType", description="InterfaceType should be a value as follows: 0: WAN; 2: L2TP; 3: PPTP; 4: multi-select WAN or VPN or virtual WAN.")
    private @Range(min=0L, max=4L, message="Parameter [interfaceType] should range from 0 and 4") Integer interfaceType;
    @Nullable
    @Schema(name="interfaceId", description="Interface ID")
    private String interfaceId;
    @Nullable
    @Schema(name="wanPortIds", description="WAN port list. When interfaceType is 4, at least one of the wanPortIds or vpnIds or virtualWanIds is not empty.")
    private List<String> wanPortIds;
    @Nullable
    @Schema(name="vpnIds", description="VPN list. When interfaceType is 4, at least one of the wanPortIds or vpnIds or virtualWanIds is not empty.")
    private List<String> vpnIds;
    @Schema(name="virtualWanIds", description="Virtual WAN list. When interfaceType is 4, at least one of the wanPortIds or vpnIds or virtualWanIds is not empty.")
    private List<String> virtualWanIds;
    @NotNull(message="PolicyRouting parameter [backupInterface] should not be null")
    @Schema(name="backupInterface", description="Use another WAN port if the current one is down")
    private @NotNull(message="PolicyRouting parameter [backupInterface] should not be null") Boolean backupInterface;
    @NotNull(message="PolicyRouting parameter [sourceType] should not be null")
    @Schema(name="sourceType", description="SourceType should be a value as follows: 0: Network; 1: IP Group; 2: IP port Group")
    @Range(min=0L, max=2L)
    private @NotNull(message="PolicyRouting parameter [sourceType] should not be null") @Range(min=0L, max=2L) Integer sourceType;
    @NotNull(message="PolicyRouting parameter [sourceIds] should not be null")
    @Schema(name="sourceIds", description="Source IDs, which depends on sourceType, for example: if sourceType is network, sourceIds should be LAN network ID. LAN Network can be created using 'Create LAN network' interface, and LAN Network ID can be obtained from 'Get LAN network list' interface.")
    private @NotNull(message="PolicyRouting parameter [sourceIds] should not be null") List<String> sourceIds;
    @NotNull(message="PolicyRouting parameter [destinationType] should not be null")
    @Range(min=0L, max=2L)
    @Schema(name="destinationType", description="DestinationType should be a value as follows: 0: Network; 1: IP Group; 2: IP port Group")
    private @NotNull(message="PolicyRouting parameter [destinationType] should not be null") @Range(min=0L, max=2L) Integer destinationType;
    @NotNull(message="PolicyRouting parameter [destinationIds] should not be null")
    @Schema(name="destinationIds", description="Destination IDs, which depends on destinationType, for example: if destinationType is network, destinationIds should be LAN network ID. LAN Network can be created using 'Create LAN network' interface, and LAN Network ID can be obtained from 'Get LAN network list' interface.")
    private @NotNull(message="PolicyRouting parameter [destinationIds] should not be null") List<String> destinationIds;
    @Schema(name="existVpnClient", description="Whether the interface option exists VPN client")
    private Boolean existVpnClient;
    @Schema(name="existVirtualWan", description="Whether the interface option exists virtual WAN")
    private Boolean existVirtualWan;
    @Schema(name="existMulti", description="Whether the interface option exists multi")
    private Boolean existMulti;
    @Schema(name="existLocationGroupDest", description="Whether the destination type exists location group")
    private Boolean existLocationGroupDest;
    @Schema(name="existDomainGroupDest", description="Whether the destination type exists domain group")
    private Boolean existDomainGroupDest;
    @Schema(name="existIpPortGroup", description="Whether the destination type exists ip port group")
    private Boolean existIpPortGroup;

    public static PolicyRoutingInfoOpenApiVO buildByWebVO(PolicyRoutingVO vo) {
        if (vo == null) {
            return null;
        }
        return ((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)((PolicyRoutingInfoOpenApiVOBuilder)PolicyRoutingInfoOpenApiVO.builder().id(vo.getId())).index(vo.getIndex())).status(vo.getStatus())).name(vo.getName())).protocols(vo.getProtocols())).interfaceType(vo.getInterfaceType())).interfaceId(vo.getInterfaceId())).wanPortIds(vo.getWanPortIds())).vpnIds(vo.getVpnIds())).virtualWanIds(vo.getVirtualWanIds())).backupInterface(vo.getBackupInterface())).sourceType(vo.getSourceType())).sourceIds(vo.getSourceIds())).destinationType(vo.getDestinationType())).destinationIds(vo.getDestinationIds())).existVpnClient(vo.getExistVpnClient())).existVirtualWan(vo.getExistVirtualWan())).existMulti(vo.getExistMulti())).existLocationGroupDest(vo.getExistLocationGroupDest())).existDomainGroupDest(vo.getExistDomainGroupDest())).existIpPortGroup(vo.getExistIpPortGroup())).build();
    }

    @Generated
    protected PolicyRoutingInfoOpenApiVO(PolicyRoutingInfoOpenApiVOBuilder<?, ?> b2) {
        this.id = b2.id;
        this.index = b2.index;
        this.name = b2.name;
        this.status = b2.status;
        this.protocols = b2.protocols;
        this.interfaceType = b2.interfaceType;
        this.interfaceId = b2.interfaceId;
        this.wanPortIds = b2.wanPortIds;
        this.vpnIds = b2.vpnIds;
        this.virtualWanIds = b2.virtualWanIds;
        this.backupInterface = b2.backupInterface;
        this.sourceType = b2.sourceType;
        this.sourceIds = b2.sourceIds;
        this.destinationType = b2.destinationType;
        this.destinationIds = b2.destinationIds;
        this.existVpnClient = b2.existVpnClient;
        this.existVirtualWan = b2.existVirtualWan;
        this.existMulti = b2.existMulti;
        this.existLocationGroupDest = b2.existLocationGroupDest;
        this.existDomainGroupDest = b2.existDomainGroupDest;
        this.existIpPortGroup = b2.existIpPortGroup;
    }

    @Generated
    public static PolicyRoutingInfoOpenApiVOBuilder<?, ?> builder() {
        return new PolicyRoutingInfoOpenApiVOBuilderImpl();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Integer getIndex() {
        return this.index;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public List<Integer> getProtocols() {
        return this.protocols;
    }

    @Generated
    public Integer getInterfaceType() {
        return this.interfaceType;
    }

    @Nullable
    @Generated
    public String getInterfaceId() {
        return this.interfaceId;
    }

    @Nullable
    @Generated
    public List<String> getWanPortIds() {
        return this.wanPortIds;
    }

    @Nullable
    @Generated
    public List<String> getVpnIds() {
        return this.vpnIds;
    }

    @Generated
    public List<String> getVirtualWanIds() {
        return this.virtualWanIds;
    }

    @Generated
    public Boolean getBackupInterface() {
        return this.backupInterface;
    }

    @Generated
    public Integer getSourceType() {
        return this.sourceType;
    }

    @Generated
    public List<String> getSourceIds() {
        return this.sourceIds;
    }

    @Generated
    public Integer getDestinationType() {
        return this.destinationType;
    }

    @Generated
    public List<String> getDestinationIds() {
        return this.destinationIds;
    }

    @Generated
    public Boolean getExistVpnClient() {
        return this.existVpnClient;
    }

    @Generated
    public Boolean getExistVirtualWan() {
        return this.existVirtualWan;
    }

    @Generated
    public Boolean getExistMulti() {
        return this.existMulti;
    }

    @Generated
    public Boolean getExistLocationGroupDest() {
        return this.existLocationGroupDest;
    }

    @Generated
    public Boolean getExistDomainGroupDest() {
        return this.existDomainGroupDest;
    }

    @Generated
    public Boolean getExistIpPortGroup() {
        return this.existIpPortGroup;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setIndex(Integer index) {
        this.index = index;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setStatus(Boolean status) {
        this.status = status;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setProtocols(List<Integer> protocols) {
        this.protocols = protocols;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setInterfaceType(Integer interfaceType) {
        this.interfaceType = interfaceType;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setInterfaceId(@Nullable String interfaceId) {
        this.interfaceId = interfaceId;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setWanPortIds(@Nullable List<String> wanPortIds) {
        this.wanPortIds = wanPortIds;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setVpnIds(@Nullable List<String> vpnIds) {
        this.vpnIds = vpnIds;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setVirtualWanIds(List<String> virtualWanIds) {
        this.virtualWanIds = virtualWanIds;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setBackupInterface(Boolean backupInterface) {
        this.backupInterface = backupInterface;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setSourceIds(List<String> sourceIds) {
        this.sourceIds = sourceIds;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setDestinationType(Integer destinationType) {
        this.destinationType = destinationType;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setDestinationIds(List<String> destinationIds) {
        this.destinationIds = destinationIds;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setExistVpnClient(Boolean existVpnClient) {
        this.existVpnClient = existVpnClient;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setExistVirtualWan(Boolean existVirtualWan) {
        this.existVirtualWan = existVirtualWan;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setExistMulti(Boolean existMulti) {
        this.existMulti = existMulti;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setExistLocationGroupDest(Boolean existLocationGroupDest) {
        this.existLocationGroupDest = existLocationGroupDest;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setExistDomainGroupDest(Boolean existDomainGroupDest) {
        this.existDomainGroupDest = existDomainGroupDest;
        return this;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO setExistIpPortGroup(Boolean existIpPortGroup) {
        this.existIpPortGroup = existIpPortGroup;
        return this;
    }

    @Generated
    public String toString() {
        return "PolicyRoutingInfoOpenApiVO(id=" + this.getId() + ", index=" + this.getIndex() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", protocols=" + this.getProtocols() + ", interfaceType=" + this.getInterfaceType() + ", interfaceId=" + this.getInterfaceId() + ", wanPortIds=" + this.getWanPortIds() + ", vpnIds=" + this.getVpnIds() + ", virtualWanIds=" + this.getVirtualWanIds() + ", backupInterface=" + this.getBackupInterface() + ", sourceType=" + this.getSourceType() + ", sourceIds=" + this.getSourceIds() + ", destinationType=" + this.getDestinationType() + ", destinationIds=" + this.getDestinationIds() + ", existVpnClient=" + this.getExistVpnClient() + ", existVirtualWan=" + this.getExistVirtualWan() + ", existMulti=" + this.getExistMulti() + ", existLocationGroupDest=" + this.getExistLocationGroupDest() + ", existDomainGroupDest=" + this.getExistDomainGroupDest() + ", existIpPortGroup=" + this.getExistIpPortGroup() + ")";
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO(String id, Integer index, String name, Boolean status, List<Integer> protocols, Integer interfaceType, @Nullable String interfaceId, @Nullable List<String> wanPortIds, @Nullable List<String> vpnIds, List<String> virtualWanIds, Boolean backupInterface, Integer sourceType, List<String> sourceIds, Integer destinationType, List<String> destinationIds, Boolean existVpnClient, Boolean existVirtualWan, Boolean existMulti, Boolean existLocationGroupDest, Boolean existDomainGroupDest, Boolean existIpPortGroup) {
        this.id = id;
        this.index = index;
        this.name = name;
        this.status = status;
        this.protocols = protocols;
        this.interfaceType = interfaceType;
        this.interfaceId = interfaceId;
        this.wanPortIds = wanPortIds;
        this.vpnIds = vpnIds;
        this.virtualWanIds = virtualWanIds;
        this.backupInterface = backupInterface;
        this.sourceType = sourceType;
        this.sourceIds = sourceIds;
        this.destinationType = destinationType;
        this.destinationIds = destinationIds;
        this.existVpnClient = existVpnClient;
        this.existVirtualWan = existVirtualWan;
        this.existMulti = existMulti;
        this.existLocationGroupDest = existLocationGroupDest;
        this.existDomainGroupDest = existDomainGroupDest;
        this.existIpPortGroup = existIpPortGroup;
    }

    @Generated
    public PolicyRoutingInfoOpenApiVO() {
    }

    @Generated
    public static abstract class PolicyRoutingInfoOpenApiVOBuilder<C extends PolicyRoutingInfoOpenApiVO, B extends PolicyRoutingInfoOpenApiVOBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private Integer index;
        @Generated
        private String name;
        @Generated
        private Boolean status;
        @Generated
        private List<Integer> protocols;
        @Generated
        private Integer interfaceType;
        @Generated
        private String interfaceId;
        @Generated
        private List<String> wanPortIds;
        @Generated
        private List<String> vpnIds;
        @Generated
        private List<String> virtualWanIds;
        @Generated
        private Boolean backupInterface;
        @Generated
        private Integer sourceType;
        @Generated
        private List<String> sourceIds;
        @Generated
        private Integer destinationType;
        @Generated
        private List<String> destinationIds;
        @Generated
        private Boolean existVpnClient;
        @Generated
        private Boolean existVirtualWan;
        @Generated
        private Boolean existMulti;
        @Generated
        private Boolean existLocationGroupDest;
        @Generated
        private Boolean existDomainGroupDest;
        @Generated
        private Boolean existIpPortGroup;

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B index(Integer index) {
            this.index = index;
            return this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B status(Boolean status) {
            this.status = status;
            return this.self();
        }

        @Generated
        public B protocols(List<Integer> protocols) {
            this.protocols = protocols;
            return this.self();
        }

        @Generated
        public B interfaceType(Integer interfaceType) {
            this.interfaceType = interfaceType;
            return this.self();
        }

        @Generated
        public B interfaceId(@Nullable String interfaceId) {
            this.interfaceId = interfaceId;
            return this.self();
        }

        @Generated
        public B wanPortIds(@Nullable List<String> wanPortIds) {
            this.wanPortIds = wanPortIds;
            return this.self();
        }

        @Generated
        public B vpnIds(@Nullable List<String> vpnIds) {
            this.vpnIds = vpnIds;
            return this.self();
        }

        @Generated
        public B virtualWanIds(List<String> virtualWanIds) {
            this.virtualWanIds = virtualWanIds;
            return this.self();
        }

        @Generated
        public B backupInterface(Boolean backupInterface) {
            this.backupInterface = backupInterface;
            return this.self();
        }

        @Generated
        public B sourceType(Integer sourceType) {
            this.sourceType = sourceType;
            return this.self();
        }

        @Generated
        public B sourceIds(List<String> sourceIds) {
            this.sourceIds = sourceIds;
            return this.self();
        }

        @Generated
        public B destinationType(Integer destinationType) {
            this.destinationType = destinationType;
            return this.self();
        }

        @Generated
        public B destinationIds(List<String> destinationIds) {
            this.destinationIds = destinationIds;
            return this.self();
        }

        @Generated
        public B existVpnClient(Boolean existVpnClient) {
            this.existVpnClient = existVpnClient;
            return this.self();
        }

        @Generated
        public B existVirtualWan(Boolean existVirtualWan) {
            this.existVirtualWan = existVirtualWan;
            return this.self();
        }

        @Generated
        public B existMulti(Boolean existMulti) {
            this.existMulti = existMulti;
            return this.self();
        }

        @Generated
        public B existLocationGroupDest(Boolean existLocationGroupDest) {
            this.existLocationGroupDest = existLocationGroupDest;
            return this.self();
        }

        @Generated
        public B existDomainGroupDest(Boolean existDomainGroupDest) {
            this.existDomainGroupDest = existDomainGroupDest;
            return this.self();
        }

        @Generated
        public B existIpPortGroup(Boolean existIpPortGroup) {
            this.existIpPortGroup = existIpPortGroup;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "PolicyRoutingInfoOpenApiVO.PolicyRoutingInfoOpenApiVOBuilder(id=" + this.id + ", index=" + this.index + ", name=" + this.name + ", status=" + this.status + ", protocols=" + this.protocols + ", interfaceType=" + this.interfaceType + ", interfaceId=" + this.interfaceId + ", wanPortIds=" + this.wanPortIds + ", vpnIds=" + this.vpnIds + ", virtualWanIds=" + this.virtualWanIds + ", backupInterface=" + this.backupInterface + ", sourceType=" + this.sourceType + ", sourceIds=" + this.sourceIds + ", destinationType=" + this.destinationType + ", destinationIds=" + this.destinationIds + ", existVpnClient=" + this.existVpnClient + ", existVirtualWan=" + this.existVirtualWan + ", existMulti=" + this.existMulti + ", existLocationGroupDest=" + this.existLocationGroupDest + ", existDomainGroupDest=" + this.existDomainGroupDest + ", existIpPortGroup=" + this.existIpPortGroup + ")";
        }
    }

    @Generated
    private static final class PolicyRoutingInfoOpenApiVOBuilderImpl
    extends PolicyRoutingInfoOpenApiVOBuilder<PolicyRoutingInfoOpenApiVO, PolicyRoutingInfoOpenApiVOBuilderImpl> {
        @Generated
        private PolicyRoutingInfoOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected PolicyRoutingInfoOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PolicyRoutingInfoOpenApiVO build() {
            return new PolicyRoutingInfoOpenApiVO(this);
        }
    }
}

