/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.ospf.dto;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.util.v;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.ospf.dto.OspfProcessAreaOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.ospfprocess.OspfProcessAreaVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.ospfprocess.OspfProcessVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class OspfProcessOpenApiVO {
    @Schema(name="id", description="OSPF Process ID")
    private String id;
    @NotNull(message="OSPF Process parameter [deviceName] should not be null")
    @Schema(name="deviceName", description="The name of the device")
    private @NotNull(message="OSPF Process parameter [deviceName] should not be null") String deviceName;
    @Schema(name="isStack", description="Indicates whether the device is a stack member device.")
    private Boolean isStack;
    @NotNull(message="OSPF Process parameter [mac] should not be null")
    @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] Invalid.")
    @Schema(name="mac", description="Device Mac")
    @a
    private @NotNull(message="OSPF Process parameter [mac] should not be null") @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] Invalid.") String mac;
    @Schema(name="stackId", description="Used for backend verification, the front-end does not need to pass a value, and there are values when the MAC is master")
    private String stackId;
    @NotNull(message="OSPF Process parameter [processId] should not be null")
    @Range(min=1L, max=65535L, message="Value of processId is from 1 to 65535.")
    @Schema(name="processId", description="Process ID should be within the range of 1-65535.")
    private @NotNull(message="OSPF Process parameter [processId] should not be null") @Range(min=1L, max=65535L, message="Value of processId is from 1 to 65535.") Integer processId;
    @NotNull(message="OSPF Process parameter [routerMode] should not be null")
    @Range(min=0L, max=1L, message="Value of routerMode is from 0 to 1.")
    @Schema(name="routerMode", description="RouterMode, its value should be a value as follows: 0: AUTO, 1: MANUAL.")
    private @NotNull(message="OSPF Process parameter [routerMode] should not be null") @Range(min=0L, max=1L, message="Value of routerMode is from 0 to 1.") Integer routerMode;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [routerId] Invalid.")
    @Schema(name="routerId", description="Router ID")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [routerId] Invalid.") String routerId;
    @NotNull(message="OSPF Process parameter [staticEnable] should not be null")
    @Schema(name="staticEnable", description="Static routing protocol switch")
    private @NotNull(message="OSPF Process parameter [staticEnable] should not be null") Boolean staticEnable;
    @Range(min=1L, max=0xFFFFFEL, message="Value of staticMetric is from 1 to 16777214.")
    @Schema(name="staticMetric", description="Set the metric value to be used as the metric of redistributed routes. It should be within the range of 1-16777214 and the default is equal to Default Metric configured on Basic page.")
    private @Range(min=1L, max=0xFFFFFEL, message="Value of staticMetric is from 1 to 16777214.") Integer staticMetric;
    @Range(min=1L, max=2L, message="Value of staticMetricType is from 1 to 2.")
    @Schema(name="staticMetricType", description="Set the OSPF metric type of redistributed routes. The default is External Type 2.")
    private @Range(min=1L, max=2L, message="Value of staticMetricType is from 1 to 2.") Integer staticMetricType;
    @NotNull(message="OSPF Process parameter [connectedEnable] should not be null")
    @Schema(name="connectedEnable", description="Direct connection routing protocol switch")
    private @NotNull(message="OSPF Process parameter [connectedEnable] should not be null") Boolean connectedEnable;
    @Range(min=1L, max=0xFFFFFEL, message="Value of connectedMetric is from 1 to 16777214.")
    @Schema(name="connectedMetric", description="Set the metric value to be used as the metric of redistributed routes. It should be within the range of 1-16777214 and the default is equal to Default Metric configured on Basic page.")
    private @Range(min=1L, max=0xFFFFFEL, message="Value of connectedMetric is from 1 to 16777214.") Integer connectedMetric;
    @Range(min=1L, max=2L, message="Value of connectedMetricType is from 1 to 2.")
    @Schema(name="connectedMetricType", description="Set the OSPF metric type of redistributed routes. The default is External Type 2.")
    private @Range(min=1L, max=2L, message="Value of connectedMetricType is from 1 to 2.") Integer connectedMetricType;
    @NotNull(message="OSPF Process parameter [areaList] should not be null")
    @Size(max=16, message="Size of areaList should be less than 16")
    @Schema(name="areaList", description=" Up to 16 entries are allowed for the areaList.")
    @Valid
    private @NotNull(message="OSPF Process parameter [areaList] should not be null") @Size(max=16, message="Size of areaList should be less than 16") @Valid List<OspfProcessAreaOpenApiVO> areaList;

    public static OspfProcessOpenApiVO buildByWebVO(OspfProcessVO webVO) {
        if (Objects.isNull(webVO)) {
            return null;
        }
        ArrayList<OspfProcessAreaOpenApiVO> areaList = new ArrayList<OspfProcessAreaOpenApiVO>();
        if (!CollectionUtils.isEmpty((Collection)webVO.getAreaList())) {
            for (OspfProcessAreaVO vo : webVO.getAreaList()) {
                areaList.add(OspfProcessAreaOpenApiVO.buildByWebVO(vo));
            }
        }
        OspfProcessOpenApiVO ospfProcessOpenApiVO = new OspfProcessOpenApiVO();
        ospfProcessOpenApiVO.setId(webVO.getId());
        ospfProcessOpenApiVO.setDeviceName(webVO.getDeviceName());
        ospfProcessOpenApiVO.setIsStack(webVO.getIsStack());
        ospfProcessOpenApiVO.setMac(webVO.getMac());
        ospfProcessOpenApiVO.setStackId(webVO.getStackId());
        ospfProcessOpenApiVO.setProcessId(webVO.getProcessId());
        ospfProcessOpenApiVO.setRouterMode(webVO.getRouterMode());
        ospfProcessOpenApiVO.setRouterId(webVO.getRouterId());
        ospfProcessOpenApiVO.setStaticEnable(webVO.getStaticEnable());
        ospfProcessOpenApiVO.setStaticMetric(webVO.getStaticMetric());
        ospfProcessOpenApiVO.setStaticMetricType(webVO.getStaticMetricType());
        ospfProcessOpenApiVO.setConnectedEnable(webVO.getConnectedEnable());
        ospfProcessOpenApiVO.setConnectedMetric(webVO.getConnectedMetric());
        ospfProcessOpenApiVO.setConnectedMetricType(webVO.getConnectedMetricType());
        ospfProcessOpenApiVO.setAreaList(areaList);
        return ospfProcessOpenApiVO;
    }

    public static OspfProcessVO toWebVO(OspfProcessOpenApiVO ospfProcessOpenApiVO) {
        if (Objects.isNull(ospfProcessOpenApiVO)) {
            return null;
        }
        ArrayList<OspfProcessAreaVO> areaList = new ArrayList<OspfProcessAreaVO>();
        if (!CollectionUtils.isEmpty(ospfProcessOpenApiVO.getAreaList())) {
            for (OspfProcessAreaOpenApiVO vo : ospfProcessOpenApiVO.getAreaList()) {
                areaList.add(OspfProcessAreaOpenApiVO.toWebVO(vo));
            }
        }
        OspfProcessVO webVO = new OspfProcessVO();
        webVO.setId(ospfProcessOpenApiVO.getId());
        webVO.setDeviceName(ospfProcessOpenApiVO.getDeviceName());
        webVO.setIsStack(ospfProcessOpenApiVO.getIsStack());
        webVO.setMac(ospfProcessOpenApiVO.getMac());
        webVO.setStackId(ospfProcessOpenApiVO.getStackId());
        webVO.setProcessId(ospfProcessOpenApiVO.getProcessId());
        webVO.setRouterMode(ospfProcessOpenApiVO.getRouterMode());
        webVO.setRouterId(ospfProcessOpenApiVO.getRouterId());
        webVO.setStaticEnable(ospfProcessOpenApiVO.getStaticEnable());
        webVO.setStaticMetric(ospfProcessOpenApiVO.getStaticMetric());
        webVO.setStaticMetricType(ospfProcessOpenApiVO.getStaticMetricType());
        webVO.setConnectedEnable(ospfProcessOpenApiVO.getConnectedEnable());
        webVO.setConnectedMetric(ospfProcessOpenApiVO.getConnectedMetric());
        webVO.setConnectedMetricType(ospfProcessOpenApiVO.getConnectedMetricType());
        webVO.setAreaList(areaList);
        return webVO;
    }

    public boolean validateRouterId() {
        if (!this.routerMode.equals(com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.a.a)) {
            return !v.c((String)this.routerId);
        }
        return true;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getDeviceName() {
        return this.deviceName;
    }

    @Generated
    public Boolean getIsStack() {
        return this.isStack;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getStackId() {
        return this.stackId;
    }

    @Generated
    public Integer getProcessId() {
        return this.processId;
    }

    @Generated
    public Integer getRouterMode() {
        return this.routerMode;
    }

    @Generated
    public String getRouterId() {
        return this.routerId;
    }

    @Generated
    public Boolean getStaticEnable() {
        return this.staticEnable;
    }

    @Generated
    public Integer getStaticMetric() {
        return this.staticMetric;
    }

    @Generated
    public Integer getStaticMetricType() {
        return this.staticMetricType;
    }

    @Generated
    public Boolean getConnectedEnable() {
        return this.connectedEnable;
    }

    @Generated
    public Integer getConnectedMetric() {
        return this.connectedMetric;
    }

    @Generated
    public Integer getConnectedMetricType() {
        return this.connectedMetricType;
    }

    @Generated
    public List<OspfProcessAreaOpenApiVO> getAreaList() {
        return this.areaList;
    }

    @Generated
    public OspfProcessOpenApiVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public OspfProcessOpenApiVO setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    @Generated
    public OspfProcessOpenApiVO setIsStack(Boolean isStack) {
        this.isStack = isStack;
        return this;
    }

    @Generated
    public OspfProcessOpenApiVO setMac(String mac) {
        this.mac = mac;
        return this;
    }

    @Generated
    public OspfProcessOpenApiVO setStackId(String stackId) {
        this.stackId = stackId;
        return this;
    }

    @Generated
    public OspfProcessOpenApiVO setProcessId(Integer processId) {
        this.processId = processId;
        return this;
    }

    @Generated
    public OspfProcessOpenApiVO setRouterMode(Integer routerMode) {
        this.routerMode = routerMode;
        return this;
    }

    @Generated
    public OspfProcessOpenApiVO setRouterId(String routerId) {
        this.routerId = routerId;
        return this;
    }

    @Generated
    public OspfProcessOpenApiVO setStaticEnable(Boolean staticEnable) {
        this.staticEnable = staticEnable;
        return this;
    }

    @Generated
    public OspfProcessOpenApiVO setStaticMetric(Integer staticMetric) {
        this.staticMetric = staticMetric;
        return this;
    }

    @Generated
    public OspfProcessOpenApiVO setStaticMetricType(Integer staticMetricType) {
        this.staticMetricType = staticMetricType;
        return this;
    }

    @Generated
    public OspfProcessOpenApiVO setConnectedEnable(Boolean connectedEnable) {
        this.connectedEnable = connectedEnable;
        return this;
    }

    @Generated
    public OspfProcessOpenApiVO setConnectedMetric(Integer connectedMetric) {
        this.connectedMetric = connectedMetric;
        return this;
    }

    @Generated
    public OspfProcessOpenApiVO setConnectedMetricType(Integer connectedMetricType) {
        this.connectedMetricType = connectedMetricType;
        return this;
    }

    @Generated
    public OspfProcessOpenApiVO setAreaList(List<OspfProcessAreaOpenApiVO> areaList) {
        this.areaList = areaList;
        return this;
    }
}

