/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.ospf.dto;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.util.v;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.ospf.dto.OspfProcessAreaOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.ospfprocess.OspfProcessAreaVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.ospfprocess.OspfProcessVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class OspfProcessConfigOpenApiVO {
    @NotNull(message="OSPF Process parameter [deviceName] should not be null")
    @Schema(name="deviceName", description="The name of the device")
    private @NotNull(message="OSPF Process parameter [deviceName] should not be null") String deviceName;
    @NotNull(message="OSPF Process parameter [mac] should not be null")
    @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] Invalid.")
    @Schema(name="mac", description="Device Mac")
    @a
    private @NotNull(message="OSPF Process parameter [mac] should not be null") @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] Invalid.") String mac;
    @NotNull(message="OSPF Process parameter [processId] should not be null")
    @Range(min=1L, max=65535L, message="Value of processId is from 1 to 65535.")
    @Schema(name="processId", description="Process ID should be within the range of 1-65535.")
    private @NotNull(message="OSPF Process parameter [processId] should not be null") @Range(min=1L, max=65535L, message="Value of processId is from 1 to 65535.") Integer processId;
    @NotNull(message="OSPF Process parameter [routerMode] should not be null")
    @Range(min=0L, max=1L, message="Value of routerMode is from 0 to 1.")
    @Schema(name="routerMode", description="RouterMode, its value should be a value as follows: 0: AUTO, 1: MANUAL.")
    private @NotNull(message="OSPF Process parameter [routerMode] should not be null") @Range(min=0L, max=1L, message="Value of routerMode is from 0 to 1.") Integer routerMode;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [routerId] Invalid.")
    @Schema(name="routerId", description="Router ID")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [routerId] Invalid.") String routerId;
    @NotNull(message="OSPF Process parameter [staticEnable] should not be null")
    @Schema(name="staticEnable", description="Static routing protocol switch")
    private @NotNull(message="OSPF Process parameter [staticEnable] should not be null") Boolean staticEnable;
    @Range(min=1L, max=0xFFFFFEL, message="Value of staticMetric is from 1 to 16777214.")
    @Schema(name="staticMetric", description="Set the metric value to be used as the metric of redistributed routes. It should be within the range of 1-16777214 and the default is equal to Default Metric configured on Basic page.")
    private @Range(min=1L, max=0xFFFFFEL, message="Value of staticMetric is from 1 to 16777214.") Integer staticMetric;
    @Range(min=1L, max=2L, message="Value of staticMetricType is from 1 to 2.")
    @Schema(name="staticMetricType", description="Set the OSPF metric type of redistributed routes. It should be a value as follows: 1: External Type 1, 2: External Type 2. The default is External Type 2.")
    private @Range(min=1L, max=2L, message="Value of staticMetricType is from 1 to 2.") Integer staticMetricType;
    @NotNull(message="OSPF Process parameter [connectedEnable] should not be null")
    @Schema(name="connectedEnable", description="Direct connection routing protocol switch")
    private @NotNull(message="OSPF Process parameter [connectedEnable] should not be null") Boolean connectedEnable;
    @Range(min=1L, max=0xFFFFFEL, message="Value of connectedMetric is from 1 to 16777214.")
    @Schema(name="connectedMetric", description="Set the metric value to be used as the metric of redistributed routes. It should be within the range of 1-16777214 and the default is equal to Default Metric configured on Basic page.")
    private @Range(min=1L, max=0xFFFFFEL, message="Value of connectedMetric is from 1 to 16777214.") Integer connectedMetric;
    @Range(min=1L, max=2L, message="Value of connectedMetricType is from 1 to 2.")
    @Schema(name="connectedMetricType", description="Set the OSPF metric type of redistributed routes. It should be a value as follows: 1: External Type 1, 2: External Type 2. The default is External Type 2.")
    private @Range(min=1L, max=2L, message="Value of connectedMetricType is from 1 to 2.") Integer connectedMetricType;
    @NotNull(message="OSPF Process parameter [areaList] should not be null")
    @Size(max=16, message="Size of areaList should be less than 16")
    @Schema(name="areaList", description=" Up to 16 entries are allowed for the areaList.")
    @Valid
    private @NotNull(message="OSPF Process parameter [areaList] should not be null") @Size(max=16, message="Size of areaList should be less than 16") @Valid List<OspfProcessAreaOpenApiVO> areaList;

    public static OspfProcessConfigOpenApiVO buildByWebVO(OspfProcessVO webVO) {
        if (Objects.isNull(webVO)) {
            return null;
        }
        ArrayList<OspfProcessAreaOpenApiVO> areaList = new ArrayList<OspfProcessAreaOpenApiVO>();
        if (!CollectionUtils.isEmpty((Collection)webVO.getAreaList())) {
            for (OspfProcessAreaVO vo : webVO.getAreaList()) {
                areaList.add(OspfProcessAreaOpenApiVO.buildByWebVO(vo));
            }
        }
        OspfProcessConfigOpenApiVO ospfProcessConfigOpenApiVO = new OspfProcessConfigOpenApiVO();
        ospfProcessConfigOpenApiVO.setDeviceName(webVO.getDeviceName());
        ospfProcessConfigOpenApiVO.setMac(webVO.getMac());
        ospfProcessConfigOpenApiVO.setProcessId(webVO.getProcessId());
        ospfProcessConfigOpenApiVO.setRouterMode(webVO.getRouterMode());
        ospfProcessConfigOpenApiVO.setRouterId(webVO.getRouterId());
        ospfProcessConfigOpenApiVO.setStaticEnable(webVO.getStaticEnable());
        ospfProcessConfigOpenApiVO.setStaticMetric(webVO.getStaticMetric());
        ospfProcessConfigOpenApiVO.setStaticMetricType(webVO.getStaticMetricType());
        ospfProcessConfigOpenApiVO.setConnectedEnable(webVO.getConnectedEnable());
        ospfProcessConfigOpenApiVO.setConnectedMetric(webVO.getConnectedMetric());
        ospfProcessConfigOpenApiVO.setConnectedMetricType(webVO.getConnectedMetricType());
        ospfProcessConfigOpenApiVO.setAreaList(areaList);
        return ospfProcessConfigOpenApiVO;
    }

    public static OspfProcessVO toWebVO(OspfProcessConfigOpenApiVO ospfProcessConfigOpenApiVO) {
        if (Objects.isNull(ospfProcessConfigOpenApiVO)) {
            return null;
        }
        ArrayList<OspfProcessAreaVO> areaList = new ArrayList<OspfProcessAreaVO>();
        if (!CollectionUtils.isEmpty(ospfProcessConfigOpenApiVO.getAreaList())) {
            for (OspfProcessAreaOpenApiVO vo : ospfProcessConfigOpenApiVO.getAreaList()) {
                areaList.add(OspfProcessAreaOpenApiVO.toWebVO(vo));
            }
        }
        OspfProcessVO webVO = new OspfProcessVO();
        webVO.setId(null);
        webVO.setDeviceName(ospfProcessConfigOpenApiVO.getDeviceName());
        webVO.setIsStack(null);
        webVO.setMac(ospfProcessConfigOpenApiVO.getMac());
        webVO.setStackId(null);
        webVO.setProcessId(ospfProcessConfigOpenApiVO.getProcessId());
        webVO.setRouterMode(ospfProcessConfigOpenApiVO.getRouterMode());
        webVO.setRouterId(ospfProcessConfigOpenApiVO.getRouterId());
        webVO.setStaticEnable(ospfProcessConfigOpenApiVO.getStaticEnable());
        webVO.setStaticMetric(ospfProcessConfigOpenApiVO.getStaticMetric());
        webVO.setStaticMetricType(ospfProcessConfigOpenApiVO.getStaticMetricType());
        webVO.setConnectedEnable(ospfProcessConfigOpenApiVO.getConnectedEnable());
        webVO.setConnectedMetric(ospfProcessConfigOpenApiVO.getConnectedMetric());
        webVO.setConnectedMetricType(ospfProcessConfigOpenApiVO.getConnectedMetricType());
        webVO.setAreaList(areaList);
        return webVO;
    }

    public boolean validateRouterId() {
        if (!this.routerMode.equals(com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.a.a)) {
            return !v.c((String)this.routerId);
        }
        return true;
    }

    @Generated
    public String getDeviceName() {
        return this.deviceName;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public Integer getProcessId() {
        return this.processId;
    }

    @Generated
    public Integer getRouterMode() {
        return this.routerMode;
    }

    @Generated
    public String getRouterId() {
        return this.routerId;
    }

    @Generated
    public Boolean getStaticEnable() {
        return this.staticEnable;
    }

    @Generated
    public Integer getStaticMetric() {
        return this.staticMetric;
    }

    @Generated
    public Integer getStaticMetricType() {
        return this.staticMetricType;
    }

    @Generated
    public Boolean getConnectedEnable() {
        return this.connectedEnable;
    }

    @Generated
    public Integer getConnectedMetric() {
        return this.connectedMetric;
    }

    @Generated
    public Integer getConnectedMetricType() {
        return this.connectedMetricType;
    }

    @Generated
    public List<OspfProcessAreaOpenApiVO> getAreaList() {
        return this.areaList;
    }

    @Generated
    public OspfProcessConfigOpenApiVO setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    @Generated
    public OspfProcessConfigOpenApiVO setMac(String mac) {
        this.mac = mac;
        return this;
    }

    @Generated
    public OspfProcessConfigOpenApiVO setProcessId(Integer processId) {
        this.processId = processId;
        return this;
    }

    @Generated
    public OspfProcessConfigOpenApiVO setRouterMode(Integer routerMode) {
        this.routerMode = routerMode;
        return this;
    }

    @Generated
    public OspfProcessConfigOpenApiVO setRouterId(String routerId) {
        this.routerId = routerId;
        return this;
    }

    @Generated
    public OspfProcessConfigOpenApiVO setStaticEnable(Boolean staticEnable) {
        this.staticEnable = staticEnable;
        return this;
    }

    @Generated
    public OspfProcessConfigOpenApiVO setStaticMetric(Integer staticMetric) {
        this.staticMetric = staticMetric;
        return this;
    }

    @Generated
    public OspfProcessConfigOpenApiVO setStaticMetricType(Integer staticMetricType) {
        this.staticMetricType = staticMetricType;
        return this;
    }

    @Generated
    public OspfProcessConfigOpenApiVO setConnectedEnable(Boolean connectedEnable) {
        this.connectedEnable = connectedEnable;
        return this;
    }

    @Generated
    public OspfProcessConfigOpenApiVO setConnectedMetric(Integer connectedMetric) {
        this.connectedMetric = connectedMetric;
        return this;
    }

    @Generated
    public OspfProcessConfigOpenApiVO setConnectedMetricType(Integer connectedMetricType) {
        this.connectedMetricType = connectedMetricType;
        return this;
    }

    @Generated
    public OspfProcessConfigOpenApiVO setAreaList(List<OspfProcessAreaOpenApiVO> areaList) {
        this.areaList = areaList;
        return this;
    }
}

