/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.ospf.dto;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.ospf.dto.OspfProcessAreaNetworkOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.ospfprocess.OspfProcessAreaNetworkVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.ospfprocess.OspfProcessAreaVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class OspfProcessAreaOpenApiVO {
    @NotNull(message="OSPF Process parameter [areaId] should not be null")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [areaId] Invalid.")
    @Schema(name="areaId", description="The 32 bit unsigned integer that uniquely identifies the area. It can be in decimal format or dotted decimal format.")
    private @NotNull(message="OSPF Process parameter [areaId] should not be null") @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [areaId] Invalid.") String areaId;
    @NotNull(message="OSPF Process parameter [areaType] should not be null")
    @Range(min=0L, max=2L, message="Value of areaType is from 0 to 2.")
    @Schema(name="areaType", description="OSPF area type should be a value as follows: 0: Normal, 1: Stub, or 2: NSSA.")
    private @NotNull(message="OSPF Process parameter [areaType] should not be null") @Range(min=0L, max=2L, message="Value of areaType is from 0 to 2.") Integer areaType;
    @Size(max=16, message="Size of networkList should be less than 16")
    @Schema(name="networkList", description="Up to 16 entries are allowed for the networkList.")
    private @Size(max=16, message="Size of networkList should be less than 16") List<OspfProcessAreaNetworkOpenApiVO> networkList;

    public static OspfProcessAreaOpenApiVO buildByWebVO(OspfProcessAreaVO webVO) {
        if (Objects.isNull(webVO)) {
            return null;
        }
        OspfProcessAreaOpenApiVO ospfProcessAreaOpenApiVO = new OspfProcessAreaOpenApiVO();
        ArrayList<OspfProcessAreaNetworkOpenApiVO> networkList = new ArrayList<OspfProcessAreaNetworkOpenApiVO>();
        if (!CollectionUtils.isEmpty((Collection)webVO.getNetworkList())) {
            for (OspfProcessAreaNetworkVO vo : webVO.getNetworkList()) {
                networkList.add(OspfProcessAreaNetworkOpenApiVO.buildByWebVO(vo));
            }
        }
        ospfProcessAreaOpenApiVO.setAreaId(webVO.getAreaId()).setAreaType(webVO.getAreaType()).setNetworkList(networkList);
        return ospfProcessAreaOpenApiVO;
    }

    public static OspfProcessAreaVO toWebVO(OspfProcessAreaOpenApiVO ospfProcessAreaOpenApiVO) {
        if (Objects.isNull(ospfProcessAreaOpenApiVO)) {
            return null;
        }
        OspfProcessAreaVO webVO = new OspfProcessAreaVO();
        ArrayList<OspfProcessAreaNetworkVO> networkList = new ArrayList<OspfProcessAreaNetworkVO>();
        if (!CollectionUtils.isEmpty(ospfProcessAreaOpenApiVO.getNetworkList())) {
            for (OspfProcessAreaNetworkOpenApiVO vo : ospfProcessAreaOpenApiVO.getNetworkList()) {
                networkList.add(OspfProcessAreaNetworkOpenApiVO.toWebVO(vo));
            }
        }
        webVO.setAreaId(ospfProcessAreaOpenApiVO.getAreaId());
        webVO.setAreaType(ospfProcessAreaOpenApiVO.getAreaType());
        webVO.setNetworkList(networkList);
        return webVO;
    }

    @Generated
    public String getAreaId() {
        return this.areaId;
    }

    @Generated
    public Integer getAreaType() {
        return this.areaType;
    }

    @Generated
    public List<OspfProcessAreaNetworkOpenApiVO> getNetworkList() {
        return this.networkList;
    }

    @Generated
    public OspfProcessAreaOpenApiVO setAreaId(String areaId) {
        this.areaId = areaId;
        return this;
    }

    @Generated
    public OspfProcessAreaOpenApiVO setAreaType(Integer areaType) {
        this.areaType = areaType;
        return this;
    }

    @Generated
    public OspfProcessAreaOpenApiVO setNetworkList(List<OspfProcessAreaNetworkOpenApiVO> networkList) {
        this.networkList = networkList;
        return this;
    }
}

