/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.ospf.dto;

import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.ospfprocess.OspfProcessAreaNetworkVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class OspfProcessAreaNetworkOpenApiVO {
    @NotNull(message="OSPF Process parameter [ip] should not be null")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [ip] Invalid.")
    @Schema(name="ip", description="The IP address of the network.")
    private @NotNull(message="OSPF Process parameter [ip] should not be null") @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [ip] Invalid.") String ip;
    @NotNull(message="OSPF Process parameter [mask] should not be null")
    @Range(min=0L, max=32L, message="Value of mask is from 0 to 32.")
    @Schema(name="mask", description="Mask should be within the range of 0-32.")
    private @NotNull(message="OSPF Process parameter [mask] should not be null") @Range(min=0L, max=32L, message="Value of mask is from 0 to 32.") Integer mask;

    public static OspfProcessAreaNetworkOpenApiVO buildByWebVO(OspfProcessAreaNetworkVO webVO) {
        if (Objects.isNull(webVO)) {
            return null;
        }
        OspfProcessAreaNetworkOpenApiVO ospfProcessAreaNetworkOpenApiVO = new OspfProcessAreaNetworkOpenApiVO();
        ospfProcessAreaNetworkOpenApiVO.setIp(webVO.getIp()).setMask(webVO.getMask());
        return ospfProcessAreaNetworkOpenApiVO;
    }

    public static OspfProcessAreaNetworkVO toWebVO(OspfProcessAreaNetworkOpenApiVO ospfProcessAreaNetworkOpenApiVO) {
        if (Objects.isNull(ospfProcessAreaNetworkOpenApiVO)) {
            return null;
        }
        OspfProcessAreaNetworkVO webVO = new OspfProcessAreaNetworkVO();
        webVO.setIp(ospfProcessAreaNetworkOpenApiVO.getIp());
        webVO.setMask(ospfProcessAreaNetworkOpenApiVO.getMask());
        return webVO;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public Integer getMask() {
        return this.mask;
    }

    @Generated
    public OspfProcessAreaNetworkOpenApiVO setIp(String ip) {
        this.ip = ip;
        return this;
    }

    @Generated
    public OspfProcessAreaNetworkOpenApiVO setMask(Integer mask) {
        this.mask = mask;
        return this;
    }
}

