/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.ospf.dto;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.ospfinterface.OspfInterfaceVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class OspfInterfaceOpenApiVO {
    @Schema(name="id", description="OSPF Interface ID")
    private String id;
    @NotNull(message="Ospf Interface parameter [deviceName] should not be null")
    @Schema(name="deviceName", description="Device Name")
    private @NotNull(message="Ospf Interface parameter [deviceName] should not be null") String deviceName;
    @Schema(name="isStack", description="Indicates whether the device is a stack member device.")
    private Boolean isStack;
    @NotNull(message="OSPF Interface parameter [mac] should not be null")
    @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] Invalid.")
    @Schema(name="mac", description="Device Mac")
    @a
    private @NotNull(message="OSPF Interface parameter [mac] should not be null") @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] Invalid.") String mac;
    @Schema(name="stackId", description="Stack ID, used for backend verification, there is no need to transmit values, and it has value when the mac is master.")
    private String stackId;
    @NotNull(message="OSPF Interface parameter [vlanInterfaceId] should not be null")
    @Schema(name="vlanInterfaceId", description="Vlan Interface ID")
    private @NotNull(message="OSPF Interface parameter [vlanInterfaceId] should not be null") String vlanInterfaceId;
    @NotNull(message="OSPF Interface parameter [vlanInterfaceName] should not be null")
    @Schema(name="vlanInterfaceName", description="Vlan Interface Name")
    private @NotNull(message="OSPF Interface parameter [vlanInterfaceName] should not be null") String vlanInterfaceName;
    @NotNull(message="OSPF Interface parameter [vlanId] should not be null")
    @Range(min=1L, max=4094L, message="Value of vlanInterfaceId is from 1 to 4094.")
    @Schema(name="vlanId", description="Vlan ID should be within the range of 1\u20134094.")
    private @NotNull(message="OSPF Interface parameter [vlanId] should not be null") @Range(min=1L, max=4094L, message="Value of vlanInterfaceId is from 1 to 4094.") Integer vlanId;
    @NotNull(message="OSPF Interface parameter [cost] should not be null")
    @Range(min=1L, max=65535L, message="Value of cost is from 1 to 65535.")
    @Schema(name="cost", description="The link cost. OSPF uses this value in computing shortest paths. cost should be within the range of 1 to 65535.")
    private @NotNull(message="OSPF Interface parameter [cost] should not be null") @Range(min=1L, max=65535L, message="Value of cost is from 1 to 65535.") Integer cost;
    @NotNull(message="OSPF Interface parameter [networkType] should not be null")
    @Range(min=0L, max=3L, message="Value of networkType is from 0 to 3.")
    @Schema(name="networkType", description="Network Type, it should be a value as follows: 0: Broadcast, 1: Non-Broadcast, 2: Point-to-Multipoint, 3: Point-to-Point. The default network type for Ethernet interfaces is broadcast.")
    private @NotNull(message="OSPF Interface parameter [networkType] should not be null") @Range(min=0L, max=3L, message="Value of networkType is from 0 to 3.") Integer networkType;
    @NotNull(message="OSPF Interface parameter [helloInterval] should not be null")
    @Range(min=1L, max=65535L, message="Value of helloInterval is from 1 to 65535.")
    @Schema(name="helloInterval", description="The hello interval for the specified interface in seconds. This parameter must be the same for all routers attached to a network. It should be within the range of 1-65535 seconds and the default is 10 seconds.")
    private @NotNull(message="OSPF Interface parameter [helloInterval] should not be null") @Range(min=1L, max=65535L, message="Value of helloInterval is from 1 to 65535.") Integer helloInterval;
    @Range(min=1L, max=65535L, message="Value of deadInterval is from 1 to 65535.")
    @Schema(name="deadInterval", description="The dead interval for the specified interface in seconds. This specifies how long a router will wait to see a neighbor router's Hello packets before declaring that the router is down. This parameter must be the same for all routers attached to a network. It should be within the range of 1-65535 seconds and the default is 40.")
    private @Range(min=1L, max=65535L, message="Value of deadInterval is from 1 to 65535.") Integer deadInterval;
    @NotNull(message="OSPF Interface parameter [authenticationType] should not be null")
    @Range(min=0L, max=2L, message="Value of authenticationType is from 0 to 2.")
    @Schema(name="authenticationType", description="Authentication Type, it should be a value as follows: 0: None, 1: Simple, 2: MD5.")
    private @NotNull(message="OSPF Interface parameter [authenticationType] should not be null") @Range(min=0L, max=2L, message="Value of authenticationType is from 0 to 2.") Integer authenticationType;
    @Size(min=1, max=8, message="Size of simpleKey is from 1 to 8.")
    @Schema(name="simpleKey", description="Displays the key used for simple authentication, its value should be within the range of 1-8.")
    private @Size(min=1, max=8, message="Size of simpleKey is from 1 to 8.") String simpleKey;
    @Range(min=1L, max=255L, message="Value of md5KeyId is from 1 to 255.")
    @Schema(name="md5KeyId", description="Displays the key ID used for md5 authentication, its value should be within the range of 1-255.")
    private @Range(min=1L, max=255L, message="Value of md5KeyId is from 1 to 255.") Integer md5KeyId;
    @Size(min=1, max=16, message="Size of md5Key is from 1 to 16.")
    @Schema(name="md5Key", description="Displays the key used for md5 authentication, its value should be within the range of 1-16.")
    private @Size(min=1, max=16, message="Size of md5Key is from 1 to 16.") String md5Key;

    public static OspfInterfaceOpenApiVO buildByWebVO(OspfInterfaceVO webVO) {
        if (Objects.isNull(webVO)) {
            return null;
        }
        OspfInterfaceOpenApiVO ospfInterfaceOpenApiVO = new OspfInterfaceOpenApiVO();
        ospfInterfaceOpenApiVO.setId(webVO.getId());
        ospfInterfaceOpenApiVO.setDeviceName(webVO.getDeviceName());
        ospfInterfaceOpenApiVO.setIsStack(webVO.getIsStack());
        ospfInterfaceOpenApiVO.setMac(webVO.getMac());
        ospfInterfaceOpenApiVO.setStackId(webVO.getStackId());
        ospfInterfaceOpenApiVO.setVlanInterfaceId(webVO.getVlanInterfaceId());
        ospfInterfaceOpenApiVO.setVlanInterfaceName(webVO.getVlanInterfaceName());
        ospfInterfaceOpenApiVO.setVlanId(webVO.getVlanId());
        ospfInterfaceOpenApiVO.setCost(webVO.getCost());
        ospfInterfaceOpenApiVO.setNetworkType(webVO.getNetworkType());
        ospfInterfaceOpenApiVO.setHelloInterval(webVO.getHelloInterval());
        ospfInterfaceOpenApiVO.setDeadInterval(webVO.getDeadInterval());
        ospfInterfaceOpenApiVO.setAuthenticationType(webVO.getAuthenticationType());
        ospfInterfaceOpenApiVO.setSimpleKey(webVO.getSimpleKey());
        ospfInterfaceOpenApiVO.setMd5KeyId(webVO.getMd5KeyId());
        ospfInterfaceOpenApiVO.setMd5Key(webVO.getMd5Key());
        return ospfInterfaceOpenApiVO;
    }

    public static OspfInterfaceVO toWebVO(OspfInterfaceOpenApiVO ospfInterfaceOpenApiVO) {
        if (Objects.isNull(ospfInterfaceOpenApiVO)) {
            return null;
        }
        OspfInterfaceVO webVO = new OspfInterfaceVO();
        webVO.setId(ospfInterfaceOpenApiVO.getId());
        webVO.setDeviceName(ospfInterfaceOpenApiVO.getDeviceName());
        webVO.setIsStack(ospfInterfaceOpenApiVO.getIsStack());
        webVO.setMac(ospfInterfaceOpenApiVO.getMac());
        webVO.setStackId(ospfInterfaceOpenApiVO.getStackId());
        webVO.setType(com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.a.g);
        webVO.setVlanInterfaceId(ospfInterfaceOpenApiVO.getVlanInterfaceId());
        webVO.setVlanInterfaceName(ospfInterfaceOpenApiVO.getVlanInterfaceName());
        webVO.setVlanId(ospfInterfaceOpenApiVO.getVlanId());
        webVO.setLoopbackInterfaceId(null);
        webVO.setLoopbackId(null);
        webVO.setCost(ospfInterfaceOpenApiVO.getCost());
        webVO.setNetworkType(ospfInterfaceOpenApiVO.getNetworkType());
        webVO.setHelloInterval(ospfInterfaceOpenApiVO.getHelloInterval());
        webVO.setDeadInterval(ospfInterfaceOpenApiVO.getDeadInterval());
        webVO.setAuthenticationType(ospfInterfaceOpenApiVO.getAuthenticationType());
        webVO.setSimpleKey(ospfInterfaceOpenApiVO.getSimpleKey());
        webVO.setMd5KeyId(ospfInterfaceOpenApiVO.getMd5KeyId());
        webVO.setMd5Key(ospfInterfaceOpenApiVO.getMd5Key());
        return webVO;
    }

    public OperationResponse checkAuthenticationType() {
        if (this.getAuthenticationType().equals(com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.a.j) && Objects.isNull(this.getSimpleKey())) {
            return new OperationResponse(b.d, "OSPF Interface parameter [simpleKey] should not be null when authenticationType is 1.", null);
        }
        if (this.getAuthenticationType().equals(com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.a.k) && (Objects.isNull(this.getMd5KeyId()) || Objects.isNull(this.getMd5Key()))) {
            return new OperationResponse(b.d, "OSPF Interface parameter [md5KeyId] and [md5Key] should not be null when authenticationType is 2.", null);
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getDeviceName() {
        return this.deviceName;
    }

    @Generated
    public Boolean getIsStack() {
        return this.isStack;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getStackId() {
        return this.stackId;
    }

    @Generated
    public String getVlanInterfaceId() {
        return this.vlanInterfaceId;
    }

    @Generated
    public String getVlanInterfaceName() {
        return this.vlanInterfaceName;
    }

    @Generated
    public Integer getVlanId() {
        return this.vlanId;
    }

    @Generated
    public Integer getCost() {
        return this.cost;
    }

    @Generated
    public Integer getNetworkType() {
        return this.networkType;
    }

    @Generated
    public Integer getHelloInterval() {
        return this.helloInterval;
    }

    @Generated
    public Integer getDeadInterval() {
        return this.deadInterval;
    }

    @Generated
    public Integer getAuthenticationType() {
        return this.authenticationType;
    }

    @Generated
    public String getSimpleKey() {
        return this.simpleKey;
    }

    @Generated
    public Integer getMd5KeyId() {
        return this.md5KeyId;
    }

    @Generated
    public String getMd5Key() {
        return this.md5Key;
    }

    @Generated
    public OspfInterfaceOpenApiVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public OspfInterfaceOpenApiVO setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    @Generated
    public OspfInterfaceOpenApiVO setIsStack(Boolean isStack) {
        this.isStack = isStack;
        return this;
    }

    @Generated
    public OspfInterfaceOpenApiVO setMac(String mac) {
        this.mac = mac;
        return this;
    }

    @Generated
    public OspfInterfaceOpenApiVO setStackId(String stackId) {
        this.stackId = stackId;
        return this;
    }

    @Generated
    public OspfInterfaceOpenApiVO setVlanInterfaceId(String vlanInterfaceId) {
        this.vlanInterfaceId = vlanInterfaceId;
        return this;
    }

    @Generated
    public OspfInterfaceOpenApiVO setVlanInterfaceName(String vlanInterfaceName) {
        this.vlanInterfaceName = vlanInterfaceName;
        return this;
    }

    @Generated
    public OspfInterfaceOpenApiVO setVlanId(Integer vlanId) {
        this.vlanId = vlanId;
        return this;
    }

    @Generated
    public OspfInterfaceOpenApiVO setCost(Integer cost) {
        this.cost = cost;
        return this;
    }

    @Generated
    public OspfInterfaceOpenApiVO setNetworkType(Integer networkType) {
        this.networkType = networkType;
        return this;
    }

    @Generated
    public OspfInterfaceOpenApiVO setHelloInterval(Integer helloInterval) {
        this.helloInterval = helloInterval;
        return this;
    }

    @Generated
    public OspfInterfaceOpenApiVO setDeadInterval(Integer deadInterval) {
        this.deadInterval = deadInterval;
        return this;
    }

    @Generated
    public OspfInterfaceOpenApiVO setAuthenticationType(Integer authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    @Generated
    public OspfInterfaceOpenApiVO setSimpleKey(String simpleKey) {
        this.simpleKey = simpleKey;
        return this;
    }

    @Generated
    public OspfInterfaceOpenApiVO setMd5KeyId(Integer md5KeyId) {
        this.md5KeyId = md5KeyId;
        return this;
    }

    @Generated
    public OspfInterfaceOpenApiVO setMd5Key(String md5Key) {
        this.md5Key = md5Key;
        return this;
    }
}

