/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.ospf.dto;

import com.tplink.nbu.common.pii.utils.PIIMaskUtil;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.ospfinterface.OspfInterfaceVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class OspfInterfaceConfigOpenApiVO {
    @NotNull(message="Ospf Interface parameter [deviceName] should not be null")
    @Schema(name="deviceName", description="Device Name")
    private @NotNull(message="Ospf Interface parameter [deviceName] should not be null") String deviceName;
    @NotNull(message="OSPF Interface parameter [mac] should not be null")
    @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] Invalid.")
    @Schema(name="mac", description="Device Mac")
    @a
    private @NotNull(message="OSPF Interface parameter [mac] should not be null") @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] Invalid.") String mac;
    @NotNull(message="OSPF Interface parameter [vlanInterfaceId] should not be null")
    @Schema(name="vlanInterfaceId", description="Vlan Interface ID")
    private @NotNull(message="OSPF Interface parameter [vlanInterfaceId] should not be null") String vlanInterfaceId;
    @NotNull(message="OSPF Interface parameter [vlanInterfaceName] should not be null")
    @Schema(name="vlanInterfaceName", description="Vlan Interface Name")
    private @NotNull(message="OSPF Interface parameter [vlanInterfaceName] should not be null") String vlanInterfaceName;
    @NotNull(message="OSPF Interface parameter [vlanId] should not be null")
    @Range(min=1L, max=4094L, message="Value of vlanInterfaceId is from 1 to 4094.")
    @Schema(name="vlanId", description="Vlan ID should be within the range of 1\u20134094.")
    private @NotNull(message="OSPF Interface parameter [vlanId] should not be null") @Range(min=1L, max=4094L, message="Value of vlanInterfaceId is from 1 to 4094.") Integer vlanId;
    @NotNull(message="OSPF Interface parameter [cost] should not be null")
    @Range(min=1L, max=65535L, message="Value of cost is from 1 to 65535.")
    @Schema(name="cost", description="The link cost. OSPF uses this value in computing shortest paths. It should be within the range of 1\u201365535.")
    private @NotNull(message="OSPF Interface parameter [cost] should not be null") @Range(min=1L, max=65535L, message="Value of cost is from 1 to 65535.") Integer cost;
    @NotNull(message="OSPF Interface parameter [networkType] should not be null")
    @Range(min=0L, max=3L, message="Value of networkType is from 0 to 3.")
    @Schema(name="networkType", description="Network Type, it should be a value as follows: 0: Broadcast, 1: Non-Broadcast, 2: Point-to-Multipoint, 3: Point-to-Point. The default network type for Ethernet interfaces is broadcast.")
    private @NotNull(message="OSPF Interface parameter [networkType] should not be null") @Range(min=0L, max=3L, message="Value of networkType is from 0 to 3.") Integer networkType;
    @NotNull(message="OSPF Interface parameter [helloInterval] should not be null")
    @Range(min=1L, max=65535L, message="Value of helloInterval is from 1 to 65535.")
    @Schema(name="helloInterval", description="The hello interval for the specified interface in seconds. This parameter must be the same for all routers attached to a network. It should be within the range of 1-65535 seconds and the default is 10 seconds.")
    private @NotNull(message="OSPF Interface parameter [helloInterval] should not be null") @Range(min=1L, max=65535L, message="Value of helloInterval is from 1 to 65535.") Integer helloInterval;
    @Range(min=1L, max=65535L, message="Value of deadInterval is from 1 to 65535.")
    @Schema(name="deadInterval", description="The dead interval for the specified interface in seconds. This specifies how long a router will wait to see a neighbor router's Hello packets before declaring that the router is down. This parameter must be the same for all routers attached to a network. It should be within the range of 1-65535 seconds and the default is 40.")
    private @Range(min=1L, max=65535L, message="Value of deadInterval is from 1 to 65535.") Integer deadInterval;
    @NotNull(message="OSPF Interface parameter [authenticationType] should not be null")
    @Range(min=0L, max=2L, message="Value of authenticationType is from 0 to 2.")
    @Schema(name="authenticationType", description="Authentication Type, it should be a value as follows: 0: None, 1: Simple, 2: MD5.")
    private @NotNull(message="OSPF Interface parameter [authenticationType] should not be null") @Range(min=0L, max=2L, message="Value of authenticationType is from 0 to 2.") Integer authenticationType;
    @Size(min=1, max=8, message="Size of simpleKey is from 1 to 8.")
    @Schema(name="simpleKey", description="Displays the key used for simple authentication, its value should be within the range of 1-8.")
    private @Size(min=1, max=8, message="Size of simpleKey is from 1 to 8.") String simpleKey;
    @Range(min=1L, max=255L, message="Value of md5KeyId is from 1 to 255.")
    @Schema(name="md5KeyId", description="Displays the key ID used for md5 authentication, its value should be within the range of 1-255.")
    private @Range(min=1L, max=255L, message="Value of md5KeyId is from 1 to 255.") Integer md5KeyId;
    @Size(min=1, max=16, message="Size of md5Key is from 1 to 16.")
    @Schema(name="md5Key", description="Displays the key used for md5 authentication, its value should be within the range of 1-16.")
    private @Size(min=1, max=16, message="Size of md5Key is from 1 to 16.") String md5Key;

    public static OspfInterfaceConfigOpenApiVO buildByWebVO(OspfInterfaceVO webVO) {
        if (Objects.isNull(webVO)) {
            return null;
        }
        OspfInterfaceConfigOpenApiVO ospfInterfaceConfigOpenApiVO = new OspfInterfaceConfigOpenApiVO();
        ospfInterfaceConfigOpenApiVO.setDeviceName(webVO.getDeviceName());
        ospfInterfaceConfigOpenApiVO.setMac(webVO.getMac());
        ospfInterfaceConfigOpenApiVO.setVlanInterfaceId(webVO.getVlanInterfaceId());
        ospfInterfaceConfigOpenApiVO.setVlanInterfaceName(webVO.getVlanInterfaceName());
        ospfInterfaceConfigOpenApiVO.setVlanId(webVO.getVlanId());
        ospfInterfaceConfigOpenApiVO.setCost(webVO.getCost());
        ospfInterfaceConfigOpenApiVO.setNetworkType(webVO.getNetworkType());
        ospfInterfaceConfigOpenApiVO.setHelloInterval(webVO.getHelloInterval());
        ospfInterfaceConfigOpenApiVO.setDeadInterval(webVO.getDeadInterval());
        ospfInterfaceConfigOpenApiVO.setAuthenticationType(webVO.getAuthenticationType());
        ospfInterfaceConfigOpenApiVO.setSimpleKey(webVO.getSimpleKey());
        ospfInterfaceConfigOpenApiVO.setMd5KeyId(webVO.getMd5KeyId());
        ospfInterfaceConfigOpenApiVO.setMd5Key(webVO.getMd5Key());
        return ospfInterfaceConfigOpenApiVO;
    }

    public static OspfInterfaceVO toWebVO(OspfInterfaceConfigOpenApiVO ospfInterfaceConfigOpenApiVO) {
        if (Objects.isNull(ospfInterfaceConfigOpenApiVO)) {
            return null;
        }
        OspfInterfaceVO webVO = new OspfInterfaceVO();
        webVO.setId(null);
        webVO.setDeviceName(ospfInterfaceConfigOpenApiVO.getDeviceName());
        webVO.setIsStack(null);
        webVO.setMac(ospfInterfaceConfigOpenApiVO.getMac());
        webVO.setStackId(null);
        webVO.setType(com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.a.g);
        webVO.setVlanInterfaceId(ospfInterfaceConfigOpenApiVO.getVlanInterfaceId());
        webVO.setVlanInterfaceName(ospfInterfaceConfigOpenApiVO.getVlanInterfaceName());
        webVO.setVlanId(ospfInterfaceConfigOpenApiVO.getVlanId());
        webVO.setLoopbackInterfaceId(null);
        webVO.setLoopbackId(null);
        webVO.setCost(ospfInterfaceConfigOpenApiVO.getCost());
        webVO.setNetworkType(ospfInterfaceConfigOpenApiVO.getNetworkType());
        webVO.setHelloInterval(ospfInterfaceConfigOpenApiVO.getHelloInterval());
        webVO.setDeadInterval(ospfInterfaceConfigOpenApiVO.getDeadInterval());
        webVO.setAuthenticationType(ospfInterfaceConfigOpenApiVO.getAuthenticationType());
        webVO.setSimpleKey(ospfInterfaceConfigOpenApiVO.getSimpleKey());
        webVO.setMd5KeyId(ospfInterfaceConfigOpenApiVO.getMd5KeyId());
        webVO.setMd5Key(ospfInterfaceConfigOpenApiVO.getMd5Key());
        return webVO;
    }

    public OperationResponse checkAuthenticationType() {
        if (this.getAuthenticationType().equals(com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.a.j) && Objects.isNull(this.getSimpleKey())) {
            return new OperationResponse(b.d, "OSPF Interface parameter [simpleKey] should not be null when authenticationType is 1.", null);
        }
        if (this.getAuthenticationType().equals(com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.a.k) && (Objects.isNull(this.getMd5KeyId()) || Objects.isNull(this.getMd5Key()))) {
            return new OperationResponse(b.d, "OSPF Interface parameter [md5KeyId] and [md5Key] should not be null when authenticationType is 2.", null);
        }
        return OperationResponse.SUCCESS;
    }

    public void setSimpleKey(String simpleKey, boolean isViewer) {
        if (isViewer) {
            this.simpleKey = PIIMaskUtil.mask();
            return;
        }
        this.simpleKey = simpleKey;
    }

    public void setMd5Key(String md5Key, boolean isViewer) {
        if (isViewer) {
            this.md5Key = PIIMaskUtil.mask();
            return;
        }
        this.md5Key = md5Key;
    }

    @Generated
    public String getDeviceName() {
        return this.deviceName;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getVlanInterfaceId() {
        return this.vlanInterfaceId;
    }

    @Generated
    public String getVlanInterfaceName() {
        return this.vlanInterfaceName;
    }

    @Generated
    public Integer getVlanId() {
        return this.vlanId;
    }

    @Generated
    public Integer getCost() {
        return this.cost;
    }

    @Generated
    public Integer getNetworkType() {
        return this.networkType;
    }

    @Generated
    public Integer getHelloInterval() {
        return this.helloInterval;
    }

    @Generated
    public Integer getDeadInterval() {
        return this.deadInterval;
    }

    @Generated
    public Integer getAuthenticationType() {
        return this.authenticationType;
    }

    @Generated
    public String getSimpleKey() {
        return this.simpleKey;
    }

    @Generated
    public Integer getMd5KeyId() {
        return this.md5KeyId;
    }

    @Generated
    public String getMd5Key() {
        return this.md5Key;
    }

    @Generated
    public OspfInterfaceConfigOpenApiVO setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    @Generated
    public OspfInterfaceConfigOpenApiVO setMac(String mac) {
        this.mac = mac;
        return this;
    }

    @Generated
    public OspfInterfaceConfigOpenApiVO setVlanInterfaceId(String vlanInterfaceId) {
        this.vlanInterfaceId = vlanInterfaceId;
        return this;
    }

    @Generated
    public OspfInterfaceConfigOpenApiVO setVlanInterfaceName(String vlanInterfaceName) {
        this.vlanInterfaceName = vlanInterfaceName;
        return this;
    }

    @Generated
    public OspfInterfaceConfigOpenApiVO setVlanId(Integer vlanId) {
        this.vlanId = vlanId;
        return this;
    }

    @Generated
    public OspfInterfaceConfigOpenApiVO setCost(Integer cost) {
        this.cost = cost;
        return this;
    }

    @Generated
    public OspfInterfaceConfigOpenApiVO setNetworkType(Integer networkType) {
        this.networkType = networkType;
        return this;
    }

    @Generated
    public OspfInterfaceConfigOpenApiVO setHelloInterval(Integer helloInterval) {
        this.helloInterval = helloInterval;
        return this;
    }

    @Generated
    public OspfInterfaceConfigOpenApiVO setDeadInterval(Integer deadInterval) {
        this.deadInterval = deadInterval;
        return this;
    }

    @Generated
    public OspfInterfaceConfigOpenApiVO setAuthenticationType(Integer authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    @Generated
    public OspfInterfaceConfigOpenApiVO setSimpleKey(String simpleKey) {
        this.simpleKey = simpleKey;
        return this;
    }

    @Generated
    public OspfInterfaceConfigOpenApiVO setMd5KeyId(Integer md5KeyId) {
        this.md5KeyId = md5KeyId;
        return this;
    }

    @Generated
    public OspfInterfaceConfigOpenApiVO setMd5Key(String md5Key) {
        this.md5Key = md5Key;
        return this;
    }
}

