/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.ospf.dto;

import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.ospf.ospfprocess.BatchOspfProcessVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class BatchOspfProcessOpenApiVO {
    @NotNull(message="OSPF Process parameter [processIdList] should not be null")
    @Schema(name="processIdList", description="List of Process ID")
    private @NotNull(message="OSPF Process parameter [processIdList] should not be null") List<String> processIdList;
    @NotNull(message="OSPF Process parameter [selectType] should not be null")
    @Range(min=1L, max=3L, message="Value of selectType is from 1 to 3.")
    @Schema(name="selectType", description="Select Type, it should be a value as follows: 1: SELECT ALL, 2: SELECT INCLUDE, 3: SELECT EXCLUDE.")
    private @NotNull(message="OSPF Process parameter [selectType] should not be null") @Range(min=1L, max=3L, message="Value of selectType is from 1 to 3.") Integer selectType;
    @Schema(name="searchKey", description="SearchKey")
    private String searchKey;

    public static BatchOspfProcessOpenApiVO buildByWebVO(BatchOspfProcessVO webVO) {
        if (Objects.isNull(webVO)) {
            return null;
        }
        BatchOspfProcessOpenApiVO openApiVO = new BatchOspfProcessOpenApiVO();
        openApiVO.setProcessIdList(CollectionUtils.isEmpty((Collection)webVO.getProcessIdList()) ? new ArrayList() : webVO.getProcessIdList());
        openApiVO.setSelectType(webVO.getSelectType());
        openApiVO.setSearchKey(webVO.getSearchKey());
        return openApiVO;
    }

    public static BatchOspfProcessVO toWebVO(BatchOspfProcessOpenApiVO openApiVO) {
        if (Objects.isNull(openApiVO)) {
            return null;
        }
        BatchOspfProcessVO webVO = new BatchOspfProcessVO();
        webVO.setProcessIdList(CollectionUtils.isEmpty(openApiVO.getProcessIdList()) ? new ArrayList() : openApiVO.getProcessIdList());
        webVO.setSelectType(openApiVO.getSelectType());
        webVO.setSearchKey(openApiVO.getSearchKey());
        return webVO;
    }

    @Generated
    public List<String> getProcessIdList() {
        return this.processIdList;
    }

    @Generated
    public Integer getSelectType() {
        return this.selectType;
    }

    @Generated
    public String getSearchKey() {
        return this.searchKey;
    }

    @Generated
    public BatchOspfProcessOpenApiVO setProcessIdList(List<String> processIdList) {
        this.processIdList = processIdList;
        return this;
    }

    @Generated
    public BatchOspfProcessOpenApiVO setSelectType(Integer selectType) {
        this.selectType = selectType;
        return this;
    }

    @Generated
    public BatchOspfProcessOpenApiVO setSearchKey(String searchKey) {
        this.searchKey = searchKey;
        return this;
    }
}

