/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.nat.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.PortForwardingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class PortForwardingTemplateOpenApiVO {
    @NotNull(message="PortForwarding parameter [name] should not be null")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.")
    @Schema(name="name", description="Name, name should contain 1 to 64 characters.")
    private @NotNull(message="PortForwarding parameter [name] should not be null") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.") String name;
    @NotNull(message="PortForwarding parameter [status] should not be null")
    @Schema(name="status", description="Port-forwarding enable status.")
    private @NotNull(message="PortForwarding parameter [status] should not be null") Boolean status;
    @NotNull(message="PortForwarding parameter [from] should not be null")
    @Schema(name="from", description="From corresponds with source IP in web. From should be a value as follows: 0: where; 1: limited address")
    private @NotNull(message="PortForwarding parameter [from] should not be null") Integer from;
    @Schema(name="limitedAddresses", description="Only for limited address")
    private List<String> limitedAddresses;
    @NotNull(message="PortForwarding parameter [dMZ] should not be null")
    @Schema(name="dMZ", description="With DMZ enabled, all ports are open and the traffic from external network will be forwarded to the specific destination IP in the LAN.")
    @JsonProperty(value="dMZ")
    private @NotNull(message="PortForwarding parameter [dMZ] should not be null") Boolean dMZ;
    @NotNull(message="PortForwarding parameter [interfaceWanPortId] should not be null")
    @Schema(name="interfaceWanPortId", description="This field represents WAN port ID. WAN port ID can be obtained from can be obtained from 'Get internet basic info' interface.")
    private @NotNull(message="PortForwarding parameter [interfaceWanPortId] should not be null") List<String> interfaceWanPortId;
    @Pattern(regexp="^(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))|((([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))-(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5])))$", message="Parameter [externalPort] should be xx or xx-xx, 1-65535.")
    @Schema(name="externalPort", description="External port corresponds with source port in web. External port should be within the range of 1\u201365535. Must be filled in when DMS is false.")
    private @Pattern(regexp="^(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))|((([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))-(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5])))$", message="Parameter [externalPort] should be xx or xx-xx, 1-65535.") String externalPort;
    @NotNull(message="PortForwarding parameter [forwardIp] should not be null")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [forwardIp] Invalid.")
    @Schema(name="forwardIp", description="Forward IP corresponds with destination IP in web. Forward IP")
    private @NotNull(message="PortForwarding parameter [forwardIp] should not be null") @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [forwardIp] Invalid.") String forwardIp;
    @Pattern(regexp="^(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))|((([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))-(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5])))$", message="Parameter [forwardPort] should be xx or xx-xx, 1-65535.")
    @Schema(name="forwardPort", description="Forward port corresponds with destination port in web. Forward port should be 1 or 1-10, within the range of 1\u201365535. Must be filled in when DMS is false.")
    private @Pattern(regexp="^(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))|((([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))-(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5])))$", message="Parameter [forwardPort] should be xx or xx-xx, 1-65535.") String forwardPort;
    @Range(min=0L, max=2L)
    @Schema(name="protocol", description="Protocol should be a value as follows: 0: ALL; 1: TCP; 2: UDP. Must be filled in when DMS is false.")
    private @Range(min=0L, max=2L) Integer protocol;

    public static PortForwardingVO toWebVO(PortForwardingTemplateOpenApiVO vo, String siteId) {
        PortForwardingVO portForwardingVO = new PortForwardingVO();
        portForwardingVO.setName(vo.getName());
        portForwardingVO.setStatus(vo.getStatus());
        portForwardingVO.setFrom(vo.getFrom());
        portForwardingVO.setSite(siteId);
        portForwardingVO.setLimitedAddresses(vo.getLimitedAddresses());
        portForwardingVO.setDMZ(vo.getDMZ());
        portForwardingVO.setInterfaceWanPortId(vo.getInterfaceWanPortId());
        portForwardingVO.setExternalPort(vo.getExternalPort());
        portForwardingVO.setForwardIp(vo.getForwardIp());
        portForwardingVO.setForwardPort(vo.getForwardPort());
        portForwardingVO.setProtocol(vo.getProtocol());
        return portForwardingVO;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Integer getFrom() {
        return this.from;
    }

    @Generated
    public List<String> getLimitedAddresses() {
        return this.limitedAddresses;
    }

    @Generated
    public Boolean getDMZ() {
        return this.dMZ;
    }

    @Generated
    public List<String> getInterfaceWanPortId() {
        return this.interfaceWanPortId;
    }

    @Generated
    public String getExternalPort() {
        return this.externalPort;
    }

    @Generated
    public String getForwardIp() {
        return this.forwardIp;
    }

    @Generated
    public String getForwardPort() {
        return this.forwardPort;
    }

    @Generated
    public Integer getProtocol() {
        return this.protocol;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setFrom(Integer from) {
        this.from = from;
    }

    @Generated
    public void setLimitedAddresses(List<String> limitedAddresses) {
        this.limitedAddresses = limitedAddresses;
    }

    @JsonProperty(value="dMZ")
    @Generated
    public void setDMZ(Boolean dMZ) {
        this.dMZ = dMZ;
    }

    @Generated
    public void setInterfaceWanPortId(List<String> interfaceWanPortId) {
        this.interfaceWanPortId = interfaceWanPortId;
    }

    @Generated
    public void setExternalPort(String externalPort) {
        this.externalPort = externalPort;
    }

    @Generated
    public void setForwardIp(String forwardIp) {
        this.forwardIp = forwardIp;
    }

    @Generated
    public void setForwardPort(String forwardPort) {
        this.forwardPort = forwardPort;
    }

    @Generated
    public void setProtocol(Integer protocol) {
        this.protocol = protocol;
    }

    @Generated
    public String toString() {
        return "PortForwardingTemplateOpenApiVO(name=" + this.getName() + ", status=" + this.getStatus() + ", from=" + this.getFrom() + ", limitedAddresses=" + this.getLimitedAddresses() + ", dMZ=" + this.getDMZ() + ", interfaceWanPortId=" + this.getInterfaceWanPortId() + ", externalPort=" + this.getExternalPort() + ", forwardIp=" + this.getForwardIp() + ", forwardPort=" + this.getForwardPort() + ", protocol=" + this.getProtocol() + ")";
    }

    @Generated
    public PortForwardingTemplateOpenApiVO(String name, Boolean status, Integer from, List<String> limitedAddresses, Boolean dMZ, List<String> interfaceWanPortId, String externalPort, String forwardIp, String forwardPort, Integer protocol) {
        this.name = name;
        this.status = status;
        this.from = from;
        this.limitedAddresses = limitedAddresses;
        this.dMZ = dMZ;
        this.interfaceWanPortId = interfaceWanPortId;
        this.externalPort = externalPort;
        this.forwardIp = forwardIp;
        this.forwardPort = forwardPort;
        this.protocol = protocol;
    }

    @Generated
    public PortForwardingTemplateOpenApiVO() {
    }
}

