/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.nat.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.nat.dto.PortIpOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.PortForwardingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

@Schema(name="PortForwardingInfoTemplate")
public class PortForwardingInfoTemplateOpenApiVO {
    @Schema(name="id", description="Port-forwarding ID")
    private String id;
    @Schema(name="site id", description="Site ID")
    private String site;
    @NotNull(message="PortForwarding parameter [name] should not be null")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.")
    @Schema(name="name", description="Name, name should contain 1 to 64 characters.")
    private @NotNull(message="PortForwarding parameter [name] should not be null") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [name] should be visible ASCII, between 1 and 64 characters.") String name;
    @NotNull(message="PortForwarding parameter [status] should not be null")
    @Schema(name="status", description="Port-forwarding enable status.")
    private @NotNull(message="PortForwarding parameter [status] should not be null") Boolean status;
    @NotNull(message="PortForwarding parameter [from] should not be null")
    @Schema(name="from", description="From corresponds with source IP in web. From should be a value as follows: 0: where; 1: limited address")
    @Range(min=0L, max=1L)
    private @NotNull(message="PortForwarding parameter [from] should not be null") @Range(min=0L, max=1L) Integer from;
    @Schema(name="limitedAddresses", description="Only for limited address")
    private List<String> limitedAddresses;
    @NotNull(message="PortForwarding parameter [dMZ] should not be null")
    @Schema(name="dMZ", description="With DMZ enabled, all ports are open and the traffic from external network will be forwarded to the specific destination IP in the LAN.")
    @JsonProperty(value="dMZ")
    private @NotNull(message="PortForwarding parameter [dMZ] should not be null") Boolean dMZ;
    @NotNull(message="PortForwarding parameter [interfaceWanPortId] should not be null")
    @Schema(name="interfaceWanPortId", description="This field represents WAN port ID. WAN port ID can be obtained from can be obtained from 'Get internet basic info' interface.")
    private @NotNull(message="PortForwarding parameter [interfaceWanPortId] should not be null") List<String> interfaceWanPortId;
    @Schema(name="virtualWanId", description="This field represents VirtualWan ID. VirtualWan ID can be obtained from 'Query available virtual WAN list' interface")
    private List<String> virtualWanId;
    @Valid
    @Schema(name="wanIps", description="WAN IPs")
    private List<PortIpOpenApiVO> wanIps;
    @Pattern(regexp="^(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))|((([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))-(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5])))$", message="Parameter [externalPort] should be xx or xx-xx, 1-65535.")
    @Schema(name="externalPort", description="External port corresponds with source port in web. ExternalPort should be within the range of 1\u201365535.")
    private @Pattern(regexp="^(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))|((([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))-(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5])))$", message="Parameter [externalPort] should be xx or xx-xx, 1-65535.") String externalPort;
    @NotNull(message="PortForwarding parameter [forwardIp] should not be null")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [forwardIp] Invalid.")
    @Schema(name="forwardIp", description="Forward IP corresponds with destination IP in web. Forward IP")
    private @NotNull(message="PortForwarding parameter [forwardIp] should not be null") @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [forwardIp] Invalid.") String forwardIp;
    @Pattern(regexp="^(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))|((([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))-(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5])))$", message="Parameter [forwardPort] should be xx or xx-xx, 1-65535.")
    @Schema(name="forwardPort", description="Forward port corresponds with destination port in web. ForwardPort should be 1 or 1-10, within the range of 1\u201365535.")
    private @Pattern(regexp="^(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))|((([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5]))-(([1-9]\\d{0,3})|([1-5]\\d{4})|(6[0-4]\\d{3})|(65[0-4]\\d{2})|(655[0-2]\\d)|(6553[0-5])))$", message="Parameter [forwardPort] should be xx or xx-xx, 1-65535.") String forwardPort;
    @Range(min=0L, max=2L)
    @Schema(name="protocol", description="Protocol should be a value as follows: 0: ALL; 1: TCP; 2: UDP.")
    private @Range(min=0L, max=2L) Integer protocol;

    public static PortForwardingInfoTemplateOpenApiVO buildByWebVO(PortForwardingVO vo) {
        return ((PortForwardingInfoTemplateOpenApiVOBuilder)((PortForwardingInfoTemplateOpenApiVOBuilder)((PortForwardingInfoTemplateOpenApiVOBuilder)((PortForwardingInfoTemplateOpenApiVOBuilder)((PortForwardingInfoTemplateOpenApiVOBuilder)((PortForwardingInfoTemplateOpenApiVOBuilder)((PortForwardingInfoTemplateOpenApiVOBuilder)((PortForwardingInfoTemplateOpenApiVOBuilder)((PortForwardingInfoTemplateOpenApiVOBuilder)((PortForwardingInfoTemplateOpenApiVOBuilder)((PortForwardingInfoTemplateOpenApiVOBuilder)((PortForwardingInfoTemplateOpenApiVOBuilder)((PortForwardingInfoTemplateOpenApiVOBuilder)((PortForwardingInfoTemplateOpenApiVOBuilder)PortForwardingInfoTemplateOpenApiVO.builder().id(vo.getId())).name(vo.getName())).status(vo.getStatus())).site(vo.getSite())).from(vo.getFrom())).limitedAddresses(vo.getLimitedAddresses())).dMZ(vo.getDMZ())).interfaceWanPortId(vo.getInterfaceWanPortId())).wanIps(CollectionUtils.isEmpty((Collection)vo.getWanIps()) ? null : vo.getWanIps().stream().map(PortIpOpenApiVO::buildByWebVO).toList())).virtualWanId(vo.getVirtualWanId())).externalPort(vo.getExternalPort())).forwardIp(vo.getForwardIp())).forwardPort(vo.getForwardPort())).protocol(vo.getProtocol())).build();
    }

    @Generated
    protected PortForwardingInfoTemplateOpenApiVO(PortForwardingInfoTemplateOpenApiVOBuilder<?, ?> b2) {
        this.id = b2.id;
        this.site = b2.site;
        this.name = b2.name;
        this.status = b2.status;
        this.from = b2.from;
        this.limitedAddresses = b2.limitedAddresses;
        this.dMZ = b2.dMZ;
        this.interfaceWanPortId = b2.interfaceWanPortId;
        this.virtualWanId = b2.virtualWanId;
        this.wanIps = b2.wanIps;
        this.externalPort = b2.externalPort;
        this.forwardIp = b2.forwardIp;
        this.forwardPort = b2.forwardPort;
        this.protocol = b2.protocol;
    }

    @Generated
    public static PortForwardingInfoTemplateOpenApiVOBuilder<?, ?> builder() {
        return new PortForwardingInfoTemplateOpenApiVOBuilderImpl();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getSite() {
        return this.site;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Integer getFrom() {
        return this.from;
    }

    @Generated
    public List<String> getLimitedAddresses() {
        return this.limitedAddresses;
    }

    @Generated
    public Boolean getDMZ() {
        return this.dMZ;
    }

    @Generated
    public List<String> getInterfaceWanPortId() {
        return this.interfaceWanPortId;
    }

    @Generated
    public List<String> getVirtualWanId() {
        return this.virtualWanId;
    }

    @Generated
    public List<PortIpOpenApiVO> getWanIps() {
        return this.wanIps;
    }

    @Generated
    public String getExternalPort() {
        return this.externalPort;
    }

    @Generated
    public String getForwardIp() {
        return this.forwardIp;
    }

    @Generated
    public String getForwardPort() {
        return this.forwardPort;
    }

    @Generated
    public Integer getProtocol() {
        return this.protocol;
    }

    @Generated
    public PortForwardingInfoTemplateOpenApiVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public PortForwardingInfoTemplateOpenApiVO setSite(String site) {
        this.site = site;
        return this;
    }

    @Generated
    public PortForwardingInfoTemplateOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public PortForwardingInfoTemplateOpenApiVO setStatus(Boolean status) {
        this.status = status;
        return this;
    }

    @Generated
    public PortForwardingInfoTemplateOpenApiVO setFrom(Integer from) {
        this.from = from;
        return this;
    }

    @Generated
    public PortForwardingInfoTemplateOpenApiVO setLimitedAddresses(List<String> limitedAddresses) {
        this.limitedAddresses = limitedAddresses;
        return this;
    }

    @JsonProperty(value="dMZ")
    @Generated
    public PortForwardingInfoTemplateOpenApiVO setDMZ(Boolean dMZ) {
        this.dMZ = dMZ;
        return this;
    }

    @Generated
    public PortForwardingInfoTemplateOpenApiVO setInterfaceWanPortId(List<String> interfaceWanPortId) {
        this.interfaceWanPortId = interfaceWanPortId;
        return this;
    }

    @Generated
    public PortForwardingInfoTemplateOpenApiVO setVirtualWanId(List<String> virtualWanId) {
        this.virtualWanId = virtualWanId;
        return this;
    }

    @Generated
    public PortForwardingInfoTemplateOpenApiVO setWanIps(List<PortIpOpenApiVO> wanIps) {
        this.wanIps = wanIps;
        return this;
    }

    @Generated
    public PortForwardingInfoTemplateOpenApiVO setExternalPort(String externalPort) {
        this.externalPort = externalPort;
        return this;
    }

    @Generated
    public PortForwardingInfoTemplateOpenApiVO setForwardIp(String forwardIp) {
        this.forwardIp = forwardIp;
        return this;
    }

    @Generated
    public PortForwardingInfoTemplateOpenApiVO setForwardPort(String forwardPort) {
        this.forwardPort = forwardPort;
        return this;
    }

    @Generated
    public PortForwardingInfoTemplateOpenApiVO setProtocol(Integer protocol) {
        this.protocol = protocol;
        return this;
    }

    @Generated
    public String toString() {
        return "PortForwardingInfoTemplateOpenApiVO(id=" + this.getId() + ", site=" + this.getSite() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", from=" + this.getFrom() + ", limitedAddresses=" + this.getLimitedAddresses() + ", dMZ=" + this.getDMZ() + ", interfaceWanPortId=" + this.getInterfaceWanPortId() + ", virtualWanId=" + this.getVirtualWanId() + ", wanIps=" + this.getWanIps() + ", externalPort=" + this.getExternalPort() + ", forwardIp=" + this.getForwardIp() + ", forwardPort=" + this.getForwardPort() + ", protocol=" + this.getProtocol() + ")";
    }

    @Generated
    public PortForwardingInfoTemplateOpenApiVO(String id, String site, String name, Boolean status, Integer from, List<String> limitedAddresses, Boolean dMZ, List<String> interfaceWanPortId, List<String> virtualWanId, List<PortIpOpenApiVO> wanIps, String externalPort, String forwardIp, String forwardPort, Integer protocol) {
        this.id = id;
        this.site = site;
        this.name = name;
        this.status = status;
        this.from = from;
        this.limitedAddresses = limitedAddresses;
        this.dMZ = dMZ;
        this.interfaceWanPortId = interfaceWanPortId;
        this.virtualWanId = virtualWanId;
        this.wanIps = wanIps;
        this.externalPort = externalPort;
        this.forwardIp = forwardIp;
        this.forwardPort = forwardPort;
        this.protocol = protocol;
    }

    @Generated
    public PortForwardingInfoTemplateOpenApiVO() {
    }

    @Generated
    public static abstract class PortForwardingInfoTemplateOpenApiVOBuilder<C extends PortForwardingInfoTemplateOpenApiVO, B extends PortForwardingInfoTemplateOpenApiVOBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String site;
        @Generated
        private String name;
        @Generated
        private Boolean status;
        @Generated
        private Integer from;
        @Generated
        private List<String> limitedAddresses;
        @Generated
        private Boolean dMZ;
        @Generated
        private List<String> interfaceWanPortId;
        @Generated
        private List<String> virtualWanId;
        @Generated
        private List<PortIpOpenApiVO> wanIps;
        @Generated
        private String externalPort;
        @Generated
        private String forwardIp;
        @Generated
        private String forwardPort;
        @Generated
        private Integer protocol;

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B site(String site) {
            this.site = site;
            return this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B status(Boolean status) {
            this.status = status;
            return this.self();
        }

        @Generated
        public B from(Integer from) {
            this.from = from;
            return this.self();
        }

        @Generated
        public B limitedAddresses(List<String> limitedAddresses) {
            this.limitedAddresses = limitedAddresses;
            return this.self();
        }

        @JsonProperty(value="dMZ")
        @Generated
        public B dMZ(Boolean dMZ) {
            this.dMZ = dMZ;
            return this.self();
        }

        @Generated
        public B interfaceWanPortId(List<String> interfaceWanPortId) {
            this.interfaceWanPortId = interfaceWanPortId;
            return this.self();
        }

        @Generated
        public B virtualWanId(List<String> virtualWanId) {
            this.virtualWanId = virtualWanId;
            return this.self();
        }

        @Generated
        public B wanIps(List<PortIpOpenApiVO> wanIps) {
            this.wanIps = wanIps;
            return this.self();
        }

        @Generated
        public B externalPort(String externalPort) {
            this.externalPort = externalPort;
            return this.self();
        }

        @Generated
        public B forwardIp(String forwardIp) {
            this.forwardIp = forwardIp;
            return this.self();
        }

        @Generated
        public B forwardPort(String forwardPort) {
            this.forwardPort = forwardPort;
            return this.self();
        }

        @Generated
        public B protocol(Integer protocol) {
            this.protocol = protocol;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "PortForwardingInfoTemplateOpenApiVO.PortForwardingInfoTemplateOpenApiVOBuilder(id=" + this.id + ", site=" + this.site + ", name=" + this.name + ", status=" + this.status + ", from=" + this.from + ", limitedAddresses=" + this.limitedAddresses + ", dMZ=" + this.dMZ + ", interfaceWanPortId=" + this.interfaceWanPortId + ", virtualWanId=" + this.virtualWanId + ", wanIps=" + this.wanIps + ", externalPort=" + this.externalPort + ", forwardIp=" + this.forwardIp + ", forwardPort=" + this.forwardPort + ", protocol=" + this.protocol + ")";
        }
    }

    @Generated
    private static final class PortForwardingInfoTemplateOpenApiVOBuilderImpl
    extends PortForwardingInfoTemplateOpenApiVOBuilder<PortForwardingInfoTemplateOpenApiVO, PortForwardingInfoTemplateOpenApiVOBuilderImpl> {
        @Generated
        private PortForwardingInfoTemplateOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected PortForwardingInfoTemplateOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PortForwardingInfoTemplateOpenApiVO build() {
            return new PortForwardingInfoTemplateOpenApiVO(this);
        }
    }
}

