/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.nat.dto;

import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.OtoNatVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;

public class OtoNatOpenApiVO {
    @NotNull(message="Nat name should not be null")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Invalid internal ip format.")
    @Schema(name="name", description="Name, name should contain 1 to 64 characters.")
    private @NotNull(message="Nat name should not be null") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Invalid internal ip format.") String name;
    @NotNull(message="Wan ports should not be null")
    @Schema(name="status", description="Status")
    private @NotNull(message="Wan ports should not be null") Boolean status;
    @NotNull(message="Wan ports should not be null")
    @Schema(name="interfaceIds", description="This field represents WAN port ID. WAN port ID can be obtained from can be obtained from 'Get internet basic info' interface.")
    private @NotNull(message="Wan ports should not be null") List<String> interfaceIds;
    @NotNull(message="Internal IP should not be null")
    @Schema(name="internalIp", description="Internal IP")
    private @NotNull(message="Internal IP should not be null") String internalIp;
    @NotNull(message="External IP should not be null")
    @Schema(name="externalIp", description="External IP")
    private @NotNull(message="External IP should not be null") String externalIp;
    @NotNull(message="Dmz should not be null")
    @Schema(name="dmz", description="Whether to enable the h323 dmz")
    private @NotNull(message="Dmz should not be null") Boolean dmz;
    @Schema(name="description", description="Description should contain 1 to 64 characters.")
    @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [description] should be 1 ~ 64 characters")
    private @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [description] should be 1 ~ 64 characters") String description;

    public static OtoNatVO toWebVO(OtoNatOpenApiVO vo) {
        OtoNatVO otoNatVO = new OtoNatVO();
        otoNatVO.setName(vo.getName());
        otoNatVO.setDescription(vo.getDescription());
        otoNatVO.setDmz(vo.getDmz());
        otoNatVO.setInterfaceIds(vo.getInterfaceIds());
        otoNatVO.setInternalIp(vo.getInternalIp());
        otoNatVO.setExternalIp(vo.getExternalIp());
        otoNatVO.setStatus(vo.getStatus());
        return otoNatVO;
    }

    @Generated
    protected OtoNatOpenApiVO(OtoNatOpenApiVOBuilder<?, ?> b2) {
        this.name = b2.name;
        this.status = b2.status;
        this.interfaceIds = b2.interfaceIds;
        this.internalIp = b2.internalIp;
        this.externalIp = b2.externalIp;
        this.dmz = b2.dmz;
        this.description = b2.description;
    }

    @Generated
    public static OtoNatOpenApiVOBuilder<?, ?> builder() {
        return new OtoNatOpenApiVOBuilderImpl();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public List<String> getInterfaceIds() {
        return this.interfaceIds;
    }

    @Generated
    public String getInternalIp() {
        return this.internalIp;
    }

    @Generated
    public String getExternalIp() {
        return this.externalIp;
    }

    @Generated
    public Boolean getDmz() {
        return this.dmz;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public OtoNatOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public OtoNatOpenApiVO setStatus(Boolean status) {
        this.status = status;
        return this;
    }

    @Generated
    public OtoNatOpenApiVO setInterfaceIds(List<String> interfaceIds) {
        this.interfaceIds = interfaceIds;
        return this;
    }

    @Generated
    public OtoNatOpenApiVO setInternalIp(String internalIp) {
        this.internalIp = internalIp;
        return this;
    }

    @Generated
    public OtoNatOpenApiVO setExternalIp(String externalIp) {
        this.externalIp = externalIp;
        return this;
    }

    @Generated
    public OtoNatOpenApiVO setDmz(Boolean dmz) {
        this.dmz = dmz;
        return this;
    }

    @Generated
    public OtoNatOpenApiVO setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public String toString() {
        return "OtoNatOpenApiVO(name=" + this.getName() + ", status=" + this.getStatus() + ", interfaceIds=" + this.getInterfaceIds() + ", internalIp=" + this.getInternalIp() + ", externalIp=" + this.getExternalIp() + ", dmz=" + this.getDmz() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public OtoNatOpenApiVO(String name, Boolean status, List<String> interfaceIds, String internalIp, String externalIp, Boolean dmz, String description) {
        this.name = name;
        this.status = status;
        this.interfaceIds = interfaceIds;
        this.internalIp = internalIp;
        this.externalIp = externalIp;
        this.dmz = dmz;
        this.description = description;
    }

    @Generated
    public OtoNatOpenApiVO() {
    }

    @Generated
    public static abstract class OtoNatOpenApiVOBuilder<C extends OtoNatOpenApiVO, B extends OtoNatOpenApiVOBuilder<C, B>> {
        @Generated
        private String name;
        @Generated
        private Boolean status;
        @Generated
        private List<String> interfaceIds;
        @Generated
        private String internalIp;
        @Generated
        private String externalIp;
        @Generated
        private Boolean dmz;
        @Generated
        private String description;

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B status(Boolean status) {
            this.status = status;
            return this.self();
        }

        @Generated
        public B interfaceIds(List<String> interfaceIds) {
            this.interfaceIds = interfaceIds;
            return this.self();
        }

        @Generated
        public B internalIp(String internalIp) {
            this.internalIp = internalIp;
            return this.self();
        }

        @Generated
        public B externalIp(String externalIp) {
            this.externalIp = externalIp;
            return this.self();
        }

        @Generated
        public B dmz(Boolean dmz) {
            this.dmz = dmz;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "OtoNatOpenApiVO.OtoNatOpenApiVOBuilder(name=" + this.name + ", status=" + this.status + ", interfaceIds=" + this.interfaceIds + ", internalIp=" + this.internalIp + ", externalIp=" + this.externalIp + ", dmz=" + this.dmz + ", description=" + this.description + ")";
        }
    }

    @Generated
    private static final class OtoNatOpenApiVOBuilderImpl
    extends OtoNatOpenApiVOBuilder<OtoNatOpenApiVO, OtoNatOpenApiVOBuilderImpl> {
        @Generated
        private OtoNatOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected OtoNatOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OtoNatOpenApiVO build() {
            return new OtoNatOpenApiVO(this);
        }
    }
}

