/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitetemplatesetting.ouibasedvlan;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.ouiBasedVlan.VlanOuiModeQueryOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.ouibasedvlan.OuiBasedVlanRuleVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.ouibasedvlan.VlanOuiModeVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class OuiBasedVlanTemplateSwitchQueryOpenApiVO {
    @Schema(name="id", description="Rule ID")
    private String id;
    @Schema(name="enable", description="Switch Rule state.")
    private Boolean enable;
    @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.")
    @Schema(name="name", description="Switch Rule name should contain 1 to 128 characters.")
    private @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.") String name;
    @Schema(name="mode", description="Switch Rule type should be a value as follows: 0: All device port; 1: Custom device port")
    private Integer mode;
    @Schema(name="ruleCombine", description="Basic vlan-oui-priority configuration of oui based vlan rule.")
    private List<VlanOuiModeQueryOpenApiVO> ruleCombine;

    public static OuiBasedVlanTemplateSwitchQueryOpenApiVO buildByWebVO(OuiBasedVlanRuleVO webVO) {
        if (Objects.isNull(webVO)) {
            return null;
        }
        OuiBasedVlanTemplateSwitchQueryOpenApiVO templateOpenApiVO = new OuiBasedVlanTemplateSwitchQueryOpenApiVO();
        templateOpenApiVO.setId(webVO.getId());
        templateOpenApiVO.setName(webVO.getName());
        templateOpenApiVO.setMode(webVO.getMode());
        templateOpenApiVO.setRuleCombine(OuiBasedVlanTemplateSwitchQueryOpenApiVO.buildRuleCombineByWebVO(webVO.getRuleCombine()));
        return templateOpenApiVO;
    }

    private static List<VlanOuiModeQueryOpenApiVO> buildRuleCombineByWebVO(List<VlanOuiModeVO> ruleCombine) {
        ArrayList<VlanOuiModeQueryOpenApiVO> vlanOuiList = new ArrayList<VlanOuiModeQueryOpenApiVO>();
        if (CollectionUtils.isEmpty(ruleCombine)) {
            return vlanOuiList;
        }
        for (VlanOuiModeVO vlanOuiModeVO : ruleCombine) {
            VlanOuiModeQueryOpenApiVO vo = new VlanOuiModeQueryOpenApiVO();
            vo.setOuiProfileId(vlanOuiModeVO.getOuiProfileId());
            vo.setOuiProfileName(vlanOuiModeVO.getOuiProfileName());
            vo.setPriority(vlanOuiModeVO.getPriority());
            vo.setVlanId(vlanOuiModeVO.getVlanId());
            vlanOuiList.add(vo);
        }
        return vlanOuiList;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public List<VlanOuiModeQueryOpenApiVO> getRuleCombine() {
        return this.ruleCombine;
    }

    @Generated
    public OuiBasedVlanTemplateSwitchQueryOpenApiVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public OuiBasedVlanTemplateSwitchQueryOpenApiVO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public OuiBasedVlanTemplateSwitchQueryOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public OuiBasedVlanTemplateSwitchQueryOpenApiVO setMode(Integer mode) {
        this.mode = mode;
        return this;
    }

    @Generated
    public OuiBasedVlanTemplateSwitchQueryOpenApiVO setRuleCombine(List<VlanOuiModeQueryOpenApiVO> ruleCombine) {
        this.ruleCombine = ruleCombine;
        return this;
    }
}

