/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitetemplatesetting.ouibasedvlan;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.ouiBasedVlan.VlanOuiModeOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.ouibasedvlan.OuiBasedVlanRuleVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.ouibasedvlan.VlanOuiModeVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class OuiBasedVlanTemplateOpenApiVO {
    @NotNull
    @Schema(name="enable", description="Switch Rule state.")
    private Boolean enable;
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.")
    @Schema(name="name", description="Switch Rule name should contain 1 to 128 characters.")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.") String name;
    @NotNull
    @Schema(name="mode", description="Switch Rule type should be a value as follows: 0: All device port")
    private Integer mode;
    @NotNull
    @Valid
    @Schema(name="ruleCombine", description="Basic vlan-oui-priority configuration of oui based rule. Cannot be empty.")
    private List<VlanOuiModeOpenApiVO> ruleCombine;

    public static OuiBasedVlanRuleVO toWebVO(OuiBasedVlanTemplateOpenApiVO templateOpenApiVO) {
        if (Objects.isNull(templateOpenApiVO)) {
            return null;
        }
        OuiBasedVlanRuleVO webVO = new OuiBasedVlanRuleVO();
        webVO.setMode(templateOpenApiVO.getMode());
        webVO.setName(templateOpenApiVO.getName());
        webVO.setEnable(templateOpenApiVO.getEnable());
        webVO.setRuleCombine(OuiBasedVlanTemplateOpenApiVO.ruleCombineToWebVO(templateOpenApiVO.getRuleCombine()));
        return webVO;
    }

    private static List<VlanOuiModeVO> ruleCombineToWebVO(List<VlanOuiModeOpenApiVO> ruleCombine) {
        ArrayList<VlanOuiModeVO> vlanOuiModeVOS = new ArrayList<VlanOuiModeVO>();
        if (CollectionUtils.isEmpty(ruleCombine)) {
            return vlanOuiModeVOS;
        }
        for (VlanOuiModeOpenApiVO openApiVO : ruleCombine) {
            VlanOuiModeVO webVO = new VlanOuiModeVO();
            webVO.setVlanId(openApiVO.getVlanId());
            webVO.setPriority(openApiVO.getPriority());
            webVO.setOuiProfileId(openApiVO.getOuiProfileId());
            vlanOuiModeVOS.add(webVO);
        }
        return vlanOuiModeVOS;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public List<VlanOuiModeOpenApiVO> getRuleCombine() {
        return this.ruleCombine;
    }

    @Generated
    public OuiBasedVlanTemplateOpenApiVO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public OuiBasedVlanTemplateOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public OuiBasedVlanTemplateOpenApiVO setMode(Integer mode) {
        this.mode = mode;
        return this;
    }

    @Generated
    public OuiBasedVlanTemplateOpenApiVO setRuleCombine(List<VlanOuiModeOpenApiVO> ruleCombine) {
        this.ruleCombine = ruleCombine;
        return this;
    }
}

