/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitetemplate.vo;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DstOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.NtpServerOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sitesetting.dto.DstDTO;
import com.tplink.smb.omada.manager.configuration.api.web.sitetemplate.vo.SiteTemplateVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

@Schema(name="site template settings")
public class SiteTemplateOpenApiVO {
    @Schema(name="id", description="site template id")
    private String id;
    @Schema(name="omadacId", description="omadacId")
    private String omadacId;
    @Schema(name="name", description="site template name")
    private String name;
    @Schema(name="timeZone", description="time zone")
    private String timeZone;
    @Schema(name="dst", description="DST config")
    private DstOpenApiVO dst;
    @Schema(name="ntpEnable", description="Network Time Protocol enable")
    private Boolean ntpEnable;
    @Valid
    @Schema(name="ntpServers", description="ntp servers")
    private List<NtpServerOpenApiVO> ntpServers;
    @Schema(name="type", description="site type. 0\uff1aBasic\uff1b1\uff1aPro")
    private Integer type;
    @Schema(name="settings", description="list of supported configurations")
    private List<String> settings;

    public static SiteTemplateOpenApiVO fromWebVO(SiteTemplateVO webVO) {
        SiteTemplateOpenApiVO openApiVO = new SiteTemplateOpenApiVO();
        if (Objects.nonNull(webVO)) {
            openApiVO.setId(webVO.getId());
            openApiVO.setOmadacId(webVO.getOmadacId());
            openApiVO.setName(webVO.getName());
            openApiVO.setTimeZone(webVO.getTimeZone());
            openApiVO.setDst(SiteTemplateOpenApiVO.toDstOpenApiVO(webVO.getDst()));
            openApiVO.setNtpEnable(webVO.getNtpEnable());
            if (!CollectionUtils.isEmpty((Collection)webVO.getNtpServers())) {
                openApiVO.setNtpServers(webVO.getNtpServers().stream().map(ntpServerVO -> new NtpServerOpenApiVO(ntpServerVO.getAddress())).collect(Collectors.toList()));
            }
            openApiVO.setType(webVO.getType());
            openApiVO.setSettings(webVO.getSettings());
        }
        return openApiVO;
    }

    public static DstOpenApiVO toDstOpenApiVO(DstDTO dto) {
        if (dto == null) {
            return null;
        }
        return DstOpenApiVO.builder().enable(dto.getEnable()).mode(dto.getMode()).offset(dto.getOffset()).start(dto.getStart()).end(dto.getEnd()).build();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getTimeZone() {
        return this.timeZone;
    }

    @Generated
    public DstOpenApiVO getDst() {
        return this.dst;
    }

    @Generated
    public Boolean getNtpEnable() {
        return this.ntpEnable;
    }

    @Generated
    public List<NtpServerOpenApiVO> getNtpServers() {
        return this.ntpServers;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public List<String> getSettings() {
        return this.settings;
    }

    @Generated
    public SiteTemplateOpenApiVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public SiteTemplateOpenApiVO setOmadacId(String omadacId) {
        this.omadacId = omadacId;
        return this;
    }

    @Generated
    public SiteTemplateOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public SiteTemplateOpenApiVO setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @Generated
    public SiteTemplateOpenApiVO setDst(DstOpenApiVO dst) {
        this.dst = dst;
        return this;
    }

    @Generated
    public SiteTemplateOpenApiVO setNtpEnable(Boolean ntpEnable) {
        this.ntpEnable = ntpEnable;
        return this;
    }

    @Generated
    public SiteTemplateOpenApiVO setNtpServers(List<NtpServerOpenApiVO> ntpServers) {
        this.ntpServers = ntpServers;
        return this;
    }

    @Generated
    public SiteTemplateOpenApiVO setType(Integer type) {
        this.type = type;
        return this;
    }

    @Generated
    public SiteTemplateOpenApiVO setSettings(List<String> settings) {
        this.settings = settings;
        return this;
    }

    @Generated
    public String toString() {
        return "SiteTemplateOpenApiVO(id=" + this.getId() + ", omadacId=" + this.getOmadacId() + ", name=" + this.getName() + ", timeZone=" + this.getTimeZone() + ", dst=" + this.getDst() + ", ntpEnable=" + this.getNtpEnable() + ", ntpServers=" + this.getNtpServers() + ", type=" + this.getType() + ", settings=" + this.getSettings() + ")";
    }
}

