/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitetemplate.vo;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;

@Schema(name="CreateSiteTemplateEntity")
public class CreateSiteTemplateEntityOpenApiVO {
    @Schema(name="name", description="Name of the site template should contain 1 to 64 characters.")
    @NotNull(message="Parameter [name] should not be null")
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters, and no spaces are allowed before or after the parameters ")
    private @NotNull(message="Parameter [name] should not be null") @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters, and no spaces are allowed before or after the parameters ") String name;
    @NumberSet(value={0, 1}, message="Parameter [type] should be 0 or 1")
    @Schema(name="type", description="The type should be a value as follows: 0:basic; 1:pro. This field applies to the Omada Pro Controller only. Please do not use it for non-Pro controllers.")
    private Integer type;
    @Schema(name="settings", description="Settings of the site template support. Optional settings are as follows: AIRFPlaning, firewall, wirelessIdsIps(only for pro controller), siteCLI, abnormal(only for pro controller), log, auditLogs, sim, applicationControl, servicesRebootSchedule, servicesPortSchedule")
    private List<String> settings;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public List<String> getSettings() {
        return this.settings;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setSettings(List<String> settings) {
        this.settings = settings;
    }

    @Generated
    public String toString() {
        return "CreateSiteTemplateEntityOpenApiVO(name=" + this.getName() + ", type=" + this.getType() + ", settings=" + this.getSettings() + ")";
    }
}

