/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.virtualWan.VirtualWanIpv4StaticVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(description="VirtualWanIpv4StaticOpenApiVO")
public class VirtualWanIpv4StaticOpenApiVO {
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP address.")
    @Schema(name="ipaddr", description="IP address.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP address.") String ipaddr;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid subnet mask.")
    @Schema(name="netmask", description="Subnet mask.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid subnet mask.") String netmask;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid gateway address.")
    @Schema(name="gateway", description="Gateway IP.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid gateway address.") String gateway;
    @Range(min=576L, max=1500L, message="MTU parameter [mtu] should between 576 and 1500")
    @Schema(name="mtu", description="Parameter [mtu] should be a value between 576 and 1500.")
    private @Range(min=576L, max=1500L, message="MTU parameter [mtu] should between 576 and 1500") Integer mtu;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.")
    @Schema(name="dns1", description="Primary DNS.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.") String dns1;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.")
    @Schema(name="dns2", description="Secondary DNS.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.") String dns2;

    public static VirtualWanIpv4StaticOpenApiVO fromWebVO(VirtualWanIpv4StaticVO staticVO) {
        VirtualWanIpv4StaticOpenApiVO openApiVO = new VirtualWanIpv4StaticOpenApiVO();
        if (staticVO == null) {
            return openApiVO;
        }
        openApiVO.setIpaddr(staticVO.getIpaddr());
        openApiVO.setNetmask(staticVO.getNetmask());
        openApiVO.setGateway(staticVO.getGateway());
        openApiVO.setMtu(staticVO.getMtu());
        openApiVO.setDns1(staticVO.getDns1());
        openApiVO.setDns2(staticVO.getDns2());
        return openApiVO;
    }

    public static VirtualWanIpv4StaticVO toWebVO(VirtualWanIpv4StaticOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        VirtualWanIpv4StaticVO staticVO = new VirtualWanIpv4StaticVO();
        staticVO.setIpaddr(openApiVO.getIpaddr());
        staticVO.setNetmask(openApiVO.getNetmask());
        staticVO.setGateway(openApiVO.getGateway());
        staticVO.setMtu(openApiVO.getMtu());
        staticVO.setDns1(openApiVO.getDns1());
        staticVO.setDns2(openApiVO.getDns2());
        return staticVO;
    }

    @Generated
    public String getIpaddr() {
        return this.ipaddr;
    }

    @Generated
    public String getNetmask() {
        return this.netmask;
    }

    @Generated
    public String getGateway() {
        return this.gateway;
    }

    @Generated
    public Integer getMtu() {
        return this.mtu;
    }

    @Generated
    public String getDns1() {
        return this.dns1;
    }

    @Generated
    public String getDns2() {
        return this.dns2;
    }

    @Generated
    public void setIpaddr(String ipaddr) {
        this.ipaddr = ipaddr;
    }

    @Generated
    public void setNetmask(String netmask) {
        this.netmask = netmask;
    }

    @Generated
    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    @Generated
    public void setMtu(Integer mtu) {
        this.mtu = mtu;
    }

    @Generated
    public void setDns1(String dns1) {
        this.dns1 = dns1;
    }

    @Generated
    public void setDns2(String dns2) {
        this.dns2 = dns2;
    }

    @Generated
    public String toString() {
        return "VirtualWanIpv4StaticOpenApiVO(ipaddr=" + this.getIpaddr() + ", netmask=" + this.getNetmask() + ", gateway=" + this.getGateway() + ", mtu=" + this.getMtu() + ", dns1=" + this.getDns1() + ", dns2=" + this.getDns2() + ")";
    }

    @Generated
    public VirtualWanIpv4StaticOpenApiVO(String ipaddr, String netmask, String gateway, Integer mtu, String dns1, String dns2) {
        this.ipaddr = ipaddr;
        this.netmask = netmask;
        this.gateway = gateway;
        this.mtu = mtu;
        this.dns1 = dns1;
        this.dns2 = dns2;
    }

    @Generated
    public VirtualWanIpv4StaticOpenApiVO() {
    }
}

