/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan.VirtualWanIpv4DhcpOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan.VirtualWanIpv4IpoaOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan.VirtualWanIpv4PppoaOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan.VirtualWanIpv4PppoeOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan.VirtualWanIpv4StaticOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.virtualWan.VirtualWanIpv4SettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(description="VirtualWanIpv4SettingConfigOpenApiVO")
public class VirtualWanIpv4SettingConfigOpenApiVO {
    @NotNull
    @Schema(name="proto", description="Virtual WAN IPv4 proto type, use static, dhcp, pppoe.")
    private String proto;
    @Range(min=0L, max=4094L, message="Vlan Id parameter [vlanId] should between 0 and 4094")
    @NotNull
    @Schema(name="vlanId", description="Vlan ID. Parameter [vlanId] should between 1 and 4094.")
    private @Range(min=0L, max=4094L, message="Vlan Id parameter [vlanId] should between 0 and 4094") @NotNull Integer vlanId;
    @Range(min=0L, max=7L, message="Vlan Priority parameter [vlanPriority] should between 0 and 7")
    @Schema(name="vlanPriority", description="Vlan Priority. It takes effect when [vlanId] is not 0, and it should be within the range of 0\u20137.")
    private @Range(min=0L, max=7L, message="Vlan Priority parameter [vlanPriority] should between 0 and 7") Integer vlanPriority;
    @Schema(name="qosTagEnable", description="Whether to enable 802.1Q Tag.")
    private Boolean qosTagEnable;
    @Range(min=0L, max=7L, message="Qos Tag parameter [qosTag] should between 0 and 7.")
    @Schema(name="qosTag", description="Qos Tag. Parameter [qosTag] should between 0 and 7.")
    private @Range(min=0L, max=7L, message="Qos Tag parameter [qosTag] should between 0 and 7.") Integer qosTag;
    @Valid
    @Schema(name="ipv4Static")
    private VirtualWanIpv4StaticOpenApiVO ipv4Static;
    @Valid
    @Schema(name="ipv4Dhcp")
    private VirtualWanIpv4DhcpOpenApiVO ipv4Dhcp;
    @Valid
    @Schema(name="ipv4Pppoe")
    private VirtualWanIpv4PppoeOpenApiVO ipv4Pppoe;
    @Valid
    @Schema(name="ipv4Pppoa")
    private VirtualWanIpv4PppoaOpenApiVO ipv4Pppoa;
    @Valid
    @Schema(name="ipv4Ipoa")
    private VirtualWanIpv4IpoaOpenApiVO ipv4Ipoa;

    public static VirtualWanIpv4SettingVO toWebVO(VirtualWanIpv4SettingConfigOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        return new VirtualWanIpv4SettingVO().setProto(openApiVO.getProto()).setVlanId(openApiVO.getVlanId()).setVlanPriority(openApiVO.getVlanPriority()).setQosTagEnable(openApiVO.getQosTagEnable()).setQosTag(openApiVO.getQosTag()).setIpv4Static(VirtualWanIpv4StaticOpenApiVO.toWebVO(openApiVO.getIpv4Static())).setIpv4Dhcp(VirtualWanIpv4DhcpOpenApiVO.toWebVO(openApiVO.getIpv4Dhcp())).setIpv4Pppoe(VirtualWanIpv4PppoeOpenApiVO.toWebVO(openApiVO.getIpv4Pppoe())).setIpv4Pppoa(VirtualWanIpv4PppoaOpenApiVO.toWebVO(openApiVO.getIpv4Pppoa())).setIpv4Ipoa(VirtualWanIpv4IpoaOpenApiVO.toWebVO(openApiVO.getIpv4Ipoa()));
    }

    @Generated
    public String getProto() {
        return this.proto;
    }

    @Generated
    public Integer getVlanId() {
        return this.vlanId;
    }

    @Generated
    public Integer getVlanPriority() {
        return this.vlanPriority;
    }

    @Generated
    public Boolean getQosTagEnable() {
        return this.qosTagEnable;
    }

    @Generated
    public Integer getQosTag() {
        return this.qosTag;
    }

    @Generated
    public VirtualWanIpv4StaticOpenApiVO getIpv4Static() {
        return this.ipv4Static;
    }

    @Generated
    public VirtualWanIpv4DhcpOpenApiVO getIpv4Dhcp() {
        return this.ipv4Dhcp;
    }

    @Generated
    public VirtualWanIpv4PppoeOpenApiVO getIpv4Pppoe() {
        return this.ipv4Pppoe;
    }

    @Generated
    public VirtualWanIpv4PppoaOpenApiVO getIpv4Pppoa() {
        return this.ipv4Pppoa;
    }

    @Generated
    public VirtualWanIpv4IpoaOpenApiVO getIpv4Ipoa() {
        return this.ipv4Ipoa;
    }

    @Generated
    public void setProto(String proto) {
        this.proto = proto;
    }

    @Generated
    public void setVlanId(Integer vlanId) {
        this.vlanId = vlanId;
    }

    @Generated
    public void setVlanPriority(Integer vlanPriority) {
        this.vlanPriority = vlanPriority;
    }

    @Generated
    public void setQosTagEnable(Boolean qosTagEnable) {
        this.qosTagEnable = qosTagEnable;
    }

    @Generated
    public void setQosTag(Integer qosTag) {
        this.qosTag = qosTag;
    }

    @Generated
    public void setIpv4Static(VirtualWanIpv4StaticOpenApiVO ipv4Static) {
        this.ipv4Static = ipv4Static;
    }

    @Generated
    public void setIpv4Dhcp(VirtualWanIpv4DhcpOpenApiVO ipv4Dhcp) {
        this.ipv4Dhcp = ipv4Dhcp;
    }

    @Generated
    public void setIpv4Pppoe(VirtualWanIpv4PppoeOpenApiVO ipv4Pppoe) {
        this.ipv4Pppoe = ipv4Pppoe;
    }

    @Generated
    public void setIpv4Pppoa(VirtualWanIpv4PppoaOpenApiVO ipv4Pppoa) {
        this.ipv4Pppoa = ipv4Pppoa;
    }

    @Generated
    public void setIpv4Ipoa(VirtualWanIpv4IpoaOpenApiVO ipv4Ipoa) {
        this.ipv4Ipoa = ipv4Ipoa;
    }

    @Generated
    public String toString() {
        return "VirtualWanIpv4SettingConfigOpenApiVO(proto=" + this.getProto() + ", vlanId=" + this.getVlanId() + ", vlanPriority=" + this.getVlanPriority() + ", qosTagEnable=" + this.getQosTagEnable() + ", qosTag=" + this.getQosTag() + ", ipv4Static=" + this.getIpv4Static() + ", ipv4Dhcp=" + this.getIpv4Dhcp() + ", ipv4Pppoe=" + this.getIpv4Pppoe() + ", ipv4Pppoa=" + this.getIpv4Pppoa() + ", ipv4Ipoa=" + this.getIpv4Ipoa() + ")";
    }

    @Generated
    public VirtualWanIpv4SettingConfigOpenApiVO(String proto, Integer vlanId, Integer vlanPriority, Boolean qosTagEnable, Integer qosTag, VirtualWanIpv4StaticOpenApiVO ipv4Static, VirtualWanIpv4DhcpOpenApiVO ipv4Dhcp, VirtualWanIpv4PppoeOpenApiVO ipv4Pppoe, VirtualWanIpv4PppoaOpenApiVO ipv4Pppoa, VirtualWanIpv4IpoaOpenApiVO ipv4Ipoa) {
        this.proto = proto;
        this.vlanId = vlanId;
        this.vlanPriority = vlanPriority;
        this.qosTagEnable = qosTagEnable;
        this.qosTag = qosTag;
        this.ipv4Static = ipv4Static;
        this.ipv4Dhcp = ipv4Dhcp;
        this.ipv4Pppoe = ipv4Pppoe;
        this.ipv4Pppoa = ipv4Pppoa;
        this.ipv4Ipoa = ipv4Ipoa;
    }

    @Generated
    public VirtualWanIpv4SettingConfigOpenApiVO() {
    }
}

