/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan.VirtualWanIpv4Connection2OpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.virtualWan.VirtualWanIpv4PppoeVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(description="VirtualWanIpv4PppoeOpenApiVO")
public class VirtualWanIpv4PppoeOpenApiVO {
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid gateway address.")
    @Schema(name="ipaddr", description="IP address.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid gateway address.") String ipaddr;
    @Pattern(regexp="^[A-Za-z0-9\\`\\~\\!\\@\\#\\$\\&\\*\\(\\)\\-\\=\\_\\+\\[\\]\\{\\}\\;\\:\\'\\\"\\\\\\|\\/\\?\\.\\,\\<\\>\\%\\^\\/]{1,255}$", message="Invalid username.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="userName", description="Username. Parameter [userName] should contain 1 to 255 ASCII characters.")
    private @Pattern(regexp="^[A-Za-z0-9\\`\\~\\!\\@\\#\\$\\&\\*\\(\\)\\-\\=\\_\\+\\[\\]\\{\\}\\;\\:\\'\\\"\\\\\\|\\/\\?\\.\\,\\<\\>\\%\\^\\/]{1,255}$", message="Invalid username.") String userName;
    @Pattern(regexp="^[A-Za-z0-9\\`\\~\\!\\@\\#\\$\\&\\*\\(\\)\\-\\=\\_\\+\\[\\]\\{\\}\\;\\:\\'\\\"\\\\\\|\\/\\?\\.\\,\\<\\>\\%\\^\\/]{1,255}$", message="Invalid password.")
    @PII(strategy=PIIMaskStrategy.MASK)
    @Schema(name="password", description="Password. Parameter [password] should contain 1 to 255 ASCII characters.")
    private @Pattern(regexp="^[A-Za-z0-9\\`\\~\\!\\@\\#\\$\\&\\*\\(\\)\\-\\=\\_\\+\\[\\]\\{\\}\\;\\:\\'\\\"\\\\\\|\\/\\?\\.\\,\\<\\>\\%\\^\\/]{1,255}$", message="Invalid password.") String password;
    @Schema(name="ipFromIsp", description="Get IP address from ISP.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String ipFromIsp;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid gateway address.")
    @Schema(name="gateway", description="Gateway IP.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid gateway address.") String gateway;
    @Schema(name="linkType", description="Connection Mode. Parameter [linkType] should be as follows: auto: Connect Automatically; demand: Connect Manually; time: Time-based.")
    private String linkType;
    @Range(min=1L, max=99999L, message="Redial Interval parameter [redialInterval] should between 0 and 99999")
    @Schema(name="redialInterval", description="It is required when [linkType] is auto. Unit: Second")
    private @Range(min=1L, max=99999L, message="Redial Interval parameter [redialInterval] should between 0 and 99999") Integer redialInterval;
    @Schema(name="startTime", description="It is required when [linkType] is 2. For example, 12:30.")
    private String startTime;
    @Schema(name="endTime", description="It is required when [linkType] is 2. For example, 12:30.")
    private String endTime;
    @Pattern(regexp="^[\\041-\\0176]{1,128}$", message="Parameter [service name] should be 1 ~ 128 visible ASCII characters")
    @Schema(name="service", description="Service name. Keep parameter [service] blank unless your ISP requires you to configure it.")
    private @Pattern(regexp="^[\\041-\\0176]{1,128}$", message="Parameter [service name] should be 1 ~ 128 visible ASCII characters") String service;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid subnet mask.")
    @Schema(name="netmask", description="Subnet mask.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid subnet mask.") String netmask;
    @Range(min=576L, max=1492L, message="MTU parameter [mtu] should between 576 and 1492")
    @Schema(name="mtu", description="Parameter [mtu] should be a value between 576 and 1492")
    private @Range(min=576L, max=1492L, message="MTU parameter [mtu] should between 576 and 1492") Integer mtu;
    @Range(min=576L, max=1492L, message="MTU parameter [mtu] should between 576 and 1492")
    @Schema(name="mru", description="Parameter [mru] should be a value between 576 and 1492")
    private @Range(min=576L, max=1492L, message="MTU parameter [mtu] should between 576 and 1492") Integer mru;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.")
    @Schema(name="dns1", description="Primary DNS")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.") String dns1;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.")
    @Schema(name="dns2", description="Secondary DNS")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.") String dns2;
    @Valid
    @Schema(name="ipv4Connection2")
    private VirtualWanIpv4Connection2OpenApiVO ipv4Connection2;
    @Range(min=0L, max=2L, message="MSS Clamping parameter [type] should between 0 and 2")
    @Nullable
    private @Range(min=0L, max=2L, message="MSS Clamping parameter [type] should between 0 and 2") Integer mssClampingType;
    @Range(min=536L, max=1452L, message="MSS Clamping parameter [value] should between 536 and 1452")
    @Nullable
    private @Range(min=536L, max=1452L, message="MSS Clamping parameter [value] should between 536 and 1452") Integer mssClampingValue;

    public static VirtualWanIpv4PppoeOpenApiVO fromWebVO(VirtualWanIpv4PppoeVO pppoeVO) {
        VirtualWanIpv4PppoeOpenApiVO openApiVO = new VirtualWanIpv4PppoeOpenApiVO();
        if (pppoeVO == null) {
            return openApiVO;
        }
        openApiVO.setIpaddr(pppoeVO.getIpaddr());
        openApiVO.setUserName(pppoeVO.getUserName());
        openApiVO.setPassword(pppoeVO.getPassword());
        openApiVO.setIpFromIsp(pppoeVO.getIpFromIsp());
        openApiVO.setGateway(pppoeVO.getGateway());
        openApiVO.setLinkType(pppoeVO.getLinkType());
        openApiVO.setRedialInterval(pppoeVO.getRedialInterval());
        openApiVO.setStartTime(pppoeVO.getStartTime());
        openApiVO.setEndTime(pppoeVO.getEndTime());
        openApiVO.setService(pppoeVO.getService());
        openApiVO.setNetmask(pppoeVO.getNetmask());
        openApiVO.setMtu(pppoeVO.getMtu());
        openApiVO.setMru(pppoeVO.getMru());
        openApiVO.setDns1(pppoeVO.getDns1());
        openApiVO.setDns2(pppoeVO.getDns2());
        openApiVO.setIpv4Connection2(VirtualWanIpv4Connection2OpenApiVO.fromWebVO(pppoeVO.getIpv4Connection2()));
        openApiVO.setMssClampingType(pppoeVO.getMssClampingType());
        openApiVO.setMssClampingValue(pppoeVO.getMssClampingValue());
        return openApiVO;
    }

    public static VirtualWanIpv4PppoeVO toWebVO(VirtualWanIpv4PppoeOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        VirtualWanIpv4PppoeVO pppoeVO = new VirtualWanIpv4PppoeVO();
        pppoeVO.setIpaddr(openApiVO.getIpaddr());
        pppoeVO.setUserName(openApiVO.getUserName());
        pppoeVO.setPassword(openApiVO.getPassword());
        pppoeVO.setIpFromIsp(openApiVO.getIpFromIsp());
        pppoeVO.setGateway(openApiVO.getGateway());
        pppoeVO.setLinkType(openApiVO.getLinkType());
        pppoeVO.setRedialInterval(openApiVO.getRedialInterval());
        pppoeVO.setStartTime(openApiVO.getStartTime());
        pppoeVO.setEndTime(openApiVO.getEndTime());
        pppoeVO.setService(openApiVO.getService());
        pppoeVO.setNetmask(openApiVO.getNetmask());
        pppoeVO.setMtu(openApiVO.getMtu());
        pppoeVO.setMru(openApiVO.getMru());
        pppoeVO.setDns1(openApiVO.getDns1());
        pppoeVO.setDns2(openApiVO.getDns2());
        pppoeVO.setIpv4Connection2(VirtualWanIpv4Connection2OpenApiVO.toWebVO(openApiVO.getIpv4Connection2()));
        pppoeVO.setMssClampingType(openApiVO.getMssClampingType());
        pppoeVO.setMssClampingValue(openApiVO.getMssClampingValue());
        return pppoeVO;
    }

    @Generated
    public String getIpaddr() {
        return this.ipaddr;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getIpFromIsp() {
        return this.ipFromIsp;
    }

    @Generated
    public String getGateway() {
        return this.gateway;
    }

    @Generated
    public String getLinkType() {
        return this.linkType;
    }

    @Generated
    public Integer getRedialInterval() {
        return this.redialInterval;
    }

    @Generated
    public String getStartTime() {
        return this.startTime;
    }

    @Generated
    public String getEndTime() {
        return this.endTime;
    }

    @Generated
    public String getService() {
        return this.service;
    }

    @Generated
    public String getNetmask() {
        return this.netmask;
    }

    @Generated
    public Integer getMtu() {
        return this.mtu;
    }

    @Generated
    public Integer getMru() {
        return this.mru;
    }

    @Generated
    public String getDns1() {
        return this.dns1;
    }

    @Generated
    public String getDns2() {
        return this.dns2;
    }

    @Generated
    public VirtualWanIpv4Connection2OpenApiVO getIpv4Connection2() {
        return this.ipv4Connection2;
    }

    @Nullable
    @Generated
    public Integer getMssClampingType() {
        return this.mssClampingType;
    }

    @Nullable
    @Generated
    public Integer getMssClampingValue() {
        return this.mssClampingValue;
    }

    @Generated
    public void setIpaddr(String ipaddr) {
        this.ipaddr = ipaddr;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setIpFromIsp(String ipFromIsp) {
        this.ipFromIsp = ipFromIsp;
    }

    @Generated
    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    @Generated
    public void setLinkType(String linkType) {
        this.linkType = linkType;
    }

    @Generated
    public void setRedialInterval(Integer redialInterval) {
        this.redialInterval = redialInterval;
    }

    @Generated
    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setService(String service) {
        this.service = service;
    }

    @Generated
    public void setNetmask(String netmask) {
        this.netmask = netmask;
    }

    @Generated
    public void setMtu(Integer mtu) {
        this.mtu = mtu;
    }

    @Generated
    public void setMru(Integer mru) {
        this.mru = mru;
    }

    @Generated
    public void setDns1(String dns1) {
        this.dns1 = dns1;
    }

    @Generated
    public void setDns2(String dns2) {
        this.dns2 = dns2;
    }

    @Generated
    public void setIpv4Connection2(VirtualWanIpv4Connection2OpenApiVO ipv4Connection2) {
        this.ipv4Connection2 = ipv4Connection2;
    }

    @Generated
    public void setMssClampingType(@Nullable Integer mssClampingType) {
        this.mssClampingType = mssClampingType;
    }

    @Generated
    public void setMssClampingValue(@Nullable Integer mssClampingValue) {
        this.mssClampingValue = mssClampingValue;
    }

    @Generated
    public String toString() {
        return "VirtualWanIpv4PppoeOpenApiVO(ipaddr=" + this.getIpaddr() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", ipFromIsp=" + this.getIpFromIsp() + ", gateway=" + this.getGateway() + ", linkType=" + this.getLinkType() + ", redialInterval=" + this.getRedialInterval() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", service=" + this.getService() + ", netmask=" + this.getNetmask() + ", mtu=" + this.getMtu() + ", mru=" + this.getMru() + ", dns1=" + this.getDns1() + ", dns2=" + this.getDns2() + ", ipv4Connection2=" + this.getIpv4Connection2() + ", mssClampingType=" + this.getMssClampingType() + ", mssClampingValue=" + this.getMssClampingValue() + ")";
    }

    @Generated
    public VirtualWanIpv4PppoeOpenApiVO(String ipaddr, String userName, String password, String ipFromIsp, String gateway, String linkType, Integer redialInterval, String startTime, String endTime, String service, String netmask, Integer mtu, Integer mru, String dns1, String dns2, VirtualWanIpv4Connection2OpenApiVO ipv4Connection2, @Nullable Integer mssClampingType, @Nullable Integer mssClampingValue) {
        this.ipaddr = ipaddr;
        this.userName = userName;
        this.password = password;
        this.ipFromIsp = ipFromIsp;
        this.gateway = gateway;
        this.linkType = linkType;
        this.redialInterval = redialInterval;
        this.startTime = startTime;
        this.endTime = endTime;
        this.service = service;
        this.netmask = netmask;
        this.mtu = mtu;
        this.mru = mru;
        this.dns1 = dns1;
        this.dns2 = dns2;
        this.ipv4Connection2 = ipv4Connection2;
        this.mssClampingType = mssClampingType;
        this.mssClampingValue = mssClampingValue;
    }

    @Generated
    public VirtualWanIpv4PppoeOpenApiVO() {
    }
}

