/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.virtualWan.VirtualWanIpv4PppoaVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(description="VirtualWanIpv4PppoaOpenApiVO")
public class VirtualWanIpv4PppoaOpenApiVO {
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid gateway address.")
    @Schema(name="ipaddr", description="IP address.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid gateway address.") String ipaddr;
    @Pattern(regexp="^[A-Za-z0-9\\`\\~\\!\\@\\#\\$\\&\\*\\(\\)\\-\\=\\_\\+\\[\\]\\{\\}\\;\\:\\'\\\"\\\\\\|\\/\\?\\.\\,\\<\\>\\%\\^\\/]{1,255}$", message="Invalid username.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="userName", description="Username. Parameter [userName] should contain 1 to 255 ASCII characters.")
    private @Pattern(regexp="^[A-Za-z0-9\\`\\~\\!\\@\\#\\$\\&\\*\\(\\)\\-\\=\\_\\+\\[\\]\\{\\}\\;\\:\\'\\\"\\\\\\|\\/\\?\\.\\,\\<\\>\\%\\^\\/]{1,255}$", message="Invalid username.") String userName;
    @Pattern(regexp="^[A-Za-z0-9\\`\\~\\!\\@\\#\\$\\&\\*\\(\\)\\-\\=\\_\\+\\[\\]\\{\\}\\;\\:\\'\\\"\\\\\\|\\/\\?\\.\\,\\<\\>\\%\\^\\/]{1,255}$", message="Invalid password.")
    @PII(strategy=PIIMaskStrategy.MASK)
    @Schema(name="password", description="Password. Parameter [password] should contain 1 to 255 ASCII characters.")
    private @Pattern(regexp="^[A-Za-z0-9\\`\\~\\!\\@\\#\\$\\&\\*\\(\\)\\-\\=\\_\\+\\[\\]\\{\\}\\;\\:\\'\\\"\\\\\\|\\/\\?\\.\\,\\<\\>\\%\\^\\/]{1,255}$", message="Invalid password.") String password;
    @Schema(name="ipFromIsp", description="Get IP address from ISP.")
    private String ipFromIsp;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid gateway address.")
    @Schema(name="gateway", description="Gateway IP.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid gateway address.") String gateway;
    @Schema(name="linkType", description="Connection Mode. Parameter [linkType] should be as follows: auto: Connect Automatically; demand: Connect Manually; time: Time-based.")
    private String linkType;
    @Range(min=1L, max=99999L, message="Redial Interval parameter [redialInterval] should between 0 and 99999.")
    @Schema(name="redialInterval", description="It is required when [linkType] is 0. Unit: Second.")
    private @Range(min=1L, max=99999L, message="Redial Interval parameter [redialInterval] should between 0 and 99999.") Integer redialInterval;
    @Schema(name="startTime", description="It is required when [linkType] is 2. For example, 12:30.")
    private String startTime;
    @Schema(name="endTime", description="It is required when [linkType] is 2. For example, 12:30.")
    private String endTime;
    @Pattern(regexp="^[\\041-\\0176]{1,128}$", message="Parameter [service] should be 1 ~ 128 visible ASCII characters.")
    @Schema(name="service", description="Parameter [service] should be 1 ~ 128 visible ASCII characters.")
    private @Pattern(regexp="^[\\041-\\0176]{1,128}$", message="Parameter [service] should be 1 ~ 128 visible ASCII characters.") String service;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid subnet mask.")
    @Schema(name="netmask", description="Subnet mask.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid subnet mask.") String netmask;
    @Range(min=576L, max=1492L, message="MTU parameter [mtu] should between 576 and 1492.")
    @Schema(name="mtu", description="Parameter [mtu] should be a value between 576 and 1492.")
    private @Range(min=576L, max=1492L, message="MTU parameter [mtu] should between 576 and 1492.") Integer mtu;
    @Range(min=576L, max=1492L, message="MTU parameter [mtu] should between 576 and 1492.")
    @Schema(name="mru", description="Parameter [mru] should be a value between 576 and 1492.")
    private @Range(min=576L, max=1492L, message="MTU parameter [mtu] should between 576 and 1492.") Integer mru;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.")
    @Schema(name="dns1", description="Primary DNS server.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.") String dns1;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.")
    @Schema(name="dns2", description="Secondary DNS server.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.") String dns2;
    @Schema(name="connect")
    private String connect;
    @Range(min=0L, max=2L, message="MSS Clamping parameter [mssClampingType] should between 0 and 2.")
    @Nullable
    @Schema(name="mssClampingType", description="It should be a value as follows: 0: Disable, 1: Auto, 2: Custom.")
    private @Range(min=0L, max=2L, message="MSS Clamping parameter [mssClampingType] should between 0 and 2.") Integer mssClampingType;
    @Range(min=536L, max=1452L, message="MSS Clamping parameter [value] should between 536 and 1452.")
    @Nullable
    @Schema(name="mssClampingValue", description="It is required when [mssClampingType] is 2, which ranges 532 ~ 1452.")
    private @Range(min=536L, max=1452L, message="MSS Clamping parameter [value] should between 536 and 1452.") Integer mssClampingValue;

    public static VirtualWanIpv4PppoaVO toWebVO(VirtualWanIpv4PppoaOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        VirtualWanIpv4PppoaVO vo = new VirtualWanIpv4PppoaVO();
        vo.setIpaddr(openApiVO.getIpaddr());
        vo.setUserName(openApiVO.getUserName());
        vo.setPassword(openApiVO.getPassword());
        vo.setIpFromIsp(openApiVO.getIpFromIsp());
        vo.setGateway(openApiVO.getGateway());
        vo.setLinkType(openApiVO.getLinkType());
        vo.setRedialInterval(openApiVO.getRedialInterval());
        vo.setStartTime(openApiVO.getStartTime());
        vo.setEndTime(openApiVO.getEndTime());
        vo.setService(openApiVO.getService());
        vo.setNetmask(openApiVO.getNetmask());
        vo.setMtu(openApiVO.getMtu());
        vo.setMru(openApiVO.getMru());
        vo.setDns1(openApiVO.getDns1());
        vo.setDns2(openApiVO.getDns2());
        vo.setConnect(openApiVO.getConnect());
        vo.setMssClampingType(openApiVO.getMssClampingType());
        vo.setMssClampingValue(openApiVO.getMssClampingValue());
        return vo;
    }

    @Generated
    public String getIpaddr() {
        return this.ipaddr;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getIpFromIsp() {
        return this.ipFromIsp;
    }

    @Generated
    public String getGateway() {
        return this.gateway;
    }

    @Generated
    public String getLinkType() {
        return this.linkType;
    }

    @Generated
    public Integer getRedialInterval() {
        return this.redialInterval;
    }

    @Generated
    public String getStartTime() {
        return this.startTime;
    }

    @Generated
    public String getEndTime() {
        return this.endTime;
    }

    @Generated
    public String getService() {
        return this.service;
    }

    @Generated
    public String getNetmask() {
        return this.netmask;
    }

    @Generated
    public Integer getMtu() {
        return this.mtu;
    }

    @Generated
    public Integer getMru() {
        return this.mru;
    }

    @Generated
    public String getDns1() {
        return this.dns1;
    }

    @Generated
    public String getDns2() {
        return this.dns2;
    }

    @Generated
    public String getConnect() {
        return this.connect;
    }

    @Nullable
    @Generated
    public Integer getMssClampingType() {
        return this.mssClampingType;
    }

    @Nullable
    @Generated
    public Integer getMssClampingValue() {
        return this.mssClampingValue;
    }

    @Generated
    public void setIpaddr(String ipaddr) {
        this.ipaddr = ipaddr;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setIpFromIsp(String ipFromIsp) {
        this.ipFromIsp = ipFromIsp;
    }

    @Generated
    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    @Generated
    public void setLinkType(String linkType) {
        this.linkType = linkType;
    }

    @Generated
    public void setRedialInterval(Integer redialInterval) {
        this.redialInterval = redialInterval;
    }

    @Generated
    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setService(String service) {
        this.service = service;
    }

    @Generated
    public void setNetmask(String netmask) {
        this.netmask = netmask;
    }

    @Generated
    public void setMtu(Integer mtu) {
        this.mtu = mtu;
    }

    @Generated
    public void setMru(Integer mru) {
        this.mru = mru;
    }

    @Generated
    public void setDns1(String dns1) {
        this.dns1 = dns1;
    }

    @Generated
    public void setDns2(String dns2) {
        this.dns2 = dns2;
    }

    @Generated
    public void setConnect(String connect) {
        this.connect = connect;
    }

    @Generated
    public void setMssClampingType(@Nullable Integer mssClampingType) {
        this.mssClampingType = mssClampingType;
    }

    @Generated
    public void setMssClampingValue(@Nullable Integer mssClampingValue) {
        this.mssClampingValue = mssClampingValue;
    }

    @Generated
    public String toString() {
        return "VirtualWanIpv4PppoaOpenApiVO(ipaddr=" + this.getIpaddr() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", ipFromIsp=" + this.getIpFromIsp() + ", gateway=" + this.getGateway() + ", linkType=" + this.getLinkType() + ", redialInterval=" + this.getRedialInterval() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", service=" + this.getService() + ", netmask=" + this.getNetmask() + ", mtu=" + this.getMtu() + ", mru=" + this.getMru() + ", dns1=" + this.getDns1() + ", dns2=" + this.getDns2() + ", connect=" + this.getConnect() + ", mssClampingType=" + this.getMssClampingType() + ", mssClampingValue=" + this.getMssClampingValue() + ")";
    }

    @Generated
    public VirtualWanIpv4PppoaOpenApiVO(String ipaddr, String userName, String password, String ipFromIsp, String gateway, String linkType, Integer redialInterval, String startTime, String endTime, String service, String netmask, Integer mtu, Integer mru, String dns1, String dns2, String connect, @Nullable Integer mssClampingType, @Nullable Integer mssClampingValue) {
        this.ipaddr = ipaddr;
        this.userName = userName;
        this.password = password;
        this.ipFromIsp = ipFromIsp;
        this.gateway = gateway;
        this.linkType = linkType;
        this.redialInterval = redialInterval;
        this.startTime = startTime;
        this.endTime = endTime;
        this.service = service;
        this.netmask = netmask;
        this.mtu = mtu;
        this.mru = mru;
        this.dns1 = dns1;
        this.dns2 = dns2;
        this.connect = connect;
        this.mssClampingType = mssClampingType;
        this.mssClampingValue = mssClampingValue;
    }

    @Generated
    public VirtualWanIpv4PppoaOpenApiVO() {
    }
}

