/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DhcpOptionOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.virtualWan.VirtualWanDhcpOptionVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.virtualWan.VirtualWanIpv4DhcpVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.validator.constraints.Range;

@Schema(description="VirtualWanIpv4DhcpOpenApiVO")
public class VirtualWanIpv4DhcpOpenApiVO {
    @Schema(name="unicast", description="Subnet mask of virtual WAN.")
    private String unicast;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.")
    @Schema(name="dns1", description="Primary DNS server.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.") String dns1;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.")
    @Schema(name="dns2", description="Secondary DNS server.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.") String dns2;
    @Pattern(regexp="^[a-zA-Z0-9_]{0,63}$", message="Enter the host name with up to 63 characters using numbers, letters, and underscores only.")
    @Schema(name="hostname", description="Host name. Parameter [hostname] should be up to 63 characters long and can only use numbers, letters, and underscores.")
    private @Pattern(regexp="^[a-zA-Z0-9_]{0,63}$", message="Enter the host name with up to 63 characters using numbers, letters, and underscores only.") String hostname;
    @Range(min=576L, max=1500L, message="MTU parameter [mtu] should between 576 and 1500")
    @Schema(name="mtu", description="Parameter [mtu] should be a value between 576 and 1500.")
    private @Range(min=576L, max=1500L, message="MTU parameter [mtu] should between 576 and 1500") Integer mtu;
    @Schema(name="dhcpOptions", description="Virtual WAN custom DHCP options.")
    private List<DhcpOptionOpenApiVO> dhcpOptions;

    public static VirtualWanIpv4DhcpOpenApiVO fromWebVO(VirtualWanIpv4DhcpVO dhcpVO) {
        VirtualWanIpv4DhcpOpenApiVO openApiVO = new VirtualWanIpv4DhcpOpenApiVO();
        if (dhcpVO == null) {
            return openApiVO;
        }
        openApiVO.setUnicast(dhcpVO.getUnicast());
        openApiVO.setDns1(dhcpVO.getDns1());
        openApiVO.setDns2(dhcpVO.getDns2());
        openApiVO.setHostname(dhcpVO.getHostname());
        openApiVO.setMtu(dhcpVO.getMtu());
        if (CollectionUtils.isEmpty((Collection)dhcpVO.getDhcpOptions())) {
            return openApiVO;
        }
        openApiVO.setDhcpOptions(dhcpVO.getDhcpOptions().stream().map(VirtualWanIpv4DhcpOpenApiVO::fromWebVO).collect(Collectors.toList()));
        return openApiVO;
    }

    public static VirtualWanIpv4DhcpVO toWebVO(VirtualWanIpv4DhcpOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        VirtualWanIpv4DhcpVO dhcpVO = new VirtualWanIpv4DhcpVO();
        dhcpVO.setUnicast(openApiVO.getUnicast());
        dhcpVO.setDns1(openApiVO.getDns1());
        dhcpVO.setDns2(openApiVO.getDns2());
        dhcpVO.setHostname(openApiVO.getHostname());
        dhcpVO.setMtu(openApiVO.getMtu());
        if (CollectionUtils.isEmpty(openApiVO.getDhcpOptions())) {
            return dhcpVO;
        }
        dhcpVO.setDhcpOptions(openApiVO.getDhcpOptions().stream().map(VirtualWanIpv4DhcpOpenApiVO::toWebVO).collect(Collectors.toList()));
        return dhcpVO;
    }

    public static DhcpOptionOpenApiVO fromWebVO(VirtualWanDhcpOptionVO optionVO) {
        DhcpOptionOpenApiVO openApiVO = new DhcpOptionOpenApiVO();
        if (optionVO == null) {
            return openApiVO;
        }
        openApiVO.setCode(openApiVO.getCode());
        openApiVO.setType(openApiVO.getType());
        openApiVO.setValue(openApiVO.getValue());
        return openApiVO;
    }

    public static VirtualWanDhcpOptionVO toWebVO(DhcpOptionOpenApiVO openApiVO) {
        VirtualWanDhcpOptionVO optionVO = new VirtualWanDhcpOptionVO();
        if (openApiVO == null) {
            return optionVO;
        }
        optionVO.setCode(optionVO.getCode());
        optionVO.setType(optionVO.getType());
        optionVO.setValue(optionVO.getValue());
        return optionVO;
    }

    @Generated
    public String getUnicast() {
        return this.unicast;
    }

    @Generated
    public String getDns1() {
        return this.dns1;
    }

    @Generated
    public String getDns2() {
        return this.dns2;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public Integer getMtu() {
        return this.mtu;
    }

    @Generated
    public List<DhcpOptionOpenApiVO> getDhcpOptions() {
        return this.dhcpOptions;
    }

    @Generated
    public void setUnicast(String unicast) {
        this.unicast = unicast;
    }

    @Generated
    public void setDns1(String dns1) {
        this.dns1 = dns1;
    }

    @Generated
    public void setDns2(String dns2) {
        this.dns2 = dns2;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public void setMtu(Integer mtu) {
        this.mtu = mtu;
    }

    @Generated
    public void setDhcpOptions(List<DhcpOptionOpenApiVO> dhcpOptions) {
        this.dhcpOptions = dhcpOptions;
    }

    @Generated
    public String toString() {
        return "VirtualWanIpv4DhcpOpenApiVO(unicast=" + this.getUnicast() + ", dns1=" + this.getDns1() + ", dns2=" + this.getDns2() + ", hostname=" + this.getHostname() + ", mtu=" + this.getMtu() + ", dhcpOptions=" + this.getDhcpOptions() + ")";
    }

    @Generated
    public VirtualWanIpv4DhcpOpenApiVO(String unicast, String dns1, String dns2, String hostname, Integer mtu, List<DhcpOptionOpenApiVO> dhcpOptions) {
        this.unicast = unicast;
        this.dns1 = dns1;
        this.dns2 = dns2;
        this.hostname = hostname;
        this.mtu = mtu;
        this.dhcpOptions = dhcpOptions;
    }

    @Generated
    public VirtualWanIpv4DhcpOpenApiVO() {
    }
}

