/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.virtualWan.VirtualWanIpv4Connection2VO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;

@Schema(description="VirtualWanIpv4Connection2OpenApiVO")
public class VirtualWanIpv4Connection2OpenApiVO {
    @Schema(name="mainProto", description="The main virtual WAN IPv4 proto type, use static, dhcp, pppoe.")
    private String mainProto;
    @Schema(name="proto", description="The second virtual WAN IPv4 proto type, use static, dhcp, pppoe.")
    private String proto;
    @Pattern.List(value={@Pattern(regexp="(((?!^0\\.0\\.0\\.0$)(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6}))|(^[A-Za-z0-9\\_\\-]+\\.{1,})", message="Invalid VPN Server/Domain Name."), @Pattern(regexp="^[\\041-\\0176]{1,253}$", message="Invalid VPN Server/Domain Name.")})
    @Schema(name="server", description="VPN server IP/domain.")
    private @Pattern.List(value={@Pattern(regexp="(((?!^0\\.0\\.0\\.0$)(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6}))|(^[A-Za-z0-9\\_\\-]+\\.{1,})", message="Invalid VPN Server/Domain Name."), @Pattern(regexp="^[\\041-\\0176]{1,253}$", message="Invalid VPN Server/Domain Name.")}) String server;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP address.")
    @Schema(name="ipaddr", description="IP address.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP address.") String ipaddr;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid subnet mask.")
    @Schema(name="netmask", description="Subnet mask.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid subnet mask.") String netmask;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid gateway address.")
    @Schema(name="gateway", description="Gateway IP.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid gateway address.") String gateway;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS server.")
    @Schema(name="dns1", description="Primary DNS server.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS server.") String dns1;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS server.")
    @Schema(name="dns2", description="Secondary DNS server.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS server.") String dns2;

    public static VirtualWanIpv4Connection2OpenApiVO fromWebVO(VirtualWanIpv4Connection2VO connection2VO) {
        VirtualWanIpv4Connection2OpenApiVO openApiVO = new VirtualWanIpv4Connection2OpenApiVO();
        if (connection2VO == null) {
            return openApiVO;
        }
        openApiVO.setMainProto(connection2VO.getMainProto());
        openApiVO.setProto(connection2VO.getProto());
        openApiVO.setServer(connection2VO.getServer());
        openApiVO.setIpaddr(connection2VO.getIpaddr());
        openApiVO.setNetmask(connection2VO.getNetmask());
        openApiVO.setGateway(connection2VO.getGateway());
        openApiVO.setDns1(connection2VO.getDns1());
        openApiVO.setDns2(connection2VO.getDns2());
        return openApiVO;
    }

    public static VirtualWanIpv4Connection2VO toWebVO(VirtualWanIpv4Connection2OpenApiVO openApiVO) {
        VirtualWanIpv4Connection2VO connection2VO = new VirtualWanIpv4Connection2VO();
        if (openApiVO == null) {
            return connection2VO;
        }
        connection2VO.setMainProto(openApiVO.getMainProto());
        connection2VO.setProto(openApiVO.getProto());
        connection2VO.setServer(openApiVO.getServer());
        connection2VO.setIpaddr(openApiVO.getIpaddr());
        connection2VO.setNetmask(openApiVO.getNetmask());
        connection2VO.setGateway(openApiVO.getGateway());
        connection2VO.setDns1(openApiVO.getDns1());
        connection2VO.setDns2(openApiVO.getDns2());
        return connection2VO;
    }

    @Generated
    public String getMainProto() {
        return this.mainProto;
    }

    @Generated
    public String getProto() {
        return this.proto;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public String getIpaddr() {
        return this.ipaddr;
    }

    @Generated
    public String getNetmask() {
        return this.netmask;
    }

    @Generated
    public String getGateway() {
        return this.gateway;
    }

    @Generated
    public String getDns1() {
        return this.dns1;
    }

    @Generated
    public String getDns2() {
        return this.dns2;
    }

    @Generated
    public void setMainProto(String mainProto) {
        this.mainProto = mainProto;
    }

    @Generated
    public void setProto(String proto) {
        this.proto = proto;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public void setIpaddr(String ipaddr) {
        this.ipaddr = ipaddr;
    }

    @Generated
    public void setNetmask(String netmask) {
        this.netmask = netmask;
    }

    @Generated
    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    @Generated
    public void setDns1(String dns1) {
        this.dns1 = dns1;
    }

    @Generated
    public void setDns2(String dns2) {
        this.dns2 = dns2;
    }

    @Generated
    public String toString() {
        return "VirtualWanIpv4Connection2OpenApiVO(mainProto=" + this.getMainProto() + ", proto=" + this.getProto() + ", server=" + this.getServer() + ", ipaddr=" + this.getIpaddr() + ", netmask=" + this.getNetmask() + ", gateway=" + this.getGateway() + ", dns1=" + this.getDns1() + ", dns2=" + this.getDns2() + ")";
    }

    @Generated
    public VirtualWanIpv4Connection2OpenApiVO(String mainProto, String proto, String server, String ipaddr, String netmask, String gateway, String dns1, String dns2) {
        this.mainProto = mainProto;
        this.proto = proto;
        this.server = server;
        this.ipaddr = ipaddr;
        this.netmask = netmask;
        this.gateway = gateway;
        this.dns1 = dns1;
        this.dns2 = dns2;
    }

    @Generated
    public VirtualWanIpv4Connection2OpenApiVO() {
    }
}

