/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.virtualWan.VirtualWanDslVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(description="VirtualWanDslOpenApiVO")
public class VirtualWanDslOpenApiVO {
    @NotNull
    @JsonProperty(value="isp")
    @Schema(name="isp", description="Your ISP (Internet Service Provider) from the drop-down list,Select Other to customize the settings.")
    private Integer isp;
    @NotNull
    @Range(min=0L, max=1L)
    @JsonProperty(value="modulationType")
    @Schema(name="modulationType", description="The modulation type used for your DSL connection. 0: VDSL, 1: ADSL.")
    private @NotNull @Range(min=0L, max=1L) Integer modulation;
    @Range(min=0L, max=255L, message="Parameter [vpi] should between 0 and 255.")
    @Schema(name="vpi", description="The VPI(0~255) assigned by your ISP to specify the virtual path between endpoints in an ATM network.")
    private @Range(min=0L, max=255L, message="Parameter [vpi] should between 0 and 255.") Integer vpi;
    @Range(min=0L, max=65535L, message="Parameter [vci] should between 0 and 65535.")
    @Schema(name="vci", description="The VCI(1~65535) assigned by your ISP to specify the virtual channel endpoints in an ATM network.")
    private @Range(min=0L, max=65535L, message="Parameter [vci] should between 0 and 65535.") Integer vci;
    @Schema(name="encapMode", description="Encap mode assigned by your ISP. 0: LLC, 1: VC-MUX, 2: VC/MUX, 3: 1483 Bridged IP LLC, 4: 1483 Routed IP LLC.")
    private Integer encapMode;
    @NotNull
    @Schema(name="location", description="Your country/region.")
    private String location;
    @Schema(name="merEnable", description="If your ISP requires MER for network connection(e.g., Sky VDSL).MER switch configuration, only configurable when in VDSL mode and DHCP dial-up mode.")
    private Boolean merEnable;
    @Pattern(regexp="^[^\\s]{1,63}$")
    @Schema(name="merUsername", description="MER username configuration, only configurable when in VDSL mode and DHCP dial-up mode.")
    private @Pattern(regexp="^[^\\s]{1,63}$") String merUsername;
    @Pattern(regexp="^[^\\s]{1,63}$")
    @Schema(name="merPassword", description="MER password configuration, only configurable when in VDSL mode and DHCP dial-up mode.")
    private @Pattern(regexp="^[^\\s]{1,63}$") String merPassword;

    public static VirtualWanDslOpenApiVO fromWebVO(VirtualWanDslVO dslVO) {
        VirtualWanDslOpenApiVO openApiVO = new VirtualWanDslOpenApiVO();
        if (dslVO == null) {
            return openApiVO;
        }
        openApiVO.setIsp(dslVO.getIsp());
        openApiVO.setModulation(dslVO.getModulation());
        openApiVO.setVpi(dslVO.getVpi());
        openApiVO.setVci(dslVO.getVci());
        openApiVO.setEncapMode(dslVO.getEncapMode());
        openApiVO.setLocation(dslVO.getLocation());
        openApiVO.setMerEnable(dslVO.getMerEnable());
        openApiVO.setMerUsername(dslVO.getMerUsername());
        openApiVO.setMerPassword(dslVO.getMerPassword());
        return openApiVO;
    }

    public static VirtualWanDslVO toWebVO(VirtualWanDslOpenApiVO openApiVO) {
        VirtualWanDslVO dslVO = new VirtualWanDslVO();
        if (openApiVO == null) {
            return dslVO;
        }
        dslVO.setIsp(openApiVO.getIsp());
        dslVO.setModulation(openApiVO.getModulation());
        dslVO.setVpi(openApiVO.getVpi());
        dslVO.setVci(openApiVO.getVci());
        dslVO.setEncapMode(openApiVO.getEncapMode());
        dslVO.setLocation(openApiVO.getLocation());
        dslVO.setMerEnable(openApiVO.getMerEnable());
        dslVO.setMerUsername(openApiVO.getMerUsername());
        dslVO.setMerPassword(openApiVO.getMerPassword());
        return dslVO;
    }

    @Generated
    public Integer getIsp() {
        return this.isp;
    }

    @Generated
    public Integer getModulation() {
        return this.modulation;
    }

    @Generated
    public Integer getVpi() {
        return this.vpi;
    }

    @Generated
    public Integer getVci() {
        return this.vci;
    }

    @Generated
    public Integer getEncapMode() {
        return this.encapMode;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public Boolean getMerEnable() {
        return this.merEnable;
    }

    @Generated
    public String getMerUsername() {
        return this.merUsername;
    }

    @Generated
    public String getMerPassword() {
        return this.merPassword;
    }

    @JsonProperty(value="isp")
    @Generated
    public void setIsp(Integer isp) {
        this.isp = isp;
    }

    @JsonProperty(value="modulationType")
    @Generated
    public void setModulation(Integer modulation) {
        this.modulation = modulation;
    }

    @Generated
    public void setVpi(Integer vpi) {
        this.vpi = vpi;
    }

    @Generated
    public void setVci(Integer vci) {
        this.vci = vci;
    }

    @Generated
    public void setEncapMode(Integer encapMode) {
        this.encapMode = encapMode;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @Generated
    public void setMerEnable(Boolean merEnable) {
        this.merEnable = merEnable;
    }

    @Generated
    public void setMerUsername(String merUsername) {
        this.merUsername = merUsername;
    }

    @Generated
    public void setMerPassword(String merPassword) {
        this.merPassword = merPassword;
    }

    @Generated
    public String toString() {
        return "VirtualWanDslOpenApiVO(isp=" + this.getIsp() + ", modulation=" + this.getModulation() + ", vpi=" + this.getVpi() + ", vci=" + this.getVci() + ", encapMode=" + this.getEncapMode() + ", location=" + this.getLocation() + ", merEnable=" + this.getMerEnable() + ", merUsername=" + this.getMerUsername() + ", merPassword=" + this.getMerPassword() + ")";
    }

    @Generated
    public VirtualWanDslOpenApiVO(Integer isp, Integer modulation, Integer vpi, Integer vci, Integer encapMode, String location, Boolean merEnable, String merUsername, String merPassword) {
        this.isp = isp;
        this.modulation = modulation;
        this.vpi = vpi;
        this.vci = vci;
        this.encapMode = encapMode;
        this.location = location;
        this.merEnable = merEnable;
        this.merUsername = merUsername;
        this.merPassword = merPassword;
    }

    @Generated
    public VirtualWanDslOpenApiVO() {
    }
}

