/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan.VirtualWanDslOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan.VirtualWanIpv4SettingConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan.VirtualWanMacSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.virtualWan.VirtualWanVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Schema(description="VirtualWanConfig")
public class VirtualWanConfigOpenApiVO {
    @NotNull
    @Pattern(regexp="^[A-Za-z0-9\\_]+$", message="Parameter [name] error. Only letters, digits and underscores are allowed.")
    @Length(min=1, max=128, message="Parameter [name] should be between 1 and 128 characters.")
    @Schema(name="name", description="Virtual WAN name should contain 1 to 128 characters. Only letters, digits and underscores are allowed.")
    private @NotNull @Pattern(regexp="^[A-Za-z0-9\\_]+$", message="Parameter [name] error. Only letters, digits and underscores are allowed.") @Length(min=1, max=128, message="Parameter [name] should be between 1 and 128 characters.") String name;
    @NotNull
    @Schema(name="physicalWanId", description="Physical WAN ID. Physical WAN ID can be obtained from 'Get internet basic info' interface. Only DSL WAN supports configuring virtual WAN. ")
    private String physicalWanId;
    @Valid
    @NotNull
    @JsonProperty(value="wanPortIpv4Setting")
    @Schema(name="virtualWanIpv4Setting", description="Virtual WAN Ipv4 setting.")
    private VirtualWanIpv4SettingConfigOpenApiVO virtualWanIpv4Setting;
    @Valid
    @JsonProperty(value="dslSetting")
    @Schema(name="virtualWanDsl", description="Virtual WAN DSL setting.")
    private VirtualWanDslOpenApiVO virtualWanDsl;
    @Valid
    @JsonProperty(value="wanPortMacSetting")
    private VirtualWanMacSettingOpenApiVO virtualWanMacSettingVO;

    public static VirtualWanVO toWebVO(VirtualWanConfigOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        return new VirtualWanVO().setName(openApiVO.getName()).setPhysicalWanId(openApiVO.getPhysicalWanId()).setVirtualWanIpv4Setting(VirtualWanIpv4SettingConfigOpenApiVO.toWebVO(openApiVO.getVirtualWanIpv4Setting())).setVirtualWanDsl(VirtualWanDslOpenApiVO.toWebVO(openApiVO.getVirtualWanDsl())).setVirtualWanMacSettingVO(VirtualWanMacSettingOpenApiVO.toWebVO(openApiVO.getVirtualWanMacSettingVO()));
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPhysicalWanId() {
        return this.physicalWanId;
    }

    @Generated
    public VirtualWanIpv4SettingConfigOpenApiVO getVirtualWanIpv4Setting() {
        return this.virtualWanIpv4Setting;
    }

    @Generated
    public VirtualWanDslOpenApiVO getVirtualWanDsl() {
        return this.virtualWanDsl;
    }

    @Generated
    public VirtualWanMacSettingOpenApiVO getVirtualWanMacSettingVO() {
        return this.virtualWanMacSettingVO;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPhysicalWanId(String physicalWanId) {
        this.physicalWanId = physicalWanId;
    }

    @JsonProperty(value="wanPortIpv4Setting")
    @Generated
    public void setVirtualWanIpv4Setting(VirtualWanIpv4SettingConfigOpenApiVO virtualWanIpv4Setting) {
        this.virtualWanIpv4Setting = virtualWanIpv4Setting;
    }

    @JsonProperty(value="dslSetting")
    @Generated
    public void setVirtualWanDsl(VirtualWanDslOpenApiVO virtualWanDsl) {
        this.virtualWanDsl = virtualWanDsl;
    }

    @JsonProperty(value="wanPortMacSetting")
    @Generated
    public void setVirtualWanMacSettingVO(VirtualWanMacSettingOpenApiVO virtualWanMacSettingVO) {
        this.virtualWanMacSettingVO = virtualWanMacSettingVO;
    }

    @Generated
    public String toString() {
        return "VirtualWanConfigOpenApiVO(name=" + this.getName() + ", physicalWanId=" + this.getPhysicalWanId() + ", virtualWanIpv4Setting=" + this.getVirtualWanIpv4Setting() + ", virtualWanDsl=" + this.getVirtualWanDsl() + ", virtualWanMacSettingVO=" + this.getVirtualWanMacSettingVO() + ")";
    }

    @Generated
    public VirtualWanConfigOpenApiVO(String name, String physicalWanId, VirtualWanIpv4SettingConfigOpenApiVO virtualWanIpv4Setting, VirtualWanDslOpenApiVO virtualWanDsl, VirtualWanMacSettingOpenApiVO virtualWanMacSettingVO) {
        this.name = name;
        this.physicalWanId = physicalWanId;
        this.virtualWanIpv4Setting = virtualWanIpv4Setting;
        this.virtualWanDsl = virtualWanDsl;
        this.virtualWanMacSettingVO = virtualWanMacSettingVO;
    }

    @Generated
    public VirtualWanConfigOpenApiVO() {
    }
}

