/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.UsbLteSettingConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.WanPortSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.b;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.c;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.InternetVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.WanPortSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class WanSettingConfigOpenApiVO {
    @Schema(name="wanPortsConfig", description="WAN ports config")
    @Valid
    private List<WanPortSettingOpenApiVO> wanPortsConfig;
    @Schema(name="UsbPortsConfig", description="USB LTE ports config")
    private List<UsbLteSettingConfigOpenApiVO> usbPortsConfig;

    public static InternetVO toWebVO(WanSettingConfigOpenApiVO vo, InternetVO internetVO) {
        if (vo == null) {
            return internetVO;
        }
        List wanPortSettings = internetVO.getWanPortSettings();
        Map portUuidPortSettingMap = wanPortSettings.stream().collect(Collectors.toMap(WanPortSettingVO::getPortUuid, Function.identity()));
        for (WanPortSettingOpenApiVO wanPortSettingOpenApiVO : vo.getWanPortsConfig()) {
            if (!portUuidPortSettingMap.containsKey(wanPortSettingOpenApiVO.getPortId())) continue;
            portUuidPortSettingMap.put(wanPortSettingOpenApiVO.getPortId(), WanPortSettingOpenApiVO.toWebVO(wanPortSettingOpenApiVO));
        }
        internetVO.setWanPortSettings(new ArrayList(portUuidPortSettingMap.values()));
        internetVO.setUsbLteSettings(CollectionUtils.isEmpty(vo.getUsbPortsConfig()) ? internetVO.getUsbLteSettings() : vo.getUsbPortsConfig().stream().map(UsbLteSettingConfigOpenApiVO::toWebVO).collect(Collectors.toList()));
        return internetVO;
    }

    public boolean checkConfigType() {
        if (!CollectionUtils.isEmpty(this.wanPortsConfig)) {
            for (WanPortSettingOpenApiVO vo : this.wanPortsConfig) {
                if (Objects.equals(vo.getWanPortIpv4Setting().getProtoType(), b.a.b()) && vo.getWanPortIpv4Setting().getIpv4Static() == null) {
                    return false;
                }
                if (Objects.equals(vo.getWanPortIpv4Setting().getProtoType(), b.b.b()) && vo.getWanPortIpv4Setting().getIpv4Dhcp() == null) {
                    return false;
                }
                if (Objects.equals(vo.getWanPortIpv4Setting().getProtoType(), b.d.b()) && vo.getWanPortIpv4Setting().getIpv4L2tp() == null) {
                    return false;
                }
                if (Objects.equals(vo.getWanPortIpv4Setting().getProtoType(), b.e.b()) && vo.getWanPortIpv4Setting().getIpv4Pptp() == null) {
                    return false;
                }
                if (Objects.equals(vo.getWanPortIpv4Setting().getProtoType(), b.c.b()) && vo.getWanPortIpv4Setting().getIpv4Pppoe() == null) {
                    return false;
                }
                if (Objects.equals(vo.getWanPortIpv4Setting().getProtoType(), b.f.b()) && vo.getWanPortIpv4Setting().getIpv4Pppoa() == null) {
                    return false;
                }
                if (Objects.equals(vo.getWanPortIpv4Setting().getProtoType(), b.g.b()) && vo.getWanPortIpv4Setting().getIpv4Ipoa() == null) {
                    return false;
                }
                if (Objects.equals(vo.getWanPortIpv6Setting().getProtoType(), c.a.b()) && vo.getWanPortIpv6Setting().getIpv6Static() == null) {
                    return false;
                }
                if (Objects.equals(vo.getWanPortIpv6Setting().getProtoType(), c.b.b()) && vo.getWanPortIpv6Setting().getIpv6Dynamic() == null) {
                    return false;
                }
                if (Objects.equals(vo.getWanPortIpv6Setting().getProtoType(), c.c.b()) && vo.getWanPortIpv6Setting().getIpv6Pppoe() == null) {
                    return false;
                }
                if (!Objects.equals(vo.getWanPortIpv6Setting().getProtoType(), c.d.b()) || vo.getWanPortIpv6Setting().getIpv6Tunnel() != null) continue;
                return false;
            }
        }
        return true;
    }

    @Generated
    public List<WanPortSettingOpenApiVO> getWanPortsConfig() {
        return this.wanPortsConfig;
    }

    @Generated
    public List<UsbLteSettingConfigOpenApiVO> getUsbPortsConfig() {
        return this.usbPortsConfig;
    }

    @Generated
    public void setWanPortsConfig(List<WanPortSettingOpenApiVO> wanPortsConfig) {
        this.wanPortsConfig = wanPortsConfig;
    }

    @Generated
    public void setUsbPortsConfig(List<UsbLteSettingConfigOpenApiVO> usbPortsConfig) {
        this.usbPortsConfig = usbPortsConfig;
    }

    @Generated
    public String toString() {
        return "WanSettingConfigOpenApiVO(wanPortsConfig=" + this.getWanPortsConfig() + ", usbPortsConfig=" + this.getUsbPortsConfig() + ")";
    }

    @Generated
    public WanSettingConfigOpenApiVO(List<WanPortSettingOpenApiVO> wanPortsConfig, List<UsbLteSettingConfigOpenApiVO> usbPortsConfig) {
        this.wanPortsConfig = wanPortsConfig;
        this.usbPortsConfig = usbPortsConfig;
    }

    @Generated
    public WanSettingConfigOpenApiVO() {
    }
}

