/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.WanPortDslSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.WanPortIpv4SettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.WanPortIpv6SettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.WanPortMacSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.WanPortSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import lombok.Generated;

public class WanPortSettingOpenApiVO {
    @Schema(name="portId", description="Port ID")
    @NotNull
    private String portId;
    @Schema(name="portName", description="Port name")
    private String portName;
    @Schema(name="portDescription", description="Port description should contain 1 to 32 characters.")
    private String portDescription;
    @Schema(name="wanPortIpv4Setting", description="Port IPv4 setting")
    @NotNull
    @Valid
    private WanPortIpv4SettingOpenApiVO wanPortIpv4Setting;
    @Schema(name="wanPortIpv6Setting", description="Port IPv6 setting")
    @NotNull
    @Valid
    private WanPortIpv6SettingOpenApiVO wanPortIpv6Setting;
    @Schema(name="wanPortMacSetting", description="Port MAC setting")
    @NotNull
    @Valid
    private WanPortMacSettingOpenApiVO wanPortMacSetting;
    @Schema(name="dslSetting", description="DSL settings. Only for DSL WAN.")
    @Valid
    private WanPortDslSettingOpenApiVO dslSetting;

    public static WanPortSettingOpenApiVO buildFromWebVO(WanPortSettingVO vo) {
        WanPortSettingOpenApiVO res = new WanPortSettingOpenApiVO();
        if (vo == null) {
            return res;
        }
        res.setPortId(vo.getPortUuid());
        res.setPortName(vo.getPortName());
        res.setPortDescription(vo.getPortDesc());
        res.setWanPortIpv4Setting(WanPortIpv4SettingOpenApiVO.buildFromWebVO(vo.getWanPortIpv4Setting()));
        res.setWanPortIpv6Setting(WanPortIpv6SettingOpenApiVO.buildFromWebVO(vo.getWanPortIpv6Setting()));
        res.setWanPortMacSetting(WanPortMacSettingOpenApiVO.buildFromWebVO(vo.getWanPortMacSetting()));
        Optional.ofNullable(vo.getDslSetting()).ifPresent(value -> res.setDslSetting(WanPortDslSettingOpenApiVO.fromWebVO(vo.getDslSetting())));
        return res;
    }

    public static WanPortSettingVO toWebVO(WanPortSettingOpenApiVO vo) {
        WanPortSettingVO res = new WanPortSettingVO();
        if (vo == null) {
            return res;
        }
        res.setPortUuid(vo.getPortId());
        res.setPortName(vo.getPortName());
        res.setPortDesc(vo.getPortDescription());
        res.setWanPortIpv4Setting(WanPortIpv4SettingOpenApiVO.toWebVO(vo.getWanPortIpv4Setting(), vo.getPortId()));
        res.setWanPortIpv6Setting(WanPortIpv6SettingOpenApiVO.toWebVO(vo.getWanPortIpv6Setting(), vo.getPortId()));
        res.setWanPortMacSetting(WanPortMacSettingOpenApiVO.toWebVO(vo.getWanPortMacSetting(), vo.getPortId()));
        res.setDslSetting(WanPortDslSettingOpenApiVO.toWebVO(vo.getDslSetting(), vo.getPortId()));
        return res;
    }

    @Generated
    public String getPortId() {
        return this.portId;
    }

    @Generated
    public String getPortName() {
        return this.portName;
    }

    @Generated
    public String getPortDescription() {
        return this.portDescription;
    }

    @Generated
    public WanPortIpv4SettingOpenApiVO getWanPortIpv4Setting() {
        return this.wanPortIpv4Setting;
    }

    @Generated
    public WanPortIpv6SettingOpenApiVO getWanPortIpv6Setting() {
        return this.wanPortIpv6Setting;
    }

    @Generated
    public WanPortMacSettingOpenApiVO getWanPortMacSetting() {
        return this.wanPortMacSetting;
    }

    @Generated
    public WanPortDslSettingOpenApiVO getDslSetting() {
        return this.dslSetting;
    }

    @Generated
    public void setPortId(String portId) {
        this.portId = portId;
    }

    @Generated
    public void setPortName(String portName) {
        this.portName = portName;
    }

    @Generated
    public void setPortDescription(String portDescription) {
        this.portDescription = portDescription;
    }

    @Generated
    public void setWanPortIpv4Setting(WanPortIpv4SettingOpenApiVO wanPortIpv4Setting) {
        this.wanPortIpv4Setting = wanPortIpv4Setting;
    }

    @Generated
    public void setWanPortIpv6Setting(WanPortIpv6SettingOpenApiVO wanPortIpv6Setting) {
        this.wanPortIpv6Setting = wanPortIpv6Setting;
    }

    @Generated
    public void setWanPortMacSetting(WanPortMacSettingOpenApiVO wanPortMacSetting) {
        this.wanPortMacSetting = wanPortMacSetting;
    }

    @Generated
    public void setDslSetting(WanPortDslSettingOpenApiVO dslSetting) {
        this.dslSetting = dslSetting;
    }

    @Generated
    public String toString() {
        return "WanPortSettingOpenApiVO(portId=" + this.getPortId() + ", portName=" + this.getPortName() + ", portDescription=" + this.getPortDescription() + ", wanPortIpv4Setting=" + this.getWanPortIpv4Setting() + ", wanPortIpv6Setting=" + this.getWanPortIpv6Setting() + ", wanPortMacSetting=" + this.getWanPortMacSetting() + ", dslSetting=" + this.getDslSetting() + ")";
    }

    @Generated
    public WanPortSettingOpenApiVO(String portId, String portName, String portDescription, WanPortIpv4SettingOpenApiVO wanPortIpv4Setting, WanPortIpv6SettingOpenApiVO wanPortIpv6Setting, WanPortMacSettingOpenApiVO wanPortMacSetting, WanPortDslSettingOpenApiVO dslSetting) {
        this.portId = portId;
        this.portName = portName;
        this.portDescription = portDescription;
        this.wanPortIpv4Setting = wanPortIpv4Setting;
        this.wanPortIpv6Setting = wanPortIpv6Setting;
        this.wanPortMacSetting = wanPortMacSetting;
        this.dslSetting = dslSetting;
    }

    @Generated
    public WanPortSettingOpenApiVO() {
    }
}

