/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.Ipv6DynamicOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.Ipv6PppoeOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.Ipv6StaticOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.Ipv6TunnelOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.c;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.WanPortIpv6SettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class WanPortIpv6SettingOpenApiVO {
    @Schema(name="enable")
    @NotNull
    private Boolean enable;
    @Schema(name="protoType", description="IPv4 connection type should be a value as follows: 0: static; 1: dynamic; 2: PPPoE; 3: 6to4Tunnel; 4: bridge.")
    @Range(min=0L, max=4L)
    private @Range(min=0L, max=4L) Integer protoType;
    @Schema(name="ipv6Dynamic", description="It is required when protoType is dynamic")
    @Valid
    private Ipv6DynamicOpenApiVO ipv6Dynamic;
    @Schema(name="ipv6Pppoe", description="It is required when protoType is PPPoE")
    @Valid
    private Ipv6PppoeOpenApiVO ipv6Pppoe;
    @Schema(name="ipv6Tunnel", description="It is required when protoType is 6to4Tunnel")
    @Valid
    private Ipv6TunnelOpenApiVO ipv6Tunnel;
    @Schema(name="ipv6Static", description="It is required when protoType is static")
    @Valid
    private Ipv6StaticOpenApiVO ipv6Static;

    public static WanPortIpv6SettingOpenApiVO buildFromWebVO(WanPortIpv6SettingVO vo) {
        WanPortIpv6SettingOpenApiVO res = new WanPortIpv6SettingOpenApiVO();
        if (vo == null) {
            return res;
        }
        res.setEnable(Objects.equals(vo.getEnable(), 1));
        res.setProtoType(vo.getProtoType());
        res.setIpv6Dynamic(Ipv6DynamicOpenApiVO.buildFromWebVO(vo.getIpv6Dynamic()));
        res.setIpv6Pppoe(Ipv6PppoeOpenApiVO.buildFromWebVO(vo.getIpv6Pppoe()));
        res.setIpv6Tunnel(Ipv6TunnelOpenApiVO.buildFromWebVO(vo.getIpv6Tunnel()));
        res.setIpv6Static(Ipv6StaticOpenApiVO.buildFromWebVO(vo.getIpv6Static()));
        return res;
    }

    public static WanPortIpv6SettingVO toWebVO(WanPortIpv6SettingOpenApiVO vo, String portId) {
        WanPortIpv6SettingVO res = new WanPortIpv6SettingVO();
        if (vo == null) {
            return res;
        }
        res.setPortUuid(portId);
        res.setEnable(Integer.valueOf(Boolean.TRUE.equals(vo.getEnable()) ? 1 : 0));
        if (Objects.equals(res.getEnable(), 1)) {
            res.setProtoType(vo.getProtoType());
            res.setProto(c.a(vo.getProtoType()).a());
            res.setIpv6Dynamic(Ipv6DynamicOpenApiVO.toWebVO(vo.getIpv6Dynamic()));
            res.setIpv6Pppoe(Ipv6PppoeOpenApiVO.toWebVO(vo.getIpv6Pppoe()));
            res.setIpv6Tunnel(Ipv6TunnelOpenApiVO.toWebVO(vo.getIpv6Tunnel()));
            res.setIpv6Static(Ipv6StaticOpenApiVO.toWebVO(vo.getIpv6Static()));
        }
        return res;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Integer getProtoType() {
        return this.protoType;
    }

    @Generated
    public Ipv6DynamicOpenApiVO getIpv6Dynamic() {
        return this.ipv6Dynamic;
    }

    @Generated
    public Ipv6PppoeOpenApiVO getIpv6Pppoe() {
        return this.ipv6Pppoe;
    }

    @Generated
    public Ipv6TunnelOpenApiVO getIpv6Tunnel() {
        return this.ipv6Tunnel;
    }

    @Generated
    public Ipv6StaticOpenApiVO getIpv6Static() {
        return this.ipv6Static;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setProtoType(Integer protoType) {
        this.protoType = protoType;
    }

    @Generated
    public void setIpv6Dynamic(Ipv6DynamicOpenApiVO ipv6Dynamic) {
        this.ipv6Dynamic = ipv6Dynamic;
    }

    @Generated
    public void setIpv6Pppoe(Ipv6PppoeOpenApiVO ipv6Pppoe) {
        this.ipv6Pppoe = ipv6Pppoe;
    }

    @Generated
    public void setIpv6Tunnel(Ipv6TunnelOpenApiVO ipv6Tunnel) {
        this.ipv6Tunnel = ipv6Tunnel;
    }

    @Generated
    public void setIpv6Static(Ipv6StaticOpenApiVO ipv6Static) {
        this.ipv6Static = ipv6Static;
    }

    @Generated
    public String toString() {
        return "WanPortIpv6SettingOpenApiVO(enable=" + this.getEnable() + ", protoType=" + this.getProtoType() + ", ipv6Dynamic=" + this.getIpv6Dynamic() + ", ipv6Pppoe=" + this.getIpv6Pppoe() + ", ipv6Tunnel=" + this.getIpv6Tunnel() + ", ipv6Static=" + this.getIpv6Static() + ")";
    }

    @Generated
    public WanPortIpv6SettingOpenApiVO(Boolean enable, Integer protoType, Ipv6DynamicOpenApiVO ipv6Dynamic, Ipv6PppoeOpenApiVO ipv6Pppoe, Ipv6TunnelOpenApiVO ipv6Tunnel, Ipv6StaticOpenApiVO ipv6Static) {
        this.enable = enable;
        this.protoType = protoType;
        this.ipv6Dynamic = ipv6Dynamic;
        this.ipv6Pppoe = ipv6Pppoe;
        this.ipv6Tunnel = ipv6Tunnel;
        this.ipv6Static = ipv6Static;
    }

    @Generated
    public WanPortIpv6SettingOpenApiVO() {
    }
}

