/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.Ipv4DhcpOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.Ipv4IpoaOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.Ipv4L2tpOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.Ipv4PppoaOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.Ipv4PppoeOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.Ipv4PptpOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.Ipv4StaticOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.b;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.WanPortIpv4SettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class WanPortIpv4SettingOpenApiVO {
    @Schema(name="protoType", description="IPv4 connection type should be a value as follows: 0:static; 1:DHCP; 2:PPPoE; 3:L2TP; 4:PPTP.")
    @NotNull(message="Parameter [protoType] should not be null.")
    @Range(min=0L, max=4L)
    private @NotNull(message="Parameter [protoType] should not be null.") @Range(min=0L, max=4L) Integer protoType;
    @Schema(name="vlanId", description="VLAN ID should be within the range of 0\u20134094, 0 means disable.")
    @NotNull(message="Parameter [vlanId] should not be null.")
    @Range(min=0L, max=4094L)
    private @NotNull(message="Parameter [vlanId] should not be null.") @Range(min=0L, max=4094L) Integer vlanId;
    @Schema(name="qosTag", description="802.1Q Tag. It takes effect when [vlanId] is not 0.")
    private Boolean qosTagEnable;
    @Schema(name="vlanPriority", description="Vlan Priority. It takes effect when [vlanId] is not 0, and it should be within the range of 0\u20137.")
    @Range(min=0L, max=7L)
    private @Range(min=0L, max=7L) Integer vlanPriority;
    @Schema(name="ipv4Static", description="It is required when [protoType] is 0.")
    @Valid
    @Nullable
    private Ipv4StaticOpenApiVO ipv4Static;
    @Schema(name="ipv4Dhcp", description="It is required when [protoType] is 1.")
    @Valid
    @Nullable
    private Ipv4DhcpOpenApiVO ipv4Dhcp;
    @Schema(name="ipv4Pppoe", description="It is required when [protoType] is 2.")
    @Valid
    @Nullable
    private Ipv4PppoeOpenApiVO ipv4Pppoe;
    @Schema(name="ipv4L2tp", description="It is required when [protoType] is 3.")
    @Valid
    @Nullable
    private Ipv4L2tpOpenApiVO ipv4L2tp;
    @Schema(name="ipv4Pptp", description="It is required when [protoType] is 4.")
    @Valid
    @Nullable
    private Ipv4PptpOpenApiVO ipv4Pptp;
    @Schema(name="ipv4Pppoa", description="It is required when [protoType] is 7.")
    @Valid
    @Nullable
    private Ipv4PppoaOpenApiVO ipv4Pppoa;
    @Schema(name="ipv4Ipoa", description="It is required when [protoType] is 8.")
    @Valid
    @Nullable
    private Ipv4IpoaOpenApiVO ipv4Ipoa;

    public static WanPortIpv4SettingOpenApiVO buildFromWebVO(WanPortIpv4SettingVO vo) {
        WanPortIpv4SettingOpenApiVO res = new WanPortIpv4SettingOpenApiVO();
        if (vo == null) {
            return res;
        }
        res.setProtoType(vo.getProtoType());
        res.setVlanId(vo.getVlanId());
        res.setQosTagEnable(vo.getQosTagEnable());
        res.setVlanPriority(vo.getVlanPriority());
        res.setIpv4Static(Ipv4StaticOpenApiVO.buildFromWebVO(vo.getIpv4Static()));
        res.setIpv4Dhcp(Ipv4DhcpOpenApiVO.buildFromWebVO(vo.getIpv4Dhcp()));
        res.setIpv4Pppoe(Ipv4PppoeOpenApiVO.buildFromWebVO(vo.getIpv4Pppoe()));
        res.setIpv4L2tp(Ipv4L2tpOpenApiVO.buildFromWebVO(vo.getIpv4L2tp()));
        res.setIpv4Pptp(Ipv4PptpOpenApiVO.buildFromWebVO(vo.getIpv4Pptp()));
        res.setIpv4Pppoa(Ipv4PppoaOpenApiVO.buildFromWebVO(vo.getIpv4Pppoa()));
        res.setIpv4Ipoa(Ipv4IpoaOpenApiVO.buildFromWebVO(vo.getIpv4Ipoa()));
        return res;
    }

    public static WanPortIpv4SettingVO toWebVO(WanPortIpv4SettingOpenApiVO vo, String portId) {
        WanPortIpv4SettingVO res = new WanPortIpv4SettingVO();
        if (vo == null) {
            return res;
        }
        res.setPortUuid(portId);
        res.setProto(b.a(vo.getProtoType()).a());
        res.setVlanId(vo.getVlanId());
        res.setQosTagEnable(vo.getQosTagEnable());
        res.setVlanPriority(vo.getVlanPriority());
        res.setIpv4Static(Ipv4StaticOpenApiVO.toWebVO(vo.getIpv4Static()));
        res.setIpv4Dhcp(Ipv4DhcpOpenApiVO.toWebVO(vo.getIpv4Dhcp()));
        res.setIpv4Pppoe(Ipv4PppoeOpenApiVO.toWebVO(vo.getIpv4Pppoe()));
        res.setIpv4L2tp(Ipv4L2tpOpenApiVO.toWebVO(vo.getIpv4L2tp()));
        res.setIpv4Pptp(Ipv4PptpOpenApiVO.toWebVO(vo.getIpv4Pptp()));
        res.setIpv4Pppoa(Ipv4PppoaOpenApiVO.toWebVO(vo.getIpv4Pppoa()));
        res.setIpv4Ipoa(Ipv4IpoaOpenApiVO.toWebVO(vo.getIpv4Ipoa()));
        return res;
    }

    @Generated
    public Integer getProtoType() {
        return this.protoType;
    }

    @Generated
    public Integer getVlanId() {
        return this.vlanId;
    }

    @Generated
    public Boolean getQosTagEnable() {
        return this.qosTagEnable;
    }

    @Generated
    public Integer getVlanPriority() {
        return this.vlanPriority;
    }

    @Nullable
    @Generated
    public Ipv4StaticOpenApiVO getIpv4Static() {
        return this.ipv4Static;
    }

    @Nullable
    @Generated
    public Ipv4DhcpOpenApiVO getIpv4Dhcp() {
        return this.ipv4Dhcp;
    }

    @Nullable
    @Generated
    public Ipv4PppoeOpenApiVO getIpv4Pppoe() {
        return this.ipv4Pppoe;
    }

    @Nullable
    @Generated
    public Ipv4L2tpOpenApiVO getIpv4L2tp() {
        return this.ipv4L2tp;
    }

    @Nullable
    @Generated
    public Ipv4PptpOpenApiVO getIpv4Pptp() {
        return this.ipv4Pptp;
    }

    @Nullable
    @Generated
    public Ipv4PppoaOpenApiVO getIpv4Pppoa() {
        return this.ipv4Pppoa;
    }

    @Nullable
    @Generated
    public Ipv4IpoaOpenApiVO getIpv4Ipoa() {
        return this.ipv4Ipoa;
    }

    @Generated
    public void setProtoType(Integer protoType) {
        this.protoType = protoType;
    }

    @Generated
    public void setVlanId(Integer vlanId) {
        this.vlanId = vlanId;
    }

    @Generated
    public void setQosTagEnable(Boolean qosTagEnable) {
        this.qosTagEnable = qosTagEnable;
    }

    @Generated
    public void setVlanPriority(Integer vlanPriority) {
        this.vlanPriority = vlanPriority;
    }

    @Generated
    public void setIpv4Static(@Nullable Ipv4StaticOpenApiVO ipv4Static) {
        this.ipv4Static = ipv4Static;
    }

    @Generated
    public void setIpv4Dhcp(@Nullable Ipv4DhcpOpenApiVO ipv4Dhcp) {
        this.ipv4Dhcp = ipv4Dhcp;
    }

    @Generated
    public void setIpv4Pppoe(@Nullable Ipv4PppoeOpenApiVO ipv4Pppoe) {
        this.ipv4Pppoe = ipv4Pppoe;
    }

    @Generated
    public void setIpv4L2tp(@Nullable Ipv4L2tpOpenApiVO ipv4L2tp) {
        this.ipv4L2tp = ipv4L2tp;
    }

    @Generated
    public void setIpv4Pptp(@Nullable Ipv4PptpOpenApiVO ipv4Pptp) {
        this.ipv4Pptp = ipv4Pptp;
    }

    @Generated
    public void setIpv4Pppoa(@Nullable Ipv4PppoaOpenApiVO ipv4Pppoa) {
        this.ipv4Pppoa = ipv4Pppoa;
    }

    @Generated
    public void setIpv4Ipoa(@Nullable Ipv4IpoaOpenApiVO ipv4Ipoa) {
        this.ipv4Ipoa = ipv4Ipoa;
    }

    @Generated
    public String toString() {
        return "WanPortIpv4SettingOpenApiVO(protoType=" + this.getProtoType() + ", vlanId=" + this.getVlanId() + ", qosTagEnable=" + this.getQosTagEnable() + ", vlanPriority=" + this.getVlanPriority() + ", ipv4Static=" + this.getIpv4Static() + ", ipv4Dhcp=" + this.getIpv4Dhcp() + ", ipv4Pppoe=" + this.getIpv4Pppoe() + ", ipv4L2tp=" + this.getIpv4L2tp() + ", ipv4Pptp=" + this.getIpv4Pptp() + ", ipv4Pppoa=" + this.getIpv4Pppoa() + ", ipv4Ipoa=" + this.getIpv4Ipoa() + ")";
    }

    @Generated
    public WanPortIpv4SettingOpenApiVO(Integer protoType, Integer vlanId, Boolean qosTagEnable, Integer vlanPriority, @Nullable Ipv4StaticOpenApiVO ipv4Static, @Nullable Ipv4DhcpOpenApiVO ipv4Dhcp, @Nullable Ipv4PppoeOpenApiVO ipv4Pppoe, @Nullable Ipv4L2tpOpenApiVO ipv4L2tp, @Nullable Ipv4PptpOpenApiVO ipv4Pptp, @Nullable Ipv4PppoaOpenApiVO ipv4Pppoa, @Nullable Ipv4IpoaOpenApiVO ipv4Ipoa) {
        this.protoType = protoType;
        this.vlanId = vlanId;
        this.qosTagEnable = qosTagEnable;
        this.vlanPriority = vlanPriority;
        this.ipv4Static = ipv4Static;
        this.ipv4Dhcp = ipv4Dhcp;
        this.ipv4Pppoe = ipv4Pppoe;
        this.ipv4L2tp = ipv4L2tp;
        this.ipv4Pptp = ipv4Pptp;
        this.ipv4Pppoa = ipv4Pppoa;
        this.ipv4Ipoa = ipv4Ipoa;
    }

    @Generated
    public WanPortIpv4SettingOpenApiVO() {
    }
}

