/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.DslWanSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class WanPortDslSettingOpenApiVO {
    @Schema(name="portName", description="Wan port name.")
    private String portName;
    @Schema(name="portUuid", description="Wan port UUID.")
    @NotNull
    private String portUuid;
    @Schema(name="portDesc", description="Wan port description.")
    private String portDesc;
    @Schema(name="location", description="Your country/region.")
    @NotNull
    private String location;
    @Schema(name="isp", description="Your ISP (Internet Service Provider) from the drop-down list,Select Other to customize the settings.")
    @NotNull
    @JsonProperty(value="isp")
    @JsonAlias(value={"isp", "p"})
    private Integer isp;
    @Schema(name="modulationType", description="The modulation type used for your DSL connection. 0: VDSL, 1: ADSL.")
    @NotNull
    @Range(min=0L, max=1L)
    @JsonProperty(value="modulationType")
    private @NotNull @Range(min=0L, max=1L) Integer modulation;
    @Schema(name="vpi", description="The VPI(0~255) assigned by your ISP to specify the virtual path between endpoints in an ATM network.")
    @Range(min=0L, max=255L)
    private @Range(min=0L, max=255L) Integer vpi;
    @Schema(name="vci", description="The VCI(1~65535) assigned by your ISP to specify the virtual channel endpoints in an ATM network.")
    @Range(min=1L, max=65535L)
    private @Range(min=1L, max=65535L) Integer vci;
    @Schema(name="encapMode", description="Encap mode assigned by your ISP. 0: LLC, 1: VC-MUX, 2: VC/MUX, 3: 1483 Bridged IP LLC, 4: 1483 Routed IP LLC")
    @Range(min=0L, max=4L)
    private @Range(min=0L, max=4L) Integer encapMode;
    @Schema(name="merEnable", description="If your ISP requires MER for network connection(e.g., Sky VDSL).MER switch configuration, only configurable when in VDSL mode and DHCP dial-up mode.")
    private Boolean merEnable;
    @Schema(name="merUsername", description="MER username configuration, only configurable when in VDSL mode and DHCP dial-up mode.")
    @Pattern(regexp="^[^\\s]{1,63}$")
    private @Pattern(regexp="^[^\\s]{1,63}$") String merUsername;
    @Schema(name="merPassword", description="MER password configuration, only configurable when in VDSL mode and DHCP dial-up mode.")
    @Pattern(regexp="^[^\\s]{1,63}$")
    private @Pattern(regexp="^[^\\s]{1,63}$") String merPassword;

    public static WanPortDslSettingOpenApiVO fromWebVO(DslWanSettingVO vo) {
        if (Objects.isNull(vo)) {
            return null;
        }
        WanPortDslSettingOpenApiVO openApiVO = new WanPortDslSettingOpenApiVO();
        openApiVO.setPortName(vo.getPortName());
        openApiVO.setPortUuid(vo.getPortUuid());
        openApiVO.setPortDesc(vo.getPortDesc());
        openApiVO.setLocation(vo.getLocation());
        openApiVO.setIsp(vo.getIsp());
        openApiVO.setModulation(vo.getModulation());
        openApiVO.setVpi(vo.getVpi());
        openApiVO.setVci(vo.getVci());
        openApiVO.setEncapMode(vo.getEncapMode());
        openApiVO.setMerEnable(vo.getMerEnable());
        openApiVO.setMerUsername(vo.getMerUsername());
        openApiVO.setMerPassword(vo.getMerPassword());
        return openApiVO;
    }

    public static DslWanSettingVO toWebVO(WanPortDslSettingOpenApiVO openApiVO, String portId) {
        if (Objects.isNull(openApiVO)) {
            return null;
        }
        DslWanSettingVO vo = new DslWanSettingVO();
        vo.setPortName(openApiVO.getPortName());
        vo.setPortUuid(portId);
        vo.setPortDesc(openApiVO.getPortDesc());
        vo.setLocation(openApiVO.getLocation());
        vo.setIsp(openApiVO.getIsp());
        vo.setModulation(openApiVO.getModulation());
        vo.setVpi(openApiVO.getVpi());
        vo.setVci(openApiVO.getVci());
        vo.setEncapMode(openApiVO.getEncapMode());
        vo.setMerEnable(openApiVO.getMerEnable());
        vo.setMerUsername(openApiVO.getMerUsername());
        vo.setMerPassword(openApiVO.getMerPassword());
        return vo;
    }

    @Generated
    public String getPortName() {
        return this.portName;
    }

    @Generated
    public String getPortUuid() {
        return this.portUuid;
    }

    @Generated
    public String getPortDesc() {
        return this.portDesc;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public Integer getIsp() {
        return this.isp;
    }

    @Generated
    public Integer getModulation() {
        return this.modulation;
    }

    @Generated
    public Integer getVpi() {
        return this.vpi;
    }

    @Generated
    public Integer getVci() {
        return this.vci;
    }

    @Generated
    public Integer getEncapMode() {
        return this.encapMode;
    }

    @Generated
    public Boolean getMerEnable() {
        return this.merEnable;
    }

    @Generated
    public String getMerUsername() {
        return this.merUsername;
    }

    @Generated
    public String getMerPassword() {
        return this.merPassword;
    }

    @Generated
    public void setPortName(String portName) {
        this.portName = portName;
    }

    @Generated
    public void setPortUuid(String portUuid) {
        this.portUuid = portUuid;
    }

    @Generated
    public void setPortDesc(String portDesc) {
        this.portDesc = portDesc;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @JsonProperty(value="isp")
    @JsonAlias(value={"isp", "p"})
    @Generated
    public void setIsp(Integer isp) {
        this.isp = isp;
    }

    @JsonProperty(value="modulationType")
    @Generated
    public void setModulation(Integer modulation) {
        this.modulation = modulation;
    }

    @Generated
    public void setVpi(Integer vpi) {
        this.vpi = vpi;
    }

    @Generated
    public void setVci(Integer vci) {
        this.vci = vci;
    }

    @Generated
    public void setEncapMode(Integer encapMode) {
        this.encapMode = encapMode;
    }

    @Generated
    public void setMerEnable(Boolean merEnable) {
        this.merEnable = merEnable;
    }

    @Generated
    public void setMerUsername(String merUsername) {
        this.merUsername = merUsername;
    }

    @Generated
    public void setMerPassword(String merPassword) {
        this.merPassword = merPassword;
    }

    @Generated
    public String toString() {
        return "WanPortDslSettingOpenApiVO(portName=" + this.getPortName() + ", portUuid=" + this.getPortUuid() + ", portDesc=" + this.getPortDesc() + ", location=" + this.getLocation() + ", isp=" + this.getIsp() + ", modulation=" + this.getModulation() + ", vpi=" + this.getVpi() + ", vci=" + this.getVci() + ", encapMode=" + this.getEncapMode() + ", merEnable=" + this.getMerEnable() + ", merUsername=" + this.getMerUsername() + ", merPassword=" + this.getMerPassword() + ")";
    }

    @Generated
    public WanPortDslSettingOpenApiVO(String portName, String portUuid, String portDesc, String location, Integer isp, Integer modulation, Integer vpi, Integer vci, Integer encapMode, Boolean merEnable, String merUsername, String merPassword) {
        this.portName = portName;
        this.portUuid = portUuid;
        this.portDesc = portDesc;
        this.location = location;
        this.isp = isp;
        this.modulation = modulation;
        this.vpi = vpi;
        this.vci = vci;
        this.encapMode = encapMode;
        this.merEnable = merEnable;
        this.merUsername = merUsername;
        this.merPassword = merPassword;
    }

    @Generated
    public WanPortDslSettingOpenApiVO() {
    }
}

