/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan.VirtualWanWeightOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.WanLoadBalanceVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class WanLoadBalanceOpenApiVO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WanLoadBalanceOpenApiVO.class);
    private static String BACKUP = "backup";
    @Schema(name="weights", description="Load Balancing Weights,item of weights should be within the range of 1 to the max int value(2147483647). It is sorted by port ID.")
    @NotNull
    private List<Integer> weights;
    @Schema(name="appOptRouting", description="Application Optimized Routing")
    @NotNull
    private Boolean appOptRouting;
    @Schema(name="linkBackup", description="Link Backup")
    @NotNull
    private Boolean linkBackup;
    @Schema(name="method", description="effective only for 'linkBackup: true'")
    private String method;
    @Schema(name="primaryWans", description="Primary WAN port IDs. It is required when [linkBackup] is true.")
    private List<String> primaryWans;
    @Schema(name="backupWan", description="Backup WAN ID. It is required when [linkBackup] is true.")
    private String backupWan;
    @Schema(name="backupMode", description="It is required when [linkBackup] is true. 0: The system will try to forward the traffic via the backup WAN port when primary WAN fails. Even if the primary WAN is recovered, it will not switch back unless the backup WAN fails; 1: Traffic is always forwarded through the primary WAN port unless it fails. The system will try to forward the traffic via the backup WAN port when it fails, and switch back when it recovers.")
    @Range(min=0L, max=1L)
    private @Range(min=0L, max=1L) Integer backupMode;
    @Schema(name="mode", description="It is required when [linkBackup] is true. 0: Enable backup link when any primary WAN fails. 1: Enable backup link when all primary WANs fail.")
    @Range(min=0L, max=1L)
    private @Range(min=0L, max=1L) Integer mode;
    @Schema(name="virtualWanWeights", description="virtual wan load balance")
    private List<VirtualWanWeightOpenApiVO> virtualWanWeights;

    public static WanLoadBalanceVO toWebVO(WanLoadBalanceOpenApiVO openApiVO) {
        WanLoadBalanceVO wanLoadBalanceVO = new WanLoadBalanceVO();
        wanLoadBalanceVO.setWeight(T.a(openApiVO.getWeights(), (String)","));
        wanLoadBalanceVO.setAppOptRouting(openApiVO.getAppOptRouting());
        wanLoadBalanceVO.setLinkBackup(openApiVO.getLinkBackup());
        wanLoadBalanceVO.setBackupWan(openApiVO.getBackupWan());
        wanLoadBalanceVO.setMethod(openApiVO.getMethod());
        wanLoadBalanceVO.setPrimaryWan(openApiVO.getPrimaryWans());
        wanLoadBalanceVO.setVirtualWanWeights(CollectionUtils.isEmpty(openApiVO.getVirtualWanWeights()) ? new ArrayList() : openApiVO.getVirtualWanWeights().stream().map(VirtualWanWeightOpenApiVO::toWebVO).toList());
        wanLoadBalanceVO.setMode(openApiVO.getMode());
        return wanLoadBalanceVO;
    }

    public static WanLoadBalanceOpenApiVO buildFromWebVO(WanLoadBalanceVO vo) {
        WanLoadBalanceOpenApiVO res = new WanLoadBalanceOpenApiVO();
        if (vo == null) {
            return res;
        }
        res.setWeights(WanLoadBalanceOpenApiVO.getWeight(vo.getWeight()));
        res.setAppOptRouting(vo.getAppOptRouting());
        res.setLinkBackup(vo.getLinkBackup());
        if (Boolean.TRUE.equals(res.getLinkBackup())) {
            res.setPrimaryWans(vo.getPrimaryWan());
            res.setBackupWan(vo.getBackupWan());
            res.setMode(vo.getMode());
            res.setBackupMode(BACKUP.equals(vo.getMethod()) ? 0 : 1);
        }
        return res;
    }

    private static List<Integer> getWeight(String weights) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        if (T.a((String)weights) || !weights.contains(",")) {
            return res;
        }
        String[] weightList = weights.split(",");
        if (weightList.length < 2) {
            return res;
        }
        for (String weight : weightList) {
            try {
                res.add(Integer.valueOf(weight));
            }
            catch (NumberFormatException e2) {
                log.warn("wrong load balance weight {}", (Object)weights, (Object)e2);
            }
        }
        return res;
    }

    @Generated
    public List<Integer> getWeights() {
        return this.weights;
    }

    @Generated
    public Boolean getAppOptRouting() {
        return this.appOptRouting;
    }

    @Generated
    public Boolean getLinkBackup() {
        return this.linkBackup;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public List<String> getPrimaryWans() {
        return this.primaryWans;
    }

    @Generated
    public String getBackupWan() {
        return this.backupWan;
    }

    @Generated
    public Integer getBackupMode() {
        return this.backupMode;
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public List<VirtualWanWeightOpenApiVO> getVirtualWanWeights() {
        return this.virtualWanWeights;
    }

    @Generated
    public void setWeights(List<Integer> weights) {
        this.weights = weights;
    }

    @Generated
    public void setAppOptRouting(Boolean appOptRouting) {
        this.appOptRouting = appOptRouting;
    }

    @Generated
    public void setLinkBackup(Boolean linkBackup) {
        this.linkBackup = linkBackup;
    }

    @Generated
    public void setMethod(String method) {
        this.method = method;
    }

    @Generated
    public void setPrimaryWans(List<String> primaryWans) {
        this.primaryWans = primaryWans;
    }

    @Generated
    public void setBackupWan(String backupWan) {
        this.backupWan = backupWan;
    }

    @Generated
    public void setBackupMode(Integer backupMode) {
        this.backupMode = backupMode;
    }

    @Generated
    public void setMode(Integer mode) {
        this.mode = mode;
    }

    @Generated
    public void setVirtualWanWeights(List<VirtualWanWeightOpenApiVO> virtualWanWeights) {
        this.virtualWanWeights = virtualWanWeights;
    }

    @Generated
    public String toString() {
        return "WanLoadBalanceOpenApiVO(weights=" + this.getWeights() + ", appOptRouting=" + this.getAppOptRouting() + ", linkBackup=" + this.getLinkBackup() + ", method=" + this.getMethod() + ", primaryWans=" + this.getPrimaryWans() + ", backupWan=" + this.getBackupWan() + ", backupMode=" + this.getBackupMode() + ", mode=" + this.getMode() + ", virtualWanWeights=" + this.getVirtualWanWeights() + ")";
    }

    @Generated
    public WanLoadBalanceOpenApiVO(List<Integer> weights, Boolean appOptRouting, Boolean linkBackup, String method, List<String> primaryWans, String backupWan, Integer backupMode, Integer mode, List<VirtualWanWeightOpenApiVO> virtualWanWeights) {
        this.weights = weights;
        this.appOptRouting = appOptRouting;
        this.linkBackup = linkBackup;
        this.method = method;
        this.primaryWans = primaryWans;
        this.backupWan = backupWan;
        this.backupMode = backupMode;
        this.mode = mode;
        this.virtualWanWeights = virtualWanWeights;
    }

    @Generated
    public WanLoadBalanceOpenApiVO() {
    }
}

