/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.AutoConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.DnsConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.ManuallyConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.WanDhcpOptionOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.UsbLteSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

@KeepClass
public class UsbLteSettingOpenApiVO {
    @Schema(name="portId", description="Port ID")
    @NotNull
    private String portId;
    @Schema(name="portDescription", description="Port description")
    private String portDescription;
    @Schema(name="portName", description="Port Name")
    private String portName;
    @Schema(name="usbModem", description="USB modem name")
    private String usbModem;
    @Schema(name="reduceUsbRif", description="whether to use usb2.0, false means close, default is open")
    private Boolean reduceUsbRfi;
    @Schema(name="configType", description="0: Auto; 1\uff1aManually.")
    @NotNull
    private Integer configType;
    @Schema(name="autoConfig", description="It is required when [configType] is 0.")
    private AutoConfigOpenApiVO autoConfig;
    @Schema(name="manuallyConfig", description="It is required when [configType] is 1.")
    private ManuallyConfigOpenApiVO manuallyConfig;
    @Schema(name="connectionMode", description="1: Connect Automatically, 2: Connect Manually")
    @NotNull
    private Integer connectionMode;
    @Schema(name="usbModemMsgId")
    private Integer usbModemMsgId;
    @Schema(name="pin", description="It is required when [usbModemMsgId] is 1 or 3")
    private String pin;
    @Schema(name="authType", description="0:Auto, 1:PAP, 2:CHAP")
    @NotNull
    private Integer authType;
    @Schema(name="mtuSize", description="MTU range from 576 ~ 1500")
    @NotNull
    private Integer mtuSize;
    @NotNull
    private Boolean dnsEnable;
    @Schema(name="dhcpOptions")
    private List<WanDhcpOptionOpenApiVO> dhcpOptions;
    @Schema(name="dnsConfig", description="It is required when [dnsEnable] is true")
    private DnsConfigOpenApiVO dnsConfig;

    public static UsbLteSettingOpenApiVO buildFromWebVO(UsbLteSettingVO vo) {
        UsbLteSettingOpenApiVO res = new UsbLteSettingOpenApiVO();
        if (vo == null) {
            return res;
        }
        res.setPortId(vo.getPortUuid());
        res.setPortDescription(vo.getPortDesc());
        res.setUsbModem(vo.getUsbModem());
        res.setConfigType(vo.getConfigType());
        res.setAutoConfig(AutoConfigOpenApiVO.buildFromWebVO(vo.getAutoConfig()));
        res.setManuallyConfig(ManuallyConfigOpenApiVO.buildFromWebVO(vo.getManuallyConfig()));
        res.setConnectionMode(vo.getConnectionMode());
        res.setUsbModemMsgId(vo.getUsbModemMsgId());
        res.setPin(vo.getPin());
        res.setAuthType(vo.getAuthType());
        res.setMtuSize(vo.getMtuSize());
        res.setDnsEnable(vo.getDnsEnable());
        res.setDnsConfig(DnsConfigOpenApiVO.buildFromWebVO(vo.getDnsConfig()));
        res.setDhcpOptions(CollectionUtils.isEmpty((Collection)vo.getDhcpOptions()) ? new ArrayList<WanDhcpOptionOpenApiVO>() : vo.getDhcpOptions().stream().map(WanDhcpOptionOpenApiVO::buildFromWebVO).collect(Collectors.toList()));
        return res;
    }

    public static UsbLteSettingVO toVO(UsbLteSettingOpenApiVO openApiVO) {
        UsbLteSettingVO result = new UsbLteSettingVO();
        if (Objects.isNull(openApiVO)) {
            return result;
        }
        result.setPortUuid(openApiVO.portId);
        result.setPortDesc(openApiVO.getPortDescription());
        result.setPortName(openApiVO.getPortName());
        result.setUsbModem(openApiVO.getUsbModem());
        result.setReduceUsbRfi(openApiVO.getReduceUsbRfi());
        result.setConfigType(openApiVO.getConfigType());
        result.setAutoConfig(AutoConfigOpenApiVO.toWebVO(openApiVO.getAutoConfig()));
        result.setManuallyConfig(ManuallyConfigOpenApiVO.toWebVO(openApiVO.getManuallyConfig()));
        result.setConnectionMode(openApiVO.getConnectionMode());
        result.setUsbModemMsgId(openApiVO.getUsbModemMsgId());
        result.setPin(openApiVO.getPin());
        result.setAuthType(openApiVO.getAuthType());
        result.setMtuSize(openApiVO.getMtuSize());
        result.setDnsEnable(openApiVO.getDnsEnable());
        result.setDnsConfig(DnsConfigOpenApiVO.toWebVO(openApiVO.getDnsConfig()));
        result.setDhcpOptions(CollectionUtils.isEmpty(openApiVO.getDhcpOptions()) ? new ArrayList() : openApiVO.getDhcpOptions().stream().map(WanDhcpOptionOpenApiVO::toWebVO).toList());
        return result;
    }

    @Generated
    public String getPortId() {
        return this.portId;
    }

    @Generated
    public String getPortDescription() {
        return this.portDescription;
    }

    @Generated
    public String getPortName() {
        return this.portName;
    }

    @Generated
    public String getUsbModem() {
        return this.usbModem;
    }

    @Generated
    public Boolean getReduceUsbRfi() {
        return this.reduceUsbRfi;
    }

    @Generated
    public Integer getConfigType() {
        return this.configType;
    }

    @Generated
    public AutoConfigOpenApiVO getAutoConfig() {
        return this.autoConfig;
    }

    @Generated
    public ManuallyConfigOpenApiVO getManuallyConfig() {
        return this.manuallyConfig;
    }

    @Generated
    public Integer getConnectionMode() {
        return this.connectionMode;
    }

    @Generated
    public Integer getUsbModemMsgId() {
        return this.usbModemMsgId;
    }

    @Generated
    public String getPin() {
        return this.pin;
    }

    @Generated
    public Integer getAuthType() {
        return this.authType;
    }

    @Generated
    public Integer getMtuSize() {
        return this.mtuSize;
    }

    @Generated
    public Boolean getDnsEnable() {
        return this.dnsEnable;
    }

    @Generated
    public List<WanDhcpOptionOpenApiVO> getDhcpOptions() {
        return this.dhcpOptions;
    }

    @Generated
    public DnsConfigOpenApiVO getDnsConfig() {
        return this.dnsConfig;
    }

    @Generated
    public void setPortId(String portId) {
        this.portId = portId;
    }

    @Generated
    public void setPortDescription(String portDescription) {
        this.portDescription = portDescription;
    }

    @Generated
    public void setPortName(String portName) {
        this.portName = portName;
    }

    @Generated
    public void setUsbModem(String usbModem) {
        this.usbModem = usbModem;
    }

    @Generated
    public void setReduceUsbRfi(Boolean reduceUsbRfi) {
        this.reduceUsbRfi = reduceUsbRfi;
    }

    @Generated
    public void setConfigType(Integer configType) {
        this.configType = configType;
    }

    @Generated
    public void setAutoConfig(AutoConfigOpenApiVO autoConfig) {
        this.autoConfig = autoConfig;
    }

    @Generated
    public void setManuallyConfig(ManuallyConfigOpenApiVO manuallyConfig) {
        this.manuallyConfig = manuallyConfig;
    }

    @Generated
    public void setConnectionMode(Integer connectionMode) {
        this.connectionMode = connectionMode;
    }

    @Generated
    public void setUsbModemMsgId(Integer usbModemMsgId) {
        this.usbModemMsgId = usbModemMsgId;
    }

    @Generated
    public void setPin(String pin) {
        this.pin = pin;
    }

    @Generated
    public void setAuthType(Integer authType) {
        this.authType = authType;
    }

    @Generated
    public void setMtuSize(Integer mtuSize) {
        this.mtuSize = mtuSize;
    }

    @Generated
    public void setDnsEnable(Boolean dnsEnable) {
        this.dnsEnable = dnsEnable;
    }

    @Generated
    public void setDhcpOptions(List<WanDhcpOptionOpenApiVO> dhcpOptions) {
        this.dhcpOptions = dhcpOptions;
    }

    @Generated
    public void setDnsConfig(DnsConfigOpenApiVO dnsConfig) {
        this.dnsConfig = dnsConfig;
    }

    @Generated
    public String toString() {
        return "UsbLteSettingOpenApiVO(portId=" + this.getPortId() + ", portDescription=" + this.getPortDescription() + ", portName=" + this.getPortName() + ", usbModem=" + this.getUsbModem() + ", reduceUsbRfi=" + this.getReduceUsbRfi() + ", configType=" + this.getConfigType() + ", autoConfig=" + this.getAutoConfig() + ", manuallyConfig=" + this.getManuallyConfig() + ", connectionMode=" + this.getConnectionMode() + ", usbModemMsgId=" + this.getUsbModemMsgId() + ", pin=" + this.getPin() + ", authType=" + this.getAuthType() + ", mtuSize=" + this.getMtuSize() + ", dnsEnable=" + this.getDnsEnable() + ", dhcpOptions=" + this.getDhcpOptions() + ", dnsConfig=" + this.getDnsConfig() + ")";
    }
}

