/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.AutoConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.DnsConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.ManuallyConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.WanDhcpOptionOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.UsbLteSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

@KeepClass
public class UsbLteSettingConfigOpenApiVO {
    @Schema(name="portId", description="Port ID")
    @NotNull
    private String portId;
    @Schema(name="portDescription", description="Port description should contain 1 to 32 characters.")
    private String portDescription;
    @Schema(name="configType", description="0: Auto; 1\uff1aManually")
    @NotNull
    @Range(min=0L, max=1L)
    private @NotNull @Range(min=0L, max=1L) Integer configType;
    @Schema(name="autoConfig", description="It is required when [configType] is 0.")
    private AutoConfigOpenApiVO autoConfig;
    @Schema(name="manuallyConfig", description="It is required when [configType] is 1.")
    private ManuallyConfigOpenApiVO manuallyConfig;
    @Schema(name="connectionMode", description="1: Connect Automatically, 2: Connect Manually.")
    @Range(min=1L, max=2L)
    @NotNull
    private @Range(min=1L, max=2L) @NotNull Integer connectionMode;
    @Schema(name="pin", description="It is required when [usbModemMsgId] is 1 or 3.")
    private String pin;
    @Schema(name="authType", description="0:Auto; 1:PAP; 2:CHAP.")
    @NotNull
    @Range(min=0L, max=2L)
    private @NotNull @Range(min=0L, max=2L) Integer authType;
    @Schema(name="mtuSize", description="MTU ranges from 576 ~ 1500.")
    @NotNull
    @Range(min=576L, max=1500L)
    private @NotNull @Range(min=576L, max=1500L) Integer mtuSize;
    @NotNull
    @Schema(name="dnsEnable", description="0:off,1:on.")
    private Boolean dnsEnable;
    @Schema(name="dhcpOptions")
    private List<WanDhcpOptionOpenApiVO> dhcpOptions;
    @Schema(name="dnsConfig", description="It is required when [dnsEnable] is true.")
    private DnsConfigOpenApiVO dnsConfig;

    public static UsbLteSettingVO toWebVO(UsbLteSettingConfigOpenApiVO vo) {
        UsbLteSettingVO res = new UsbLteSettingVO();
        if (vo == null) {
            return res;
        }
        res.setPortUuid(vo.getPortId());
        res.setPortDesc(vo.getPortDescription());
        res.setConfigType(vo.getConfigType());
        res.setAutoConfig(AutoConfigOpenApiVO.toWebVO(vo.getAutoConfig()));
        res.setManuallyConfig(ManuallyConfigOpenApiVO.toWebVO(vo.getManuallyConfig()));
        res.setConnectionMode(vo.getConnectionMode());
        res.setPin(vo.getPin());
        res.setAuthType(vo.getAuthType());
        res.setMtuSize(vo.getMtuSize());
        res.setDnsEnable(vo.getDnsEnable());
        res.setDnsConfig(DnsConfigOpenApiVO.toWebVO(vo.getDnsConfig()));
        res.setDhcpOptions(CollectionUtils.isEmpty(vo.getDhcpOptions()) ? new ArrayList() : vo.getDhcpOptions().stream().map(WanDhcpOptionOpenApiVO::toWebVO).collect(Collectors.toList()));
        return res;
    }

    public static UsbLteSettingConfigOpenApiVO buildFromWebVO(UsbLteSettingVO vo) {
        UsbLteSettingConfigOpenApiVO res = new UsbLteSettingConfigOpenApiVO();
        if (vo == null) {
            return res;
        }
        res.setPortId(vo.getPortUuid());
        res.setPortDescription(vo.getPortDesc());
        res.setConfigType(vo.getConfigType());
        res.setAutoConfig(AutoConfigOpenApiVO.buildFromWebVO(vo.getAutoConfig()));
        res.setManuallyConfig(ManuallyConfigOpenApiVO.buildFromWebVO(vo.getManuallyConfig()));
        res.setConnectionMode(vo.getConnectionMode());
        res.setPin(vo.getPin());
        res.setAuthType(vo.getAuthType());
        res.setMtuSize(vo.getMtuSize());
        res.setDnsEnable(vo.getDnsEnable());
        res.setDnsConfig(DnsConfigOpenApiVO.buildFromWebVO(vo.getDnsConfig()));
        res.setDhcpOptions(CollectionUtils.isEmpty((Collection)vo.getDhcpOptions()) ? new ArrayList<WanDhcpOptionOpenApiVO>() : vo.getDhcpOptions().stream().map(WanDhcpOptionOpenApiVO::buildFromWebVO).collect(Collectors.toList()));
        return res;
    }

    @Generated
    public String getPortId() {
        return this.portId;
    }

    @Generated
    public String getPortDescription() {
        return this.portDescription;
    }

    @Generated
    public Integer getConfigType() {
        return this.configType;
    }

    @Generated
    public AutoConfigOpenApiVO getAutoConfig() {
        return this.autoConfig;
    }

    @Generated
    public ManuallyConfigOpenApiVO getManuallyConfig() {
        return this.manuallyConfig;
    }

    @Generated
    public Integer getConnectionMode() {
        return this.connectionMode;
    }

    @Generated
    public String getPin() {
        return this.pin;
    }

    @Generated
    public Integer getAuthType() {
        return this.authType;
    }

    @Generated
    public Integer getMtuSize() {
        return this.mtuSize;
    }

    @Generated
    public Boolean getDnsEnable() {
        return this.dnsEnable;
    }

    @Generated
    public List<WanDhcpOptionOpenApiVO> getDhcpOptions() {
        return this.dhcpOptions;
    }

    @Generated
    public DnsConfigOpenApiVO getDnsConfig() {
        return this.dnsConfig;
    }

    @Generated
    public void setPortId(String portId) {
        this.portId = portId;
    }

    @Generated
    public void setPortDescription(String portDescription) {
        this.portDescription = portDescription;
    }

    @Generated
    public void setConfigType(Integer configType) {
        this.configType = configType;
    }

    @Generated
    public void setAutoConfig(AutoConfigOpenApiVO autoConfig) {
        this.autoConfig = autoConfig;
    }

    @Generated
    public void setManuallyConfig(ManuallyConfigOpenApiVO manuallyConfig) {
        this.manuallyConfig = manuallyConfig;
    }

    @Generated
    public void setConnectionMode(Integer connectionMode) {
        this.connectionMode = connectionMode;
    }

    @Generated
    public void setPin(String pin) {
        this.pin = pin;
    }

    @Generated
    public void setAuthType(Integer authType) {
        this.authType = authType;
    }

    @Generated
    public void setMtuSize(Integer mtuSize) {
        this.mtuSize = mtuSize;
    }

    @Generated
    public void setDnsEnable(Boolean dnsEnable) {
        this.dnsEnable = dnsEnable;
    }

    @Generated
    public void setDhcpOptions(List<WanDhcpOptionOpenApiVO> dhcpOptions) {
        this.dhcpOptions = dhcpOptions;
    }

    @Generated
    public void setDnsConfig(DnsConfigOpenApiVO dnsConfig) {
        this.dnsConfig = dnsConfig;
    }

    @Generated
    public String toString() {
        return "UsbLteSettingConfigOpenApiVO(portId=" + this.getPortId() + ", portDescription=" + this.getPortDescription() + ", configType=" + this.getConfigType() + ", autoConfig=" + this.getAutoConfig() + ", manuallyConfig=" + this.getManuallyConfig() + ", connectionMode=" + this.getConnectionMode() + ", pin=" + this.getPin() + ", authType=" + this.getAuthType() + ", mtuSize=" + this.getMtuSize() + ", dnsEnable=" + this.getDnsEnable() + ", dhcpOptions=" + this.getDhcpOptions() + ", dnsConfig=" + this.getDnsConfig() + ")";
    }
}

