/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.common.constant.G;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.DialupSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.DialupSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.LteWanSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@KeepClass
public class LteWanPortSettingOpenApiVO {
    @Schema(name="portUuId", description="Port UUID")
    @NotNull
    private String portId;
    @Schema(name="portDescription", description="Port description")
    private String portDescription;
    @Schema(name="portName", description="Port name")
    private String portName;
    @Schema(name="simCardUsed", description="The SIM card being used")
    private Integer simCardUsed;
    @Schema(name="status", description="0: unknown, 1: disconnected, 2:disconnecting, 3:connected, 4:connecting")
    @Range(min=0L, max=4L)
    private @Range(min=0L, max=4L) Integer status;
    @Schema(name="cardStatus", description="cardStatus: 0:no_sim, 1:unknown, 2:pin_lock, 3:pin_verified, 4:ready, 5:puk_lock, 6:blocked")
    private Integer cardStatus;
    @Schema(name="simPriority", description="Which SIM card is used first.")
    private Integer simPriority;
    @NotNull
    @Schema(name="mobileData", description="mobile data")
    private Boolean mobileData;
    @NotNull
    @Schema(name="dataRoaming", description="First SIM card's data roaming")
    private Boolean dataRoaming;
    @Range(max=6L)
    @NotNull
    @Schema(name="networkMode", description="First SIM card's networkMode: 1:3G Only, 2:4G Only, 3:4G Preferred, 4: 5G-NSA/4G, 5: 5G-SA, 6: 5G/4G/3G")
    private @Range(max=6L) @NotNull Integer networkMode;
    @Range(max=1L)
    @Schema(name="bandMode", description="First SIM card's bandMode: 0:auto, 1:manual, only for networkMode 4g Only and 4G Preferred")
    private @Range(max=1L) Integer bandMode;
    @Schema(name="bands", description="First SIM card's. Only for band mode manual")
    private List<String> bands;
    @Schema(name="bands5g", description="First SIM card's. Only for band mode manual")
    private List<String> bands5g;
    @NotNull
    @Valid
    @Schema(name="dialupSetting", description="First SIM card's dial-up setting")
    private DialupSettingOpenApiVO dialupSetting;
    @Schema(name="failoverTimeout", description="First SIM card's failoverTimeout. Set the dial-up timeout (100 to 3552 seconds). If the connection is not successfully established within the specified time, the gateway will use the other SIM card to connect to the internet.")
    private Integer failoverTimeout;
    @Schema(name="dataRoaming2", description="Second SIM card's data roaming")
    private Boolean dataRoaming2;
    @Schema(name="networkMode2", description="Second SIM card's networkMode: 1:3G Only, 2:4G Only, 3:4G Preferred4: 5G-NSA/4G, 5: 5G-SA, 6: 5G/4G/3G")
    private Integer networkMode2;
    @Schema(name="bandMode2", description="Second SIM card's bandMode: 0:auto, 1:manual, only for networkMode 4g Only and 4G Preferred")
    private Integer bandMode2;
    @Schema(name="bands2", description="Second SIM card's bands. Only for band mode manual")
    private List<String> bands2;
    @Schema(name="bands5g2", description="Second SIM card's. Only for band mode manual")
    private List<String> bands5g2;
    @Schema(name="dialupSetting2", description="Second SIM card's dial-up setting")
    private DialupSettingOpenApiVO dialupSetting2;
    @Schema(name="failoverTimeout2", description="Second SIM card's failoverTimeout. Set the dial-up timeout (100 to 3552 seconds). If the connection is not successfully established within the specified time, the gateway will use the other SIM card to connect to the internet.")
    private Integer failoverTimeout2;
    @Schema(name="supportNetworkMode", description="The network mode that the device can select.")
    private List<Integer> supportNetworkMode;

    public static LteWanPortSettingOpenApiVO fromWebVO(LteWanSettingVO vo) {
        LteWanPortSettingOpenApiVO openApiVO = new LteWanPortSettingOpenApiVO();
        openApiVO.setPortId(vo.getPortUuid());
        openApiVO.setPortName(vo.getPortName());
        openApiVO.setPortDescription(vo.getPortDesc());
        openApiVO.setMobileData(vo.getMobileData());
        openApiVO.setSupportNetworkMode(vo.getSupportNetworkMode());
        openApiVO.setSimPriority(vo.getSimPriority());
        Optional dialupSettingVOOptional = vo.getSingleDialUpSettingVO(G.a);
        if (dialupSettingVOOptional.isEmpty()) {
            return openApiVO;
        }
        DialupSettingVO dialupSettingVO = (DialupSettingVO)dialupSettingVOOptional.get();
        openApiVO.setDialupSetting(DialupSettingOpenApiVO.fromWebVO(dialupSettingVO));
        openApiVO.setDataRoaming(vo.getDataRoaming());
        openApiVO.setNetworkMode(dialupSettingVO.getNetworkMode());
        openApiVO.setBandMode(dialupSettingVO.getBandMode());
        if (Objects.equals(openApiVO.getBandMode(), 1)) {
            openApiVO.setBands(dialupSettingVO.getBands());
            openApiVO.setBands5g(dialupSettingVO.getBands5g());
        }
        openApiVO.setFailoverTimeout(dialupSettingVO.getFailoverTimeout());
        Optional sim2DialupSettingVOOptional = vo.getSingleDialUpSettingVO(G.b);
        if (sim2DialupSettingVOOptional.isEmpty()) {
            return openApiVO;
        }
        DialupSettingVO sim2DialupSettingVO = (DialupSettingVO)sim2DialupSettingVOOptional.get();
        openApiVO.setDialupSetting2(DialupSettingOpenApiVO.fromWebVO(dialupSettingVO));
        openApiVO.setDataRoaming2(sim2DialupSettingVO.getDataRoaming());
        openApiVO.setNetworkMode2(sim2DialupSettingVO.getNetworkMode());
        openApiVO.setBandMode2(sim2DialupSettingVO.getBandMode());
        if (Objects.equals(openApiVO.getBandMode2(), 1)) {
            openApiVO.setBands2(sim2DialupSettingVO.getBands());
            openApiVO.setBands5g2(sim2DialupSettingVO.getBands5g());
        }
        openApiVO.setFailoverTimeout2(sim2DialupSettingVO.getFailoverTimeout());
        return openApiVO;
    }

    public static LteWanSettingVO toWebVO(LteWanPortSettingOpenApiVO openApiVO) {
        DialupSettingVO dialupSettingVO;
        LteWanSettingVO result = new LteWanSettingVO();
        if (Objects.isNull(openApiVO)) {
            return result;
        }
        result.setPortName(openApiVO.getPortName());
        result.setPortUuid(openApiVO.getPortId());
        result.setPortDesc(openApiVO.getPortDescription());
        result.setStatus(openApiVO.getStatus());
        result.setCardStatus(openApiVO.getCardStatus());
        result.setMobileData(openApiVO.getMobileData());
        result.setNetworkMode(openApiVO.getNetworkMode());
        result.setBandMode(openApiVO.getBandMode());
        result.setBands(openApiVO.getBands());
        result.setBands5g(openApiVO.getBands5g());
        result.setDataRoaming(openApiVO.getDataRoaming());
        result.setSimCardUsed(openApiVO.getSimCardUsed());
        result.setSimPriority(openApiVO.getSimPriority());
        ArrayList<DialupSettingVO> dialUpSettings = new ArrayList<DialupSettingVO>();
        if (!Objects.isNull(openApiVO.getDialupSetting())) {
            dialupSettingVO = DialupSettingOpenApiVO.toWebVO(openApiVO.getDialupSetting());
            dialupSettingVO.setNetworkMode(openApiVO.getNetworkMode());
            dialupSettingVO.setBandMode(openApiVO.getBandMode());
            if (Objects.equals(openApiVO.getBandMode(), 1)) {
                dialupSettingVO.setBands(openApiVO.getBands());
                dialupSettingVO.setBands5g(openApiVO.getBands5g());
            }
            dialUpSettings.add(dialupSettingVO);
        }
        if (!Objects.isNull(openApiVO.getDialupSetting2())) {
            dialupSettingVO = DialupSettingOpenApiVO.toWebVO(openApiVO.getDialupSetting2());
            dialupSettingVO.setNetworkMode(openApiVO.getNetworkMode2());
            dialupSettingVO.setBandMode(openApiVO.getBandMode2());
            if (Objects.equals(openApiVO.getBandMode2(), 1)) {
                dialupSettingVO.setBands(openApiVO.getBands2());
                dialupSettingVO.setBands5g(openApiVO.getBands5g2());
            }
            dialUpSettings.add(dialupSettingVO);
        }
        result.setDialUpSettings(dialUpSettings);
        result.setSupportNetworkMode(openApiVO.getSupportNetworkMode());
        result.setSimPriority(openApiVO.getSimPriority());
        return result;
    }

    @Generated
    public String getPortId() {
        return this.portId;
    }

    @Generated
    public String getPortDescription() {
        return this.portDescription;
    }

    @Generated
    public String getPortName() {
        return this.portName;
    }

    @Generated
    public Integer getSimCardUsed() {
        return this.simCardUsed;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public Integer getCardStatus() {
        return this.cardStatus;
    }

    @Generated
    public Integer getSimPriority() {
        return this.simPriority;
    }

    @Generated
    public Boolean getMobileData() {
        return this.mobileData;
    }

    @Generated
    public Boolean getDataRoaming() {
        return this.dataRoaming;
    }

    @Generated
    public Integer getNetworkMode() {
        return this.networkMode;
    }

    @Generated
    public Integer getBandMode() {
        return this.bandMode;
    }

    @Generated
    public List<String> getBands() {
        return this.bands;
    }

    @Generated
    public List<String> getBands5g() {
        return this.bands5g;
    }

    @Generated
    public DialupSettingOpenApiVO getDialupSetting() {
        return this.dialupSetting;
    }

    @Generated
    public Integer getFailoverTimeout() {
        return this.failoverTimeout;
    }

    @Generated
    public Boolean getDataRoaming2() {
        return this.dataRoaming2;
    }

    @Generated
    public Integer getNetworkMode2() {
        return this.networkMode2;
    }

    @Generated
    public Integer getBandMode2() {
        return this.bandMode2;
    }

    @Generated
    public List<String> getBands2() {
        return this.bands2;
    }

    @Generated
    public List<String> getBands5g2() {
        return this.bands5g2;
    }

    @Generated
    public DialupSettingOpenApiVO getDialupSetting2() {
        return this.dialupSetting2;
    }

    @Generated
    public Integer getFailoverTimeout2() {
        return this.failoverTimeout2;
    }

    @Generated
    public List<Integer> getSupportNetworkMode() {
        return this.supportNetworkMode;
    }

    @Generated
    public void setPortId(String portId) {
        this.portId = portId;
    }

    @Generated
    public void setPortDescription(String portDescription) {
        this.portDescription = portDescription;
    }

    @Generated
    public void setPortName(String portName) {
        this.portName = portName;
    }

    @Generated
    public void setSimCardUsed(Integer simCardUsed) {
        this.simCardUsed = simCardUsed;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setCardStatus(Integer cardStatus) {
        this.cardStatus = cardStatus;
    }

    @Generated
    public void setSimPriority(Integer simPriority) {
        this.simPriority = simPriority;
    }

    @Generated
    public void setMobileData(Boolean mobileData) {
        this.mobileData = mobileData;
    }

    @Generated
    public void setDataRoaming(Boolean dataRoaming) {
        this.dataRoaming = dataRoaming;
    }

    @Generated
    public void setNetworkMode(Integer networkMode) {
        this.networkMode = networkMode;
    }

    @Generated
    public void setBandMode(Integer bandMode) {
        this.bandMode = bandMode;
    }

    @Generated
    public void setBands(List<String> bands) {
        this.bands = bands;
    }

    @Generated
    public void setBands5g(List<String> bands5g) {
        this.bands5g = bands5g;
    }

    @Generated
    public void setDialupSetting(DialupSettingOpenApiVO dialupSetting) {
        this.dialupSetting = dialupSetting;
    }

    @Generated
    public void setFailoverTimeout(Integer failoverTimeout) {
        this.failoverTimeout = failoverTimeout;
    }

    @Generated
    public void setDataRoaming2(Boolean dataRoaming2) {
        this.dataRoaming2 = dataRoaming2;
    }

    @Generated
    public void setNetworkMode2(Integer networkMode2) {
        this.networkMode2 = networkMode2;
    }

    @Generated
    public void setBandMode2(Integer bandMode2) {
        this.bandMode2 = bandMode2;
    }

    @Generated
    public void setBands2(List<String> bands2) {
        this.bands2 = bands2;
    }

    @Generated
    public void setBands5g2(List<String> bands5g2) {
        this.bands5g2 = bands5g2;
    }

    @Generated
    public void setDialupSetting2(DialupSettingOpenApiVO dialupSetting2) {
        this.dialupSetting2 = dialupSetting2;
    }

    @Generated
    public void setFailoverTimeout2(Integer failoverTimeout2) {
        this.failoverTimeout2 = failoverTimeout2;
    }

    @Generated
    public void setSupportNetworkMode(List<Integer> supportNetworkMode) {
        this.supportNetworkMode = supportNetworkMode;
    }

    @Generated
    public String toString() {
        return "LteWanPortSettingOpenApiVO(portId=" + this.getPortId() + ", portDescription=" + this.getPortDescription() + ", portName=" + this.getPortName() + ", simCardUsed=" + this.getSimCardUsed() + ", status=" + this.getStatus() + ", cardStatus=" + this.getCardStatus() + ", simPriority=" + this.getSimPriority() + ", mobileData=" + this.getMobileData() + ", dataRoaming=" + this.getDataRoaming() + ", networkMode=" + this.getNetworkMode() + ", bandMode=" + this.getBandMode() + ", bands=" + this.getBands() + ", bands5g=" + this.getBands5g() + ", dialupSetting=" + this.getDialupSetting() + ", failoverTimeout=" + this.getFailoverTimeout() + ", dataRoaming2=" + this.getDataRoaming2() + ", networkMode2=" + this.getNetworkMode2() + ", bandMode2=" + this.getBandMode2() + ", bands2=" + this.getBands2() + ", bands5g2=" + this.getBands5g2() + ", dialupSetting2=" + this.getDialupSetting2() + ", failoverTimeout2=" + this.getFailoverTimeout2() + ", supportNetworkMode=" + this.getSupportNetworkMode() + ")";
    }
}

