/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.common.constant.G;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.DialupSettingOpenApiV2VO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.DialupSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.LteWanSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@KeepClass
public class LteWanPortSettingOpenApiV2VO {
    @Schema(name="portUuid", description="Port Uuid")
    @NotNull
    private String portUuid;
    @Schema(name="portDesc", description="Port description should contain 1 to 32 characters.")
    private String portDesc;
    @Schema(name="portName", description="Port name")
    private String portName;
    @Schema(name="simCardUsed", description="The SIM card being used")
    private Integer simCardUsed;
    @Schema(name="status", description="0: unknown, 1: disconnected, 2:disconnecting, 3:connected, 4:connecting")
    @Range(min=0L, max=4L)
    private @Range(min=0L, max=4L) Integer status;
    @Schema(name="cardStatus", description="cardStatus: 0:no_sim, 1:unknown, 2:pin_lock, 3:pin_verified, 4:ready, 5:puk_lock, 6:blocked")
    private Integer cardStatus;
    @Schema(name="simPriority", description="Which SIM card is used first.")
    private Integer simPriority;
    @NotNull
    @Schema(name="mobileData", description="mobile data")
    private Boolean mobileData;
    @NotNull
    @Valid
    @Schema(name="dialupSetting", description="First SIM card's dial-up setting")
    private DialupSettingOpenApiV2VO dialupSetting;
    @Valid
    @Schema(name="dialupSetting2", description="Second SIM card's dial-up setting")
    private DialupSettingOpenApiV2VO dialupSetting2;
    @Schema(name="supportNetworkMode", description="The network mode that the device can select.")
    private List<Integer> supportNetworkMode;
    @Schema(name="supportDualSim", description="Support dual sim card or not.")
    private Integer supportDualSim;

    public static LteWanPortSettingOpenApiV2VO fromWebVO(LteWanSettingVO vo) {
        LteWanPortSettingOpenApiV2VO openApiVO = new LteWanPortSettingOpenApiV2VO();
        openApiVO.setPortUuid(vo.getPortUuid());
        openApiVO.setPortName(vo.getPortName());
        openApiVO.setPortDesc(vo.getPortDesc());
        openApiVO.setMobileData(vo.getMobileData());
        openApiVO.setSupportNetworkMode(vo.getSupportNetworkMode());
        openApiVO.setSimPriority(vo.getSimPriority());
        openApiVO.setSimCardUsed(vo.getSimCardUsed());
        openApiVO.setStatus(vo.getStatus());
        openApiVO.setCardStatus(vo.getCardStatus());
        openApiVO.setSupportDualSim(vo.getSupportDualSim());
        Optional dialupSettingVOOptional = vo.getSingleDialUpSettingVO(G.a);
        if (dialupSettingVOOptional.isEmpty()) {
            return openApiVO;
        }
        DialupSettingVO dialupSettingVO = (DialupSettingVO)dialupSettingVOOptional.get();
        openApiVO.setDialupSetting(DialupSettingOpenApiV2VO.fromWebVO(dialupSettingVO));
        Optional sim2DialupSettingVOOptional = vo.getSingleDialUpSettingVO(G.b);
        if (sim2DialupSettingVOOptional.isEmpty()) {
            return openApiVO;
        }
        DialupSettingVO sim2DialupSettingVO = (DialupSettingVO)sim2DialupSettingVOOptional.get();
        openApiVO.setDialupSetting2(DialupSettingOpenApiV2VO.fromWebVO(sim2DialupSettingVO));
        return openApiVO;
    }

    @Generated
    public String getPortUuid() {
        return this.portUuid;
    }

    @Generated
    public String getPortDesc() {
        return this.portDesc;
    }

    @Generated
    public String getPortName() {
        return this.portName;
    }

    @Generated
    public Integer getSimCardUsed() {
        return this.simCardUsed;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public Integer getCardStatus() {
        return this.cardStatus;
    }

    @Generated
    public Integer getSimPriority() {
        return this.simPriority;
    }

    @Generated
    public Boolean getMobileData() {
        return this.mobileData;
    }

    @Generated
    public DialupSettingOpenApiV2VO getDialupSetting() {
        return this.dialupSetting;
    }

    @Generated
    public DialupSettingOpenApiV2VO getDialupSetting2() {
        return this.dialupSetting2;
    }

    @Generated
    public List<Integer> getSupportNetworkMode() {
        return this.supportNetworkMode;
    }

    @Generated
    public Integer getSupportDualSim() {
        return this.supportDualSim;
    }

    @Generated
    public void setPortUuid(String portUuid) {
        this.portUuid = portUuid;
    }

    @Generated
    public void setPortDesc(String portDesc) {
        this.portDesc = portDesc;
    }

    @Generated
    public void setPortName(String portName) {
        this.portName = portName;
    }

    @Generated
    public void setSimCardUsed(Integer simCardUsed) {
        this.simCardUsed = simCardUsed;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setCardStatus(Integer cardStatus) {
        this.cardStatus = cardStatus;
    }

    @Generated
    public void setSimPriority(Integer simPriority) {
        this.simPriority = simPriority;
    }

    @Generated
    public void setMobileData(Boolean mobileData) {
        this.mobileData = mobileData;
    }

    @Generated
    public void setDialupSetting(DialupSettingOpenApiV2VO dialupSetting) {
        this.dialupSetting = dialupSetting;
    }

    @Generated
    public void setDialupSetting2(DialupSettingOpenApiV2VO dialupSetting2) {
        this.dialupSetting2 = dialupSetting2;
    }

    @Generated
    public void setSupportNetworkMode(List<Integer> supportNetworkMode) {
        this.supportNetworkMode = supportNetworkMode;
    }

    @Generated
    public void setSupportDualSim(Integer supportDualSim) {
        this.supportDualSim = supportDualSim;
    }

    @Generated
    public String toString() {
        return "LteWanPortSettingOpenApiV2VO(portUuid=" + this.getPortUuid() + ", portDesc=" + this.getPortDesc() + ", portName=" + this.getPortName() + ", simCardUsed=" + this.getSimCardUsed() + ", status=" + this.getStatus() + ", cardStatus=" + this.getCardStatus() + ", simPriority=" + this.getSimPriority() + ", mobileData=" + this.getMobileData() + ", dialupSetting=" + this.getDialupSetting() + ", dialupSetting2=" + this.getDialupSetting2() + ", supportNetworkMode=" + this.getSupportNetworkMode() + ", supportDualSim=" + this.getSupportDualSim() + ")";
    }
}

