/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.DialupSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.DialupSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.InternetPortVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.LteWanSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@KeepClass
public class LteWanPortSettingConfigOpenApiVO {
    @Schema(name="portId", description="Port ID")
    @NotNull
    private String portId;
    @Schema(name="portDescription", description="Port description should contain 1 to 32 characters.")
    private String portDescription;
    @Schema(name="simPriority", description="Set which SIM card is used first. SIM Priority takes effect only when the device is powered on and the priority is changed. If only one SIM card is inserted, this card is used by default.")
    private Integer simPriority;
    @NotNull
    @Schema(name="mobileData", description="mobile data")
    private Boolean mobileData;
    @NotNull
    @Schema(name="dataRoaming", description="First SIM card's data roaming")
    private Boolean dataRoaming;
    @Range(min=1L, max=6L)
    @NotNull
    @Schema(name="networkMode", description="First SIM card's networkMode: 1:3G Only, 2:4G Only, 3:4G Preferred4: 5G-NSA/4G, 5: 5G-SA, 6: 5G/4G/3G")
    private @Range(min=1L, max=6L) @NotNull Integer networkMode;
    @Range(max=1L)
    @Schema(name="bandMode", description="First SIM card's bandMode: 0:auto, 1:manual, only for networkMode 4g Only and 4G Preferred")
    private @Range(max=1L) Integer bandMode;
    @Schema(name="bands", description="First SIM card's bands. Only for band mode manual")
    private List<String> bands;
    @Schema(name="bands5g", description="First SIM card's. Only for band mode manual")
    private List<String> bands5g;
    @NotNull
    @Valid
    @Schema(name="dialupSetting", description="First SIM card's dial-up setting")
    private DialupSettingOpenApiVO dialupSetting;
    @Schema(name="failoverTimeout", description="First SIM card's failoverTimeout. Set the dial-up timeout (100 to 3552 seconds). If the connection is not successfully established within the specified time, the gateway will use the other SIM card to connect to the internet.")
    @Range(min=100L, max=3552L)
    private @Range(min=100L, max=3552L) Integer failoverTimeout;
    @Schema(name="dataRoaming2", description="Second SIM card's data roaming")
    private Boolean dataRoaming2;
    @Range(min=1L, max=6L)
    @Schema(name="networkMode2", description="Second SIM card's networkMode: 1:3G Only, 2:4G Only, 3:4G Preferred4: 5G-NSA/4G, 5: 5G-SA, 6: 5G/4G/3G")
    private @Range(min=1L, max=6L) Integer networkMode2;
    @Range(max=1L)
    @Schema(name="bandMode2", description="Second SIM card's bandMode: 0:auto, 1:manual, only for networkMode 4g Only and 4G Preferred")
    private @Range(max=1L) Integer bandMode2;
    @Schema(name="bands2", description="Second SIM card's bands. Only for band mode manual")
    private List<String> bands2;
    @Schema(name="bands5g2", description="Second SIM card's. Only for band mode manual")
    private List<String> bands5g2;
    @Valid
    @Schema(name="dialupSetting2", description="Second SIM card's dial-up setting")
    private DialupSettingOpenApiVO dialupSetting2;
    @Schema(name="failoverTimeout2", description="Second SIM card's failoverTimeout. Set the dial-up timeout (100 to 3552 seconds). If the connection is not successfully established within the specified time, the gateway will use the other SIM card to connect to the internet.")
    @Range(min=100L, max=3552L)
    private @Range(min=100L, max=3552L) Integer failoverTimeout2;

    public static InternetPortVO toWebVO(LteWanPortSettingConfigOpenApiVO openApiVO) {
        InternetPortVO internetPortVO = new InternetPortVO();
        internetPortVO.setType(Integer.valueOf(2));
        LteWanSettingVO lteWanSettingVO = new LteWanSettingVO();
        lteWanSettingVO.setPortUuid(openApiVO.getPortId());
        lteWanSettingVO.setPortDesc(openApiVO.getPortDescription());
        lteWanSettingVO.setMobileData(openApiVO.getMobileData());
        lteWanSettingVO.setSimPriority(openApiVO.getSimPriority());
        ArrayList<DialupSettingVO> dialupSettingVOS = new ArrayList<DialupSettingVO>(2);
        DialupSettingVO dialupSettingVO = new DialupSettingVO();
        if (openApiVO.getDialupSetting() != null) {
            dialupSettingVO = DialupSettingOpenApiVO.toWebVO(openApiVO.getDialupSetting());
        }
        dialupSettingVO.setDataRoaming(openApiVO.getDataRoaming());
        dialupSettingVO.setNetworkMode(openApiVO.getNetworkMode());
        dialupSettingVO.setBandMode(openApiVO.getBandMode());
        if (Objects.equals(dialupSettingVO.getBandMode(), 1)) {
            dialupSettingVO.setBands(openApiVO.getBands());
            dialupSettingVO.setBands5g(openApiVO.getBands5g());
        }
        dialupSettingVO.setFailoverTimeout(openApiVO.getFailoverTimeout());
        dialupSettingVOS.add(dialupSettingVO);
        if (openApiVO.getDialupSetting2() == null || openApiVO.getNetworkMode2() == null || openApiVO.getBandMode2() == null) {
            lteWanSettingVO.setDialUpSettings(dialupSettingVOS);
            internetPortVO.setLteWanSetting(lteWanSettingVO);
            return internetPortVO;
        }
        DialupSettingVO sim2DialupSettingVO = new DialupSettingVO();
        if (openApiVO.getDialupSetting2() != null) {
            sim2DialupSettingVO = DialupSettingOpenApiVO.toWebVO(openApiVO.getDialupSetting2());
        }
        sim2DialupSettingVO.setDataRoaming(openApiVO.getDataRoaming2());
        sim2DialupSettingVO.setNetworkMode(openApiVO.getNetworkMode2());
        sim2DialupSettingVO.setBandMode(openApiVO.getBandMode2());
        if (Objects.equals(sim2DialupSettingVO.getBandMode(), 1)) {
            sim2DialupSettingVO.setBands(openApiVO.getBands2());
            sim2DialupSettingVO.setBands5g(openApiVO.getBands5g2());
        }
        sim2DialupSettingVO.setFailoverTimeout(openApiVO.getFailoverTimeout2());
        dialupSettingVOS.add(sim2DialupSettingVO);
        lteWanSettingVO.setDialUpSettings(dialupSettingVOS);
        internetPortVO.setLteWanSetting(lteWanSettingVO);
        return internetPortVO;
    }

    @Generated
    public String getPortId() {
        return this.portId;
    }

    @Generated
    public String getPortDescription() {
        return this.portDescription;
    }

    @Generated
    public Integer getSimPriority() {
        return this.simPriority;
    }

    @Generated
    public Boolean getMobileData() {
        return this.mobileData;
    }

    @Generated
    public Boolean getDataRoaming() {
        return this.dataRoaming;
    }

    @Generated
    public Integer getNetworkMode() {
        return this.networkMode;
    }

    @Generated
    public Integer getBandMode() {
        return this.bandMode;
    }

    @Generated
    public List<String> getBands() {
        return this.bands;
    }

    @Generated
    public List<String> getBands5g() {
        return this.bands5g;
    }

    @Generated
    public DialupSettingOpenApiVO getDialupSetting() {
        return this.dialupSetting;
    }

    @Generated
    public Integer getFailoverTimeout() {
        return this.failoverTimeout;
    }

    @Generated
    public Boolean getDataRoaming2() {
        return this.dataRoaming2;
    }

    @Generated
    public Integer getNetworkMode2() {
        return this.networkMode2;
    }

    @Generated
    public Integer getBandMode2() {
        return this.bandMode2;
    }

    @Generated
    public List<String> getBands2() {
        return this.bands2;
    }

    @Generated
    public List<String> getBands5g2() {
        return this.bands5g2;
    }

    @Generated
    public DialupSettingOpenApiVO getDialupSetting2() {
        return this.dialupSetting2;
    }

    @Generated
    public Integer getFailoverTimeout2() {
        return this.failoverTimeout2;
    }

    @Generated
    public void setPortId(String portId) {
        this.portId = portId;
    }

    @Generated
    public void setPortDescription(String portDescription) {
        this.portDescription = portDescription;
    }

    @Generated
    public void setSimPriority(Integer simPriority) {
        this.simPriority = simPriority;
    }

    @Generated
    public void setMobileData(Boolean mobileData) {
        this.mobileData = mobileData;
    }

    @Generated
    public void setDataRoaming(Boolean dataRoaming) {
        this.dataRoaming = dataRoaming;
    }

    @Generated
    public void setNetworkMode(Integer networkMode) {
        this.networkMode = networkMode;
    }

    @Generated
    public void setBandMode(Integer bandMode) {
        this.bandMode = bandMode;
    }

    @Generated
    public void setBands(List<String> bands) {
        this.bands = bands;
    }

    @Generated
    public void setBands5g(List<String> bands5g) {
        this.bands5g = bands5g;
    }

    @Generated
    public void setDialupSetting(DialupSettingOpenApiVO dialupSetting) {
        this.dialupSetting = dialupSetting;
    }

    @Generated
    public void setFailoverTimeout(Integer failoverTimeout) {
        this.failoverTimeout = failoverTimeout;
    }

    @Generated
    public void setDataRoaming2(Boolean dataRoaming2) {
        this.dataRoaming2 = dataRoaming2;
    }

    @Generated
    public void setNetworkMode2(Integer networkMode2) {
        this.networkMode2 = networkMode2;
    }

    @Generated
    public void setBandMode2(Integer bandMode2) {
        this.bandMode2 = bandMode2;
    }

    @Generated
    public void setBands2(List<String> bands2) {
        this.bands2 = bands2;
    }

    @Generated
    public void setBands5g2(List<String> bands5g2) {
        this.bands5g2 = bands5g2;
    }

    @Generated
    public void setDialupSetting2(DialupSettingOpenApiVO dialupSetting2) {
        this.dialupSetting2 = dialupSetting2;
    }

    @Generated
    public void setFailoverTimeout2(Integer failoverTimeout2) {
        this.failoverTimeout2 = failoverTimeout2;
    }

    @Generated
    public String toString() {
        return "LteWanPortSettingConfigOpenApiVO(portId=" + this.getPortId() + ", portDescription=" + this.getPortDescription() + ", simPriority=" + this.getSimPriority() + ", mobileData=" + this.getMobileData() + ", dataRoaming=" + this.getDataRoaming() + ", networkMode=" + this.getNetworkMode() + ", bandMode=" + this.getBandMode() + ", bands=" + this.getBands() + ", bands5g=" + this.getBands5g() + ", dialupSetting=" + this.getDialupSetting() + ", failoverTimeout=" + this.getFailoverTimeout() + ", dataRoaming2=" + this.getDataRoaming2() + ", networkMode2=" + this.getNetworkMode2() + ", bandMode2=" + this.getBandMode2() + ", bands2=" + this.getBands2() + ", bands5g2=" + this.getBands5g2() + ", dialupSetting2=" + this.getDialupSetting2() + ", failoverTimeout2=" + this.getFailoverTimeout2() + ")";
    }
}

