/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.DialupSettingOpenApiV2VO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.DialupSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.InternetPortVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.LteWanSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import lombok.Generated;

@KeepClass
public class LteWanPortSettingConfigOpenApiV2VO {
    @Schema(name="portUuid", description="Port Uuid")
    @NotNull
    private String portUuid;
    @Schema(name="portDesc", description="Port description should contain 1 to 32 characters.")
    private String portDesc;
    @Schema(name="simPriority", description="Set which SIM card is used first. SIM Priority takes effect only when the device is powered on and the priority is changed. If only one SIM card is inserted, this card is used by default.")
    private Integer simPriority;
    @NotNull
    @Schema(name="mobileData", description="mobile data")
    private Boolean mobileData;
    @NotNull
    @Valid
    @Schema(name="dialupSetting", description="First SIM card's dial-up setting")
    private DialupSettingOpenApiV2VO dialupSetting;
    @Valid
    @Schema(name="dialupSetting2", description="Second SIM card's dial-up setting")
    private DialupSettingOpenApiV2VO dialupSetting2;

    public static InternetPortVO toWebVO(LteWanPortSettingConfigOpenApiV2VO openApiVO) {
        InternetPortVO internetPortVO = new InternetPortVO();
        internetPortVO.setType(Integer.valueOf(2));
        LteWanSettingVO lteWanSettingVO = new LteWanSettingVO();
        lteWanSettingVO.setPortUuid(openApiVO.getPortUuid());
        lteWanSettingVO.setPortDesc(openApiVO.getPortDesc());
        lteWanSettingVO.setMobileData(openApiVO.getMobileData());
        lteWanSettingVO.setSimPriority(openApiVO.getSimPriority());
        ArrayList<DialupSettingVO> dialupSettingVOS = new ArrayList<DialupSettingVO>(2);
        DialupSettingVO dialupSettingVO = new DialupSettingVO();
        if (openApiVO.getDialupSetting() != null) {
            dialupSettingVO = DialupSettingOpenApiV2VO.toWebVO(openApiVO.getDialupSetting());
        }
        dialupSettingVOS.add(dialupSettingVO);
        if (openApiVO.getDialupSetting2() == null) {
            lteWanSettingVO.setDialUpSettings(dialupSettingVOS);
            internetPortVO.setLteWanSetting(lteWanSettingVO);
            return internetPortVO;
        }
        DialupSettingVO sim2DialupSettingVO = DialupSettingOpenApiV2VO.toWebVO(openApiVO.getDialupSetting2());
        dialupSettingVOS.add(sim2DialupSettingVO);
        lteWanSettingVO.setDialUpSettings(dialupSettingVOS);
        internetPortVO.setLteWanSetting(lteWanSettingVO);
        return internetPortVO;
    }

    @Generated
    public String getPortUuid() {
        return this.portUuid;
    }

    @Generated
    public String getPortDesc() {
        return this.portDesc;
    }

    @Generated
    public Integer getSimPriority() {
        return this.simPriority;
    }

    @Generated
    public Boolean getMobileData() {
        return this.mobileData;
    }

    @Generated
    public DialupSettingOpenApiV2VO getDialupSetting() {
        return this.dialupSetting;
    }

    @Generated
    public DialupSettingOpenApiV2VO getDialupSetting2() {
        return this.dialupSetting2;
    }

    @Generated
    public void setPortUuid(String portUuid) {
        this.portUuid = portUuid;
    }

    @Generated
    public void setPortDesc(String portDesc) {
        this.portDesc = portDesc;
    }

    @Generated
    public void setSimPriority(Integer simPriority) {
        this.simPriority = simPriority;
    }

    @Generated
    public void setMobileData(Boolean mobileData) {
        this.mobileData = mobileData;
    }

    @Generated
    public void setDialupSetting(DialupSettingOpenApiV2VO dialupSetting) {
        this.dialupSetting = dialupSetting;
    }

    @Generated
    public void setDialupSetting2(DialupSettingOpenApiV2VO dialupSetting2) {
        this.dialupSetting2 = dialupSetting2;
    }

    @Generated
    public String toString() {
        return "LteWanPortSettingConfigOpenApiV2VO(portUuid=" + this.getPortUuid() + ", portDesc=" + this.getPortDesc() + ", simPriority=" + this.getSimPriority() + ", mobileData=" + this.getMobileData() + ", dialupSetting=" + this.getDialupSetting() + ", dialupSetting2=" + this.getDialupSetting2() + ")";
    }
}

