/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DhcpGuardOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DhcpOptionOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DhcpRangeOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.Dhcpv6GuardOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.Dhcpv6OpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.RouteAdvertisementOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.DhcpSettingsTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.LanNetworkIpv6ConfigTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.SlaacTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpGuardVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpOptionVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpRangeVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpSettingsVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.Dhcpv6GuardVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.Dhcpv6VO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.LanNetworkIpv6ConfigVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.LanNetworkVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.RouteAdvertisementVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.SlaacVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class LanNetworkTemplateQueryOpenApiV2VO {
    @Schema(name="id", description="LAN network ID")
    private String id;
    @JsonProperty(value="primary")
    @Schema(name="primary", description="Primary")
    private Boolean primary;
    @NotNull
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters")
    @Schema(name="name", description="LAN network name should contain 1 to 128 characters.")
    private @NotNull @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters") String name;
    @NotNull
    @Schema(name="purpose", description="LAN network purpose should be a value as follows: 0: VLAN; 1: interface")
    @Range(min=0L, max=1L)
    private @NotNull @Range(min=0L, max=1L) Integer purpose;
    @Schema(name="interfaceIds", description="Gateway LAN port IDs (acquired from \"Check WAN/LAN status\")")
    private List<String> interfaceIds;
    @Range(min=0L, max=1L)
    @Schema(name="vlanType", description="When purpose is interface, VLANType should be a value as follows: 0: Single; 1: Multiple")
    private @Range(min=0L, max=1L) Integer vlanType;
    @Pattern(regexp="^[\\d|\\d-\\d]+(,[\\d|\\d-\\d]+)*$", message="Parameter [vlans] should be like '2-100,200'.")
    @Schema(name="vlans", description="When purpose is interface and VLANType is 1, batch create VLANs. VLAN format: 200, 1-100.")
    private @Pattern(regexp="^[\\d|\\d-\\d]+(,[\\d|\\d-\\d]+)*$", message="Parameter [vlans] should be like '2-100,200'.") String vlans;
    @Range(min=1L, max=4090L, message="Value of vlan is from 1 to 4090.")
    @Schema(name="vlan", description="When purpose is \"VLAN\" or purpose is \"interface\" and VLANType is 0, vlan should be within the range of 1-4090.")
    private @Range(min=1L, max=4090L, message="Value of vlan is from 1 to 4090.") Integer vlan;
    @Schema(name="application", description="Effective device type should be a value as follows: 0: Gateway and Switch; 1: Switch")
    private Integer application;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30))\\b", message="Parameter [gatewaySubnet] Invalid.")
    @Schema(name="gatewaySubnet", description="When purpose is interface, gateway subnet is needed. Format: IP/Mask")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30))\\b", message="Parameter [gatewaySubnet] Invalid.") String gatewaySubnet;
    @Valid
    @Schema(name="dhcpSettingsVO", description="Configure DHCP settings")
    private DhcpSettingsTemplateOpenApiVO dhcpSettingsVO;
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Enter the valid domain name. For example, www.omadanetworks.com.")
    @Schema(name="domain", description="The domain of this network")
    private @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Enter the valid domain name. For example, www.omadanetworks.com.") String domain;
    @NotNull(message="Parameter [igmpSnoopEnable] should not be null.")
    @Schema(name="igmpSnoopEnable", description="Enable IGMP snooping")
    private @NotNull(message="Parameter [igmpSnoopEnable] should not be null.") Boolean igmpSnoopEnable;
    @Schema(name="mldSnoopEnable", description="Enable MLD snooping")
    private Boolean mldSnoopEnable;
    @Schema(name="dhcpL2RelayEnable", description="The switch of DHCP L2 relay")
    private Boolean dhcpL2RelayEnable;
    @Valid
    @Schema(name="dhcpGuard", description="Legal DHCP Server")
    private DhcpGuardOpenApiVO dhcpGuard;
    @Schema(name="dhcpv6Guard", description="Legal DHCPv6 Server")
    private Dhcpv6GuardOpenApiVO dhcpv6Guard;
    @Schema(name="portal", description="Show portal is enabled or not")
    private Boolean portal;
    @Schema(name="portalId", description="Show portal ID")
    private String portalId;
    @Schema(name="portalName", description="Show related portal name")
    private String portalName;
    @Schema(name="accessControlRule", description="Show AccessControlRule is enabled or not")
    private Boolean accessControlRule;
    @Schema(name="rateLimit", description="Show RateLimit is enabled or not")
    private Boolean rateLimit;
    @Valid
    @Schema(name="lanNeworkIpv6Config", description="LAN network IPv6 config")
    private LanNetworkIpv6ConfigTemplateOpenApiVO lanNetworkIpv6Config;
    @Schema(name="allLan", description="When Internet pre-config is closed or Internet pre-config is Universal, allLAN is \"true\"; after adopting gateway, allLAN is \"false\".")
    private Boolean allLan;

    public static LanNetworkTemplateQueryOpenApiV2VO buildByWebVO(LanNetworkVO lanNetworkVO) {
        LanNetworkTemplateQueryOpenApiV2VO lanNetworkTemplateQueryOpenApiV2VO = new LanNetworkTemplateQueryOpenApiV2VO();
        lanNetworkTemplateQueryOpenApiV2VO.setId(lanNetworkVO.getId());
        lanNetworkTemplateQueryOpenApiV2VO.setPrimary(lanNetworkVO.getPrimary());
        lanNetworkTemplateQueryOpenApiV2VO.setName(lanNetworkVO.getName());
        lanNetworkTemplateQueryOpenApiV2VO.setPurpose(LanNetworkTemplateQueryOpenApiV2VO.buildPurpose(lanNetworkVO.getPurpose()));
        lanNetworkTemplateQueryOpenApiV2VO.setInterfaceIds(lanNetworkVO.getInterfaceIds());
        lanNetworkTemplateQueryOpenApiV2VO.setVlanType(lanNetworkVO.getVlanType());
        lanNetworkTemplateQueryOpenApiV2VO.setVlans(lanNetworkVO.getVlans());
        lanNetworkTemplateQueryOpenApiV2VO.setApplication(lanNetworkVO.getApplication());
        lanNetworkTemplateQueryOpenApiV2VO.setVlan(lanNetworkVO.getVlan());
        lanNetworkTemplateQueryOpenApiV2VO.setGatewaySubnet(lanNetworkVO.getGatewaySubnet());
        lanNetworkTemplateQueryOpenApiV2VO.setDhcpSettingsVO(LanNetworkTemplateQueryOpenApiV2VO.buildDhcpSettingsVO(lanNetworkVO.getDhcpSettings()));
        lanNetworkTemplateQueryOpenApiV2VO.setDomain(lanNetworkVO.getDomain());
        lanNetworkTemplateQueryOpenApiV2VO.setIgmpSnoopEnable(lanNetworkVO.getIgmpSnoopEnable());
        lanNetworkTemplateQueryOpenApiV2VO.setMldSnoopEnable(lanNetworkVO.getMldSnoopEnable());
        lanNetworkTemplateQueryOpenApiV2VO.setDhcpv6Guard(LanNetworkTemplateQueryOpenApiV2VO.buildDhcpv6Guard(lanNetworkVO.getDhcpv6Guard()));
        lanNetworkTemplateQueryOpenApiV2VO.setDhcpL2RelayEnable(lanNetworkVO.getDhcpL2RelayEnable());
        lanNetworkTemplateQueryOpenApiV2VO.setDhcpGuard(LanNetworkTemplateQueryOpenApiV2VO.buildDhcpGuard(lanNetworkVO.getDhcpGuard()));
        lanNetworkTemplateQueryOpenApiV2VO.setPortal(lanNetworkVO.getPortal());
        lanNetworkTemplateQueryOpenApiV2VO.setPortalId(lanNetworkVO.getPortalId());
        lanNetworkTemplateQueryOpenApiV2VO.setPortalName(lanNetworkVO.getPortalName());
        lanNetworkTemplateQueryOpenApiV2VO.setAccessControlRule(lanNetworkVO.getAccessControlRule());
        lanNetworkTemplateQueryOpenApiV2VO.setRateLimit(lanNetworkVO.getRateLimit());
        lanNetworkTemplateQueryOpenApiV2VO.setLanNetworkIpv6Config(LanNetworkTemplateQueryOpenApiV2VO.buildLanNetworkIpv6Config(lanNetworkVO.getLanNetworkIpv6Config()));
        lanNetworkTemplateQueryOpenApiV2VO.setAllLan(lanNetworkVO.getAllLan());
        return lanNetworkTemplateQueryOpenApiV2VO;
    }

    private static Integer buildPurpose(String purposeVO) {
        if (T.a((String)purposeVO)) {
            return null;
        }
        switch (purposeVO) {
            case "vlan": {
                return 0;
            }
            case "interface": {
                return 1;
            }
        }
        return null;
    }

    private static LanNetworkIpv6ConfigTemplateOpenApiVO buildLanNetworkIpv6Config(LanNetworkIpv6ConfigVO lanNetworkIpv6Config) {
        if (Objects.isNull(lanNetworkIpv6Config)) {
            return null;
        }
        LanNetworkIpv6ConfigTemplateOpenApiVO lanNetworkIpv6ConfigOpenApiVO = new LanNetworkIpv6ConfigTemplateOpenApiVO();
        lanNetworkIpv6ConfigOpenApiVO.setProto(LanNetworkTemplateQueryOpenApiV2VO.buildProto(lanNetworkIpv6Config.getProto()));
        lanNetworkIpv6ConfigOpenApiVO.setEnable(lanNetworkIpv6Config.getEnable());
        lanNetworkIpv6ConfigOpenApiVO.setDhcpv6(LanNetworkTemplateQueryOpenApiV2VO.buildDhcpv6(lanNetworkIpv6Config.getDhcpv6()));
        lanNetworkIpv6ConfigOpenApiVO.setSlaac(LanNetworkTemplateQueryOpenApiV2VO.buildSlaacOpenApiVO(lanNetworkIpv6Config.getSlaac()));
        lanNetworkIpv6ConfigOpenApiVO.setRdnss(LanNetworkTemplateQueryOpenApiV2VO.buildSlaacOpenApiVO(lanNetworkIpv6Config.getRdnss()));
        lanNetworkIpv6ConfigOpenApiVO.setRa(LanNetworkTemplateQueryOpenApiV2VO.buildRa(lanNetworkIpv6Config.getRa()));
        return lanNetworkIpv6ConfigOpenApiVO;
    }

    private static Integer buildProto(String proto) {
        if (T.a((String)proto)) {
            return 0;
        }
        switch (proto) {
            case "dhcpv6": {
                return 1;
            }
            case "slaac": {
                return 2;
            }
            case "rdnss": {
                return 3;
            }
            case "passthrough": {
                return 4;
            }
        }
        return 0;
    }

    private static RouteAdvertisementOpenApiVO buildRa(RouteAdvertisementVO ra) {
        if (Objects.isNull(ra)) {
            return null;
        }
        RouteAdvertisementOpenApiVO routeAdvertisementOpenApiVO = new RouteAdvertisementOpenApiVO();
        routeAdvertisementOpenApiVO.setEnable(ra.getEnable());
        routeAdvertisementOpenApiVO.setPreference(ra.getPreference());
        routeAdvertisementOpenApiVO.setValidLifetime(ra.getValidLifetime());
        routeAdvertisementOpenApiVO.setPreferredLifetime(ra.getPreferredLifetime());
        return routeAdvertisementOpenApiVO;
    }

    private static SlaacTemplateOpenApiVO buildSlaacOpenApiVO(SlaacVO slaac) {
        if (Objects.isNull(slaac)) {
            return null;
        }
        SlaacTemplateOpenApiVO slaacOpenApiVO = new SlaacTemplateOpenApiVO();
        slaacOpenApiVO.setPrefix(slaac.getPrefix());
        slaacOpenApiVO.setPreId(slaac.getPreId());
        slaacOpenApiVO.setDnsv6(LanNetworkTemplateQueryOpenApiV2VO.buildDnsv6(slaac.getDnsv6()));
        slaacOpenApiVO.setPriDns(slaac.getPriDns());
        slaacOpenApiVO.setSndDns(slaac.getSndDns());
        return slaacOpenApiVO;
    }

    private static Integer buildDnsv6(String dnsv6) {
        if (T.a((String)dnsv6)) {
            return null;
        }
        switch (dnsv6) {
            case "auto": {
                return 0;
            }
            case "manual": {
                return 1;
            }
        }
        return null;
    }

    private static Dhcpv6OpenApiVO buildDhcpv6(Dhcpv6VO dhcpv6) {
        if (Objects.isNull(dhcpv6)) {
            return null;
        }
        Dhcpv6OpenApiVO dhcpv6OpenApiVO = new Dhcpv6OpenApiVO();
        dhcpv6OpenApiVO.setGateway(dhcpv6.getGateway());
        dhcpv6OpenApiVO.setSubnet(dhcpv6.getSubnet());
        dhcpv6OpenApiVO.setIpaddrStart(dhcpv6.getIpaddrStart());
        dhcpv6OpenApiVO.setIpaddrEnd(dhcpv6.getIpaddrEnd());
        dhcpv6OpenApiVO.setLeasetime(dhcpv6.getLeasetime());
        dhcpv6OpenApiVO.setDnsv6(LanNetworkTemplateQueryOpenApiV2VO.buildDnsv6(dhcpv6.getDnsv6()));
        dhcpv6OpenApiVO.setPriDns(dhcpv6.getPriDns());
        dhcpv6OpenApiVO.setSndDns(dhcpv6.getSndDns());
        return dhcpv6OpenApiVO;
    }

    private static DhcpGuardOpenApiVO buildDhcpGuard(DhcpGuardVO dhcpGuard) {
        if (Objects.isNull(dhcpGuard)) {
            return null;
        }
        DhcpGuardOpenApiVO dhcpGuardOpenApiVO = new DhcpGuardOpenApiVO();
        dhcpGuardOpenApiVO.setEnable(dhcpGuard.getEnable());
        dhcpGuardOpenApiVO.setDhcpSvr1(dhcpGuard.getDhcpSvr1());
        dhcpGuardOpenApiVO.setDhcpSvr2(dhcpGuard.getDhcpSvr2());
        return dhcpGuardOpenApiVO;
    }

    private static Dhcpv6GuardOpenApiVO buildDhcpv6Guard(Dhcpv6GuardVO dhcpv6Guard) {
        if (Objects.isNull(dhcpv6Guard)) {
            return null;
        }
        Dhcpv6GuardOpenApiVO dhcpv6GuardOpenApiVO = new Dhcpv6GuardOpenApiVO();
        dhcpv6GuardOpenApiVO.setEnable(dhcpv6Guard.getEnable());
        dhcpv6GuardOpenApiVO.setDhcpv6Svr1(dhcpv6Guard.getDhcpv6Svr1());
        dhcpv6GuardOpenApiVO.setDhcpv6Svr2(dhcpv6Guard.getDhcpv6Svr2());
        return dhcpv6GuardOpenApiVO;
    }

    private static DhcpSettingsTemplateOpenApiVO buildDhcpSettingsVO(DhcpSettingsVO dhcpSettings) {
        if (Objects.isNull(dhcpSettings)) {
            return null;
        }
        DhcpSettingsTemplateOpenApiVO dhcpSettingsOpenApiVO = new DhcpSettingsTemplateOpenApiVO();
        dhcpSettingsOpenApiVO.setEnable(dhcpSettings.getEnable());
        dhcpSettingsOpenApiVO.setIpRangePool(LanNetworkTemplateQueryOpenApiV2VO.buildDhcpRangeOpenApiVO(dhcpSettings.getIpRangePool()));
        dhcpSettingsOpenApiVO.setIpRangeStart(dhcpSettings.getIpRangeStart());
        dhcpSettingsOpenApiVO.setIpRangeEnd(dhcpSettings.getIpRangeEnd());
        dhcpSettingsOpenApiVO.setDhcpns(dhcpSettings.getDhcpns());
        dhcpSettingsOpenApiVO.setPriDns(dhcpSettings.getPriDns());
        dhcpSettingsOpenApiVO.setSndDns(dhcpSettings.getSndDns());
        dhcpSettingsOpenApiVO.setLeasetime(dhcpSettings.getLeasetime());
        dhcpSettingsOpenApiVO.setGateway(dhcpSettings.getGateway());
        dhcpSettingsOpenApiVO.setOptions(LanNetworkTemplateQueryOpenApiV2VO.buildDhcpOptions(dhcpSettings.getOptions()));
        return dhcpSettingsOpenApiVO;
    }

    private static List<DhcpRangeOpenApiVO> buildDhcpRangeOpenApiVO(List<DhcpRangeVO> ipRangePools) {
        if (ipRangePools == null) {
            return null;
        }
        return ipRangePools.stream().map(dhcpRangeVO -> new DhcpRangeOpenApiVO().setIpaddrStart(dhcpRangeVO.getIpaddrStart()).setIpaddrEnd(dhcpRangeVO.getIpaddrEnd())).collect(Collectors.toList());
    }

    private static List<DhcpOptionOpenApiVO> buildDhcpOptions(List<DhcpOptionVO> options) {
        if (CollectionUtils.isEmpty(options)) {
            return Collections.emptyList();
        }
        ArrayList<DhcpOptionOpenApiVO> dhcpOptions = new ArrayList<DhcpOptionOpenApiVO>();
        options.forEach(vo -> {
            DhcpOptionOpenApiVO openApiVO = new DhcpOptionOpenApiVO();
            openApiVO.setCode(vo.getCode());
            openApiVO.setType(vo.getType());
            openApiVO.setValue(vo.getValue());
            dhcpOptions.add(openApiVO);
        });
        return dhcpOptions;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Boolean getPrimary() {
        return this.primary;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getPurpose() {
        return this.purpose;
    }

    @Generated
    public List<String> getInterfaceIds() {
        return this.interfaceIds;
    }

    @Generated
    public Integer getVlanType() {
        return this.vlanType;
    }

    @Generated
    public String getVlans() {
        return this.vlans;
    }

    @Generated
    public Integer getVlan() {
        return this.vlan;
    }

    @Generated
    public Integer getApplication() {
        return this.application;
    }

    @Generated
    public String getGatewaySubnet() {
        return this.gatewaySubnet;
    }

    @Generated
    public DhcpSettingsTemplateOpenApiVO getDhcpSettingsVO() {
        return this.dhcpSettingsVO;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public Boolean getIgmpSnoopEnable() {
        return this.igmpSnoopEnable;
    }

    @Generated
    public Boolean getMldSnoopEnable() {
        return this.mldSnoopEnable;
    }

    @Generated
    public Boolean getDhcpL2RelayEnable() {
        return this.dhcpL2RelayEnable;
    }

    @Generated
    public DhcpGuardOpenApiVO getDhcpGuard() {
        return this.dhcpGuard;
    }

    @Generated
    public Dhcpv6GuardOpenApiVO getDhcpv6Guard() {
        return this.dhcpv6Guard;
    }

    @Generated
    public Boolean getPortal() {
        return this.portal;
    }

    @Generated
    public String getPortalId() {
        return this.portalId;
    }

    @Generated
    public String getPortalName() {
        return this.portalName;
    }

    @Generated
    public Boolean getAccessControlRule() {
        return this.accessControlRule;
    }

    @Generated
    public Boolean getRateLimit() {
        return this.rateLimit;
    }

    @Generated
    public LanNetworkIpv6ConfigTemplateOpenApiVO getLanNetworkIpv6Config() {
        return this.lanNetworkIpv6Config;
    }

    @Generated
    public Boolean getAllLan() {
        return this.allLan;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="primary")
    @Generated
    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPurpose(Integer purpose) {
        this.purpose = purpose;
    }

    @Generated
    public void setInterfaceIds(List<String> interfaceIds) {
        this.interfaceIds = interfaceIds;
    }

    @Generated
    public void setVlanType(Integer vlanType) {
        this.vlanType = vlanType;
    }

    @Generated
    public void setVlans(String vlans) {
        this.vlans = vlans;
    }

    @Generated
    public void setVlan(Integer vlan) {
        this.vlan = vlan;
    }

    @Generated
    public void setApplication(Integer application) {
        this.application = application;
    }

    @Generated
    public void setGatewaySubnet(String gatewaySubnet) {
        this.gatewaySubnet = gatewaySubnet;
    }

    @Generated
    public void setDhcpSettingsVO(DhcpSettingsTemplateOpenApiVO dhcpSettingsVO) {
        this.dhcpSettingsVO = dhcpSettingsVO;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setIgmpSnoopEnable(Boolean igmpSnoopEnable) {
        this.igmpSnoopEnable = igmpSnoopEnable;
    }

    @Generated
    public void setMldSnoopEnable(Boolean mldSnoopEnable) {
        this.mldSnoopEnable = mldSnoopEnable;
    }

    @Generated
    public void setDhcpL2RelayEnable(Boolean dhcpL2RelayEnable) {
        this.dhcpL2RelayEnable = dhcpL2RelayEnable;
    }

    @Generated
    public void setDhcpGuard(DhcpGuardOpenApiVO dhcpGuard) {
        this.dhcpGuard = dhcpGuard;
    }

    @Generated
    public void setDhcpv6Guard(Dhcpv6GuardOpenApiVO dhcpv6Guard) {
        this.dhcpv6Guard = dhcpv6Guard;
    }

    @Generated
    public void setPortal(Boolean portal) {
        this.portal = portal;
    }

    @Generated
    public void setPortalId(String portalId) {
        this.portalId = portalId;
    }

    @Generated
    public void setPortalName(String portalName) {
        this.portalName = portalName;
    }

    @Generated
    public void setAccessControlRule(Boolean accessControlRule) {
        this.accessControlRule = accessControlRule;
    }

    @Generated
    public void setRateLimit(Boolean rateLimit) {
        this.rateLimit = rateLimit;
    }

    @Generated
    public void setLanNetworkIpv6Config(LanNetworkIpv6ConfigTemplateOpenApiVO lanNetworkIpv6Config) {
        this.lanNetworkIpv6Config = lanNetworkIpv6Config;
    }

    @Generated
    public void setAllLan(Boolean allLan) {
        this.allLan = allLan;
    }

    @Generated
    public String toString() {
        return "LanNetworkTemplateQueryOpenApiV2VO(id=" + this.getId() + ", primary=" + this.getPrimary() + ", name=" + this.getName() + ", purpose=" + this.getPurpose() + ", interfaceIds=" + this.getInterfaceIds() + ", vlanType=" + this.getVlanType() + ", vlans=" + this.getVlans() + ", vlan=" + this.getVlan() + ", application=" + this.getApplication() + ", gatewaySubnet=" + this.getGatewaySubnet() + ", dhcpSettingsVO=" + this.getDhcpSettingsVO() + ", domain=" + this.getDomain() + ", igmpSnoopEnable=" + this.getIgmpSnoopEnable() + ", mldSnoopEnable=" + this.getMldSnoopEnable() + ", dhcpL2RelayEnable=" + this.getDhcpL2RelayEnable() + ", dhcpGuard=" + this.getDhcpGuard() + ", dhcpv6Guard=" + this.getDhcpv6Guard() + ", portal=" + this.getPortal() + ", portalId=" + this.getPortalId() + ", portalName=" + this.getPortalName() + ", accessControlRule=" + this.getAccessControlRule() + ", rateLimit=" + this.getRateLimit() + ", lanNetworkIpv6Config=" + this.getLanNetworkIpv6Config() + ", allLan=" + this.getAllLan() + ")";
    }

    @Generated
    public LanNetworkTemplateQueryOpenApiV2VO(String id, Boolean primary, String name, Integer purpose, List<String> interfaceIds, Integer vlanType, String vlans, Integer vlan, Integer application, String gatewaySubnet, DhcpSettingsTemplateOpenApiVO dhcpSettingsVO, String domain, Boolean igmpSnoopEnable, Boolean mldSnoopEnable, Boolean dhcpL2RelayEnable, DhcpGuardOpenApiVO dhcpGuard, Dhcpv6GuardOpenApiVO dhcpv6Guard, Boolean portal, String portalId, String portalName, Boolean accessControlRule, Boolean rateLimit, LanNetworkIpv6ConfigTemplateOpenApiVO lanNetworkIpv6Config, Boolean allLan) {
        this.id = id;
        this.primary = primary;
        this.name = name;
        this.purpose = purpose;
        this.interfaceIds = interfaceIds;
        this.vlanType = vlanType;
        this.vlans = vlans;
        this.vlan = vlan;
        this.application = application;
        this.gatewaySubnet = gatewaySubnet;
        this.dhcpSettingsVO = dhcpSettingsVO;
        this.domain = domain;
        this.igmpSnoopEnable = igmpSnoopEnable;
        this.mldSnoopEnable = mldSnoopEnable;
        this.dhcpL2RelayEnable = dhcpL2RelayEnable;
        this.dhcpGuard = dhcpGuard;
        this.dhcpv6Guard = dhcpv6Guard;
        this.portal = portal;
        this.portalId = portalId;
        this.portalName = portalName;
        this.accessControlRule = accessControlRule;
        this.rateLimit = rateLimit;
        this.lanNetworkIpv6Config = lanNetworkIpv6Config;
        this.allLan = allLan;
    }

    @Generated
    public LanNetworkTemplateQueryOpenApiV2VO() {
    }
}

