/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DhcpGuardOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DhcpOptionOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DhcpRangeOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.Dhcpv6GuardOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.Dhcpv6OpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.RouteAdvertisementOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.DhcpSettingsConfigTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.LanNetworkIpv6ConfigTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.SlaacTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpGuardVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpOptionVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpRangeVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpSettingsVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.Dhcpv6GuardVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.Dhcpv6VO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.LanNetworkIpv6ConfigVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.LanNetworkVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.RouteAdvertisementVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.SlaacVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

@Schema(description="LANNetworkTemplateOpenApiVO")
public class LanNetworkTemplateOpenApiVO {
    @NotNull
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.")
    @Schema(name="name", description="LAN network name should contain 1 to 128 characters.")
    private @NotNull @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be between 1 and 128 characters.") String name;
    @NotNull
    @Schema(name="purpose", description="LAN network purpose should be a value as follows: 0: VLAN; 1: interface")
    @Range(min=0L, max=1L)
    private @NotNull @Range(min=0L, max=1L) Integer purpose;
    @Schema(name="interfaceIds", description="Gateway LAN port IDs, which are acquired from \"Check WAN/LAN status\"")
    private List<String> interfaceIds;
    @Range(min=0L, max=1L)
    @Schema(name="vlanType", description="When purpose is interface, VLANType should be a value as follows: 0: Single; 1: Multiple")
    private @Range(min=0L, max=1L) Integer vlanType;
    @Pattern(regexp="^[\\d|\\d-\\d]+(,[\\d|\\d-\\d]+)*$", message="Parameter [vlans] should be like '2-100,200'.")
    @Schema(name="vlans", description="When purpose is \"interface\" and VLANType is 1, batch create VLANs. VLAN format: 200, 1-100.")
    private @Pattern(regexp="^[\\d|\\d-\\d]+(,[\\d|\\d-\\d]+)*$", message="Parameter [vlans] should be like '2-100,200'.") String vlans;
    @Range(min=1L, max=4090L, message="Value of vlan is from 1 to 4090.")
    @Schema(name="vlan", description="When purpose is \"VLAN\" or purpose is \"interface\" and VLANType is 0, vlan should be within the range of 1-4090.")
    private @Range(min=1L, max=4090L, message="Value of vlan is from 1 to 4090.") Integer vlan;
    @Schema(name="application", description="Effective device type should be a value as follows: 0: Gateway and Switch; 1: Switch")
    private Integer application;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30))\\b", message="Parameter [gatewaySubnet] Invalid.")
    @Schema(name="gatewaySubnet", description="When purpose is interface, gateway subnet is needed. Format: IP/Mask")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30))\\b", message="Parameter [gatewaySubnet] Invalid.") String gatewaySubnet;
    @Valid
    @Schema(name="dhcpSettingsVO", description="Configure DHCP settings")
    private DhcpSettingsConfigTemplateOpenApiVO dhcpSettingsVO;
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Enter the valid domain name. For example, www.omadanetworks.com.")
    @Schema(name="domain", description="The domain of this network")
    private @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Enter the valid domain name. For example, www.omadanetworks.com.") String domain;
    @NotNull(message="Parameter [igmpSnoopEnable] should not be null.")
    @Schema(name="igmpSnoopEnable", description="Enable IGMP snooping")
    private @NotNull(message="Parameter [igmpSnoopEnable] should not be null.") Boolean igmpSnoopEnable;
    @Schema(name="mldSnoopEnable", description="Enable MLD snooping")
    private Boolean mldSnoopEnable;
    @Schema(name="dhcpL2RelayEnable", description="The switch of DHCP L2 relay")
    private Boolean dhcpL2RelayEnable;
    @Valid
    @Schema(name="dhcpGuard", description="Legal DHCP Server")
    private DhcpGuardOpenApiVO dhcpGuard;
    @Schema(name="dhcpv6Guard", description="Legal DHCPv6 Server")
    private Dhcpv6GuardOpenApiVO dhcpv6Guard;
    @Valid
    @Schema(name="lanNeworkIpv6Config", description="LAN network IPv6 config")
    private LanNetworkIpv6ConfigTemplateOpenApiVO lanNetworkIpv6Config;
    @Schema(name="allLan", description="When Internet pre-config is closed or Internet pre-config is Universal, allLAN is \"true\"; after adopting gateway, allLAN is \"false\".")
    private Boolean allLan;

    public static LanNetworkVO toLanNetworkVO(LanNetworkTemplateOpenApiVO lanNetworkOpenApiVO) {
        if (Objects.isNull(lanNetworkOpenApiVO)) {
            return null;
        }
        LanNetworkVO lanNetworkVO = new LanNetworkVO();
        lanNetworkVO.setName(lanNetworkOpenApiVO.getName());
        lanNetworkVO.setPurpose(LanNetworkTemplateOpenApiVO.toPurpose(lanNetworkOpenApiVO.getPurpose()));
        lanNetworkVO.setInterfaceIds(lanNetworkOpenApiVO.getInterfaceIds());
        lanNetworkVO.setVlanType(lanNetworkOpenApiVO.getVlanType());
        lanNetworkVO.setVlans(lanNetworkOpenApiVO.getVlans());
        lanNetworkVO.setApplication(lanNetworkOpenApiVO.getApplication());
        lanNetworkVO.setVlan(lanNetworkOpenApiVO.getVlan());
        lanNetworkVO.setGatewaySubnet(lanNetworkOpenApiVO.getGatewaySubnet());
        lanNetworkVO.setDhcpSettings(LanNetworkTemplateOpenApiVO.toDhcpSettings(lanNetworkOpenApiVO.getDhcpSettingsVO()));
        lanNetworkVO.setDomain(lanNetworkOpenApiVO.getDomain());
        lanNetworkVO.setIgmpSnoopEnable(Boolean.valueOf(Boolean.TRUE.equals(lanNetworkOpenApiVO.getIgmpSnoopEnable())));
        lanNetworkVO.setMldSnoopEnable(Boolean.valueOf(Boolean.TRUE.equals(lanNetworkOpenApiVO.getMldSnoopEnable())));
        lanNetworkVO.setDhcpv6Guard(LanNetworkTemplateOpenApiVO.toDhcpv6Guard(lanNetworkOpenApiVO.getDhcpv6Guard()));
        lanNetworkVO.setDhcpL2RelayEnable(Boolean.valueOf(Boolean.TRUE.equals(lanNetworkOpenApiVO.getDhcpL2RelayEnable())));
        lanNetworkVO.setDhcpGuard(LanNetworkTemplateOpenApiVO.toDhcpGuard(lanNetworkOpenApiVO.getDhcpGuard()));
        lanNetworkVO.setLanNetworkIpv6Config(LanNetworkTemplateOpenApiVO.toLanNetworkIpv6Config(lanNetworkOpenApiVO.getLanNetworkIpv6Config()));
        lanNetworkVO.setAllLan(lanNetworkOpenApiVO.getAllLan());
        return lanNetworkVO;
    }

    private static String toPurpose(Integer purpose) {
        switch (purpose) {
            case 0: {
                return "vlan";
            }
            case 1: {
                return "interface";
            }
        }
        return null;
    }

    private static LanNetworkIpv6ConfigVO toLanNetworkIpv6Config(LanNetworkIpv6ConfigTemplateOpenApiVO lanNetworkIpv6Config) {
        if (Objects.isNull(lanNetworkIpv6Config)) {
            LanNetworkIpv6ConfigVO lanNetworkIpv6ConfigVO = new LanNetworkIpv6ConfigVO();
            lanNetworkIpv6ConfigVO.setEnable(Integer.valueOf(0));
            lanNetworkIpv6ConfigVO.setProto("none");
            lanNetworkIpv6ConfigVO.setRdnss(LanNetworkTemplateOpenApiVO.toSlaacVO(null));
            lanNetworkIpv6ConfigVO.setSlaac(LanNetworkTemplateOpenApiVO.toSlaacVO(null));
            return lanNetworkIpv6ConfigVO;
        }
        LanNetworkIpv6ConfigVO lanNetworkIpv6ConfigVO = new LanNetworkIpv6ConfigVO();
        lanNetworkIpv6ConfigVO.setProto(LanNetworkTemplateOpenApiVO.toProto(lanNetworkIpv6Config.getProto()));
        lanNetworkIpv6ConfigVO.setEnable(Integer.valueOf(lanNetworkIpv6Config.getEnable() == null ? 0 : lanNetworkIpv6Config.getEnable()));
        lanNetworkIpv6ConfigVO.setDhcpv6(LanNetworkTemplateOpenApiVO.toDhcpv6(lanNetworkIpv6Config.getDhcpv6()));
        lanNetworkIpv6ConfigVO.setSlaac(LanNetworkTemplateOpenApiVO.toSlaacVO(lanNetworkIpv6Config.getSlaac()));
        lanNetworkIpv6ConfigVO.setRdnss(LanNetworkTemplateOpenApiVO.toSlaacVO(lanNetworkIpv6Config.getRdnss()));
        lanNetworkIpv6ConfigVO.setRa(LanNetworkTemplateOpenApiVO.toRouteAdvertisement(lanNetworkIpv6Config.getRa()));
        return lanNetworkIpv6ConfigVO;
    }

    private static String toProto(Integer proto) {
        if (Objects.isNull(proto)) {
            return "none";
        }
        switch (proto) {
            case 1: {
                return "dhcpv6";
            }
            case 2: {
                return "slaac";
            }
            case 3: {
                return "rdnss";
            }
            case 4: {
                return "passthrough";
            }
        }
        return "none";
    }

    private static RouteAdvertisementVO toRouteAdvertisement(RouteAdvertisementOpenApiVO ra) {
        if (Objects.isNull(ra)) {
            return null;
        }
        RouteAdvertisementVO routeAdvertisementVO = new RouteAdvertisementVO();
        routeAdvertisementVO.setEnable(ra.getEnable());
        routeAdvertisementVO.setPreference(ra.getPreference());
        routeAdvertisementVO.setValidLifetime(ra.getValidLifetime());
        routeAdvertisementVO.setPreferredLifetime(ra.getPreferredLifetime());
        return routeAdvertisementVO;
    }

    private static SlaacVO toSlaacVO(SlaacTemplateOpenApiVO slaac) {
        if (Objects.isNull(slaac)) {
            SlaacVO slaacVO = new SlaacVO();
            slaacVO.setPreType(Integer.valueOf(0));
            return slaacVO;
        }
        SlaacVO slaacVO = new SlaacVO();
        slaacVO.setPreType(Integer.valueOf(0));
        slaacVO.setPrefix(slaac.getPrefix());
        slaacVO.setPreId(slaac.getPreId());
        slaacVO.setDnsv6(LanNetworkTemplateOpenApiVO.toDnsv6(slaac.getDnsv6()));
        slaacVO.setPriDns(slaac.getPriDns());
        slaacVO.setSndDns(slaac.getSndDns());
        return slaacVO;
    }

    private static String toDnsv6(Integer dnsv6) {
        if (Objects.isNull(dnsv6)) {
            return null;
        }
        switch (dnsv6) {
            case 0: {
                return "auto";
            }
            case 1: {
                return "manual";
            }
        }
        return null;
    }

    private static Dhcpv6VO toDhcpv6(Dhcpv6OpenApiVO dhcpv6) {
        if (Objects.isNull(dhcpv6)) {
            return null;
        }
        Dhcpv6VO dhcpv6VO = new Dhcpv6VO();
        dhcpv6VO.setGateway(dhcpv6.getGateway());
        dhcpv6VO.setSubnet(dhcpv6.getSubnet());
        dhcpv6VO.setIpaddrStart(dhcpv6.getIpaddrStart());
        dhcpv6VO.setIpaddrEnd(dhcpv6.getIpaddrEnd());
        dhcpv6VO.setLeasetime(dhcpv6.getLeasetime());
        dhcpv6VO.setDnsv6(LanNetworkTemplateOpenApiVO.toDnsv6(dhcpv6.getDnsv6()));
        dhcpv6VO.setPriDns(dhcpv6.getPriDns());
        dhcpv6VO.setSndDns(dhcpv6.getSndDns());
        return dhcpv6VO;
    }

    private static DhcpGuardVO toDhcpGuard(DhcpGuardOpenApiVO dhcpGuard) {
        if (Objects.isNull(dhcpGuard)) {
            DhcpGuardVO dhcpGuardVO = new DhcpGuardVO();
            dhcpGuardVO.setEnable(Boolean.valueOf(false));
            return dhcpGuardVO;
        }
        DhcpGuardVO dhcpGuardVO = new DhcpGuardVO();
        dhcpGuardVO.setEnable(Boolean.valueOf(Boolean.TRUE.equals(dhcpGuard.getEnable())));
        dhcpGuardVO.setDhcpSvr1(dhcpGuard.getDhcpSvr1());
        dhcpGuardVO.setDhcpSvr2(dhcpGuard.getDhcpSvr2());
        return dhcpGuardVO;
    }

    private static Dhcpv6GuardVO toDhcpv6Guard(Dhcpv6GuardOpenApiVO dhcpv6Guard) {
        if (Objects.isNull(dhcpv6Guard)) {
            Dhcpv6GuardVO dhcpv6GuardVO = new Dhcpv6GuardVO();
            dhcpv6GuardVO.setEnable(Boolean.valueOf(false));
            return dhcpv6GuardVO;
        }
        Dhcpv6GuardVO dhcpv6GuardVO = new Dhcpv6GuardVO();
        dhcpv6GuardVO.setEnable(Boolean.valueOf(Boolean.TRUE.equals(dhcpv6Guard.getEnable())));
        dhcpv6GuardVO.setDhcpv6Svr1(dhcpv6Guard.getDhcpv6Svr1());
        dhcpv6GuardVO.setDhcpv6Svr2(dhcpv6Guard.getDhcpv6Svr2());
        return dhcpv6GuardVO;
    }

    private static DhcpSettingsVO toDhcpSettings(DhcpSettingsConfigTemplateOpenApiVO dhcpSettingsVO) {
        if (Objects.isNull(dhcpSettingsVO)) {
            DhcpSettingsVO dhcpSettings = new DhcpSettingsVO();
            dhcpSettings.setEnable(Boolean.valueOf(false));
            return dhcpSettings;
        }
        DhcpSettingsVO dhcpSettings = new DhcpSettingsVO();
        dhcpSettings.setEnable(Boolean.valueOf(Boolean.TRUE.equals(dhcpSettingsVO.getEnable())));
        dhcpSettings.setIpRangePool(LanNetworkTemplateOpenApiVO.buildDhcpRangeVO(dhcpSettingsVO.getIpRangePool()));
        dhcpSettings.setDhcpns(dhcpSettingsVO.getDhcpns());
        dhcpSettings.setPriDns(dhcpSettingsVO.getPriDns());
        dhcpSettings.setSndDns(dhcpSettingsVO.getSndDns());
        dhcpSettings.setLeasetime(dhcpSettingsVO.getLeasetime());
        dhcpSettings.setGateway(dhcpSettingsVO.getGateway());
        dhcpSettings.setOptions(LanNetworkTemplateOpenApiVO.toOptions(dhcpSettingsVO.getOptions()));
        return dhcpSettings;
    }

    private static List<DhcpRangeVO> buildDhcpRangeVO(List<DhcpRangeOpenApiVO> dhcpRangeOpenApiVOs) {
        if (dhcpRangeOpenApiVOs == null) {
            return null;
        }
        return dhcpRangeOpenApiVOs.stream().map(dhcpRangeOpenApiVO -> new DhcpRangeVO().setIpaddrStart(dhcpRangeOpenApiVO.getIpaddrStart()).setIpaddrEnd(dhcpRangeOpenApiVO.getIpaddrEnd())).collect(Collectors.toList());
    }

    private static List<DhcpOptionVO> toOptions(List<DhcpOptionOpenApiVO> openApiOptions) {
        if (CollectionUtils.isEmpty(openApiOptions)) {
            return Collections.emptyList();
        }
        ArrayList<DhcpOptionVO> dhcpOptionVOList = new ArrayList<DhcpOptionVO>();
        openApiOptions.forEach(dhcpOptionOpenApiVO -> {
            DhcpOptionVO dhcpOptionVO = new DhcpOptionVO();
            dhcpOptionVO.setCode(dhcpOptionOpenApiVO.getCode());
            dhcpOptionVO.setType(dhcpOptionOpenApiVO.getType());
            dhcpOptionVO.setValue(dhcpOptionOpenApiVO.getValue());
            dhcpOptionVOList.add(dhcpOptionVO);
        });
        return dhcpOptionVOList;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getPurpose() {
        return this.purpose;
    }

    @Generated
    public List<String> getInterfaceIds() {
        return this.interfaceIds;
    }

    @Generated
    public Integer getVlanType() {
        return this.vlanType;
    }

    @Generated
    public String getVlans() {
        return this.vlans;
    }

    @Generated
    public Integer getVlan() {
        return this.vlan;
    }

    @Generated
    public Integer getApplication() {
        return this.application;
    }

    @Generated
    public String getGatewaySubnet() {
        return this.gatewaySubnet;
    }

    @Generated
    public DhcpSettingsConfigTemplateOpenApiVO getDhcpSettingsVO() {
        return this.dhcpSettingsVO;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public Boolean getIgmpSnoopEnable() {
        return this.igmpSnoopEnable;
    }

    @Generated
    public Boolean getMldSnoopEnable() {
        return this.mldSnoopEnable;
    }

    @Generated
    public Boolean getDhcpL2RelayEnable() {
        return this.dhcpL2RelayEnable;
    }

    @Generated
    public DhcpGuardOpenApiVO getDhcpGuard() {
        return this.dhcpGuard;
    }

    @Generated
    public Dhcpv6GuardOpenApiVO getDhcpv6Guard() {
        return this.dhcpv6Guard;
    }

    @Generated
    public LanNetworkIpv6ConfigTemplateOpenApiVO getLanNetworkIpv6Config() {
        return this.lanNetworkIpv6Config;
    }

    @Generated
    public Boolean getAllLan() {
        return this.allLan;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPurpose(Integer purpose) {
        this.purpose = purpose;
    }

    @Generated
    public void setInterfaceIds(List<String> interfaceIds) {
        this.interfaceIds = interfaceIds;
    }

    @Generated
    public void setVlanType(Integer vlanType) {
        this.vlanType = vlanType;
    }

    @Generated
    public void setVlans(String vlans) {
        this.vlans = vlans;
    }

    @Generated
    public void setVlan(Integer vlan) {
        this.vlan = vlan;
    }

    @Generated
    public void setApplication(Integer application) {
        this.application = application;
    }

    @Generated
    public void setGatewaySubnet(String gatewaySubnet) {
        this.gatewaySubnet = gatewaySubnet;
    }

    @Generated
    public void setDhcpSettingsVO(DhcpSettingsConfigTemplateOpenApiVO dhcpSettingsVO) {
        this.dhcpSettingsVO = dhcpSettingsVO;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setIgmpSnoopEnable(Boolean igmpSnoopEnable) {
        this.igmpSnoopEnable = igmpSnoopEnable;
    }

    @Generated
    public void setMldSnoopEnable(Boolean mldSnoopEnable) {
        this.mldSnoopEnable = mldSnoopEnable;
    }

    @Generated
    public void setDhcpL2RelayEnable(Boolean dhcpL2RelayEnable) {
        this.dhcpL2RelayEnable = dhcpL2RelayEnable;
    }

    @Generated
    public void setDhcpGuard(DhcpGuardOpenApiVO dhcpGuard) {
        this.dhcpGuard = dhcpGuard;
    }

    @Generated
    public void setDhcpv6Guard(Dhcpv6GuardOpenApiVO dhcpv6Guard) {
        this.dhcpv6Guard = dhcpv6Guard;
    }

    @Generated
    public void setLanNetworkIpv6Config(LanNetworkIpv6ConfigTemplateOpenApiVO lanNetworkIpv6Config) {
        this.lanNetworkIpv6Config = lanNetworkIpv6Config;
    }

    @Generated
    public void setAllLan(Boolean allLan) {
        this.allLan = allLan;
    }

    @Generated
    public String toString() {
        return "LanNetworkTemplateOpenApiVO(name=" + this.getName() + ", purpose=" + this.getPurpose() + ", interfaceIds=" + this.getInterfaceIds() + ", vlanType=" + this.getVlanType() + ", vlans=" + this.getVlans() + ", vlan=" + this.getVlan() + ", application=" + this.getApplication() + ", gatewaySubnet=" + this.getGatewaySubnet() + ", dhcpSettingsVO=" + this.getDhcpSettingsVO() + ", domain=" + this.getDomain() + ", igmpSnoopEnable=" + this.getIgmpSnoopEnable() + ", mldSnoopEnable=" + this.getMldSnoopEnable() + ", dhcpL2RelayEnable=" + this.getDhcpL2RelayEnable() + ", dhcpGuard=" + this.getDhcpGuard() + ", dhcpv6Guard=" + this.getDhcpv6Guard() + ", lanNetworkIpv6Config=" + this.getLanNetworkIpv6Config() + ", allLan=" + this.getAllLan() + ")";
    }

    @Generated
    public LanNetworkTemplateOpenApiVO(String name, Integer purpose, List<String> interfaceIds, Integer vlanType, String vlans, Integer vlan, Integer application, String gatewaySubnet, DhcpSettingsConfigTemplateOpenApiVO dhcpSettingsVO, String domain, Boolean igmpSnoopEnable, Boolean mldSnoopEnable, Boolean dhcpL2RelayEnable, DhcpGuardOpenApiVO dhcpGuard, Dhcpv6GuardOpenApiVO dhcpv6Guard, LanNetworkIpv6ConfigTemplateOpenApiVO lanNetworkIpv6Config, Boolean allLan) {
        this.name = name;
        this.purpose = purpose;
        this.interfaceIds = interfaceIds;
        this.vlanType = vlanType;
        this.vlans = vlans;
        this.vlan = vlan;
        this.application = application;
        this.gatewaySubnet = gatewaySubnet;
        this.dhcpSettingsVO = dhcpSettingsVO;
        this.domain = domain;
        this.igmpSnoopEnable = igmpSnoopEnable;
        this.mldSnoopEnable = mldSnoopEnable;
        this.dhcpL2RelayEnable = dhcpL2RelayEnable;
        this.dhcpGuard = dhcpGuard;
        this.dhcpv6Guard = dhcpv6Guard;
        this.lanNetworkIpv6Config = lanNetworkIpv6Config;
        this.allLan = allLan;
    }

    @Generated
    public LanNetworkTemplateOpenApiVO() {
    }
}

