/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.manager.configuration.api.web.site.wired.landns.LanDnsVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class LanDnsOpenApiVO {
    private String id;
    @NotNull(message="LAN DNS parameter [enable] should not be null.")
    @Schema(name="enable", description="off:false, on: true")
    private @NotNull(message="LAN DNS parameter [enable] should not be null.") Boolean enable;
    @NotNull(message="LAN DNS parameter [name] should not be null.")
    @Size(min=1, max=128, message="Size of name is from 1 to 128.")
    @Schema(name="name", description="Name of Lan Dns Item")
    private @NotNull(message="LAN DNS parameter [name] should not be null.") @Size(min=1, max=128, message="Size of name is from 1 to 128.") String name;
    @NotNull(message="LAN DNS parameter [domain] should not be null.")
    @Pattern(regexp="(?=^.{1,67}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+", message="Parameter [domain] Invalid.")
    @Schema(name="domain", description="Enter the domain name.")
    private @NotNull(message="LAN DNS parameter [domain] should not be null.") @Pattern(regexp="(?=^.{1,67}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+", message="Parameter [domain] Invalid.") String domain;
    @Size(max=7, message="Size of aliases should be less than 7")
    @Schema(name="aliases", description="Name of Lan Dns Item")
    private @Size(max=7, message="Size of aliases should be less than 7") List<String> aliases;
    @NotNull(message="LAN DNS parameter [type] should not be null.")
    @Range(min=0L, max=2L, message="Value of type is from 0 to 2.")
    @Schema(name="type", description="There are three options, IP:0, CNAME:1, and FORWARD:2.")
    private @NotNull(message="LAN DNS parameter [type] should not be null.") @Range(min=0L, max=2L, message="Value of type is from 0 to 2.") Integer type;
    @Size(max=32, message="Size of ipAddresses should be less than 32")
    @Schema(name="ipAddresses", description="When the Type is IP, it is the IPv4 address of the returned DNS response.")
    private @Size(max=32, message="Size of ipAddresses should be less than 32") List<String> ipAddresses;
    @Size(max=32, message="Size of ipv6Addresses should be less than 32")
    @Schema(name="ipv6Addresses", description="When the Type is IP, it is the IPv6 address of the returned DNS response.")
    private @Size(max=32, message="Size of ipv6Addresses should be less than 32") List<String> ipv6Addresses;
    @Pattern(regexp="(?=^.{1,67}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+", message="Parameter [cname] Invalid.")
    @Schema(name="cname", description="When Type is CNAME, set the domain name to which Domain Name and Alias Domain Name need to be mapped.")
    private @Pattern(regexp="(?=^.{1,67}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+", message="Parameter [cname] Invalid.") String cname;
    @Size(max=2, message="Size of dnsServers should be less than 2")
    @Schema(name="dnsServers", description="When the Type is FORWARD, set the Domain Name and Alias Domain Name to be forwarded to a specific DNS Server, up to two DNS Servers can be configured.")
    private @Size(max=2, message="Size of dnsServers should be less than 2") List<String> dnsServers;
    @Schema(name="lanNetworkIds", description="The ids of Lan Network.")
    private List<String> lanNetworkIds;

    public static LanDnsVO toWebVO(LanDnsOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        return LanDnsVO.builder().id(openApiVO.getId()).enable(openApiVO.getEnable()).name(openApiVO.getName()).domain(openApiVO.getDomain()).aliases(openApiVO.getAliases()).type(openApiVO.getType()).ipAddresses(openApiVO.getIpAddresses()).ipv6Addresses(openApiVO.getIpv6Addresses()).cname(openApiVO.getCname()).dnsServers(openApiVO.getDnsServers()).lanNetworkIds(openApiVO.getLanNetworkIds()).build();
    }

    public static LanDnsOpenApiVO fromWebVO(LanDnsVO lanDnsVO) {
        if (lanDnsVO == null) {
            return null;
        }
        LanDnsOpenApiVO lanDnsOpenApiVO = new LanDnsOpenApiVO();
        lanDnsOpenApiVO.setId(lanDnsVO.getId());
        lanDnsOpenApiVO.setEnable(lanDnsVO.getEnable());
        lanDnsOpenApiVO.setName(lanDnsVO.getName());
        lanDnsOpenApiVO.setDomain(lanDnsVO.getDomain());
        lanDnsOpenApiVO.setAliases(lanDnsVO.getAliases());
        lanDnsOpenApiVO.setType(lanDnsVO.getType());
        lanDnsOpenApiVO.setIpAddresses(lanDnsVO.getIpAddresses());
        lanDnsOpenApiVO.setIpv6Addresses(lanDnsVO.getIpv6Addresses());
        lanDnsOpenApiVO.setCname(lanDnsVO.getCname());
        lanDnsOpenApiVO.setDnsServers(lanDnsVO.getDnsServers());
        lanDnsOpenApiVO.setLanNetworkIds(lanDnsVO.getLanNetworkIds());
        return lanDnsOpenApiVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public List<String> getAliases() {
        return this.aliases;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public List<String> getIpAddresses() {
        return this.ipAddresses;
    }

    @Generated
    public List<String> getIpv6Addresses() {
        return this.ipv6Addresses;
    }

    @Generated
    public String getCname() {
        return this.cname;
    }

    @Generated
    public List<String> getDnsServers() {
        return this.dnsServers;
    }

    @Generated
    public List<String> getLanNetworkIds() {
        return this.lanNetworkIds;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setIpAddresses(List<String> ipAddresses) {
        this.ipAddresses = ipAddresses;
    }

    @Generated
    public void setIpv6Addresses(List<String> ipv6Addresses) {
        this.ipv6Addresses = ipv6Addresses;
    }

    @Generated
    public void setCname(String cname) {
        this.cname = cname;
    }

    @Generated
    public void setDnsServers(List<String> dnsServers) {
        this.dnsServers = dnsServers;
    }

    @Generated
    public void setLanNetworkIds(List<String> lanNetworkIds) {
        this.lanNetworkIds = lanNetworkIds;
    }

    @Generated
    public String toString() {
        return "LanDnsOpenApiVO(id=" + this.getId() + ", enable=" + this.getEnable() + ", name=" + this.getName() + ", domain=" + this.getDomain() + ", aliases=" + this.getAliases() + ", type=" + this.getType() + ", ipAddresses=" + this.getIpAddresses() + ", ipv6Addresses=" + this.getIpv6Addresses() + ", cname=" + this.getCname() + ", dnsServers=" + this.getDnsServers() + ", lanNetworkIds=" + this.getLanNetworkIds() + ")";
    }

    @Generated
    public LanDnsOpenApiVO() {
    }

    @Generated
    public LanDnsOpenApiVO(String id, Boolean enable, String name, String domain, List<String> aliases, Integer type, List<String> ipAddresses, List<String> ipv6Addresses, String cname, List<String> dnsServers, List<String> lanNetworkIds) {
        this.id = id;
        this.enable = enable;
        this.name = name;
        this.domain = domain;
        this.aliases = aliases;
        this.type = type;
        this.ipAddresses = ipAddresses;
        this.ipv6Addresses = ipv6Addresses;
        this.cname = cname;
        this.dnsServers = dnsServers;
        this.lanNetworkIds = lanNetworkIds;
    }
}

