/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.IspResultOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.scan.isp.IspScanResultVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class IspScanResultOpenApiVO {
    @Schema(name="status", description="The status of the band scan: 0 - Failed, 1 - Succeeded, 2 - Scanning.")
    @Range(min=0L, max=2L, message="Value of status is from 0 to 2.")
    private @Range(min=0L, max=2L, message="Value of status is from 0 to 2.") Integer status;
    @Schema(name="ispList", description="The list of the isp, contains the ISP name and the ID and the state of the ISP.")
    private List<IspResultOpenApiVO> ispList;

    public static IspScanResultOpenApiVO buildFromWebVO(IspScanResultVO vo) {
        IspScanResultOpenApiVO res = new IspScanResultOpenApiVO();
        if (Objects.isNull(vo)) {
            return res;
        }
        res.setStatus(vo.getStatus());
        res.setIspList(CollectionUtils.isEmpty((Collection)vo.getIspList()) ? new ArrayList<IspResultOpenApiVO>() : vo.getIspList().stream().map(IspResultOpenApiVO::buildFromWebVO).collect(Collectors.toList()));
        return res;
    }

    @Generated
    public static IspScanResultOpenApiVOBuilder builder() {
        return new IspScanResultOpenApiVOBuilder();
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public List<IspResultOpenApiVO> getIspList() {
        return this.ispList;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setIspList(List<IspResultOpenApiVO> ispList) {
        this.ispList = ispList;
    }

    @Generated
    public String toString() {
        return "IspScanResultOpenApiVO(status=" + this.getStatus() + ", ispList=" + this.getIspList() + ")";
    }

    @Generated
    public IspScanResultOpenApiVO() {
    }

    @Generated
    public IspScanResultOpenApiVO(Integer status, List<IspResultOpenApiVO> ispList) {
        this.status = status;
        this.ispList = ispList;
    }

    @Generated
    public static class IspScanResultOpenApiVOBuilder {
        @Generated
        private Integer status;
        @Generated
        private List<IspResultOpenApiVO> ispList;

        @Generated
        IspScanResultOpenApiVOBuilder() {
        }

        @Generated
        public IspScanResultOpenApiVOBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        @Generated
        public IspScanResultOpenApiVOBuilder ispList(List<IspResultOpenApiVO> ispList) {
            this.ispList = ispList;
            return this;
        }

        @Generated
        public IspScanResultOpenApiVO build() {
            return new IspScanResultOpenApiVO(this.status, this.ispList);
        }

        @Generated
        public String toString() {
            return "IspScanResultOpenApiVO.IspScanResultOpenApiVOBuilder(status=" + this.status + ", ispList=" + this.ispList + ")";
        }
    }
}

