/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.Ipv6PppoeVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@KeepClass
public class Ipv6PppoeOpenApiVO {
    @Schema(name="pppShare", description="Share the same PPPoE session with IPv4")
    @NotNull
    private Boolean pppShare;
    @NotNull
    private String userName;
    @NotNull
    private String password;
    @Schema(name="getIpv6Type", description="It should be a value as follows: 0: SLAAC, 1: DHCPv6, 2: specified, 3: auto, 4:non_address, which ranges from 48 ~ 64.")
    @NotNull
    @Range(min=48L, max=64L)
    private @NotNull @Range(min=48L, max=64L) Integer getIpv6Type;
    @NotNull
    private Boolean prefixEnable;
    @Schema(name="prefixSize", description="It is required when [prefixEnable] is true.")
    private Integer prefixSize;
    @Schema(name="specificIp", description="It is required when [getIpv6Type] is 2.")
    private String specificIp;
    @Schema(name="dnsType", description="DNS Address Type should be a value as follows: 0: dynamic, 1: static.")
    @NotNull
    @Range(min=0L, max=1L)
    private @NotNull @Range(min=0L, max=1L) Integer dnsType;
    @Schema(name="primaryDns", description="It is required when [dnsType] is 1.")
    private String primaryDns;
    @Schema(name="secondaryDns", description="It takes effect when [dnsType] is 1.")
    private String secondaryDns;

    public static Ipv6PppoeOpenApiVO buildFromWebVO(Ipv6PppoeVO vo) {
        Ipv6PppoeOpenApiVO res = new Ipv6PppoeOpenApiVO();
        if (vo == null) {
            return res;
        }
        res.setPppShare(Objects.equals(vo.getPppShare(), 1));
        res.setUserName(vo.getUserName());
        res.setPassword(vo.getPassword());
        res.setGetIpv6Type(vo.getGetIpv6Type());
        res.setPrefixEnable(Objects.equals(vo.getPrefix(), 1));
        res.setPrefixSize(vo.getPdSize());
        res.setSpecificIp(vo.getSpecificIp());
        res.setDnsType(vo.getDnsType());
        res.setPrimaryDns(vo.getPriDns());
        res.setSecondaryDns(vo.getSndDns());
        return res;
    }

    public static Ipv6PppoeVO toWebVO(Ipv6PppoeOpenApiVO vo) {
        Ipv6PppoeVO res = new Ipv6PppoeVO();
        if (vo == null) {
            return res;
        }
        res.setPppShare(Integer.valueOf(Boolean.TRUE.equals(vo.getPppShare()) ? 1 : 0));
        res.setUserName(vo.getUserName());
        res.setPassword(vo.getPassword());
        res.setGetIpv6Type(vo.getGetIpv6Type());
        res.setPrefix(Integer.valueOf(Boolean.TRUE.equals(vo.getPrefixEnable()) ? 1 : 0));
        res.setPdSize(vo.getPrefixSize());
        res.setSpecificIp(vo.getSpecificIp());
        res.setDnsType(vo.getDnsType());
        res.setPriDns(vo.getPrimaryDns());
        res.setSndDns(vo.getSecondaryDns());
        return res;
    }

    @Generated
    public Boolean getPppShare() {
        return this.pppShare;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Integer getGetIpv6Type() {
        return this.getIpv6Type;
    }

    @Generated
    public Boolean getPrefixEnable() {
        return this.prefixEnable;
    }

    @Generated
    public Integer getPrefixSize() {
        return this.prefixSize;
    }

    @Generated
    public String getSpecificIp() {
        return this.specificIp;
    }

    @Generated
    public Integer getDnsType() {
        return this.dnsType;
    }

    @Generated
    public String getPrimaryDns() {
        return this.primaryDns;
    }

    @Generated
    public String getSecondaryDns() {
        return this.secondaryDns;
    }

    @Generated
    public Ipv6PppoeOpenApiVO setPppShare(Boolean pppShare) {
        this.pppShare = pppShare;
        return this;
    }

    @Generated
    public Ipv6PppoeOpenApiVO setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    @Generated
    public Ipv6PppoeOpenApiVO setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public Ipv6PppoeOpenApiVO setGetIpv6Type(Integer getIpv6Type) {
        this.getIpv6Type = getIpv6Type;
        return this;
    }

    @Generated
    public Ipv6PppoeOpenApiVO setPrefixEnable(Boolean prefixEnable) {
        this.prefixEnable = prefixEnable;
        return this;
    }

    @Generated
    public Ipv6PppoeOpenApiVO setPrefixSize(Integer prefixSize) {
        this.prefixSize = prefixSize;
        return this;
    }

    @Generated
    public Ipv6PppoeOpenApiVO setSpecificIp(String specificIp) {
        this.specificIp = specificIp;
        return this;
    }

    @Generated
    public Ipv6PppoeOpenApiVO setDnsType(Integer dnsType) {
        this.dnsType = dnsType;
        return this;
    }

    @Generated
    public Ipv6PppoeOpenApiVO setPrimaryDns(String primaryDns) {
        this.primaryDns = primaryDns;
        return this;
    }

    @Generated
    public Ipv6PppoeOpenApiVO setSecondaryDns(String secondaryDns) {
        this.secondaryDns = secondaryDns;
        return this;
    }

    @Generated
    public String toString() {
        return "Ipv6PppoeOpenApiVO(pppShare=" + this.getPppShare() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", getIpv6Type=" + this.getGetIpv6Type() + ", prefixEnable=" + this.getPrefixEnable() + ", prefixSize=" + this.getPrefixSize() + ", specificIp=" + this.getSpecificIp() + ", dnsType=" + this.getDnsType() + ", primaryDns=" + this.getPrimaryDns() + ", secondaryDns=" + this.getSecondaryDns() + ")";
    }
}

