/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.a;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.Ipv6DynamicVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@KeepClass
public class Ipv6DynamicOpenApiVO {
    @Schema(name="getIpv6Type", description="It should be a value as follows: 0: SLAAC; 1: DHCPv6; 2: specified; 3: auto; 4:non-address.")
    @NotNull
    @Range(min=0L, max=4L)
    private @NotNull @Range(min=0L, max=4L) Integer getIpv6Type;
    @NotNull
    private Boolean prefixEnable;
    @Schema(name="prefixSize", description="It is required when [prefixEnable] is true, which ranges from 48 ~ 64.")
    @Range(min=48L, max=64L)
    private @Range(min=48L, max=64L) Integer prefixSize;
    @NotNull
    @Schema(name="dnsType", description="DNS Address Type, 0: dynamic, 1: static.")
    @Range(min=0L, max=1L)
    private @NotNull @Range(min=0L, max=1L) Integer dnsType;
    @Schema(name="primaryDns", description="It is required when [dnsType] is 1.")
    private String primaryDns;
    @Schema(name="secondaryDns", description="It takes effect when [dnsType] is 1")
    private String secondaryDns;

    public static Ipv6DynamicOpenApiVO buildFromWebVO(Ipv6DynamicVO vo) {
        Ipv6DynamicOpenApiVO res = new Ipv6DynamicOpenApiVO();
        if (vo == null) {
            return res;
        }
        res.setGetIpv6Type(vo.getGetIpv6Type());
        res.setPrefixEnable(Objects.equals(vo.getPrefix(), 1));
        res.setPrefixSize(vo.getPdSize());
        res.setDnsType(vo.getDnsType());
        res.setPrimaryDns(vo.getPriDns());
        res.setSecondaryDns(vo.getSndDns());
        return res;
    }

    public static Ipv6DynamicVO toWebVO(Ipv6DynamicOpenApiVO vo) {
        Ipv6DynamicVO res = new Ipv6DynamicVO();
        if (vo == null) {
            return res;
        }
        res.setGetIpv6Type(vo.getGetIpv6Type());
        res.setGetIpv6(a.a(vo.getGetIpv6Type()).a());
        res.setPrefix(Integer.valueOf(Boolean.TRUE.equals(vo.getPrefixEnable()) ? 1 : 0));
        res.setPdSize(vo.getPrefixSize());
        res.setDnsType(vo.getDnsType());
        res.setPriDns(vo.getPrimaryDns());
        res.setSndDns(vo.getSecondaryDns());
        return res;
    }

    @Generated
    public Integer getGetIpv6Type() {
        return this.getIpv6Type;
    }

    @Generated
    public Boolean getPrefixEnable() {
        return this.prefixEnable;
    }

    @Generated
    public Integer getPrefixSize() {
        return this.prefixSize;
    }

    @Generated
    public Integer getDnsType() {
        return this.dnsType;
    }

    @Generated
    public String getPrimaryDns() {
        return this.primaryDns;
    }

    @Generated
    public String getSecondaryDns() {
        return this.secondaryDns;
    }

    @Generated
    public Ipv6DynamicOpenApiVO setGetIpv6Type(Integer getIpv6Type) {
        this.getIpv6Type = getIpv6Type;
        return this;
    }

    @Generated
    public Ipv6DynamicOpenApiVO setPrefixEnable(Boolean prefixEnable) {
        this.prefixEnable = prefixEnable;
        return this;
    }

    @Generated
    public Ipv6DynamicOpenApiVO setPrefixSize(Integer prefixSize) {
        this.prefixSize = prefixSize;
        return this;
    }

    @Generated
    public Ipv6DynamicOpenApiVO setDnsType(Integer dnsType) {
        this.dnsType = dnsType;
        return this;
    }

    @Generated
    public Ipv6DynamicOpenApiVO setPrimaryDns(String primaryDns) {
        this.primaryDns = primaryDns;
        return this;
    }

    @Generated
    public Ipv6DynamicOpenApiVO setSecondaryDns(String secondaryDns) {
        this.secondaryDns = secondaryDns;
        return this;
    }

    @Generated
    public String toString() {
        return "Ipv6DynamicOpenApiVO(getIpv6Type=" + this.getGetIpv6Type() + ", prefixEnable=" + this.getPrefixEnable() + ", prefixSize=" + this.getPrefixSize() + ", dnsType=" + this.getDnsType() + ", primaryDns=" + this.getPrimaryDns() + ", secondaryDns=" + this.getSecondaryDns() + ")";
    }
}

