/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.Ipv4Connection2OpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.b;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.d;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.Ipv4PptpVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@KeepClass
public class Ipv4PptpOpenApiVO {
    @Pattern(regexp="^[A-Za-z0-9\\`\\~\\!\\@\\#\\$\\&\\*\\(\\)\\-\\=\\_\\+\\[\\]\\{\\}\\;\\:\\'\\\"\\\\\\|\\/\\?\\.\\,\\<\\>\\%\\^\\/]{1,255}$", message="Invalid username.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @NotNull
    private @Pattern(regexp="^[A-Za-z0-9\\`\\~\\!\\@\\#\\$\\&\\*\\(\\)\\-\\=\\_\\+\\[\\]\\{\\}\\;\\:\\'\\\"\\\\\\|\\/\\?\\.\\,\\<\\>\\%\\^\\/]{1,255}$", message="Invalid username.") @NotNull String userName;
    @Pattern(regexp="^[A-Za-z0-9\\`\\~\\!\\@\\#\\$\\&\\*\\(\\)\\-\\=\\_\\+\\[\\]\\{\\}\\;\\:\\'\\\"\\\\\\|\\/\\?\\.\\,\\<\\>\\%\\^\\/]{1,255}$", message="Invalid password.")
    @PII(strategy=PIIMaskStrategy.MASK)
    @NotNull
    private @Pattern(regexp="^[A-Za-z0-9\\`\\~\\!\\@\\#\\$\\&\\*\\(\\)\\-\\=\\_\\+\\[\\]\\{\\}\\;\\:\\'\\\"\\\\\\|\\/\\?\\.\\,\\<\\>\\%\\^\\/]{1,255}$", message="Invalid password.") @NotNull String password;
    @Schema(name="ipFromIsp", description="Get IP address from ISP.")
    @NotNull
    private Boolean ipFromIsp;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.")
    @Schema(name="primaryDns", description="Primary DNS")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.") String primaryDns;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.")
    @Schema(name="secondaryDns", description="Secondary DNS")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.") String secondaryDns;
    @Schema(name="connectionMode", description="It should be a value as follows: 0: Connect Automatically; 1: Connect Manually; 2: Time-based.")
    @NotNull
    private Integer connectionMode;
    @Range(min=1L, max=99999L, message="Redial Interval parameter [redialInterval] should between 0 and 99999.")
    @Schema(name="redialInterval", description="It is required when [linkType] is 0. Unit: Second")
    private @Range(min=1L, max=99999L, message="Redial Interval parameter [redialInterval] should between 0 and 99999.") Integer redialInterval;
    @Schema(name="startTime", description="It is required when [linkType] is 2. For example, 12:30.")
    private String startTime;
    @Schema(name="endTime", description="It is required when [linkType] is 2. For example, 12:30.")
    private String endTime;
    @Range(min=576L, max=1500L, message="MTU parameter [mtu] should between 576 and 1500.")
    @Schema(name="mtu", description="576-1500, default:1420")
    @NotNull
    private @Range(min=576L, max=1500L, message="MTU parameter [mtu] should between 576 and 1500.") @NotNull Integer mtu;
    @Range(min=0L, max=2L, message="MSS Clamping parameter [type] should between 0 and 2.")
    @Schema(name="mssClampingType", description="0: Disable, 1: Auto, 2: Custom")
    private @Range(min=0L, max=2L, message="MSS Clamping parameter [type] should between 0 and 2.") Integer mssClampingType;
    @Range(min=532L, max=1452L, message="MSS Clamping parameter [value] should between 532 and 1452.")
    @Nullable
    @Schema(name="mssClampingValue", description="(Optional) It is required when [mssClampingType] is 2, which ranges from 532 ~ 1452.")
    private @Range(min=532L, max=1452L, message="MSS Clamping parameter [value] should between 532 and 1452.") Integer mssClampingValue;
    @Valid
    @NotNull
    private Ipv4Connection2OpenApiVO ipv4Connection2;

    public static Ipv4PptpOpenApiVO buildFromWebVO(Ipv4PptpVO vo) {
        Ipv4PptpOpenApiVO res = new Ipv4PptpOpenApiVO();
        if (vo == null) {
            return res;
        }
        res.setUserName(vo.getUserName());
        res.setPassword(vo.getPassword());
        res.setIpFromIsp("on".equals(vo.getIpFromIsp()));
        res.setPrimaryDns(vo.getDns1());
        res.setSecondaryDns(vo.getDns2());
        res.setConnectionMode(d.a(vo.getLinkType()).b());
        res.setRedialInterval(vo.getRedialInterval());
        res.setStartTime(vo.getStartTime());
        res.setEndTime(vo.getEndTime());
        res.setMtu(vo.getMtu());
        res.setMssClampingType(vo.getMssClampingType());
        res.setMssClampingValue(vo.getMssClampingValue());
        res.setIpv4Connection2(Ipv4Connection2OpenApiVO.buildFromWebVO(vo.getIpv4Connection2()));
        return res;
    }

    public static Ipv4PptpVO toWebVO(Ipv4PptpOpenApiVO vo) {
        Ipv4PptpVO res = new Ipv4PptpVO();
        if (vo == null) {
            return res;
        }
        res.setUserName(vo.getUserName());
        res.setPassword(vo.getPassword());
        res.setIpFromIsp(Boolean.TRUE.equals(vo.getIpFromIsp()) ? "on" : "off");
        res.setDns1(vo.getPrimaryDns());
        res.setDns2(vo.getSecondaryDns());
        res.setLinkType(d.a(vo.getConnectionMode()).a());
        res.setRedialInterval(vo.getRedialInterval());
        res.setStartTime(vo.getStartTime());
        res.setEndTime(vo.getEndTime());
        res.setMtu(vo.getMtu());
        res.setMssClampingType(vo.getMssClampingType());
        res.setMssClampingValue(vo.getMssClampingValue());
        res.setIpv4Connection2(Ipv4Connection2OpenApiVO.toWebVO(vo.getIpv4Connection2(), b.e.a()));
        return res;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Boolean getIpFromIsp() {
        return this.ipFromIsp;
    }

    @Generated
    public String getPrimaryDns() {
        return this.primaryDns;
    }

    @Generated
    public String getSecondaryDns() {
        return this.secondaryDns;
    }

    @Generated
    public Integer getConnectionMode() {
        return this.connectionMode;
    }

    @Generated
    public Integer getRedialInterval() {
        return this.redialInterval;
    }

    @Generated
    public String getStartTime() {
        return this.startTime;
    }

    @Generated
    public String getEndTime() {
        return this.endTime;
    }

    @Generated
    public Integer getMtu() {
        return this.mtu;
    }

    @Generated
    public Integer getMssClampingType() {
        return this.mssClampingType;
    }

    @Nullable
    @Generated
    public Integer getMssClampingValue() {
        return this.mssClampingValue;
    }

    @Generated
    public Ipv4Connection2OpenApiVO getIpv4Connection2() {
        return this.ipv4Connection2;
    }

    @Generated
    public Ipv4PptpOpenApiVO setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    @Generated
    public Ipv4PptpOpenApiVO setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public Ipv4PptpOpenApiVO setIpFromIsp(Boolean ipFromIsp) {
        this.ipFromIsp = ipFromIsp;
        return this;
    }

    @Generated
    public Ipv4PptpOpenApiVO setPrimaryDns(String primaryDns) {
        this.primaryDns = primaryDns;
        return this;
    }

    @Generated
    public Ipv4PptpOpenApiVO setSecondaryDns(String secondaryDns) {
        this.secondaryDns = secondaryDns;
        return this;
    }

    @Generated
    public Ipv4PptpOpenApiVO setConnectionMode(Integer connectionMode) {
        this.connectionMode = connectionMode;
        return this;
    }

    @Generated
    public Ipv4PptpOpenApiVO setRedialInterval(Integer redialInterval) {
        this.redialInterval = redialInterval;
        return this;
    }

    @Generated
    public Ipv4PptpOpenApiVO setStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @Generated
    public Ipv4PptpOpenApiVO setEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @Generated
    public Ipv4PptpOpenApiVO setMtu(Integer mtu) {
        this.mtu = mtu;
        return this;
    }

    @Generated
    public Ipv4PptpOpenApiVO setMssClampingType(Integer mssClampingType) {
        this.mssClampingType = mssClampingType;
        return this;
    }

    @Generated
    public Ipv4PptpOpenApiVO setMssClampingValue(@Nullable Integer mssClampingValue) {
        this.mssClampingValue = mssClampingValue;
        return this;
    }

    @Generated
    public Ipv4PptpOpenApiVO setIpv4Connection2(Ipv4Connection2OpenApiVO ipv4Connection2) {
        this.ipv4Connection2 = ipv4Connection2;
        return this;
    }

    @Generated
    public String toString() {
        return "Ipv4PptpOpenApiVO(userName=" + this.getUserName() + ", password=" + this.getPassword() + ", ipFromIsp=" + this.getIpFromIsp() + ", primaryDns=" + this.getPrimaryDns() + ", secondaryDns=" + this.getSecondaryDns() + ", connectionMode=" + this.getConnectionMode() + ", redialInterval=" + this.getRedialInterval() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", mtu=" + this.getMtu() + ", mssClampingType=" + this.getMssClampingType() + ", mssClampingValue=" + this.getMssClampingValue() + ", ipv4Connection2=" + this.getIpv4Connection2() + ")";
    }
}

