/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.Ipv4Connection2OpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.b;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.d;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.Ipv4L2tpVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@KeepClass
public class Ipv4L2tpOpenApiVO {
    @Pattern(regexp="^[A-Za-z0-9\\`\\~\\!\\@\\#\\$\\&\\*\\(\\)\\-\\=\\_\\+\\[\\]\\{\\}\\;\\:\\'\\\"\\\\\\|\\/\\?\\.\\,\\<\\>\\%\\^\\/]{1,255}$", message="Invalid username.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @NotNull(message="Parameter [userName] should not be null.")
    private @Pattern(regexp="^[A-Za-z0-9\\`\\~\\!\\@\\#\\$\\&\\*\\(\\)\\-\\=\\_\\+\\[\\]\\{\\}\\;\\:\\'\\\"\\\\\\|\\/\\?\\.\\,\\<\\>\\%\\^\\/]{1,255}$", message="Invalid username.") @NotNull(message="Parameter [userName] should not be null.") String userName;
    @Pattern(regexp="^[A-Za-z0-9\\`\\~\\!\\@\\#\\$\\&\\*\\(\\)\\-\\=\\_\\+\\[\\]\\{\\}\\;\\:\\'\\\"\\\\\\|\\/\\?\\.\\,\\<\\>\\%\\^\\/]{1,255}$", message="Invalid password.")
    @PII(strategy=PIIMaskStrategy.MASK)
    @NotNull(message="Parameter [password] should not be null.")
    private @Pattern(regexp="^[A-Za-z0-9\\`\\~\\!\\@\\#\\$\\&\\*\\(\\)\\-\\=\\_\\+\\[\\]\\{\\}\\;\\:\\'\\\"\\\\\\|\\/\\?\\.\\,\\<\\>\\%\\^\\/]{1,255}$", message="Invalid password.") @NotNull(message="Parameter [password] should not be null.") String password;
    @Schema(name="ipFromIsp", description="Get IP address from ISP.")
    @NotNull(message="Parameter [ipFromIsp] not be null.")
    private @NotNull(message="Parameter [ipFromIsp] not be null.") Boolean ipFromIsp;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.")
    @Schema(name="primaryDns", description="Primary DNS")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.") String primaryDns;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.")
    @Schema(name="secondaryDns", description="Secondary DNS")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.") String secondaryDns;
    @Schema(name="connectionMode", description="It should be a value as follows: 0: Connect Automatically; 1: Connect Manually; 2: Time-based.")
    @NotNull(message="Parameter [connectionMode] not be null.")
    private @NotNull(message="Parameter [connectionMode] not be null.") Integer connectionMode;
    @Range(min=1L, max=99999L, message="Redial Interval parameter [redialInterval] should between 0 and 99999.")
    @Schema(name="redialInterval", description="It is required when [linkType] is 0. Unit: Second")
    private @Range(min=1L, max=99999L, message="Redial Interval parameter [redialInterval] should between 0 and 99999.") Integer redialInterval;
    @Schema(name="startTime", description="It is required when [linkType] is 2. For example, 12:30.")
    private String startTime;
    @Schema(name="endTime", description="It is required when [linkType] is 2. For example, 12:30.")
    private String endTime;
    @Range(min=576L, max=1500L, message="MTU parameter [mtu] should between 576 and 1500.")
    @Schema(name="mtu", description="576-1500, default:1460")
    @NotNull(message="Parameter [mtu] not be null.")
    private @Range(min=576L, max=1500L, message="MTU parameter [mtu] should between 576 and 1500.") @NotNull(message="Parameter [mtu] not be null.") Integer mtu;
    @Range(min=0L, max=2L, message="MSS Clamping parameter [type] should between 0 and 2.")
    @Nullable
    @Schema(name="mssClampingType", description="0: Disable; 1: Auto; 2: Custom.")
    private @Range(min=0L, max=2L, message="MSS Clamping parameter [type] should between 0 and 2.") Integer mssClampingType;
    @Range(min=532L, max=1452L, message="MSS Clamping parameter [value] should between 532 and 1452.")
    @Nullable
    @Schema(name="mssClampingValue", description="It is required when [mssClampingType] is 2, which ranges 532 ~ 1452.")
    private @Range(min=532L, max=1452L, message="MSS Clamping parameter [value] should between 532 and 1452.") Integer mssClampingValue;
    @Valid
    @NotNull(message="Parameter [ipv4Connection2] not be null.")
    private @Valid @NotNull(message="Parameter [ipv4Connection2] not be null.") Ipv4Connection2OpenApiVO ipv4Connection2;

    public static Ipv4L2tpOpenApiVO buildFromWebVO(Ipv4L2tpVO vo) {
        Ipv4L2tpOpenApiVO res = new Ipv4L2tpOpenApiVO();
        if (vo == null) {
            return res;
        }
        res.setUserName(vo.getUserName());
        res.setPassword(vo.getPassword());
        res.setIpFromIsp("on".equals(vo.getIpFromIsp()));
        res.setPrimaryDns(vo.getDns1());
        res.setSecondaryDns(vo.getDns2());
        res.setConnectionMode(d.a(vo.getLinkType()).b());
        res.setRedialInterval(vo.getRedialInterval());
        res.setStartTime(vo.getStartTime());
        res.setEndTime(vo.getEndTime());
        res.setMtu(vo.getMtu());
        res.setMssClampingType(vo.getMssClampingType());
        res.setMssClampingValue(vo.getMssClampingValue());
        res.setIpv4Connection2(Ipv4Connection2OpenApiVO.buildFromWebVO(vo.getIpv4Connection2()));
        return res;
    }

    public static Ipv4L2tpVO toWebVO(Ipv4L2tpOpenApiVO vo) {
        Ipv4L2tpVO res = new Ipv4L2tpVO();
        if (vo == null) {
            return res;
        }
        res.setUserName(vo.getUserName());
        res.setPassword(vo.getPassword());
        res.setIpFromIsp(Boolean.TRUE.equals(vo.getIpFromIsp()) ? "on" : "off");
        res.setDns1(vo.getPrimaryDns());
        res.setDns2(vo.getSecondaryDns());
        res.setLinkType(d.a(vo.getConnectionMode()).a());
        res.setRedialInterval(vo.getRedialInterval());
        res.setStartTime(vo.getStartTime());
        res.setEndTime(vo.getEndTime());
        res.setMtu(vo.getMtu());
        res.setMssClampingType(vo.getMssClampingType());
        res.setMssClampingValue(vo.getMssClampingValue());
        res.setIpv4Connection2(Ipv4Connection2OpenApiVO.toWebVO(vo.getIpv4Connection2(), b.d.a()));
        return res;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Boolean getIpFromIsp() {
        return this.ipFromIsp;
    }

    @Generated
    public String getPrimaryDns() {
        return this.primaryDns;
    }

    @Generated
    public String getSecondaryDns() {
        return this.secondaryDns;
    }

    @Generated
    public Integer getConnectionMode() {
        return this.connectionMode;
    }

    @Generated
    public Integer getRedialInterval() {
        return this.redialInterval;
    }

    @Generated
    public String getStartTime() {
        return this.startTime;
    }

    @Generated
    public String getEndTime() {
        return this.endTime;
    }

    @Generated
    public Integer getMtu() {
        return this.mtu;
    }

    @Nullable
    @Generated
    public Integer getMssClampingType() {
        return this.mssClampingType;
    }

    @Nullable
    @Generated
    public Integer getMssClampingValue() {
        return this.mssClampingValue;
    }

    @Generated
    public Ipv4Connection2OpenApiVO getIpv4Connection2() {
        return this.ipv4Connection2;
    }

    @Generated
    public Ipv4L2tpOpenApiVO setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    @Generated
    public Ipv4L2tpOpenApiVO setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public Ipv4L2tpOpenApiVO setIpFromIsp(Boolean ipFromIsp) {
        this.ipFromIsp = ipFromIsp;
        return this;
    }

    @Generated
    public Ipv4L2tpOpenApiVO setPrimaryDns(String primaryDns) {
        this.primaryDns = primaryDns;
        return this;
    }

    @Generated
    public Ipv4L2tpOpenApiVO setSecondaryDns(String secondaryDns) {
        this.secondaryDns = secondaryDns;
        return this;
    }

    @Generated
    public Ipv4L2tpOpenApiVO setConnectionMode(Integer connectionMode) {
        this.connectionMode = connectionMode;
        return this;
    }

    @Generated
    public Ipv4L2tpOpenApiVO setRedialInterval(Integer redialInterval) {
        this.redialInterval = redialInterval;
        return this;
    }

    @Generated
    public Ipv4L2tpOpenApiVO setStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @Generated
    public Ipv4L2tpOpenApiVO setEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @Generated
    public Ipv4L2tpOpenApiVO setMtu(Integer mtu) {
        this.mtu = mtu;
        return this;
    }

    @Generated
    public Ipv4L2tpOpenApiVO setMssClampingType(@Nullable Integer mssClampingType) {
        this.mssClampingType = mssClampingType;
        return this;
    }

    @Generated
    public Ipv4L2tpOpenApiVO setMssClampingValue(@Nullable Integer mssClampingValue) {
        this.mssClampingValue = mssClampingValue;
        return this;
    }

    @Generated
    public Ipv4L2tpOpenApiVO setIpv4Connection2(Ipv4Connection2OpenApiVO ipv4Connection2) {
        this.ipv4Connection2 = ipv4Connection2;
        return this;
    }

    @Generated
    public String toString() {
        return "Ipv4L2tpOpenApiVO(userName=" + this.getUserName() + ", password=" + this.getPassword() + ", ipFromIsp=" + this.getIpFromIsp() + ", primaryDns=" + this.getPrimaryDns() + ", secondaryDns=" + this.getSecondaryDns() + ", connectionMode=" + this.getConnectionMode() + ", redialInterval=" + this.getRedialInterval() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", mtu=" + this.getMtu() + ", mssClampingType=" + this.getMssClampingType() + ", mssClampingValue=" + this.getMssClampingValue() + ", ipv4Connection2=" + this.getIpv4Connection2() + ")";
    }
}

