/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.WanMultipleIpOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.Ipv4IpoaVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@KeepClass
public class Ipv4IpoaOpenApiVO {
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP address.")
    @Schema(name="ipAddress", description="IP address")
    @NotNull(message="Parameter [ipAddress] should not be null.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP address.") @NotNull(message="Parameter [ipAddress] should not be null.") String ipAddress;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid subnet mask.")
    @NotNull(message="Parameter [subnetMask] should not be null.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid subnet mask.") @NotNull(message="Parameter [subnetMask] should not be null.") String subnetMask;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid gateway address.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid gateway address.") String defaultGateway;
    @Range(min=576L, max=1500L, message="MTU parameter [mtu] should between 576 and 1500.")
    @Schema(name="mtu", description="576-1500, default:1500")
    @NotNull(message="Parameter [mtu] should not be null.")
    private @Range(min=576L, max=1500L, message="MTU parameter [mtu] should between 576 and 1500.") @NotNull(message="Parameter [mtu] should not be null.") Integer mtu;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.")
    @Schema(name="primaryDns", description="Primary DNS")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.") String primaryDns;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.")
    @Schema(name="secondaryDns", description="Secondary DNS")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid DNS Server.") String secondaryDns;
    @Valid
    private List<WanMultipleIpOpenApiVO> wanMultipleIps;

    public static Ipv4IpoaOpenApiVO buildFromWebVO(Ipv4IpoaVO vo) {
        Ipv4IpoaOpenApiVO res = new Ipv4IpoaOpenApiVO();
        if (vo == null) {
            return res;
        }
        res.setIpAddress(vo.getIpaddr());
        res.setSubnetMask(vo.getNetmask());
        res.setDefaultGateway(vo.getGateway());
        res.setMtu(vo.getMtu());
        res.setPrimaryDns(vo.getDns1());
        res.setSecondaryDns(vo.getDns2());
        return res;
    }

    public static Ipv4IpoaVO toWebVO(Ipv4IpoaOpenApiVO vo) {
        Ipv4IpoaVO res = new Ipv4IpoaVO();
        if (vo == null) {
            return res;
        }
        res.setIpaddr(vo.getIpAddress());
        res.setNetmask(vo.getSubnetMask());
        res.setGateway(vo.getDefaultGateway());
        res.setMtu(vo.getMtu());
        res.setDns1(vo.getPrimaryDns());
        res.setDns2(vo.getSecondaryDns());
        return res;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public String getSubnetMask() {
        return this.subnetMask;
    }

    @Generated
    public String getDefaultGateway() {
        return this.defaultGateway;
    }

    @Generated
    public Integer getMtu() {
        return this.mtu;
    }

    @Generated
    public String getPrimaryDns() {
        return this.primaryDns;
    }

    @Generated
    public String getSecondaryDns() {
        return this.secondaryDns;
    }

    @Generated
    public List<WanMultipleIpOpenApiVO> getWanMultipleIps() {
        return this.wanMultipleIps;
    }

    @Generated
    public Ipv4IpoaOpenApiVO setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Generated
    public Ipv4IpoaOpenApiVO setSubnetMask(String subnetMask) {
        this.subnetMask = subnetMask;
        return this;
    }

    @Generated
    public Ipv4IpoaOpenApiVO setDefaultGateway(String defaultGateway) {
        this.defaultGateway = defaultGateway;
        return this;
    }

    @Generated
    public Ipv4IpoaOpenApiVO setMtu(Integer mtu) {
        this.mtu = mtu;
        return this;
    }

    @Generated
    public Ipv4IpoaOpenApiVO setPrimaryDns(String primaryDns) {
        this.primaryDns = primaryDns;
        return this;
    }

    @Generated
    public Ipv4IpoaOpenApiVO setSecondaryDns(String secondaryDns) {
        this.secondaryDns = secondaryDns;
        return this;
    }

    @Generated
    public Ipv4IpoaOpenApiVO setWanMultipleIps(List<WanMultipleIpOpenApiVO> wanMultipleIps) {
        this.wanMultipleIps = wanMultipleIps;
        return this;
    }

    @Generated
    public String toString() {
        return "Ipv4IpoaOpenApiVO(ipAddress=" + this.getIpAddress() + ", subnetMask=" + this.getSubnetMask() + ", defaultGateway=" + this.getDefaultGateway() + ", mtu=" + this.getMtu() + ", primaryDns=" + this.getPrimaryDns() + ", secondaryDns=" + this.getSecondaryDns() + ", wanMultipleIps=" + this.getWanMultipleIps() + ")";
    }
}

